/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.migration;

import java.util.Set;
import javax.wsdl.Operation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.migration.CorrelationKeyMigration;
import org.apache.ode.bpel.engine.migration.Migration;
import org.apache.ode.bpel.o.OPartnerLink;

public class CorrelationKeySetDataMigration
implements Migration {
    private static final Log __log = LogFactory.getLog(CorrelationKeyMigration.class);

    @Override
    public boolean migrate(Set<BpelProcess> registeredProcesses, BpelDAOConnection connection) {
        for (BpelProcess process : registeredProcesses) {
            __log.debug((Object)("Migrating correlators data for process " + process.getConf().getProcessId()));
            ProcessDAO processDao = connection.getProcess(process.getConf().getProcessId());
            for (OPartnerLink plink : process.getOProcess().getAllPartnerLinks()) {
                if (!plink.hasMyRole()) continue;
                for (Operation op : plink.myRolePortType.getOperations()) {
                    CorrelatorDAO corr = processDao.getCorrelator(plink.getName() + "." + op.getName());
                    if (corr == null) continue;
                    for (MessageRouteDAO routeDAO : corr.getAllRoutes()) {
                        CorrelationKey oldKey = routeDAO.getCorrelationKey();
                        if (oldKey == null) continue;
                        CorrelationKeySet keySet = new CorrelationKeySet();
                        keySet.add(oldKey);
                        routeDAO.setCorrelationKeySet(keySet);
                    }
                }
            }
        }
        return true;
    }
}

