/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannel;
import org.apache.ode.bpel.runtime.channels.TerminationChannel;
import org.apache.ode.bpel.runtime.extension.ExtensionContext;
import org.apache.ode.utils.Namespaces;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtensionContextImpl
implements ExtensionContext {
    private static final Log __log = LogFactory.getLog(ExtensionContextImpl.class);
    private BpelRuntimeContext _context;
    private ScopeFrame _scopeFrame;
    private ActivityInfo _activityInfo;
    private boolean hasCompleted = false;
    private String[] _correlationValues;
    private String _correlatorId;
    private static final long serialVersionUID = -89894857418738011L;

    public ExtensionContextImpl(ActivityInfo activityInfo, ScopeFrame scopeFrame, BpelRuntimeContext context) {
        this._activityInfo = activityInfo;
        this._context = context;
        this._scopeFrame = scopeFrame;
    }

    public void setBpelRuntimeContext(BpelRuntimeContext context) {
        this._context = context;
    }

    @Override
    public Long getProcessId() {
        return this._context.getPid();
    }

    @Override
    public Map<String, OScope.Variable> getVisibleVariables() throws FaultException {
        HashMap<String, OScope.Variable> visVars = new HashMap<String, OScope.Variable>();
        for (OScope current = this._scopeFrame.oscope; current != null; current = current.getParent()) {
            if (!(current instanceof OScope)) continue;
            for (String varName : current.variables.keySet()) {
                if (visVars.containsKey(varName)) continue;
                visVars.put(varName, (OScope.Variable)current.variables.get(varName));
            }
        }
        return visVars;
    }

    @Override
    public String readMessageProperty(OScope.Variable variable, OProcess.OProperty property) throws FaultException {
        VariableInstance vi = this._scopeFrame.resolve(variable);
        return this._context.readProperty(vi, property);
    }

    @Override
    public Node readVariable(OScope.Variable variable) throws FaultException {
        VariableInstance vi = this._scopeFrame.resolve(variable);
        return this._context.fetchVariableData(vi, this._scopeFrame, true);
    }

    @Override
    public void writeVariable(String variableName, Node value) throws FaultException {
        OScope.Variable var = this.getVisibleVariable(variableName);
        if (var == null) {
            throw new RuntimeException("Variable '" + variableName + "' not visible.");
        }
        this.writeVariable(var, value);
    }

    @Override
    public Node readVariable(String variableName) throws FaultException {
        OScope.Variable var = this.getVisibleVariable(variableName);
        if (var == null) {
            throw new RuntimeException("Variable '" + variableName + "' not visible.");
        }
        return this.readVariable(var);
    }

    @Override
    public void writeVariable(OScope.Variable variable, Node value) throws FaultException {
        VariableInstance vi = this._scopeFrame.resolve(variable);
        this._context.initializeVariable(vi, this._scopeFrame, value);
        VariableModificationEvent vme = new VariableModificationEvent(variable.name);
        vme.setNewValue(value);
        this.sendEvent((ScopeEvent)vme);
    }

    public OScope.Variable getVisibleVariable(String varName) {
        return this._scopeFrame.oscope.getVisibleVariable(varName);
    }

    @Override
    public boolean isVariableVisible(String varName) {
        return this._scopeFrame.oscope.getVisibleVariable(varName) != null;
    }

    @Override
    public String getActivityName() {
        return this._activityInfo.o.name;
    }

    @Override
    public OActivity getOActivity() {
        return this._activityInfo.o;
    }

    public void sendEvent(ScopeEvent event) {
        if (event.getLineNo() == -1 && this._activityInfo.o.debugInfo != null) {
            event.setLineNo(this._activityInfo.o.debugInfo.startLine);
        }
        this._scopeFrame.fillEventInfo(event);
        this._context.sendEvent(event);
    }

    @Override
    public void complete(String cid) {
        if (!this.hasCompleted) {
            this._context.completeExtensionActivity(cid, null);
            this.hasCompleted = true;
        } else if (__log.isWarnEnabled()) {
            __log.warn((Object)("Activity '" + this._activityInfo.o.name + "' has already been completed."));
        }
    }

    @Override
    public void completeWithFault(String cid, Throwable t) {
        if (!this.hasCompleted) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            FaultData fault = new FaultData(new QName(Namespaces.WSBPEL2_0_FINAL_EXEC, "subLanguageExecutionFault"), (OBase)this._activityInfo.o, sw.getBuffer().toString());
            this._context.completeExtensionActivity(cid, fault);
            this.hasCompleted = true;
        } else if (__log.isWarnEnabled()) {
            __log.warn((Object)("Activity '" + this._activityInfo.o.name + "' has already been completed."));
        }
    }

    @Override
    public void completeWithFault(String cid, FaultException ex) {
        if (!this.hasCompleted) {
            FaultData fault = new FaultData(ex.getQName(), (OBase)this._activityInfo.o, ex.getMessage());
            this._context.completeExtensionActivity(cid, fault);
            this.hasCompleted = true;
        } else if (__log.isWarnEnabled()) {
            __log.warn((Object)("Activity '" + this._activityInfo.o.name + "' has already been completed."));
        }
    }

    @Override
    public BpelRuntimeContext getInternalInstance() {
        return this._context;
    }

    @Override
    public URI getDUDir() {
        return this._context.getBaseResourceURI();
    }

    @Override
    public void printToConsole(String msg) {
        LogFactory.getLog((String)"org.apache.ode.extension.Console").info((Object)msg);
    }

    @Override
    public PartnerLinkInstance getPartnerLinkInstance(String partnerLinkName) throws FaultException {
        OPartnerLink plink = this.getVisiblePartnerLink(partnerLinkName);
        if (plink == null) {
            throw new RuntimeException("PartnerLink '" + partnerLinkName + "' not visible.");
        }
        return this.getPartnerLinkInstance(plink);
    }

    public OPartnerLink getVisiblePartnerLink(String partnerLinkName) {
        return this._scopeFrame.oscope.getVisiblePartnerLink(partnerLinkName);
    }

    @Override
    public boolean isPartnerLinkVisible(String partnerLinkName) {
        return this._scopeFrame.oscope.getVisiblePartnerLink(partnerLinkName) != null;
    }

    @Override
    public PartnerLinkInstance getPartnerLinkInstance(OPartnerLink partnerLink) throws FaultException {
        return this._scopeFrame.resolve(partnerLink);
    }

    @Override
    public OProcess getProcessModel() {
        return this._context.getProcessModel();
    }

    @Override
    public void setCorrelationValues(String[] values) {
        this._correlationValues = values;
    }

    @Override
    public String[] getCorrelationValues() {
        return this._correlationValues;
    }

    @Override
    public String getCorrelatorId() {
        return this._correlatorId;
    }

    @Override
    public void setCorrelatorId(String correlatorId) {
        this._correlatorId = correlatorId;
    }

    @Override
    public Node getPartData(Element element, String variable) {
        OScope.Variable var = this.getVisibleVariable(variable);
        OMessageVarType varType = null;
        if (var.type instanceof OMessageVarType) {
            varType = (OMessageVarType)var.type;
        }
        OMessageVarType.Part part = null;
        if (varType != null && varType.parts.size() > 0) {
            part = (OMessageVarType.Part)varType.parts.values().toArray()[0];
        }
        if (part == null) {
            return null;
        }
        return this._context.getPartData(element, part);
    }

    @Override
    public TerminationChannel getTerminationChannel() {
        return this._activityInfo.self;
    }

    @Override
    public ParentScopeChannel getParentScopeChannel() {
        return this._activityInfo.parent;
    }

    public ScopeFrame getScopeFrame() {
        return this._scopeFrame;
    }
}

