/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.extvar.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evar.IncompleteKeyException;
import org.apache.ode.bpel.extvar.jdbc.DbExternalVariable;
import org.apache.ode.bpel.extvar.jdbc.EVarId;
import org.apache.ode.bpel.extvar.jdbc.GenType;
import org.apache.ode.bpel.extvar.jdbc.InitType;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.ObjectPrinter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JdbcExternalVariableModule
implements ExternalVariableModule {
    private static final Log __log = LogFactory.getLog(JdbcExternalVariableModule.class);
    public static final String JDBC_NS = "http://ode.apache.org/externalVariables/jdbc";
    public static final QName NAME = new QName("http://ode.apache.org/externalVariables/jdbc", "jdbc");
    private final HashMap<String, DataSource> _dataSources = new HashMap();
    private final HashMap<EVarId, DbExternalVariable> _vars = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(QName pid, String extVarId, Element config) throws ExternalVariableModuleException {
        DatabaseMetaData metaData;
        EVarId evarId = new EVarId(pid, extVarId);
        DataSource ds = null;
        Element jndiDs = DOMUtils.findChildByName((Element)config, (QName)new QName(JDBC_NS, "datasource-jndi"));
        Element jndiRef = DOMUtils.findChildByName((Element)config, (QName)new QName(JDBC_NS, "datasource-ref"));
        Element initMode = DOMUtils.findChildByName((Element)config, (QName)new QName(JDBC_NS, "init-mode"));
        if (jndiRef != null) {
            String refname = jndiRef.getTextContent().trim();
            ds = this._dataSources.get(refname);
            if (ds == null) {
                throw new ExternalVariableModuleException("Data source reference \"" + refname + "\" not found for external variable " + evarId + "; make sure to register the data source with the engine!");
            }
        } else if (jndiDs != null) {
            Object dsCandidate;
            InitialContext ctx;
            String name = jndiDs.getTextContent().trim();
            try {
                ctx = new InitialContext();
            }
            catch (Exception ex) {
                throw new ExternalVariableModuleException("Unable to access JNDI context for external variable " + evarId, (Throwable)ex);
            }
            try {
                dsCandidate = ctx.lookup(name);
            }
            catch (Exception ex) {
                throw new ExternalVariableModuleException("Lookup of data source for " + evarId + "  failed.", (Throwable)ex);
            }
            finally {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
            }
            if (dsCandidate == null) {
                throw new ExternalVariableModuleException("Data source \"" + name + "\" not found in JNDI!");
            }
            if (!(dsCandidate instanceof DataSource)) {
                throw new ExternalVariableModuleException("JNDI object \"" + name + "\" does not implement javax.sql.DataSource");
            }
            ds = (DataSource)dsCandidate;
        }
        if (ds == null) {
            throw new ExternalVariableModuleException("No valid data source configuration for JDBC external varible " + evarId);
        }
        Connection conn = null;
        try {
            conn = ds.getConnection();
            metaData = conn.getMetaData();
        }
        catch (Exception ex) {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw new ExternalVariableModuleException("Unable to open database connection for external variable " + evarId, (Throwable)ex);
        }
        try {
            Element tableName;
            DbExternalVariable dbev = new DbExternalVariable(evarId, ds);
            if (initMode != null) {
                try {
                    dbev._initType = InitType.valueOf(initMode.getTextContent().trim());
                }
                catch (Exception ex) {
                    throw new ExternalVariableModuleException("Invalid <init-mode> value: " + initMode.getTextContent().trim());
                }
            }
            if ((tableName = DOMUtils.findChildByName((Element)config, (QName)new QName(JDBC_NS, "table"))) == null || tableName.getTextContent().trim().equals("")) {
                throw new ExternalVariableModuleException("Must specify <table> for external variable " + evarId);
            }
            String table = tableName.getTextContent().trim();
            String schema = null;
            if (table.indexOf(46) != -1) {
                schema = table.substring(0, table.indexOf(46));
                table = table.substring(table.indexOf(46) + 1);
            }
            if (metaData.storesLowerCaseIdentifiers()) {
                table = table.toLowerCase();
                if (schema != null) {
                    schema = table.toLowerCase();
                }
            } else if (metaData.storesUpperCaseIdentifiers()) {
                table = table.toUpperCase();
                if (schema != null) {
                    schema = schema.toUpperCase();
                }
            }
            dbev.generatedKeys = metaData.supportsGetGeneratedKeys();
            ResultSet tables = metaData.getTables(null, schema, table, null);
            if (!tables.next()) {
                throw new ExternalVariableModuleException("Table \"" + table + "\" not found in database.");
            }
            dbev.table = tables.getString("TABLE_NAME");
            dbev.schema = tables.getString("TABLE_SCHEM");
            tables.close();
            List columns = DOMUtils.findChildrenByName((Element)config, (QName)new QName(JDBC_NS, "column"));
            for (Element col : columns) {
                DbExternalVariable.Column c;
                block60: {
                    GenType gtype;
                    String name = col.getAttribute("name");
                    String colname = col.getAttribute("column-name");
                    String key = col.getAttribute("key");
                    String gentype = col.getAttribute("generator");
                    String expression = col.getAttribute("expression");
                    if (key == null || "".equals(key)) {
                        key = "no";
                    }
                    if (gentype == null || "".equals(gentype)) {
                        gentype = GenType.none.toString();
                    }
                    if (colname == null || "".equals(colname)) {
                        colname = name;
                    }
                    if (name == null || "".equals(name)) {
                        throw new ExternalVariableModuleException("External variable " + evarId + " <column> element must have \"name\" attribute. ");
                    }
                    if (metaData.storesLowerCaseIdentifiers()) {
                        colname = colname.toLowerCase();
                    } else if (metaData.storesUpperCaseIdentifiers()) {
                        colname = colname.toUpperCase();
                    }
                    try {
                        gtype = GenType.valueOf(gentype);
                    }
                    catch (Exception ex) {
                        throw new ExternalVariableModuleException("External variable " + evarId + " column \"" + name + "\" generator type \"" + gentype + "\" is unknown.");
                    }
                    if (gtype == GenType.expression && (expression == null || "".equals(expression))) {
                        throw new ExternalVariableModuleException("External variable " + evarId + " column \"" + name + "\" used \"expression\" generator, but did not specify an expression");
                    }
                    DbExternalVariable dbExternalVariable = dbev;
                    dbExternalVariable.getClass();
                    c = dbExternalVariable.new DbExternalVariable.Column(name, colname, key.equalsIgnoreCase("yes"), gtype, expression);
                    ResultSet cmd = metaData.getColumns(null, dbev.schema, dbev.table, colname);
                    try {
                        if (cmd.next()) {
                            c.dataType = cmd.getInt("DATA_TYPE");
                            c.nullok = cmd.getInt("NULLABLE") != 0;
                            break block60;
                        }
                        throw new ExternalVariableModuleException("External variable " + evarId + " referenced " + "non-existant column \"" + colname + "\"!");
                    }
                    finally {
                        cmd.close();
                    }
                }
                dbev.addColumn(c);
            }
            if (dbev.numColumns() == 0) {
                throw new ExternalVariableModuleException("External variable " + evarId + " did not have any <column> elements!");
            }
            this._vars.put(evarId, dbev);
        }
        catch (SQLException se) {
            throw new ExternalVariableModuleException("SQL Error", (Throwable)se);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {}
        }
    }

    public QName getName() {
        return NAME;
    }

    public boolean isTransactional() {
        return true;
    }

    public void shutdown() {
    }

    public void start() {
    }

    public void stop() {
    }

    public ExternalVariableModule.Value writeValue(QName varType, ExternalVariableModule.Value newval) throws ExternalVariableModuleException {
        boolean insert;
        EVarId evarId = new EVarId(newval.locator.pid, newval.locator.varId);
        DbExternalVariable evar = this._vars.get(evarId);
        if (evar == null) {
            throw new ExternalVariableModuleException("No such variable. ");
        }
        DbExternalVariable.RowKey key = evar.keyFromLocator(newval.locator);
        DbExternalVariable.RowVal val = evar.parseXmlRow(evar.new DbExternalVariable.RowVal(), (Element)newval.value);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("JdbcExternalVariable.writeValue() RowKey: " + key + " RowVal: " + val));
        }
        if (!key.missingValues() && evar._initType == InitType.delete_insert) {
            throw new ExternalVariableModuleException("Delete not implemented. ");
        }
        boolean tryupdatefirst = (evar._initType == InitType.update || evar._initType == InitType.update_insert) && !evar._keycolumns.isEmpty() && !key.missingDatabaseGeneratedValues();
        boolean bl = insert = evar._initType != InitType.update;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("tryUpdateFirst: " + tryupdatefirst + " insert: " + insert + " initType: " + (Object)((Object)evar._initType) + " key.isEmpty: " + evar._keycolumns.isEmpty() + " key.missingValues: " + key.missingValues() + " key.missingDBValues: " + key.missingDatabaseGeneratedValues()));
        }
        try {
            if (tryupdatefirst) {
                boolean bl2 = insert = this.execUpdate(evar, key, val) == 0;
            }
            if (insert) {
                key = this.execInsert(evar, newval.locator, key, val);
                key.write(varType, newval.locator);
            }
        }
        catch (SQLException se) {
            throw new ExternalVariableModuleException("Error updating row.", (Throwable)se);
        }
        return newval;
    }

    public ExternalVariableModule.Value readValue(QName varType, ExternalVariableModule.Locator locator) throws ExternalVariableModuleException {
        Element val;
        EVarId evarId = new EVarId(locator.pid, locator.varId);
        DbExternalVariable evar = this._vars.get(evarId);
        if (evar == null) {
            throw new ExternalVariableModuleException("No such variable: " + evarId);
        }
        try {
            DbExternalVariable.RowVal rowval = this.execSelect(evar, locator);
            val = evar.renderXmlRow(locator, varType, rowval);
        }
        catch (SQLException se) {
            throw new ExternalVariableModuleException("SQL Error.", (Throwable)se);
        }
        return new ExternalVariableModule.Value(locator, (Node)val, null);
    }

    public void registerDataSource(String dsName, DataSource ds) {
        this._dataSources.put(dsName, ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int execUpdate(DbExternalVariable dbev, DbExternalVariable.RowKey key, DbExternalVariable.RowVal values) throws SQLException {
        Connection conn = dbev.dataSource.getConnection();
        Statement stmt = null;
        try {
            Object val;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("execUpdate: key=" + key + " values=" + values));
                __log.debug((Object)("Prepare statement: " + dbev.update));
            }
            stmt = conn.prepareStatement(dbev.update);
            int idx = 1;
            for (DbExternalVariable.Column c : dbev._updcolumns) {
                val = values.get(c.name);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Set value parameter " + idx + ": " + val));
                }
                if (val == null) {
                    stmt.setNull(idx, c.dataType);
                } else {
                    stmt.setObject(idx, this.downcastValue(val, c.dataType));
                }
                ++idx;
            }
            for (DbExternalVariable.Column ck : dbev._keycolumns) {
                val = key.get(ck.name);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Set key parameter " + idx + ": " + val));
                }
                if (val == null) {
                    stmt.setNull(idx, ck.dataType);
                } else {
                    stmt.setObject(idx, this.downcastValue(val, ck.dataType));
                }
                ++idx;
            }
            int n = stmt.executeUpdate();
            return n;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            try {
                conn.close();
            }
            catch (SQLException e) {}
        }
    }

    private Object downcastValue(Object value, int dataType) {
        if (value == null) {
            return null;
        }
        try {
            switch (dataType) {
                case 2003: {
                    break;
                }
                case -5: {
                    if (value instanceof BigInteger) break;
                    value = new BigDecimal(value.toString()).longValue();
                    break;
                }
                case -2: {
                    break;
                }
                case -7: {
                    if (value instanceof Boolean) break;
                    value = new Boolean(value.toString());
                    break;
                }
                case 2004: {
                    break;
                }
                case 16: {
                    if (value instanceof Boolean) break;
                    value = new Boolean(value.toString());
                    break;
                }
                case 1: {
                    break;
                }
                case 2005: {
                    break;
                }
                case 70: {
                    break;
                }
                case 91: {
                    break;
                }
                case 3: {
                    value = new BigDecimal(new BigDecimal(value.toString()).toPlainString());
                    break;
                }
                case 2001: {
                    break;
                }
                case 8: {
                    if (value instanceof Double) break;
                    value = (double)Double.valueOf(value.toString());
                    break;
                }
                case 6: {
                    if (value instanceof Float) break;
                    value = Float.valueOf(Float.valueOf(value.toString()).floatValue());
                    break;
                }
                case 4: {
                    if (value instanceof Integer) break;
                    value = Double.valueOf(value.toString()).intValue();
                    break;
                }
                case 2000: {
                    break;
                }
                case -4: {
                    break;
                }
                case -1: {
                    break;
                }
                case 2: {
                    value = new BigDecimal(new BigDecimal(value.toString()).toPlainString());
                    break;
                }
                case 1111: {
                    break;
                }
                case 7: {
                    if (value instanceof Double) break;
                    value = Float.valueOf(Float.valueOf(value.toString()).floatValue());
                    break;
                }
                case 2006: {
                    break;
                }
                case 5: {
                    if (value instanceof Short) break;
                    value = (short)new Short(value.toString());
                    break;
                }
                case 2002: {
                    break;
                }
                case 92: {
                    break;
                }
                case 93: {
                    break;
                }
                case -6: {
                    if (value instanceof Short) break;
                    value = (short)new Short(value.toString());
                    break;
                }
                case -3: {
                    break;
                }
                case 12: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbExternalVariable.RowVal execSelect(DbExternalVariable dbev, ExternalVariableModule.Locator locator) throws SQLException, ExternalVariableModuleException {
        DbExternalVariable.RowVal ret;
        block23: {
            DbExternalVariable.RowKey rowkey = dbev.keyFromLocator(locator);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("execSelect: " + rowkey));
            }
            if (rowkey.missingDatabaseGeneratedValues()) {
                return null;
            }
            if (rowkey.missingValues()) {
                throw new IncompleteKeyException(rowkey.getMissing());
            }
            ret = dbev.new DbExternalVariable.RowVal();
            Connection conn = dbev.dataSource.getConnection();
            Statement stmt = null;
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Prepare statement: " + dbev.select));
                }
                stmt = conn.prepareStatement(dbev.select);
                int idx = 1;
                for (Object k : rowkey) {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("Set key parameter " + idx + ": " + k));
                    }
                    stmt.setObject(idx++, k);
                }
                ResultSet rs = stmt.executeQuery();
                try {
                    if (rs.next()) {
                        for (DbExternalVariable.Column c : dbev._columns) {
                            int i = c.idx + 1;
                            Object val = c.isDate() ? rs.getDate(i) : (c.isTimeStamp() ? rs.getTimestamp(i) : (c.isTime() ? rs.getTime(i) : (c.isInteger() ? new Long(rs.getLong(i)) : (c.isReal() ? new Double(rs.getDouble(i)) : (c.isBoolean() ? new Boolean(rs.getBoolean(i)) : rs.getObject(i))))));
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("Result column index " + c.idx + ": " + val));
                            }
                            ret.set(c.idx, val);
                        }
                        break block23;
                    }
                    DbExternalVariable.RowVal rowVal = null;
                    return rowVal;
                }
                finally {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbExternalVariable.RowKey execInsert(DbExternalVariable dbev, ExternalVariableModule.Locator locator, DbExternalVariable.RowKey keys, DbExternalVariable.RowVal values) throws SQLException {
        Connection conn = dbev.dataSource.getConnection();
        Statement stmt = null;
        try {
            Object val;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("execInsert: keys=" + keys + " values=" + values));
                __log.debug((Object)("Prepare statement: " + dbev.insert));
                __log.debug((Object)("missingDatabaseGeneratedValues: " + keys.missingDatabaseGeneratedValues()));
                __log.debug((Object)("_autoColNames: " + ObjectPrinter.stringifyNvList((Object[])dbev._autoColNames)));
            }
            stmt = keys.missingDatabaseGeneratedValues() ? conn.prepareStatement(dbev.insert, dbev._autoColNames) : conn.prepareStatement(dbev.insert);
            int idx = 1;
            for (DbExternalVariable.Column c : dbev._inscolumns) {
                val = c.getValue(c.name, keys, values, locator.iid);
                values.put(c.name, val);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Set parameter " + idx + ": " + val));
                }
                if (val == null) {
                    stmt.setNull(idx, c.dataType);
                } else {
                    stmt.setObject(idx, val);
                }
                ++idx;
            }
            stmt.execute();
            for (DbExternalVariable.Column ck : keys._columns) {
                val = values.get(ck.name);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Key " + ck.name + ": " + val));
                }
                keys.put(ck.name, val);
            }
            if (keys.missingDatabaseGeneratedValues()) {
                ResultSet keyRS = stmt.getGeneratedKeys();
                try {
                    if (keyRS == null) {
                        throw new SQLException("Database did not return generated keys");
                    }
                    keyRS.next();
                    for (DbExternalVariable.Column ck : keys._columns) {
                        Object value = keyRS.getObject(ck.idx + 1);
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)("Generated key " + ck.name + ": " + value));
                        }
                        keys.put(ck.name, value);
                    }
                }
                finally {
                    keyRS.close();
                }
            }
            DbExternalVariable.RowKey rowKey = keys;
            return rowKey;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            try {
                conn.close();
            }
            catch (SQLException e) {}
        }
    }
}

