/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableReadEvent;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OConstants;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.EventContextImpl;
import org.apache.ode.bpel.runtime.ExprEvaluationContextImpl;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.jacob.IndexedObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class ACTIVITY
extends BpelJacobRunnable
implements IndexedObject {
    private static final Log __log = LogFactory.getLog(ACTIVITY.class);
    protected ActivityInfo _self;
    protected boolean _permeable = true;
    protected ScopeFrame _scopeFrame;
    protected LinkFrame _linkFrame;

    public ACTIVITY(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        assert (self != null);
        assert (scopeFrame != null);
        assert (linkFrame != null);
        this._self = self;
        this._scopeFrame = scopeFrame;
        this._linkFrame = linkFrame;
    }

    public Object getKey() {
        return new Key(this._self.o, this._self.aId);
    }

    protected void sendVariableReadEvent(VariableInstance var) {
        VariableReadEvent vre = new VariableReadEvent();
        vre.setVarName(var.declaration.name);
        this.sendEvent((ScopeEvent)vre);
    }

    protected void sendEvent(ActivityEvent event) {
        event.setActivityName(this._self.o.name);
        event.setActivityType(this._self.o.getType());
        event.setActivityDeclarationId(this._self.o.getId());
        event.setActivityId(this._self.aId);
        if (event.getLineNo() == -1) {
            event.setLineNo(this.getLineNo());
        }
        this.sendEvent((ScopeEvent)event);
    }

    protected void sendEvent(ScopeEvent event) {
        if (event.getLineNo() == -1 && this._self.o.debugInfo != null) {
            event.setLineNo(this._self.o.debugInfo.startLine);
        }
        this._scopeFrame.fillEventInfo(event);
        this.fillEventContext(event);
        this.getBpelRuntimeContext().sendEvent(event);
    }

    protected void fillEventContext(ScopeEvent event) {
        EventContextImpl eventContext = new EventContextImpl(this._scopeFrame.oscope, this._scopeFrame.scopeInstanceId, this.getBpelRuntimeContext());
        event.eventContext = eventContext;
    }

    protected void dpe(Collection<OLink> links) {
        for (OLink link : links) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("DPE on link " + link.name));
            }
            this._linkFrame.resolve((OLink)link).pub.linkStatus(false);
        }
    }

    protected OConstants getConstants() {
        return this._self.o.getOwner().constants;
    }

    protected void dpe(OActivity activity) {
        this.dpe(activity.sourceLinks);
        this.dpe(activity.outgoingLinks);
    }

    protected EvaluationContext getEvaluationContext() {
        return new ExprEvaluationContextImpl(this._scopeFrame, this.getBpelRuntimeContext());
    }

    private int getLineNo() {
        if (this._self.o.debugInfo != null && this._self.o.debugInfo.startLine != -1) {
            return this._self.o.debugInfo.startLine;
        }
        return -1;
    }

    Node fetchVariableData(VariableInstance variable, boolean forWriting) throws FaultException {
        return this._scopeFrame.fetchVariableData(this.getBpelRuntimeContext(), variable, forWriting);
    }

    Node fetchVariableData(VariableInstance var, OMessageVarType.Part part, boolean forWriting) throws FaultException {
        return this._scopeFrame.fetchVariableData(this.getBpelRuntimeContext(), var, part, forWriting);
    }

    Node initializeVariable(VariableInstance lvar, Node val) throws ExternalVariableModuleException {
        return this._scopeFrame.initializeVariable(this.getBpelRuntimeContext(), lvar, val);
    }

    void commitChanges(VariableInstance lval, Node lvalue) throws ExternalVariableModuleException {
        this._scopeFrame.commitChanges(this.getBpelRuntimeContext(), lval, lvalue);
    }

    Node getPartData(Element message, OMessageVarType.Part part) {
        return this._scopeFrame.getPartData(message, part);
    }

    public static final class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final OActivity type;
        final long aid;

        public Key(OActivity type, long aid) {
            this.type = type;
            this.aid = aid;
        }

        public String toString() {
            return this.type + "::" + this.aid;
        }
    }
}

