/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstanceLockManager {
    private static final Log __log = LogFactory.getLog(InstanceLockManager.class);
    private final Lock _mutex = new ReentrantLock();
    private final Map<Long, InstanceInfo> _locks = new HashMap<Long, InstanceInfo>();

    public void lock(Long iid, int time, TimeUnit tu) throws InterruptedException, TimeoutException {
        if (iid == null) {
            return;
        }
        String thrd = Thread.currentThread().toString();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(thrd + ": lock(iid=" + iid + ", time=" + time + (Object)((Object)tu) + ")"));
        }
        this._mutex.lock();
        try {
            InstanceInfo li;
            do {
                if ((li = this._locks.get(iid)) == null) {
                    li = new InstanceInfo(iid, Thread.currentThread());
                    this._locks.put(iid, li);
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)(thrd + ": lock(iid=" + iid + ", time=" + time + (Object)((Object)tu) + ")-->GRANTED"));
                    }
                    return;
                }
                if (!__log.isDebugEnabled()) continue;
                __log.debug((Object)(thrd + ": lock(iid=" + iid + ", time=" + time + (Object)((Object)tu) + ")-->WAITING(held by " + li.acquierer + ")"));
            } while (li.available.await(time, tu));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)(thrd + ": lock(iid=" + iid + ", time=" + time + (Object)((Object)tu) + ")-->TIMEOUT (held by " + li.acquierer + ")"));
            }
            throw new TimeoutException();
        }
        finally {
            this._mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Long iid) {
        if (iid == null) {
            return;
        }
        String thrd = Thread.currentThread().toString();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(thrd + ": unlock(iid=" + iid + ")"));
        }
        this._mutex.lock();
        try {
            InstanceInfo li = this._locks.get(iid);
            if (li == null) {
                throw new IllegalStateException("Instance not locked, cannot unlock!");
            }
            this._locks.remove(iid);
            li.available.signalAll();
        }
        finally {
            this._mutex.unlock();
        }
    }

    public String toString() {
        return "{InstanceLockManager: " + this._locks + "}";
    }

    public static final class TimeoutException
    extends Exception {
        private static final long serialVersionUID = 7247629086692580285L;
    }

    private class InstanceInfo {
        final long iid;
        final Thread acquierer;
        Condition available;

        InstanceInfo(long iid, Thread t) {
            this.available = InstanceLockManager.this._mutex.newCondition();
            this.iid = iid;
            this.acquierer = t;
        }

        public String toString() {
            return "{Lock for Instance #" + this.iid + ", acquired by " + this.acquierer + "}";
        }
    }
}

