/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.InterceptorContextImpl;
import org.apache.ode.bpel.engine.MessageExchangeImpl;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.replayer.Replayer;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.OdeGlobalConfig;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.AbortMessageExchangeException;
import org.apache.ode.bpel.intercept.FaultMessageExchangeException;
import org.apache.ode.bpel.intercept.InterceptorInvoker;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MyRoleMessageExchangeImpl
extends MessageExchangeImpl
implements MyRoleMessageExchange {
    private static final Log __log = LogFactory.getLog(MyRoleMessageExchangeImpl.class);
    protected BpelProcess _process;
    protected static Map<String, ResponseCallback> _waitingCallbacks = new ConcurrentHashMap<String, ResponseCallback>();

    public MyRoleMessageExchangeImpl(BpelProcess process, BpelEngineImpl engine, MessageExchangeDAO mexdao) {
        super(engine, mexdao);
        this._process = process;
    }

    public MyRoleMessageExchange.CorrelationStatus getCorrelationStatus() {
        return MyRoleMessageExchange.CorrelationStatus.valueOf((String)this.getDAO().getCorrelationStatus());
    }

    public void setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus status) {
        this.getDAO().setCorrelationStatus(status.toString());
    }

    private boolean processInterceptors(MyRoleMessageExchangeImpl mex, InterceptorInvoker invoker) {
        InterceptorContextImpl ictx = new InterceptorContextImpl(this._engine._contexts.dao.getConnection(), mex._dao.getProcess(), null, this._engine, this._process);
        for (MessageExchangeInterceptor i : this._engine.getGlobalInterceptors()) {
            if (this.processInterceptor(i, mex, ictx, invoker)) continue;
            return false;
        }
        return true;
    }

    boolean processInterceptor(MessageExchangeInterceptor i, MyRoleMessageExchangeImpl mex, MessageExchangeInterceptor.InterceptorContext ictx, InterceptorInvoker invoker) {
        __log.debug((Object)(invoker + "--> interceptor " + i));
        try {
            invoker.invoke(i, mex, ictx);
        }
        catch (FaultMessageExchangeException fme) {
            __log.debug((Object)("interceptor " + i + " caused invoke on " + this + " to be aborted with FAULT " + fme.getFaultName()));
            mex.setFault(fme.getFaultName(), fme.getFaultData());
            return false;
        }
        catch (AbortMessageExchangeException ame) {
            __log.debug((Object)("interceptor " + i + " cause invoke on " + this + " to be aborted with FAILURE: " + ame.getMessage()));
            mex.setFailure(MessageExchange.FailureType.ABORTED, __msgs.msgInterceptorAborted(mex.getMessageExchangeId(), i.toString(), ame.getMessage()), null);
            return false;
        }
        return true;
    }

    public Future invoke(Message request) {
        if (request == null) {
            String errmsg = "Must pass non-null message to invoke()!";
            __log.fatal((Object)errmsg);
            throw new NullPointerException(errmsg);
        }
        this._dao.setRequest(((MessageImpl)request)._dao);
        this._dao.setStatus(MessageExchange.Status.REQUEST.toString());
        if (!this.processInterceptors(this, InterceptorInvoker.__onBpelServerInvoked)) {
            return null;
        }
        BpelProcess target = this._process;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("invoke() EPR= " + this._epr + " ==> " + target));
        }
        if (target == null) {
            if (__log.isWarnEnabled()) {
                __log.warn((Object)__msgs.msgUnknownEPR("" + this._epr));
            }
            this.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.UKNOWN_ENDPOINT);
            this.setFailure(MessageExchange.FailureType.UNKNOWN_ENDPOINT, null, null);
            return null;
        }
        Scheduler.JobDetails we = new Scheduler.JobDetails();
        we.setType(Scheduler.JobType.INVOKE_INTERNAL);
        we.setInMem(Boolean.valueOf(target.isInMemory()));
        we.setProcessId(target.getPID());
        we.setMexId(this.getDAO().getMessageExchangeId());
        if (this.getOperation().getOutput() != null) {
            ResponseCallback callback = new ResponseCallback();
            _waitingCallbacks.put(this.getClientId(), callback);
        }
        this.setStatus(MessageExchange.Status.ASYNC);
        Replayer replayer = Replayer.replayer.get();
        if (replayer == null) {
            if (target.isInMemory()) {
                this._engine._contexts.scheduler.scheduleVolatileJob(true, we);
            } else {
                this._engine._contexts.scheduler.schedulePersistedJob(we, null);
            }
        } else {
            replayer.scheduler.schedulePersistedJob(we, null);
        }
        return new ResponseFuture(this.getClientId());
    }

    public void complete() {
    }

    public QName getServiceName() {
        return this.getDAO().getCallee();
    }

    public void setClientId(String clientKey) {
        this.getDAO().setCorrelationId(clientKey);
    }

    public String getClientId() {
        return this.getDAO().getCorrelationId();
    }

    public String toString() {
        try {
            return "{MyRoleMex#" + this.getMessageExchangeId() + " [Client " + this.getClientId() + "] calling " + this.getServiceName() + "." + this.getOperationName() + "(...)}";
        }
        catch (Throwable t) {
            return "{MyRoleMex#???}";
        }
    }

    public boolean isAsynchronous() {
        if (OdeGlobalConfig.queueInOutMessages()) {
            return true;
        }
        return this.getPattern() == MessageExchange.MessageExchangePattern.REQUEST_ONLY;
    }

    public void release(boolean instanceSucceeded) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Releasing mex " + this.getMessageExchangeId()));
        }
        if (this._process != null) {
            this._dao.release(this._process.isCleanupCategoryEnabled(instanceSucceeded, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
        }
        this._dao = null;
    }

    protected Message cloneMessage(Message message) {
        Message clone = this.createMessage(message.getType());
        clone.setMessage((Element)message.getMessage().cloneNode(true));
        Map headerParts = message.getHeaderParts();
        for (String partName : headerParts.keySet()) {
            clone.setHeaderPart(partName, (Element)((Node)headerParts.get(partName)).cloneNode(true));
        }
        Map parts = message.getHeaderParts();
        for (String partName : parts.keySet()) {
            clone.setHeaderPart(partName, (Element)((Node)parts.get(partName)).cloneNode(true));
        }
        return clone;
    }

    protected void responseReceived() {
        final String cid = this.getClientId();
        this._engine._contexts.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

            public void afterCompletion(boolean success) {
                __log.debug((Object)"Received myrole mex response callback");
                if (success) {
                    ResponseCallback callback = _waitingCallbacks.remove(cid);
                    if (callback != null) {
                        callback.responseReceived();
                    }
                } else {
                    __log.warn((Object)"Transaction is rolled back on sending back the response.");
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    static class ResponseCallback {
        private boolean _timedout;
        private boolean _waiting = true;

        ResponseCallback() {
        }

        synchronized boolean responseReceived() {
            if (this._timedout) {
                return false;
            }
            this._waiting = false;
            this.notify();
            return true;
        }

        synchronized void waitResponse(long timeout) {
            long etime = timeout == 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
            try {
                long ctime;
                while (this._waiting && (ctime = System.currentTimeMillis()) < etime) {
                    this.wait(etime - ctime);
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this._timedout = this._waiting;
        }
    }

    static class ResponseFuture
    implements Future {
        private String _clientId;
        private boolean _done = false;

        public ResponseFuture(String clientId) {
            this._clientId = clientId;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException();
        }

        public Object get() throws InterruptedException, ExecutionException {
            try {
                return this.get(0L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new ExecutionException(e);
            }
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            ResponseCallback callback = _waitingCallbacks.get(this._clientId);
            if (callback != null) {
                callback.waitResponse(timeout);
                this._done = true;
                if (callback._timedout) {
                    throw new TimeoutException("Message exchange " + this + " timed out(" + timeout + " ms) when waiting for a response!");
                }
            }
            return null;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return this._done;
        }
    }
}

