/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.common.ProcessFilter;
import org.apache.ode.bpel.dao.ActivityRecoveryDAO;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ProcessManagementDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.engine.BpelManagementFacadeImpl;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.BpelProcessDatabase;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.DebuggerSupport;
import org.apache.ode.bpel.engine.DocumentInfoGenerator;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.ProcessStatusConverter;
import org.apache.ode.bpel.engine.replayer.Replayer;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.CorrelationEvent;
import org.apache.ode.bpel.evt.CorrelationMatchEvent;
import org.apache.ode.bpel.evt.CorrelationSetEvent;
import org.apache.ode.bpel.evt.CorrelationSetWriteEvent;
import org.apache.ode.bpel.evt.ExpressionEvaluationEvent;
import org.apache.ode.bpel.evt.ExpressionEvaluationFailedEvent;
import org.apache.ode.bpel.evt.NewProcessInstanceEvent;
import org.apache.ode.bpel.evt.PartnerLinkEvent;
import org.apache.ode.bpel.evt.ProcessCompletionEvent;
import org.apache.ode.bpel.evt.ProcessEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStartedEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStateChangeEvent;
import org.apache.ode.bpel.evt.ProcessMessageExchangeEvent;
import org.apache.ode.bpel.evt.ScopeCompletionEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.ScopeFaultEvent;
import org.apache.ode.bpel.evt.VariableEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.evtproc.ActivityStateDocumentBuilder;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.pmapi.ActivityExtInfoListDocument;
import org.apache.ode.bpel.pmapi.ActivityInfoDocument;
import org.apache.ode.bpel.pmapi.EventInfoListDocument;
import org.apache.ode.bpel.pmapi.GetCommunication;
import org.apache.ode.bpel.pmapi.GetCommunicationResponseDocument;
import org.apache.ode.bpel.pmapi.InstanceInfoDocument;
import org.apache.ode.bpel.pmapi.InstanceInfoListDocument;
import org.apache.ode.bpel.pmapi.InstanceManagement;
import org.apache.ode.bpel.pmapi.InstanceNotFoundException;
import org.apache.ode.bpel.pmapi.InvalidRequestException;
import org.apache.ode.bpel.pmapi.ManagementException;
import org.apache.ode.bpel.pmapi.ProcessInfoCustomizer;
import org.apache.ode.bpel.pmapi.ProcessInfoDocument;
import org.apache.ode.bpel.pmapi.ProcessInfoListDocument;
import org.apache.ode.bpel.pmapi.ProcessManagement;
import org.apache.ode.bpel.pmapi.ProcessNotFoundException;
import org.apache.ode.bpel.pmapi.ProcessingException;
import org.apache.ode.bpel.pmapi.Replay;
import org.apache.ode.bpel.pmapi.ReplayResponse;
import org.apache.ode.bpel.pmapi.ReplayResponseDocument;
import org.apache.ode.bpel.pmapi.ScopeInfoDocument;
import org.apache.ode.bpel.pmapi.TActivityExtInfo;
import org.apache.ode.bpel.pmapi.TActivityStatus;
import org.apache.ode.bpel.pmapi.TActivitytExtInfoList;
import org.apache.ode.bpel.pmapi.TCorrelationProperty;
import org.apache.ode.bpel.pmapi.TDefinitionInfo;
import org.apache.ode.bpel.pmapi.TDeploymentInfo;
import org.apache.ode.bpel.pmapi.TDocumentInfo;
import org.apache.ode.bpel.pmapi.TEndpointReferences;
import org.apache.ode.bpel.pmapi.TEventInfo;
import org.apache.ode.bpel.pmapi.TEventInfoList;
import org.apache.ode.bpel.pmapi.TFailureInfo;
import org.apache.ode.bpel.pmapi.TFailuresInfo;
import org.apache.ode.bpel.pmapi.TFaultInfo;
import org.apache.ode.bpel.pmapi.TInstanceInfo;
import org.apache.ode.bpel.pmapi.TInstanceInfoList;
import org.apache.ode.bpel.pmapi.TInstanceStatus;
import org.apache.ode.bpel.pmapi.TInstanceSummary;
import org.apache.ode.bpel.pmapi.TProcessInfo;
import org.apache.ode.bpel.pmapi.TProcessInfoList;
import org.apache.ode.bpel.pmapi.TProcessProperties;
import org.apache.ode.bpel.pmapi.TProcessStatus;
import org.apache.ode.bpel.pmapi.TScopeInfo;
import org.apache.ode.bpel.pmapi.TScopeRef;
import org.apache.ode.bpel.pmapi.TVariableInfo;
import org.apache.ode.bpel.pmapi.TVariableRef;
import org.apache.ode.bpel.pmapi.VariableInfoDocument;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.apache.ode.utils.stl.UnaryFunction;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessAndInstanceManagementImpl
implements InstanceManagement,
ProcessManagement {
    protected static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    protected static Log __log = LogFactory.getLog(BpelManagementFacadeImpl.class);
    protected static final ProcessStatusConverter __psc = new ProcessStatusConverter();
    protected BpelDatabase _db;
    protected ProcessStore _store;
    protected Calendar _calendar = Calendar.getInstance();
    protected BpelServerImpl _server;

    public ProcessAndInstanceManagementImpl(BpelServer server, ProcessStore store) {
        this._server = (BpelServerImpl)server;
        this._db = this._server._db;
        this._store = store;
    }

    public ProcessInfoListDocument listProcessesCustom(String filter, String orderKeys, final ProcessInfoCustomizer custom) {
        ProcessInfoListDocument ret = ProcessInfoListDocument.Factory.newInstance();
        final TProcessInfoList procInfoList = ret.addNewProcessInfoList();
        final ProcessFilter processFilter = new ProcessFilter(filter, orderKeys);
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection conn) throws Exception {
                    Collection<ProcessConf> pconfs = ProcessAndInstanceManagementImpl.this.processQuery(processFilter);
                    for (ProcessConf pconf : pconfs) {
                        try {
                            ProcessAndInstanceManagementImpl.this.fillProcessInfo(procInfoList.addNewProcessInfo(), pconf, custom);
                        }
                        catch (Exception e) {
                            ProcessAndInstanceManagementImpl.failIfSQLException(e);
                            __log.error((Object)("Exception when querying process " + pconf.getProcessId()), (Throwable)e);
                        }
                    }
                    try {
                        ProcessAndInstanceManagementImpl.this.fillProcessInfoSummary(conn, procInfoList.getProcessInfoList(), custom);
                    }
                    catch (Exception e) {
                        ProcessAndInstanceManagementImpl.failIfSQLException(e);
                        __log.error((Object)"Exception fetching instances summary", (Throwable)e);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            __log.error((Object)"Exception while listing processes", (Throwable)e);
            throw new ProcessingException("Exception while listing processes: " + e.toString());
        }
        return ret;
    }

    public ProcessInfoListDocument listProcesses(String filter, String orderKeys) {
        return this.listProcessesCustom(filter, orderKeys, ProcessInfoCustomizer.ALL);
    }

    public ProcessInfoListDocument listAllProcesses() {
        return this.listProcessesCustom(null, null, ProcessInfoCustomizer.ALL);
    }

    public ProcessInfoListDocument listProcessesSummaryOnly() {
        return this.listProcessesCustom(null, null, ProcessInfoCustomizer.SUMMARYONLY);
    }

    public ProcessInfoListDocument listProcessesSummaryAndProperties() {
        return this.listProcessesCustom(null, null, ProcessInfoCustomizer.SUMMARY_PROPERTIES);
    }

    public ProcessInfoDocument getProcessInfoCustom(final QName pid, final ProcessInfoCustomizer custom) {
        try {
            return this._db.exec(new BpelDatabase.Callable<ProcessInfoDocument>(){

                @Override
                public ProcessInfoDocument run(BpelDAOConnection conn) {
                    return ProcessAndInstanceManagementImpl.this.genProcessInfoDocument(conn, pid, custom);
                }
            });
        }
        catch (Exception ex) {
            __log.error((Object)"Exception in getProcessInfoCustom()", (Throwable)ex);
            throw new ManagementException("Exception in getProcessInfoCustom(): " + ex.toString());
        }
    }

    public ProcessInfoDocument getProcessInfo(QName pid) {
        return this.getProcessInfoCustom(pid, ProcessInfoCustomizer.ALL);
    }

    public ProcessInfoDocument activate(QName pid) {
        try {
            this._store.setState(pid, ProcessState.ACTIVE);
        }
        catch (Exception ex) {
            __log.error((Object)"Exception while setting process state", (Throwable)ex);
            throw new ManagementException("Error setting process state: " + ex.toString());
        }
        return this.getProcessInfoCustom(pid, ProcessInfoCustomizer.NONE);
    }

    public ProcessInfoDocument setRetired(QName pid, boolean retired) throws ManagementException {
        try {
            this._store.setState(pid, retired ? ProcessState.RETIRED : ProcessState.ACTIVE);
        }
        catch (BpelEngineException e) {
            __log.error((Object)"Exception while setting process as retired", (Throwable)e);
            throw new ProcessNotFoundException("ProcessNotFound:" + pid);
        }
        return this.getProcessInfoCustom(pid, ProcessInfoCustomizer.NONE);
    }

    public void setPackageRetired(String packageName, boolean retired) throws ManagementException {
        try {
            this._store.setRetiredPackage(packageName, retired);
        }
        catch (BpelEngineException e) {
            __log.error((Object)"Exception while setting process as retired", (Throwable)e);
            throw new ProcessNotFoundException("PackageNotFound:" + packageName);
        }
    }

    public ProcessInfoDocument setProcessPropertyNode(final QName pid, final QName propertyName, final Node value) throws ManagementException {
        ProcessInfoDocument ret = ProcessInfoDocument.Factory.newInstance();
        final TProcessInfo pi = ret.addNewProcessInfo();
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection conn) throws Exception {
                    try {
                        ProcessAndInstanceManagementImpl.this._store.setProperty(pid, propertyName, value);
                    }
                    catch (Exception ex) {
                        ProcessAndInstanceManagementImpl.failIfSQLException(ex);
                        __log.debug((Object)("Error setting property value for " + pid + "; " + propertyName), (Throwable)ex);
                    }
                    ProcessConf proc = ProcessAndInstanceManagementImpl.this._store.getProcessConfiguration(pid);
                    if (proc == null) {
                        throw new ProcessNotFoundException("ProcessNotFound:" + pid);
                    }
                    ProcessAndInstanceManagementImpl.this.fillProcessInfo(pi, proc, new ProcessInfoCustomizer(new ProcessInfoCustomizer.Item[]{ProcessInfoCustomizer.Item.PROPERTIES}));
                    return null;
                }
            });
        }
        catch (ManagementException me) {
            throw me;
        }
        catch (Exception e) {
            __log.error((Object)"Exception while setting process property", (Throwable)e);
            throw new ProcessingException("Exception while setting process property: " + e.toString());
        }
        return ret;
    }

    public ProcessInfoDocument setProcessProperty(final QName pid, final QName propertyName, final String value) throws ManagementException {
        ProcessInfoDocument ret = ProcessInfoDocument.Factory.newInstance();
        final TProcessInfo pi = ret.addNewProcessInfo();
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection conn) throws Exception {
                    try {
                        ProcessAndInstanceManagementImpl.this._store.setProperty(pid, propertyName, value);
                    }
                    catch (Exception ex) {
                        ProcessAndInstanceManagementImpl.failIfSQLException(ex);
                        __log.debug((Object)("Error setting property value for " + pid + "; " + propertyName), (Throwable)ex);
                    }
                    ProcessConf proc = ProcessAndInstanceManagementImpl.this._store.getProcessConfiguration(pid);
                    if (proc == null) {
                        throw new ProcessNotFoundException("ProcessNotFound:" + pid);
                    }
                    ProcessAndInstanceManagementImpl.this.fillProcessInfo(pi, proc, new ProcessInfoCustomizer(new ProcessInfoCustomizer.Item[]{ProcessInfoCustomizer.Item.PROPERTIES}));
                    return null;
                }
            });
        }
        catch (ManagementException me) {
            throw me;
        }
        catch (Exception e) {
            __log.error((Object)"Exception while setting process property", (Throwable)e);
            throw new ProcessingException("Exception while setting process property" + e.toString());
        }
        return ret;
    }

    private boolean garbage(String filter) {
        if (filter == null) {
            return false;
        }
        Matcher expressionMatcher = Filter.__comparatorPattern.matcher(filter);
        return !filter.trim().equals("") && !expressionMatcher.find();
    }

    public InstanceInfoListDocument listInstances(String filter, String order, int limit) {
        InstanceInfoListDocument ret = InstanceInfoListDocument.Factory.newInstance();
        final TInstanceInfoList infolist = ret.addNewInstanceInfoList();
        if (this.garbage(filter)) {
            return ret;
        }
        final InstanceFilter instanceFilter = new InstanceFilter(filter, order, limit);
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection conn) {
                    Collection instances = conn.instanceQuery(instanceFilter);
                    for (ProcessInstanceDAO instance : instances) {
                        ProcessAndInstanceManagementImpl.this.fillInstanceInfo(infolist.addNewInstanceInfo(), instance);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            __log.error((Object)"Exception while listing instances", (Throwable)e);
            throw new ProcessingException("Exception while listing instances: " + e.toString());
        }
        return ret;
    }

    public InstanceInfoListDocument listInstancesSummary(String filter, String order, int limit) {
        InstanceInfoListDocument ret = InstanceInfoListDocument.Factory.newInstance();
        final TInstanceInfoList infolist = ret.addNewInstanceInfoList();
        if (this.garbage(filter)) {
            return ret;
        }
        final InstanceFilter instanceFilter = new InstanceFilter(filter, order, limit);
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection conn) {
                    Collection instances = conn.instanceQuery(instanceFilter);
                    Map icsets = conn.getCorrelationSets(instances);
                    for (ProcessInstanceDAO instance : instances) {
                        TInstanceInfo info = infolist.addNewInstanceInfo();
                        ProcessAndInstanceManagementImpl.this.fillInstanceSummary(info, instance);
                        Collection csets = (Collection)icsets.get(instance.getInstanceId());
                        if (csets == null) continue;
                        for (CorrelationSetDAO cset : csets) {
                            Map props = cset.getProperties();
                            ProcessAndInstanceManagementImpl.this.fillProperties(info, instance, props);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            __log.error((Object)"Exception while listing instances", (Throwable)e);
            throw new ProcessingException("Exception while listing instances: " + e.toString());
        }
        return ret;
    }

    public InstanceInfoListDocument listAllInstances() {
        return this.listInstancesSummary(null, null, Integer.MAX_VALUE);
    }

    public InstanceInfoListDocument listAllInstancesWithLimit(int limit) {
        return this.listInstancesSummary(null, null, limit);
    }

    public InstanceInfoDocument getInstanceInfo(final Long iid) throws InstanceNotFoundException {
        try {
            return this._db.exec(new BpelDatabase.Callable<InstanceInfoDocument>(){

                @Override
                public InstanceInfoDocument run(BpelDAOConnection conn) {
                    return ProcessAndInstanceManagementImpl.this.genInstanceInfoDocument(conn, iid);
                }
            });
        }
        catch (Exception e) {
            __log.error((Object)"Exception while retrieving instance info", (Throwable)e);
            throw new ProcessingException("Exception while retrieving instance info: " + e.toString());
        }
    }

    public ScopeInfoDocument getScopeInfo(String siid) {
        return this.getScopeInfoWithActivity(siid, false);
    }

    public ScopeInfoDocument getScopeInfoWithActivity(final String siid, final boolean includeActivityInfo) {
        try {
            return this._db.exec(new BpelDatabase.Callable<ScopeInfoDocument>(){

                @Override
                public ScopeInfoDocument run(BpelDAOConnection conn) throws Exception {
                    return ProcessAndInstanceManagementImpl.this.genScopeInfoDocument(conn, siid, includeActivityInfo);
                }
            });
        }
        catch (Exception e) {
            __log.error((Object)"Exception while retrieving scope info", (Throwable)e);
            throw new ProcessingException("Exception while retrieving scope info: " + e.toString());
        }
    }

    public VariableInfoDocument getVariableInfo(final String scopeId, final String varName) throws ManagementException {
        VariableInfoDocument ret = VariableInfoDocument.Factory.newInstance();
        final TVariableInfo vinf = ret.addNewVariableInfo();
        final TVariableRef sref = vinf.addNewSelf();
        this.dbexec(new BpelDatabase.Callable<Object>(){

            @Override
            public Object run(BpelDAOConnection session) throws Exception {
                ScopeDAO scope = session.getScope(new Long(scopeId));
                if (scope == null) {
                    throw new InvalidRequestException("ScopeNotFound:" + scopeId);
                }
                sref.setSiid(scopeId);
                sref.setIid(scope.getProcessInstance().getInstanceId().toString());
                sref.setName(varName);
                XmlDataDAO var = scope.getVariable(varName);
                if (var == null) {
                    throw new InvalidRequestException("VarNotFound:" + varName);
                }
                Node nval = var.get();
                if (nval != null) {
                    TVariableInfo.Value val = vinf.addNewValue();
                    val.getDomNode().appendChild(val.getDomNode().getOwnerDocument().importNode(nval, true));
                }
                return null;
            }
        });
        return ret;
    }

    public VariableInfoDocument setVariable(final String scopeId, final String varName, final XmlObject value) throws ManagementException {
        VariableInfoDocument ret = VariableInfoDocument.Factory.newInstance();
        final TVariableInfo vinf = ret.addNewVariableInfo();
        final TVariableRef sref = vinf.addNewSelf();
        this.dbexec(new BpelDatabase.Callable<Object>(){

            @Override
            public Object run(BpelDAOConnection session) throws Exception {
                ScopeDAO scope = session.getScope(new Long(scopeId));
                if (scope == null) {
                    throw new InvalidRequestException("ScopeNotFound:" + scopeId);
                }
                sref.setSiid(scopeId);
                sref.setIid(scope.getProcessInstance().getInstanceId().toString());
                sref.setName(varName);
                XmlDataDAO var = scope.getVariable(varName);
                if (var == null) {
                    throw new InvalidRequestException("VarNotFound:" + varName);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                value.save((OutputStream)out, new XmlOptions().setSaveOuter());
                Element value2 = DOMUtils.getFirstChildElement((Element)DOMUtils.stringToDOM((String)out.toString()));
                var.set((Node)value2);
                Node nval = var.get();
                if (nval != null) {
                    TVariableInfo.Value val = vinf.addNewValue();
                    val.getDomNode().appendChild(val.getDomNode().getOwnerDocument().importNode(nval, true));
                }
                return null;
            }
        });
        return ret;
    }

    public InstanceInfoDocument fault(Long iid, QName faultname, Element faultData) {
        return this.getInstanceInfo(iid);
    }

    public InstanceInfoDocument resume(Long iid) {
        this.getDebugger(iid).resume(iid);
        return this.getInstanceInfo(iid);
    }

    public InstanceInfoDocument suspend(Long iid) throws ManagementException {
        DebuggerSupport debugSupport = this.getDebugger(iid);
        assert (debugSupport != null) : "getDebugger(Long) returned NULL!";
        debugSupport.suspend(iid);
        return this.getInstanceInfo(iid);
    }

    public InstanceInfoDocument terminate(Long iid) throws ManagementException {
        DebuggerSupport debugSupport = this.getDebugger(iid);
        assert (debugSupport != null) : "getDebugger(Long) returned NULL!";
        debugSupport.terminate(iid);
        return this.getInstanceInfo(iid);
    }

    public InstanceInfoDocument recoverActivity(final Long iid, final Long aid, final String action) {
        try {
            this._db.exec(new BpelDatabase.Callable<QName>(){

                @Override
                public QName run(BpelDAOConnection conn) throws Exception {
                    ProcessInstanceDAO instance = conn.getInstance(iid);
                    if (instance == null) {
                        return null;
                    }
                    for (ActivityRecoveryDAO recovery : instance.getActivityRecoveries()) {
                        BpelProcess process;
                        if (recovery.getActivityId() != aid.longValue() || (process = ProcessAndInstanceManagementImpl.this._server._engine._activeProcesses.get(instance.getProcess().getProcessId())) == null) continue;
                        process.recoverActivity(instance, recovery.getChannel(), aid, action, null);
                        break;
                    }
                    return instance.getProcess().getProcessId();
                }
            });
        }
        catch (Exception e) {
            __log.error((Object)"Exception during activity recovery", (Throwable)e);
            throw new ProcessingException("Exception during activity recovery" + e.toString());
        }
        return this.getInstanceInfo(iid);
    }

    public Collection<Long> delete(String filter) {
        final InstanceFilter instanceFilter = new InstanceFilter(filter);
        final LinkedList<Long> ret = new LinkedList<Long>();
        if (this.garbage(filter)) {
            return ret;
        }
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection conn) {
                    Collection instances = conn.instanceQuery(instanceFilter);
                    for (ProcessInstanceDAO instance : instances) {
                        ProcessConf proc = ProcessAndInstanceManagementImpl.this._store.getProcessConfiguration(instance.getProcess().getProcessId());
                        if (proc == null) {
                            throw new ProcessNotFoundException("ProcessNotFound:" + instance.getProcess().getProcessId());
                        }
                        instance.delete(EnumSet.allOf(ProcessConf.CLEANUP_CATEGORY.class));
                        ret.add(instance.getInstanceId());
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            __log.error((Object)"Exception during instance deletion", (Throwable)e);
            throw new ProcessingException("Exception during instance deletion: " + e.toString());
        }
        return ret;
    }

    public List<String> getEventTimeline(String instanceFilter, String eventFilter) {
        final InstanceFilter ifilter = new InstanceFilter(instanceFilter, null, 0);
        final BpelEventFilter efilter = new BpelEventFilter(eventFilter, 0);
        List<Date> tline = this.dbexec(new BpelDatabase.Callable<List<Date>>(){

            @Override
            public List<Date> run(BpelDAOConnection session) throws Exception {
                return session.bpelEventTimelineQuery(ifilter, efilter);
            }
        });
        ArrayList<String> ret = new ArrayList<String>(tline.size());
        CollectionsX.transform(ret, tline, (UnaryFunction)new UnaryFunction<Date, String>(){

            public String apply(Date x) {
                return ISO8601DateParser.format((Date)x);
            }
        });
        return ret;
    }

    public EventInfoListDocument listEvents(String instanceFilter, String eventFilter, int maxCount) {
        final InstanceFilter ifilter = new InstanceFilter(instanceFilter, null, 0);
        final BpelEventFilter efilter = new BpelEventFilter(eventFilter, maxCount);
        EventInfoListDocument eid = EventInfoListDocument.Factory.newInstance();
        final TEventInfoList eil = eid.addNewEventInfoList();
        this.dbexec(new BpelDatabase.Callable<Object>(){

            @Override
            public Object run(BpelDAOConnection session) throws Exception {
                List events = session.bpelEventQuery(ifilter, efilter);
                for (BpelEvent event : events) {
                    TEventInfo tei = eil.addNewEventInfo();
                    ProcessAndInstanceManagementImpl.this.fillEventInfo(tei, event);
                }
                return null;
            }
        });
        return eid;
    }

    public ActivityExtInfoListDocument getExtensibilityElements(QName pid, Integer[] aids) {
        ActivityExtInfoListDocument aeild = ActivityExtInfoListDocument.Factory.newInstance();
        TActivitytExtInfoList taeil = aeild.addNewActivityExtInfoList();
        OProcess oprocess = this._server._engine.getOProcess(pid);
        if (oprocess == null) {
            throw new ProcessNotFoundException("The process \"" + pid + "\" does not exist.");
        }
        Integer[] arr$ = aids;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int aid = arr$[i$];
            OBase obase = oprocess.getChild(aid);
            if (obase == null || obase.debugInfo == null || obase.debugInfo.extensibilityElements == null) continue;
            for (Map.Entry entry : obase.debugInfo.extensibilityElements.entrySet()) {
                TActivityExtInfo taei = taeil.addNewActivityExtInfo();
                taei.setAiid("" + aid);
                Object extValue = entry.getValue();
                if (extValue instanceof Element) {
                    taei.getDomNode().appendChild(taei.getDomNode().getOwnerDocument().importNode((Element)extValue, true));
                    continue;
                }
                if (!(extValue instanceof String)) continue;
                Element valueElmt = taei.getDomNode().getOwnerDocument().createElementNS(((QName)entry.getKey()).getNamespaceURI(), ((QName)entry.getKey()).getLocalPart());
                valueElmt.appendChild(taei.getDomNode().getOwnerDocument().createTextNode((String)extValue));
                taei.getDomNode().appendChild(valueElmt);
            }
        }
        return aeild;
    }

    protected final DebuggerSupport getDebugger(QName procid) throws ManagementException {
        BpelProcess process = this._server._engine._activeProcesses.get(procid);
        if (process == null) {
            throw new ProcessNotFoundException("The process \"" + procid + "\" does not exist.");
        }
        return process._debugger;
    }

    protected final DebuggerSupport getDebugger(final Long iid) {
        QName processId;
        try {
            processId = this._db.exec(new BpelDatabase.Callable<QName>(){

                @Override
                public QName run(BpelDAOConnection conn) throws Exception {
                    ProcessInstanceDAO instance = conn.getInstance(iid);
                    return instance == null ? null : instance.getProcess().getProcessId();
                }
            });
        }
        catch (Exception e) {
            __log.error((Object)"Exception during instance retrieval", (Throwable)e);
            throw new ProcessingException("Exception during instance retrieval: " + e.toString());
        }
        return this.getDebugger(processId);
    }

    protected <T> T dbexec(BpelProcessDatabase.Callable<T> runnable) throws ManagementException {
        try {
            return runnable.exec();
        }
        catch (ManagementException me) {
            throw me;
        }
        catch (Exception e) {
            __log.error((Object)"Exception during database operation", (Throwable)e);
            throw new ManagementException("Exception during database operation: " + e.toString());
        }
    }

    protected <T> T dbexec(BpelDatabase.Callable<T> callable) throws ManagementException {
        try {
            return this._db.exec(callable);
        }
        catch (ManagementException me) {
            throw me;
        }
        catch (Exception ex) {
            __log.error((Object)"Exception during database operation", (Throwable)ex);
            throw new ManagementException("Exception during database operation" + ex.toString());
        }
    }

    private ProcessInfoDocument genProcessInfoDocument(BpelDAOConnection conn, QName procid, ProcessInfoCustomizer custom) throws ManagementException {
        if (procid == null) {
            throw new InvalidRequestException("Valid QName as process id expected.");
        }
        ProcessInfoDocument ret = ProcessInfoDocument.Factory.newInstance();
        TProcessInfo pi = ret.addNewProcessInfo();
        try {
            ProcessConf pconf = this._store.getProcessConfiguration(procid);
            if (pconf == null) {
                throw new ProcessNotFoundException("ProcessNotFound:" + procid);
            }
            this.fillProcessInfo(pi, pconf, custom);
            this.fillProcessInfoSummary(conn, Collections.singletonList(pi), custom);
        }
        catch (ManagementException me) {
            throw me;
        }
        catch (Exception e) {
            __log.error((Object)"Exception while retrieving process information", (Throwable)e);
            throw new ProcessingException("Exception while retrieving process information: " + e.toString());
        }
        return ret;
    }

    private InstanceInfoDocument genInstanceInfoDocument(BpelDAOConnection conn, Long iid) {
        if (iid == null) {
            throw new InvalidRequestException("Must specifiy instance id.");
        }
        InstanceInfoDocument ret = InstanceInfoDocument.Factory.newInstance();
        TInstanceInfo ii = ret.addNewInstanceInfo();
        ii.setIid(iid.toString());
        ProcessInstanceDAO instance = conn.getInstance(iid);
        if (instance == null) {
            throw new InstanceNotFoundException("InstanceNotFoundException " + iid);
        }
        this.fillInstanceInfo(ii, instance);
        return ret;
    }

    private ScopeInfoDocument genScopeInfoDocument(BpelDAOConnection conn, String siid, boolean includeActivityInfo) throws Exception {
        Long siidl;
        if (siid == null) {
            throw new InvalidRequestException("Must specifiy scope instance id.");
        }
        try {
            siidl = new Long(siid);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidRequestException("Invalid scope instance id.");
        }
        ScopeInfoDocument ret = ScopeInfoDocument.Factory.newInstance();
        TScopeInfo ii = ret.addNewScopeInfo();
        ii.setSiid(siid);
        try {
            ScopeDAO instance = conn.getScope(siidl);
            if (instance == null) {
                throw new InvalidRequestException("Scope not found: " + siidl);
            }
            this.fillScopeInfo(ii, instance, includeActivityInfo);
        }
        catch (Exception e) {
            ProcessAndInstanceManagementImpl.failIfSQLException(e);
            __log.error((Object)"Exception while retrieving scope information", (Throwable)e);
        }
        return ret;
    }

    private void fillProcessInfoSummary(BpelDAOConnection conn, List<TProcessInfo> infos, ProcessInfoCustomizer custom) {
        if (custom.includeInstanceSummary()) {
            HashSet<String> pids = new HashSet<String>();
            for (TProcessInfo i : infos) {
                pids.add(i.getPid());
            }
            Map m = conn.getProcessManagement().countInstancesSummary(pids);
            Map f = conn.getProcessManagement().findFailedCountAndLastFailedDateForProcessIds(pids);
            for (TProcessInfo info : infos) {
                TInstanceSummary isum = info.addNewInstanceSummary();
                this.genInstanceSummaryEntry(isum.addNewInstances(), TInstanceStatus.ACTIVE, info.getPid(), m);
                this.genInstanceSummaryEntry(isum.addNewInstances(), TInstanceStatus.COMPLETED, info.getPid(), m);
                this.genInstanceSummaryEntry(isum.addNewInstances(), TInstanceStatus.ERROR, info.getPid(), m);
                this.genInstanceSummaryEntry(isum.addNewInstances(), TInstanceStatus.FAILED, info.getPid(), m);
                this.genInstanceSummaryEntry(isum.addNewInstances(), TInstanceStatus.SUSPENDED, info.getPid(), m);
                this.genInstanceSummaryEntry(isum.addNewInstances(), TInstanceStatus.TERMINATED, info.getPid(), m);
                this.getInstanceSummaryActivityFailure(isum, f, info.getPid());
            }
        }
    }

    private void fillProcessInfo(TProcessInfo info, ProcessConf pconf, ProcessInfoCustomizer custom) {
        if (pconf == null) {
            throw new IllegalArgumentException("Null pconf.");
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Filling process info for " + pconf.getProcessId()));
        }
        info.setPid(pconf.getProcessId().toString());
        if (pconf.getState() == ProcessState.RETIRED) {
            info.setStatus(TProcessStatus.RETIRED);
        } else {
            info.setStatus(TProcessStatus.ACTIVE);
        }
        info.setVersion(pconf.getVersion());
        TDefinitionInfo definfo = info.addNewDefinitionInfo();
        definfo.setProcessName(pconf.getType());
        TDeploymentInfo depinfo = info.addNewDeploymentInfo();
        depinfo.setPackage(pconf.getPackage());
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(" package name: " + depinfo.getPackage()));
        }
        depinfo.setDocument(pconf.getBpelDocument());
        depinfo.setDeployDate(this.toCalendar(pconf.getDeployDate()));
        depinfo.setDeployer(pconf.getDeployer());
        if (custom.includeDocumentLists()) {
            TProcessInfo.Documents docinfo = info.addNewDocuments();
            List files = pconf.getFiles();
            if (files != null) {
                this.genDocumentInfo(docinfo, files.toArray(new File[files.size()]), true);
            } else if (__log.isDebugEnabled()) {
                __log.debug((Object)("fillProcessInfo: No files for " + pconf.getProcessId()));
            }
        }
        TProcessProperties properties = info.addNewProperties();
        if (custom.includeProcessProperties()) {
            for (Map.Entry propEntry : pconf.getProcessProperties().entrySet()) {
                TProcessProperties.Property tprocProp = properties.addNewProperty();
                tprocProp.setName(new QName(((QName)propEntry.getKey()).getNamespaceURI(), ((QName)propEntry.getKey()).getLocalPart()));
                Node propNode = tprocProp.getDomNode();
                Document processInfoDoc = propNode.getOwnerDocument();
                Node node2append = processInfoDoc.importNode((Node)propEntry.getValue(), true);
                propNode.appendChild(node2append);
            }
        }
        TEndpointReferences eprs = info.addNewEndpoints();
        OProcess oprocess = this._server._engine.getOProcess(pconf.getProcessId());
        if (custom.includeEndpoints() && oprocess != null) {
            for (OPartnerLink oplink : oprocess.getAllPartnerLinks()) {
                EndpointReference pepr;
                if (!oplink.hasPartnerRole() || !oplink.initializePartnerRole || (pepr = this._server._engine._activeProcesses.get(pconf.getProcessId()).getInitialPartnerRoleEPR(oplink)) == null) continue;
                TEndpointReferences.EndpointRef epr = eprs.addNewEndpointRef();
                Document eprNodeDoc = epr.getDomNode().getOwnerDocument();
                epr.getDomNode().appendChild(eprNodeDoc.importNode(pepr.toXML().getDocumentElement(), true));
            }
        }
    }

    String findVersionStringFromNodeToken(String packageName) {
        int i;
        for (i = packageName.length() - 1; i > 0 && Character.isDigit(packageName.charAt(i)); --i) {
        }
        if (i < packageName.length() - 1 && packageName.charAt(i) == '-') {
            return packageName.substring(i + 1);
        }
        return null;
    }

    private void genDocumentInfo(TProcessInfo.Documents docinfo, File[] files, boolean recurse) {
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isHidden()) continue;
            if (f.isDirectory()) {
                if (!recurse) continue;
                this.genDocumentInfo(docinfo, f.listFiles(), true);
                continue;
            }
            if (!f.isFile()) continue;
            this.genDocumentInfo(docinfo, f);
        }
    }

    private void genDocumentInfo(TProcessInfo.Documents docinfo, File f) {
        DocumentInfoGenerator dig = new DocumentInfoGenerator(f);
        if (dig.isRecognized() && dig.isVisible()) {
            TDocumentInfo doc = docinfo.addNewDocument();
            doc.setName(dig.getName());
            doc.setSource(dig.getURL());
            doc.setType(dig.getType());
        }
    }

    private void genInstanceSummaryEntry(TInstanceSummary.Instances instances, TInstanceStatus.Enum state, String pid, Map<ProcessManagementDAO.InstanceSummaryKey, Long> summary) {
        instances.setState(state);
        Long count = summary.get(new ProcessManagementDAO.InstanceSummaryKey(pid, state.toString()));
        instances.setCount(count == null ? 0 : count.intValue());
    }

    private void getInstanceSummaryActivityFailure(TInstanceSummary summary, Map<String, ProcessManagementDAO.FailedSummaryValue> f, String pid) {
        ProcessManagementDAO.FailedSummaryValue v = f.get(pid);
        if (v != null) {
            TFailuresInfo failures = summary.addNewFailures();
            failures.setDtFailure(this.toCalendar(v.lastFailed));
            failures.setCount(v.count.intValue());
        }
    }

    private void fillProperties(TInstanceInfo info, ProcessInstanceDAO instance, Map<QName, String> props) {
        TInstanceInfo.CorrelationProperties corrProperties = info.addNewCorrelationProperties();
        for (Map.Entry<QName, String> property : props.entrySet()) {
            TCorrelationProperty tproperty = corrProperties.addNewCorrelationProperty();
            tproperty.setPropertyName(property.getKey());
            tproperty.setStringValue(property.getValue());
        }
    }

    private void fillInstanceSummary(TInstanceInfo info, ProcessInstanceDAO instance) {
        info.setIid("" + instance.getInstanceId());
        ProcessDAO processDAO = instance.getProcess();
        info.setPid(processDAO.getProcessId().toString());
        info.setProcessName(processDAO.getType());
        info.setDtStarted(this.toCalendar(instance.getCreateTime()));
        info.setDtLastActive(this.toCalendar(instance.getLastActiveTime()));
        info.setStatus(__psc.cvtInstanceStatus(instance.getState()));
        if (instance.getFault() != null) {
            TFaultInfo faultInfo = info.addNewFaultInfo();
            faultInfo.setName(instance.getFault().getName());
            faultInfo.setExplanation(instance.getFault().getExplanation());
            faultInfo.setAiid(instance.getFault().getActivityId());
            faultInfo.setLineNumber(instance.getFault().getLineNo());
        }
        if (instance.getActivityFailureCount() > 0) {
            TFailuresInfo failures = info.addNewFailures();
            failures.setDtFailure(this.toCalendar(instance.getActivityFailureDateTime()));
            failures.setCount(instance.getActivityFailureCount());
        }
    }

    private void fillInstanceInfo(TInstanceInfo info, ProcessInstanceDAO instance) {
        this.fillInstanceSummary(info, instance);
        if (instance.getRootScope() != null) {
            info.setRootScope(this.genScopeRef(instance.getRootScope()));
        }
        ProcessInstanceDAO.EventsFirstLastCountTuple flc = instance.getEventsFirstLastCount();
        TInstanceInfo.EventInfo eventInfo = info.addNewEventInfo();
        if (flc != null) {
            eventInfo.setFirstDtime(this.toCalendar(flc.first));
            eventInfo.setLastDtime(this.toCalendar(flc.last));
            eventInfo.setCount(flc.count);
        }
        if (!instance.getCorrelationSets().isEmpty()) {
            TInstanceInfo.CorrelationProperties corrProperties = info.addNewCorrelationProperties();
            for (CorrelationSetDAO correlationSetDAO : instance.getCorrelationSets()) {
                for (Map.Entry property : correlationSetDAO.getProperties().entrySet()) {
                    TCorrelationProperty tproperty = corrProperties.addNewCorrelationProperty();
                    tproperty.setCsetid("" + correlationSetDAO.getCorrelationSetId());
                    tproperty.setPropertyName((QName)property.getKey());
                    tproperty.setStringValue((String)property.getValue());
                }
            }
        }
    }

    private void fillScopeInfo(TScopeInfo scopeInfo, ScopeDAO scope, boolean includeActivityInfo) {
        Collection plinks;
        scopeInfo.setSiid("" + scope.getScopeInstanceId());
        scopeInfo.setName(scope.getName());
        if (scope.getParentScope() != null) {
            scopeInfo.setParentScopeRef(this.genScopeRef(scope.getParentScope()));
        }
        scopeInfo.setStatus(__psc.cvtScopeStatus(scope.getState()));
        TScopeInfo.Children children = scopeInfo.addNewChildren();
        for (ScopeDAO i : scope.getChildScopes()) {
            this.fillScopeRef(children.addNewChildRef(), i);
        }
        TScopeInfo.Variables vars = scopeInfo.addNewVariables();
        for (XmlDataDAO i : scope.getVariables()) {
            this.fillVariableRef(vars.addNewVariableRef(), i);
        }
        if (!scope.getCorrelationSets().isEmpty()) {
            TScopeInfo.CorrelationSets correlationSets = scopeInfo.addNewCorrelationSets();
            for (CorrelationSetDAO correlationSetDAO : scope.getCorrelationSets()) {
                TScopeInfo.CorrelationSets.CorrelationSet correlationSet = correlationSets.addNewCorrelationSet();
                correlationSet.setCsetid("" + correlationSetDAO.getCorrelationSetId());
                correlationSet.setName(correlationSetDAO.getName());
                for (Map.Entry entry : correlationSetDAO.getProperties().entrySet()) {
                    TCorrelationProperty tproperty = correlationSet.addNewCorrelationProperty();
                    tproperty.setCsetid("" + correlationSetDAO.getCorrelationSetId());
                    tproperty.setPropertyName((QName)entry.getKey());
                    tproperty.setStringValue((String)entry.getValue());
                }
            }
        }
        if (includeActivityInfo) {
            Collection recoveries = scope.getProcessInstance().getActivityRecoveries();
            TScopeInfo.Activities activities = scopeInfo.addNewActivities();
            List events = scope.listEvents();
            if (events != null && events.size() > 0) {
                ActivityStateDocumentBuilder b = new ActivityStateDocumentBuilder();
                for (BpelEvent bpelEvent : events) {
                    b.onEvent(bpelEvent);
                }
                for (ActivityInfoDocument activityInfoDocument : b.getActivities()) {
                    for (ActivityRecoveryDAO recovery : recoveries) {
                        if (!String.valueOf(recovery.getActivityId()).equals(activityInfoDocument.getActivityInfo().getAiid())) continue;
                        TFailureInfo failure = activityInfoDocument.getActivityInfo().addNewFailure();
                        failure.setReason(recovery.getReason());
                        failure.setDtFailure(this.toCalendar(recovery.getDateTime()));
                        failure.setActions(recovery.getActions());
                        failure.setRetries(recovery.getRetries());
                        activityInfoDocument.getActivityInfo().setStatus(TActivityStatus.FAILURE);
                    }
                    activities.addNewActivityInfo().set((XmlObject)activityInfoDocument.getActivityInfo());
                }
            } else if (scope.getParentScope() == null) {
                for (ActivityRecoveryDAO recovery : recoveries) {
                    ActivityInfoDocument activityInfoDocument = ActivityInfoDocument.Factory.newInstance();
                    activityInfoDocument.addNewActivityInfo().setAiid(String.valueOf(recovery.getActivityId()));
                    activityInfoDocument.getActivityInfo().setType("OActivity");
                    activityInfoDocument.getActivityInfo().setScope(TScopeRef.Factory.newInstance());
                    TFailureInfo failure = activityInfoDocument.getActivityInfo().addNewFailure();
                    failure.setReason(recovery.getReason());
                    failure.setDtFailure(this.toCalendar(recovery.getDateTime()));
                    failure.setActions(recovery.getActions());
                    failure.setRetries(recovery.getRetries());
                    activityInfoDocument.getActivityInfo().setStatus(TActivityStatus.FAILURE);
                    activities.addNewActivityInfo().set((XmlObject)activityInfoDocument.getActivityInfo());
                }
            }
        }
        if ((plinks = scope.getPartnerLinks()).size() > 0) {
            TEndpointReferences refs = scopeInfo.addNewEndpoints();
            for (PartnerLinkDAO plink : plinks) {
                if (plink.getPartnerRoleName() == null || plink.getPartnerRoleName().length() <= 0) continue;
                TEndpointReferences.EndpointRef ref = refs.addNewEndpointRef();
                ref.setPartnerLink(plink.getPartnerLinkName());
                ref.setPartnerRole(plink.getPartnerRoleName());
                if (plink.getPartnerEPR() == null) continue;
                Document document = ref.getDomNode().getOwnerDocument();
                ref.getDomNode().appendChild(document.importNode(plink.getPartnerEPR(), true));
            }
        }
    }

    private void fillVariableRef(TVariableRef ref, XmlDataDAO i) {
        ref.setIid(i.getScopeDAO().getProcessInstance().getInstanceId().toString());
        ref.setSiid(i.getScopeDAO().getScopeInstanceId().toString());
        ref.setName(i.getName());
    }

    private TScopeRef genScopeRef(ScopeDAO scope) {
        TScopeRef tref = TScopeRef.Factory.newInstance();
        this.fillScopeRef(tref, scope);
        return tref;
    }

    private void fillScopeRef(TScopeRef tref, ScopeDAO scope) {
        tref.setSiid(scope.getScopeInstanceId().toString());
        tref.setStatus(__psc.cvtScopeStatus(scope.getState()));
        tref.setName(scope.getName());
        tref.setModelId("" + scope.getModelId());
    }

    private void fillEventInfo(TEventInfo info, BpelEvent event) {
        info.setName(BpelEvent.eventName((BpelEvent)event));
        info.setType(event.getType().toString());
        info.setLineNumber(event.getLineNo());
        info.setTimestamp(this.toCalendar(event.getTimestamp()));
        if (event instanceof ActivityEvent) {
            info.setActivityName(((ActivityEvent)event).getActivityName());
            info.setActivityId(((ActivityEvent)event).getActivityId());
            info.setActivityType(((ActivityEvent)event).getActivityType());
            info.setActivityDefinitionId(((ActivityEvent)event).getActivityDeclarationId());
        }
        if (event instanceof CorrelationEvent) {
            info.setPortType(((CorrelationEvent)event).getPortType());
            info.setOperation(((CorrelationEvent)event).getOperation());
            info.setMexId(((CorrelationEvent)event).getMessageExchangeId());
        }
        if (event instanceof CorrelationMatchEvent) {
            info.setPortType(((CorrelationMatchEvent)event).getPortType());
        }
        if (event instanceof CorrelationSetEvent) {
            info.setCorrelationSet(((CorrelationSetEvent)event).getCorrelationSetName());
        }
        if (event instanceof CorrelationSetWriteEvent) {
            info.setCorrelationKey(((CorrelationSetWriteEvent)event).getCorrelationSetName());
        }
        if (event instanceof ExpressionEvaluationEvent) {
            info.setExpression(((ExpressionEvaluationEvent)event).getExpression());
        }
        if (event instanceof ExpressionEvaluationFailedEvent) {
            info.setFault(((ExpressionEvaluationFailedEvent)event).getFault());
        }
        if (event instanceof NewProcessInstanceEvent) {
            if (((NewProcessInstanceEvent)event).getRootScopeId() != null) {
                info.setRootScopeId(((NewProcessInstanceEvent)event).getRootScopeId().longValue());
            }
            info.setScopeDefinitionId(((NewProcessInstanceEvent)event).getScopeDeclarationId());
        }
        if (event instanceof PartnerLinkEvent) {
            info.setPartnerLinkName(((PartnerLinkEvent)event).getpLinkName());
        }
        if (event instanceof ProcessCompletionEvent) {
            info.setFault(((ProcessCompletionEvent)event).getFault());
        }
        if (event instanceof ProcessEvent) {
            info.setProcessId(((ProcessEvent)event).getProcessId());
            info.setProcessType(((ProcessEvent)event).getProcessName());
        }
        if (event instanceof ProcessInstanceEvent) {
            info.setInstanceId(((ProcessInstanceEvent)event).getProcessInstanceId().longValue());
        }
        if (event instanceof ProcessInstanceStartedEvent) {
            info.setRootScopeId(((ProcessInstanceStartedEvent)event).getRootScopeId().longValue());
            info.setRootScopeDeclarationId(((ProcessInstanceStartedEvent)event).getScopeDeclarationId());
        }
        if (event instanceof ProcessInstanceStateChangeEvent) {
            info.setOldState((int)((ProcessInstanceStateChangeEvent)event).getOldState());
            info.setNewState((int)((ProcessInstanceStateChangeEvent)event).getNewState());
        }
        if (event instanceof ProcessMessageExchangeEvent) {
            info.setPortType(((ProcessMessageExchangeEvent)event).getPortType());
            info.setOperation(((ProcessMessageExchangeEvent)event).getOperation());
            info.setMexId(((ProcessMessageExchangeEvent)event).getMessageExchangeId());
        }
        if (event instanceof ScopeCompletionEvent) {
            info.setSuccess(true);
        }
        if (event instanceof ScopeEvent) {
            info.setScopeId(((ScopeEvent)event).getScopeId().longValue());
            if (((ScopeEvent)event).getParentScopeId() != null) {
                info.setParentScopeId(((ScopeEvent)event).getParentScopeId().longValue());
            }
            if (((ScopeEvent)event).getScopeName() != null) {
                info.setScopeName(((ScopeEvent)event).getScopeName());
            }
            info.setScopeDefinitionId(((ScopeEvent)event).getScopeDeclarationId());
        }
        if (event instanceof ScopeFaultEvent) {
            info.setFault(((ScopeFaultEvent)event).getFaultType());
            info.setFaultLineNumber(((ScopeFaultEvent)event).getFaultLineNo());
            info.setExplanation(((ScopeFaultEvent)event).getExplanation());
        }
        if (event instanceof VariableEvent) {
            info.setVariableName(((VariableEvent)event).getVarName());
        }
        if (event instanceof VariableModificationEvent && ((VariableModificationEvent)event).getNewValue() != null) {
            info.setNewValue(DOMUtils.domToString((Node)((VariableModificationEvent)event).getNewValue()));
        }
    }

    private Calendar toCalendar(Date dtime) {
        if (dtime == null) {
            return null;
        }
        Calendar c = (Calendar)this._calendar.clone();
        c.setTime(dtime);
        return c;
    }

    public InstanceInfoListDocument queryInstances(final String query) {
        InstanceInfoListDocument ret = InstanceInfoListDocument.Factory.newInstance();
        final TInstanceInfoList infolist = ret.addNewInstanceInfoList();
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection conn) {
                    Collection instances = conn.instanceQuery(query);
                    for (ProcessInstanceDAO instance : instances) {
                        ProcessAndInstanceManagementImpl.this.fillInstanceInfo(infolist.addNewInstanceInfo(), instance);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            __log.error((Object)"Exception while querying instances", (Throwable)e);
            throw new ProcessingException("Exception while querying instances: " + e.toString());
        }
        return ret;
    }

    Collection<ProcessConf> processQuery(ProcessFilter filter) {
        Pattern pattern;
        List pids = this._store.getProcesses();
        if (filter != null && filter.getNameFilter() != null) {
            pattern = Pattern.compile(filter.getNameFilter().replace("*", ".*") + "(-\\d*)?");
            CollectionsX.remove_if((Collection)pids, (MemberOfFunction)new MemberOfFunction<QName>(){

                public boolean isMember(QName o) {
                    return !pattern.matcher(o.getLocalPart()).matches();
                }
            });
        }
        if (filter != null && filter.getNamespaceFilter() != null) {
            pattern = Pattern.compile(filter.getNamespaceFilter().replace("*", ".*"));
            CollectionsX.remove_if((Collection)pids, (MemberOfFunction)new MemberOfFunction<QName>(){

                public boolean isMember(QName o) {
                    String ns = o.getNamespaceURI() == null ? "" : o.getNamespaceURI();
                    return !pattern.matcher(ns).matches();
                }
            });
        }
        LinkedList<ProcessConf> confs = new LinkedList<ProcessConf>();
        for (QName pid : pids) {
            ProcessConf pconf = this._store.getProcessConfiguration(pid);
            confs.add(pconf);
        }
        if (filter != null) {
            if (filter.getDeployedDateFilter() != null) {
                for (final String ddf : filter.getDeployedDateFilter()) {
                    Date dd;
                    try {
                        dd = ISO8601DateParser.parse((String)Filter.getDateWithoutOp((String)ddf));
                    }
                    catch (ParseException e) {
                        __log.error((Object)"Exception while parsing date", (Throwable)e);
                        throw new RuntimeException(e.toString());
                    }
                    CollectionsX.remove_if(confs, (MemberOfFunction)new MemberOfFunction<ProcessConf>(){

                        public boolean isMember(ProcessConf o) {
                            if (ddf.startsWith("=")) {
                                return !o.getDeployDate().equals(dd);
                            }
                            if (ddf.startsWith("<=")) {
                                return o.getDeployDate().getTime() > dd.getTime();
                            }
                            if (ddf.startsWith(">=")) {
                                return o.getDeployDate().getTime() < dd.getTime();
                            }
                            if (ddf.startsWith("<")) {
                                return o.getDeployDate().getTime() >= dd.getTime();
                            }
                            if (ddf.startsWith(">")) {
                                return o.getDeployDate().getTime() <= dd.getTime();
                            }
                            return false;
                        }
                    });
                }
            }
            if (filter.getOrders() != null) {
                ComparatorChain cchain = new ComparatorChain();
                for (String key : filter.getOrders()) {
                    Comparator<ProcessConf> c;
                    boolean ascending = true;
                    String orderKey = key;
                    if (key.startsWith("+") || key.startsWith("-")) {
                        orderKey = key.substring(1, key.length());
                        if (key.startsWith("-")) {
                            ascending = false;
                        }
                    }
                    if ("name".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                return o1.getProcessId().getLocalPart().compareTo(o2.getProcessId().getLocalPart());
                            }
                        };
                    } else if ("namespace".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                String ns1 = o1.getProcessId().getNamespaceURI() == null ? "" : o1.getProcessId().getNamespaceURI();
                                String ns2 = o2.getProcessId().getNamespaceURI() == null ? "" : o2.getProcessId().getNamespaceURI();
                                return ns1.compareTo(ns2);
                            }
                        };
                    } else if ("version".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                return 0;
                            }
                        };
                    } else if ("deployed".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                return o1.getDeployDate().compareTo(o2.getDeployDate());
                            }
                        };
                    } else {
                        __log.debug((Object)("unrecognized order key" + orderKey));
                        continue;
                    }
                    cchain.addComparator((Comparator)c, !ascending);
                }
                Collections.sort(confs, cchain);
            }
        }
        return confs;
    }

    public ReplayResponseDocument replay(final Replay request) throws ManagementException {
        final Throwable[] e = new Throwable[1];
        try {
            ReplayResponseDocument response = this._db.exec(new BpelDatabase.Callable<ReplayResponseDocument>(){

                @Override
                public ReplayResponseDocument run(BpelDAOConnection conn) throws Exception {
                    try {
                        ReplayResponse response = ReplayResponse.Factory.newInstance();
                        Replayer replayer = new Replayer();
                        List<Long> iids = replayer.replayInstances(request, ProcessAndInstanceManagementImpl.this._server.getEngine(), conn);
                        for (Long iid : iids) {
                            response.addRestoredIID(iid.longValue());
                        }
                        ReplayResponseDocument responseDoc = ReplayResponseDocument.Factory.newInstance();
                        responseDoc.setReplayResponse(response);
                        return responseDoc;
                    }
                    catch (Throwable t) {
                        e[0] = t;
                        throw new Exception("", t);
                    }
                }
            });
            if (e[0] != null) {
                __log.debug((Object)"throwing pending exception");
                throw e[0];
            }
            return response;
        }
        catch (Throwable e2) {
            throw new ManagementException("", e2);
        }
    }

    public GetCommunicationResponseDocument getCommunication(final GetCommunication request) throws ManagementException {
        final Throwable[] e = new Throwable[1];
        try {
            GetCommunicationResponseDocument response = this._db.exec(new BpelDatabase.Callable<GetCommunicationResponseDocument>(){

                @Override
                public GetCommunicationResponseDocument run(BpelDAOConnection conn) throws Exception {
                    try {
                        Replayer replayer = new Replayer();
                        GetCommunicationResponseDocument responseDoc = GetCommunicationResponseDocument.Factory.newInstance();
                        responseDoc.setGetCommunicationResponse(replayer.getCommunication(request, conn));
                        return responseDoc;
                    }
                    catch (Throwable e2) {
                        e[0] = e2;
                        throw new Exception("", e2);
                    }
                }
            });
            if (e[0] != null) {
                __log.debug((Object)"throwing pending exception");
                throw e[0];
            }
            return response;
        }
        catch (Throwable e2) {
            throw new ManagementException("", e2);
        }
    }

    private static void failIfSQLException(Exception e) throws Exception {
        String[] fatal = new String[]{"org.hibernate", "org.apache.openjpa", "java.sql", "javax.sql"};
        for (int i = 0; i < fatal.length; ++i) {
            if (!e.getClass().getName().startsWith(fatal[i])) continue;
            throw e;
        }
    }
}

