/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.replayer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQConstants;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import net.sf.saxon.Configuration;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.PartnerLinkMyRoleImpl;
import org.apache.ode.bpel.engine.replayer.ReplayerBpelRuntimeContextImpl;
import org.apache.ode.bpel.engine.replayer.ReplayerScheduler;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.pmapi.CommunicationType;
import org.apache.ode.bpel.pmapi.ExchangeType;
import org.apache.ode.bpel.pmapi.MockQueryRequestDocument;
import org.apache.ode.bpel.pmapi.MockQueryResponseDocument;
import org.apache.ode.bpel.pmapi.ResponseType;
import org.apache.ode.bpel.runtime.PROCESS;
import org.apache.ode.utils.DOMUtils;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReplayerContext {
    private static final Log __log = LogFactory.getLog(ReplayerContext.class);
    public ReplayerScheduler scheduler;
    public BpelEngineImpl bpelEngine;
    public ReplayerBpelRuntimeContextImpl runtimeContext;
    public Map<QName, CommunicationType.ServiceConfig> servicesConfig = new HashMap<QName, CommunicationType.ServiceConfig>();
    public CommunicationType replayerConfig;
    public final Date replayStartDate;
    public Answers answers = new Answers();

    private void scheduleInvoke(final CommunicationType.Exchange e, final MyRoleMessageExchangeImpl mex) {
        final Date time = e.getCreateTime().getTime();
        this.scheduler.scheduleReplayerJob(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                __log.debug((Object)("call " + e));
                mex.getDAO().setStatus(MessageExchange.Status.ASYNC.toString());
                ReplayerContext.this.runtimeContext.handleIncomingRequest(mex, time);
                return null;
            }
        }, time, this.runtimeContext);
    }

    public void init(final CommunicationType r, ReplayerScheduler scheduler) throws Exception {
        this.scheduler = scheduler;
        this.replayerConfig = r;
        for (CommunicationType.ServiceConfig s : r.getServiceConfigList()) {
            this.servicesConfig.put(s.getService(), s);
        }
        final List exchangeList = r.getExchangeList();
        for (int i = 1; i < exchangeList.size(); ++i) {
            CommunicationType.Exchange e = (CommunicationType.Exchange)exchangeList.get(i);
            if (e.getType() != ExchangeType.P || e.isSetFailure()) continue;
            this.answers.add(e);
        }
        final CommunicationType.Exchange e = (CommunicationType.Exchange)exchangeList.get(0);
        final Date time = e.getCreateTime().getTime();
        scheduler.scheduleReplayerJob(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                __log.debug((Object)("initial call " + e));
                final BpelProcess p = ReplayerContext.this.bpelEngine.getNewestProcessByType(r.getProcessType());
                final ProcessDAO processDAO = p.getProcessDAO();
                final MyRoleMessageExchangeImpl mex = ReplayerBpelRuntimeContextImpl.createMyRoleMex(e, ReplayerContext.this.bpelEngine);
                p.invokeProcess(mex, new BpelProcess.InvokeHandler(){

                    public boolean invoke(PartnerLinkMyRoleImpl target, PartnerLinkMyRoleImpl.RoutingInfo routing, boolean createInstance) {
                        if (routing.messageRoute == null && createInstance) {
                            ProcessInstanceDAO newInstance = processDAO.createInstance(routing.correlator);
                            ReplayerContext.this.runtimeContext = new ReplayerBpelRuntimeContextImpl(p, newInstance, new PROCESS(p.getOProcess()), mex, ReplayerContext.this);
                            ReplayerContext.this.runtimeContext.setCurrentEventDateTime(time);
                            ReplayerContext.this.runtimeContext.updateMyRoleMex(mex);
                            ReplayerContext.this.runtimeContext.execute();
                            return true;
                        }
                        if (routing.messageRoute != null) {
                            throw new IllegalStateException("Instantiating mex causes invocation of existing instance " + mex);
                        }
                        return false;
                    }
                }, true);
                for (int i = 1; i < exchangeList.size(); ++i) {
                    CommunicationType.Exchange e2 = (CommunicationType.Exchange)exchangeList.get(i);
                    if (e2.getType() != ExchangeType.M) continue;
                    MyRoleMessageExchangeImpl mex2 = ReplayerBpelRuntimeContextImpl.createMyRoleMex(e2, ReplayerContext.this.bpelEngine);
                    ReplayerContext.this.runtimeContext.updateMyRoleMex(mex2);
                    ReplayerContext.this.scheduleInvoke(e2, mex2);
                }
                return null;
            }
        }, time, null);
    }

    public ReplayerContext(Date replayStartDate) {
        this.replayStartDate = replayStartDate;
    }

    public CommunicationType.ServiceConfig getServiceConfig(QName service) {
        CommunicationType.ServiceConfig c = this.servicesConfig.get(service);
        if (c == null) {
            c = CommunicationType.ServiceConfig.Factory.newInstance();
            c.setService(service);
            c.addNewReplayType().setMock(XmlAnySimpleType.Factory.newInstance());
            return c;
        }
        return c;
    }

    public void checkRollbackOnFault() {
        if (this.replayerConfig.getRollbackOnFault()) {
            RuntimeException e = new RuntimeException("Process instance run into fault.");
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"", (Throwable)e);
            }
            throw e;
        }
    }

    public static class AnswerResult {
        public final boolean isLive;
        public final CommunicationType.Exchange e;

        public AnswerResult(boolean isLive, CommunicationType.Exchange e) {
            this.isLive = isLive;
            this.e = e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnswersForKey {
        List<CommunicationType.Exchange> answers = new ArrayList<CommunicationType.Exchange>();
        int answerPos = 0;

        public boolean isCompleted() {
            return this.answerPos >= this.answers.size();
        }

        public void remainingExchanges(List<CommunicationType.Exchange> e) {
            for (int i = this.answerPos; i < this.answers.size(); ++i) {
                e.add(this.answers.get(i));
            }
        }

        public String toString() {
            return new Integer(this.answerPos).toString() + " / " + this.answers.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Answers {
        public Map<String, AnswersForKey> answersMap = new HashMap<String, AnswersForKey>();

        public String getAnswersKey(QName service, String operation) {
            return service.toString() + ";" + operation;
        }

        public void add(CommunicationType.Exchange e) {
            CommunicationType.ServiceConfig cfg = ReplayerContext.this.getServiceConfig(e.getService());
            if (cfg.getReplayType().isSetMock()) {
                String key = this.getAnswersKey(e.getService(), e.getOperation());
                AnswersForKey v = this.answersMap.get(key);
                if (v == null) {
                    v = new AnswersForKey();
                    this.answersMap.put(key, v);
                }
                v.answers.add(e);
            }
        }

        public AnswerResult fetchAnswer(QName service, String operation, Element outgoingMessage, Date currentEventDateTime) {
            __log.debug((Object)("fetching answer for " + service + " " + operation));
            CommunicationType.ServiceConfig cfg = ReplayerContext.this.getServiceConfig(service);
            if (cfg.getReplayType().isSetMock()) {
                CommunicationType.Exchange e;
                String key = this.getAnswersKey(service, operation);
                AnswersForKey v = this.answersMap.get(key);
                CommunicationType.Exchange exchange = v == null ? null : (e = v.answerPos < v.answers.size() ? v.answers.get(v.answerPos) : null);
                if (e == null) {
                    throw new IllegalStateException("answer for " + service + " " + operation + " at time " + currentEventDateTime + " not found, outgoing message was " + DOMUtils.domToString((Node)outgoingMessage));
                }
                ++v.answerPos;
                __log.debug((Object)("fetched " + e));
                return new AnswerResult(false, e);
            }
            if (cfg.getReplayType().isSetMockQuery()) {
                return new AnswerResult(false, this.fetchMockQuery(service, operation, outgoingMessage, cfg));
            }
            if (cfg.getReplayType().isSetLive()) {
                return new AnswerResult(true, null);
            }
            assert (false);
            return null;
        }

        public void remainingExchanges(List<CommunicationType.Exchange> e) {
            for (AnswersForKey v : this.answersMap.values()) {
                v.remainingExchanges(e);
            }
        }

        private CommunicationType.Exchange fetchMockQuery(QName service, String operation, Element outgoingMessage, CommunicationType.ServiceConfig serviceConfig) {
            try {
                MockQueryRequestDocument request = MockQueryRequestDocument.Factory.newInstance();
                request.addNewMockQueryRequest().addNewIn().set(XmlObject.Factory.parse((Node)outgoingMessage));
                String xquery = serviceConfig.getReplayType().getMockQuery();
                SaxonXQDataSource xqds = new SaxonXQDataSource();
                XQConnection xqconn = xqds.getConnection();
                Configuration configuration = ((SaxonXQConnection)xqconn).getConfiguration();
                configuration.setHostLanguage(51);
                XQPreparedExpression exp = xqconn.prepareExpression(xquery);
                Document requestNode = DOMUtils.parse((XMLStreamReader)request.newXMLStreamReader());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("request " + request.toString()));
                }
                exp.bindItem(XQConstants.CONTEXT_ITEM, xqconn.createItemFromNode((Node)requestNode, xqconn.createNodeType()));
                XQResultSequence result = exp.executeQuery();
                MockQueryResponseDocument response = MockQueryResponseDocument.Factory.parse((XMLStreamReader)result.getSequenceAsStream());
                XmlOptions opts = new XmlOptions();
                ArrayList errors = new ArrayList();
                opts.setErrorListener(errors);
                if (!response.validate(opts)) {
                    __log.error((Object)("MockQuery response doesn't validate. Errors: " + errors + " Request: " + request.toString() + " Response: " + response.toString()), (Throwable)new Exception());
                    throw new IllegalStateException("MockQuery response doesn't validate.");
                }
                ResponseType response2 = response.getMockQueryResponse();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("mockQuery result " + response));
                }
                CommunicationType.Exchange answer = CommunicationType.Exchange.Factory.newInstance();
                if (response2.isSetOut()) {
                    answer.setOut(response2.getOut());
                }
                if (response2.isSetFault()) {
                    answer.setFault(response2.getFault());
                }
                if (response2.isSetFailure()) {
                    answer.setFailure(response2.getFailure());
                }
                return answer;
            }
            catch (Exception e) {
                __log.error((Object)"", (Throwable)e);
                __log.error((Object)e.getCause());
                throw new IllegalStateException(e.getMessage());
            }
        }
    }
}

