/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.net.URI;
import java.util.Date;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableReadEvent;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.o.OConstantVarType;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprEvaluationContextImpl
implements EvaluationContext {
    private static final Log __log = LogFactory.getLog(ExprEvaluationContextImpl.class);
    private BpelRuntimeContext _native;
    private ScopeFrame _scopeInstance;
    private Map<OLink, Boolean> _linkVals;
    private Node _root;

    public ExprEvaluationContextImpl(ScopeFrame scopeInstace, BpelRuntimeContext ntv) {
        this._native = ntv;
        this._scopeInstance = scopeInstace;
    }

    public ExprEvaluationContextImpl(ScopeFrame scopeInstace, BpelRuntimeContext ntv, Node root) {
        this(scopeInstace, ntv);
        this._root = root;
    }

    public ExprEvaluationContextImpl(ScopeFrame scopeInstnce, BpelRuntimeContext ntv, Map<OLink, Boolean> linkVals) {
        this(scopeInstnce, ntv);
        this._linkVals = linkVals;
    }

    public Node readVariable(OScope.Variable variable, OMessageVarType.Part part) throws FaultException {
        Node ret;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("readVariable(" + variable + "," + part + ")"));
        }
        if (variable.type instanceof OConstantVarType) {
            ret = ((OConstantVarType)variable.type).getValue();
        } else {
            VariableInstance varInstance = this._scopeInstance.resolve(variable);
            if (varInstance == null) {
                return null;
            }
            VariableReadEvent vre = new VariableReadEvent();
            vre.setVarName(varInstance.declaration.name);
            this.sendEvent((ScopeEvent)vre);
            ret = this._scopeInstance.fetchVariableData(this._native, varInstance, part, false);
        }
        return ret;
    }

    public Node evaluateQuery(Node root, OExpression expr) throws FaultException, EvaluationException {
        return this._native.getExpLangRuntime().evaluateNode(expr, new ExprEvaluationContextImpl(this._scopeInstance, this._native, root));
    }

    public String readMessageProperty(OScope.Variable variable, OProcess.OProperty property) throws FaultException {
        VariableInstance varInstance = this._scopeInstance.resolve(variable);
        return this._native.readProperty(varInstance, property);
    }

    public boolean isLinkActive(OLink olink) throws FaultException {
        return this._linkVals.get(olink);
    }

    public String toString() {
        return "{ExprEvaluationContextImpl scopeInstance=" + this._scopeInstance + ", activeLinks=" + this._linkVals + "}";
    }

    public Node getRootNode() {
        return this._root;
    }

    public Node getPartData(Element message, OMessageVarType.Part part) throws FaultException {
        return this._scopeInstance.getPartData(message, part);
    }

    public Long getProcessId() {
        return this._native.getPid();
    }

    public boolean narrowTypes() {
        return true;
    }

    private void sendEvent(ScopeEvent se) {
        this._scopeInstance.fillEventInfo(se);
        this._native.sendEvent(se);
    }

    public URI getBaseResourceURI() {
        return this._native.getBaseResourceURI();
    }

    public Node getPropertyValue(QName propertyName) {
        return this._native.getProcessProperty(propertyName);
    }

    public QName getProcessQName() {
        return this._native.getProcessQName();
    }

    public Date getCurrentEventDateTime() {
        return this._native.getCurrentEventDateTime();
    }
}

