/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime.extension;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.extension.ExtensionBundleValidation;
import org.apache.ode.bpel.extension.ExtensionOperation;
import org.apache.ode.bpel.extension.ExtensionValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtensionBundle
implements ExtensionBundleRuntime,
ExtensionBundleValidation {
    private static Log __log = LogFactory.getLog(AbstractExtensionBundle.class);
    private Map<String, Class<? extends ExtensionOperation>> extensionsByName = new HashMap<String, Class<? extends ExtensionOperation>>();

    public abstract String getNamespaceURI();

    public abstract void registerExtensionActivities();

    protected final void registerExtensionOperation(String localName, Class<? extends ExtensionOperation> operation) {
        this.extensionsByName.put(localName, operation);
    }

    public final Set<String> getExtensionOperationNames() {
        return Collections.unmodifiableSet(this.extensionsByName.keySet());
    }

    public final Class<? extends ExtensionOperation> getExtensionOperationClass(String localName) {
        return this.extensionsByName.get(localName);
    }

    public final ExtensionOperation getExtensionOperationInstance(String localName) throws InstantiationException, IllegalAccessException {
        return this.getExtensionOperationClass(localName).newInstance();
    }

    public final Map<QName, ExtensionValidator> getExtensionValidators() {
        HashMap<QName, ExtensionValidator> result = new HashMap<QName, ExtensionValidator>();
        String ns = this.getNamespaceURI();
        for (String localName : this.extensionsByName.keySet()) {
            if (!ExtensionValidator.class.isAssignableFrom(this.extensionsByName.get(localName))) continue;
            try {
                result.put(new QName(ns, localName), (ExtensionValidator)this.getExtensionOperationInstance(localName));
            }
            catch (Exception e) {
                __log.warn((Object)("Could not instantiate extension validator for '{" + ns + "}" + localName));
            }
        }
        return result;
    }
}

