/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.dao.ScopeStateEnum;
import org.apache.ode.bpel.pmapi.ProcessingException;
import org.apache.ode.bpel.pmapi.TInstanceStatus;
import org.apache.ode.bpel.pmapi.TScopeStatus;

class ProcessStatusConverter {
    private final Map<TInstanceStatus.Enum, BitSet> __interfaceStatusCodeToInternalStatusCodeMap = new HashMap<TInstanceStatus.Enum, BitSet>();
    private final Map<ScopeStateEnum, TScopeStatus.Enum> __scopeStateMap = new HashMap<ScopeStateEnum, TScopeStatus.Enum>();

    ProcessStatusConverter() {
        for (int i = 0; i < ProcessState.ALL_STATES.length; ++i) {
            short pistate = ProcessState.ALL_STATES[i];
            TInstanceStatus.Enum intstc = this.cvtInstanceStatus(pistate);
            BitSet bset = this.__interfaceStatusCodeToInternalStatusCodeMap.get(intstc);
            if (bset == null) {
                bset = new BitSet();
                this.__interfaceStatusCodeToInternalStatusCodeMap.put(intstc, bset);
            }
            bset.set(pistate);
        }
        this.__scopeStateMap.put(ScopeStateEnum.ACTIVE, TScopeStatus.ACTIVE);
        this.__scopeStateMap.put(ScopeStateEnum.COMPLETED, TScopeStatus.COMPLETED);
        this.__scopeStateMap.put(ScopeStateEnum.FAULT, TScopeStatus.FAULTED);
    }

    TInstanceStatus.Enum cvtInstanceStatus(short instancestate) {
        switch (instancestate) {
            case 0: 
            case 10: 
            case 20: {
                return TInstanceStatus.ACTIVE;
            }
            case 30: {
                return TInstanceStatus.COMPLETED;
            }
            case 40: {
                return TInstanceStatus.FAILED;
            }
            case 50: {
                return TInstanceStatus.SUSPENDED;
            }
            case 60: {
                return TInstanceStatus.TERMINATED;
            }
        }
        throw new ProcessingException("Encountered unexpected instance state: " + instancestate);
    }

    short[] cvtInstanceStatus(TInstanceStatus.Enum status) {
        BitSet bset = this.__interfaceStatusCodeToInternalStatusCodeMap.get(status);
        if (bset == null) {
            return new short[0];
        }
        short[] ret = new short[bset.cardinality()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (short)bset.nextSetBit(i == 0 ? 0 : ret[i - 1] + 1);
        }
        return ret;
    }

    TScopeStatus.Enum cvtScopeStatus(ScopeStateEnum status) {
        return this.__scopeStateMap.get(status);
    }
}

