/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.migration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.CorrelatorMessageDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.migration.Migration;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OScope;

public class CorrelationKeyMigration
implements Migration {
    private static final Log __log = LogFactory.getLog(CorrelationKeyMigration.class);

    @Override
    public boolean migrate(Set<BpelProcess> registeredProcesses, BpelDAOConnection connection) {
        HashMap<Long, ProcessInstanceDAO> instances = new HashMap<Long, ProcessInstanceDAO>();
        Collection csets = connection.getActiveCorrelationSets();
        for (CorrelationSetDAO cset : csets) {
            CorrelationKey ckey = cset.getValue();
            instances.put(cset.getInstance().getInstanceId(), cset.getInstance());
            if (ckey == null) continue;
            __log.debug((Object)("Correlation set id " + cset.getCorrelationSetId() + " key " + ckey));
            Integer ckeyInt = this.asInt(ckey.getCorrelationSetName());
            if (ckeyInt == null) continue;
            OScope.CorrelationSet ocset = this.findCorrelationById(ckeyInt, registeredProcesses, cset.getProcess().getProcessId());
            if (ocset == null) {
                __log.debug((Object)("Correlation set not found, couldn't upgrade set " + ckey.toCanonicalString()));
                continue;
            }
            cset.setValue(null, new CorrelationKey(ocset.name, ckey.getValues()));
        }
        for (BpelProcess process : registeredProcesses) {
            __log.debug((Object)("Migrating correlators for process " + process.getConf().getProcessId()));
            ProcessDAO processDao = connection.getProcess(process.getConf().getProcessId());
            for (OPartnerLink plink : process.getOProcess().getAllPartnerLinks()) {
                if (!plink.hasMyRole()) continue;
                for (Operation op : plink.myRolePortType.getOperations()) {
                    try {
                        OScope.CorrelationSet ocset;
                        Integer ckeyInt;
                        CorrelationKey oldKey;
                        CorrelatorDAO corr = processDao.getCorrelator(plink.getName() + "." + op.getName());
                        if (corr == null) continue;
                        for (MessageRouteDAO routeDAO : corr.getAllRoutes()) {
                            oldKey = routeDAO.getCorrelationKey();
                            if (oldKey == null || (ckeyInt = this.asInt(oldKey.getCorrelationSetName())) == null) continue;
                            ocset = this.findCorrelationById(ckeyInt, registeredProcesses, process.getConf().getProcessId());
                            if (ocset == null) {
                                __log.debug((Object)("Correlation set not found, couldn't upgrade route " + oldKey.toCanonicalString()));
                                continue;
                            }
                            routeDAO.setCorrelationKey(new CorrelationKey(ocset.name, oldKey.getValues()));
                        }
                        for (CorrelatorMessageDAO corrMsgDAO : corr.getAllMessages()) {
                            oldKey = corrMsgDAO.getCorrelationKey();
                            if (oldKey == null || (ckeyInt = this.asInt(oldKey.getCorrelationSetName())) == null) continue;
                            ocset = this.findCorrelationById(ckeyInt, registeredProcesses, process.getConf().getProcessId());
                            if (ocset == null) {
                                __log.debug((Object)("Correlation set not found, couldn't upgrade route " + oldKey.toCanonicalString()));
                                continue;
                            }
                            corrMsgDAO.setCorrelationKey(new CorrelationKey(ocset.name, oldKey.getValues()));
                        }
                        __log.debug((Object)("Migrated routes and message queue for correlator " + plink.getName() + "." + op.getName()));
                    }
                    catch (IllegalArgumentException e) {
                        __log.debug((Object)("Correlator with id " + plink.getId() + "." + op.getName() + " couldn't be found, skipping."));
                    }
                }
            }
        }
        return true;
    }

    private Integer asInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private OScope.CorrelationSet findCorrelationById(int ckeyInt, Set<BpelProcess> processes, QName processId) {
        for (BpelProcess process : processes) {
            OBase ocset;
            if (!process.getConf().getProcessId().equals(processId) || !((ocset = process.getOProcess().getChild(ckeyInt)) instanceof OScope.CorrelationSet)) continue;
            return (OScope.CorrelationSet)ocset;
        }
        return null;
    }
}

