/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.intercept;

import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.intercept.FailMessageExchangeException;
import org.apache.ode.bpel.intercept.FaultMessageExchangeException;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.intercept.NoOpInterceptor;

public class ProcessSizeThrottler
extends NoOpInterceptor {
    @Override
    public void onJobScheduled(MyRoleMessageExchange mex, MessageExchangeInterceptor.InterceptorContext ic) throws FailMessageExchangeException, FaultMessageExchangeException {
        while (ic.getBpelEngine().getHydratedProcessSize(ic.getBpelProcess().getPID()) > ic.getBpelEngine().getProcessThrottledMaximumSize()) {
            if (ic.getBpelEngine().dehydrateLastUnusedProcess()) continue;
            mex.setProperty("causeCode", String.valueOf(4));
            throw new FailMessageExchangeException("The size of all running processes is more than the upper limit (" + ic.getBpelEngine().getProcessThrottledMaximumSize() + ")");
        }
    }
}

