/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evar.IncompleteKeyException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.CorrelationSetInstance;
import org.apache.ode.bpel.runtime.InstanceGlobals;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScopeFrame
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(ScopeFrame.class);
    final OScope oscope;
    final ScopeFrame parent;
    final Long scopeInstanceId;
    Set<CompensationHandler> availableCompensations;
    private FaultData _faultData;
    final InstanceGlobals globals;

    ScopeFrame(OScope scopeDef, Long scopeInstanceId, ScopeFrame parent, Set<CompensationHandler> visibleCompensationHandlers, FaultData fault) {
        this(scopeDef, scopeInstanceId, parent, visibleCompensationHandlers, parent.globals);
        this._faultData = fault;
    }

    public ScopeFrame(OScope scopeDef, Long scopeInstanceId, ScopeFrame parent, Set<CompensationHandler> visibleCompensationHandlers) {
        this(scopeDef, scopeInstanceId, parent, visibleCompensationHandlers, parent.globals);
    }

    public ScopeFrame(OScope scopeDef, Long scopeInstanceId, ScopeFrame parent, Set<CompensationHandler> visibleCompensationHandlers, InstanceGlobals globals) {
        this.oscope = scopeDef;
        this.scopeInstanceId = scopeInstanceId;
        this.parent = parent;
        this.availableCompensations = visibleCompensationHandlers;
        this.globals = globals;
    }

    public ScopeFrame find(OScope scope) {
        if (this.oscope.name.equals(scope.name)) {
            return this;
        }
        return this.parent != null ? this.parent.find(scope) : null;
    }

    public VariableInstance resolve(OScope.Variable variable) {
        ScopeFrame scopeFrame = this.find(variable.declaringScope);
        if (scopeFrame == null) {
            return null;
        }
        return new VariableInstance(scopeFrame.scopeInstanceId, variable);
    }

    public CorrelationSetInstance resolve(OScope.CorrelationSet cset) {
        return new CorrelationSetInstance(this.find((OScope)cset.declaringScope).scopeInstanceId, cset);
    }

    public PartnerLinkInstance resolve(OPartnerLink partnerLink) {
        return new PartnerLinkInstance(this.find((OScope)partnerLink.declaringScope).scopeInstanceId, partnerLink);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{ScopeFrame: o=");
        buf.append(this.oscope);
        buf.append(", id=");
        buf.append(this.scopeInstanceId);
        if (this.availableCompensations != null) {
            buf.append(", avComps=");
            buf.append(this.availableCompensations);
        }
        if (this._faultData != null) {
            buf.append(", fault=");
            buf.append(this._faultData);
        }
        buf.append('}');
        return buf.toString();
    }

    public FaultData getFault() {
        if (this._faultData != null) {
            return this._faultData;
        }
        if (this.parent != null) {
            return this.parent.getFault();
        }
        return null;
    }

    public void fillEventInfo(ScopeEvent event) {
        ScopeFrame currentScope = this;
        ArrayList<String> parentNames = new ArrayList<String>();
        while (currentScope != null) {
            parentNames.add(currentScope.oscope.name);
            currentScope = currentScope.parent;
        }
        event.setParentScopesNames(parentNames);
        if (this.parent != null) {
            event.setParentScopeId(this.parent.scopeInstanceId);
        }
        event.setScopeId(this.scopeInstanceId);
        event.setScopeName(this.oscope.name);
        event.setScopeDeclerationId(this.oscope.getId());
        if (event.getLineNo() == -1 && this.oscope.debugInfo != null) {
            event.setLineNo(this.oscope.debugInfo.startLine);
        }
    }

    Node fetchVariableData(BpelRuntimeContext brc, VariableInstance variable, boolean forWriting) throws FaultException {
        if (variable.declaration.extVar != null) {
            Element reference = (Element)this.fetchVariableData(brc, this.resolve(variable.declaration.extVar.related), false);
            try {
                Node ret = brc.readExtVar(variable.declaration, reference);
                if (ret == null) {
                    throw new FaultException(this.oscope.getOwner().constants.qnUninitializedVariable, "The external variable \"" + variable.declaration.name + "\" has not been initialized.");
                }
                return ret;
            }
            catch (IncompleteKeyException ike) {
                __log.error((Object)("External variable could not be read due to incomplete key; the following key components were missing: " + ike.getMissing()));
                throw new FaultException(this.oscope.getOwner().constants.qnUninitializedVariable, "The extenral variable \"" + variable.declaration.name + "\" has not been properly initialized;the following key compoenents were missing:" + ike.getMissing());
            }
            catch (ExternalVariableModuleException e) {
                throw new BpelEngineException((Throwable)e);
            }
        }
        Node data = brc.readVariable(variable.scopeInstance, variable.declaration.name, forWriting);
        if (data == null) {
            if (variable.declaration.type instanceof OMessageVarType) {
                OMessageVarType msgType = (OMessageVarType)variable.declaration.type;
                if (msgType.parts.size() == 0) {
                    Document doc = DOMUtils.newDocument();
                    Element root = doc.createElement("message");
                    doc.appendChild(root);
                    return root;
                }
            }
            throw new FaultException(this.oscope.getOwner().constants.qnUninitializedVariable, "The variable " + variable.declaration.name + " isn't properly initialized.");
        }
        return data;
    }

    Node fetchVariableData(BpelRuntimeContext brc, VariableInstance var, OMessageVarType.Part part, boolean forWriting) throws FaultException {
        Node container = this.fetchVariableData(brc, var, forWriting);
        if (var.declaration.type instanceof OMessageVarType && part != null) {
            container = this.getPartData((Element)container, part);
        }
        return container;
    }

    Node initializeVariable(BpelRuntimeContext context, VariableInstance var, Node value) throws ExternalVariableModuleException {
        if (var.declaration.extVar != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Initialize external variable: name=" + var.declaration + " value=" + DOMUtils.domToString((Node)value)));
            }
            VariableInstance related = this.resolve(var.declaration.extVar.related);
            Node reference = null;
            try {
                reference = this.fetchVariableData(context, related, true);
            }
            catch (FaultException faultException) {
                // empty catch block
            }
            if (reference != null) {
                value = context.readExtVar(var.declaration, reference);
            }
            return value;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Initialize variable: name=" + var.declaration + " value=" + DOMUtils.domToString((Node)value)));
        }
        return context.writeVariable(var, value);
    }

    Node commitChanges(BpelRuntimeContext context, VariableInstance var, Node value) throws ExternalVariableModuleException {
        return this.writeVariable(context, var, value);
    }

    Node writeVariable(BpelRuntimeContext context, VariableInstance var, Node value) throws ExternalVariableModuleException {
        if (var.declaration.extVar != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Write external variable: name=" + var.declaration + " value=" + DOMUtils.domToString((Node)value)));
            }
            VariableInstance related = this.resolve(var.declaration.extVar.related);
            Node reference = null;
            try {
                reference = this.fetchVariableData(context, related, true);
            }
            catch (FaultException faultException) {
                // empty catch block
            }
            BpelRuntimeContext.ValueReferencePair vrp = context.writeExtVar(var.declaration, reference, value);
            this.writeVariable(context, related, vrp.reference);
            return vrp.value;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Write variable: name=" + var.declaration + " value=" + DOMUtils.domToString((Node)value)));
        }
        return context.writeVariable(var, value);
    }

    Node getPartData(Element message, OMessageVarType.Part part) {
        QName partName = new QName(null, part.name);
        Element ret = DOMUtils.findChildByName((Element)message, (QName)partName);
        if (part.type instanceof OElementVarType) {
            QName elName = ((OElementVarType)part.type).elementType;
            ret = DOMUtils.findChildByName((Element)ret, (QName)elName);
        }
        return ret;
    }
}

