/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.agents.memory.SizingAgent;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.BpelRuntimeContextImpl;
import org.apache.ode.bpel.engine.DebuggerSupport;
import org.apache.ode.bpel.engine.InterceptorContextImpl;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.NStateLatch;
import org.apache.ode.bpel.engine.PartnerLinkMyRoleImpl;
import org.apache.ode.bpel.engine.PartnerLinkPartnerRoleImpl;
import org.apache.ode.bpel.engine.ReplacementMapImpl;
import org.apache.ode.bpel.engine.SharedEndpoints;
import org.apache.ode.bpel.engine.extvar.ExternalVariableConf;
import org.apache.ode.bpel.engine.extvar.ExternalVariableManager;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.explang.ConfigurationException;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.extension.ExtensionCorrelationFilter;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.InstanceCountThrottler;
import org.apache.ode.bpel.intercept.InterceptorInvoker;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OExpressionLanguage;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.Serializer;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.ExpressionLanguageRuntimeRegistry;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.PROCESS;
import org.apache.ode.bpel.runtime.PropertyAliasEvaluationContext;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.jacob.soup.ReplacementMap;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BpelProcess {
    static final Log __log = LogFactory.getLog(BpelProcess.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private volatile Map<OPartnerLink, PartnerLinkPartnerRoleImpl> _partnerRoles;
    private volatile Map<OPartnerLink, PartnerLinkMyRoleImpl> _myRoles;
    private volatile Map<PartnerLinkMyRoleImpl, Endpoint> _endpointToMyRoleMap;
    private SharedEndpoints _sharedEps;
    private Map<Endpoint, EndpointReference> _myEprs = new HashMap<Endpoint, EndpointReference>();
    private Map<Endpoint, EndpointReference> _partnerEprs = new HashMap<Endpoint, EndpointReference>();
    private Map<Endpoint, PartnerRoleChannel> _partnerChannels = new HashMap<Endpoint, PartnerRoleChannel>();
    final QName _pid;
    private volatile OProcess _oprocess;
    private boolean _hydratedOnce = false;
    private volatile long _lastUsed;
    BpelEngineImpl _engine;
    ClassLoader _classLoader = this.getClass().getClassLoader();
    DebuggerSupport _debugger;
    ExpressionLanguageRuntimeRegistry _expLangRuntimeRegistry;
    private ReplacementMap _replacementMap;
    final ProcessConf _pconf;
    private final List<MessageExchangeInterceptor> _mexInterceptors = new ArrayList<MessageExchangeInterceptor>();
    private HydrationLatch _hydrationLatch;
    private ExternalVariableConf _extVarConf;
    private ExternalVariableManager _evm;
    public static final QName PROP_PATH = new QName("PATH");
    public static final QName PROP_SVG = new QName("SVG");
    public static final QName PROP_LAZY_HYDRATE = new QName("process.hydration.lazy");
    public static final QName PROP_MAX_INSTANCES = new QName("process.instance.throttled.maximum.count");
    private static final int PROCESS_MEMORY_TO_SERIALIZED_SIZE_RATIO = 5;
    Set<String> _mustUnderstandExtensions;
    Map<String, ExtensionBundleRuntime> _extensionRegistry;
    Map<String, ExtensionCorrelationFilter> _filterRegistry;

    public BpelProcess(ProcessConf conf) {
        this._pid = conf.getProcessId();
        this._pconf = conf;
        this._hydrationLatch = new HydrationLatch();
    }

    public URI getBaseResourceURI() {
        return this._pconf.getBaseURI();
    }

    void initExternalVariables() {
        List conf = this._pconf.getExtensionElement(ExternalVariableConf.EXTVARCONF_ELEMENT);
        this._extVarConf = new ExternalVariableConf(conf);
        this._evm = new ExternalVariableManager(this._pid, this._extVarConf, this._engine._contexts.externalVariableEngines, this._oprocess);
    }

    public String toString() {
        return "BpelProcess[" + this._pid + "]";
    }

    public ExternalVariableManager getEVM() {
        return this._evm;
    }

    public void recoverActivity(ProcessInstanceDAO instanceDAO, String channel, long activityId, String action, FaultData fault) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Recovering activity in process " + instanceDAO.getInstanceId() + " with action " + action));
        }
        this.markused();
        BpelRuntimeContextImpl processInstance = this.createRuntimeContext(instanceDAO, null, null);
        processInstance.recoverActivity(channel, activityId, action, fault);
    }

    protected DebuggerSupport createDebuggerSupport() {
        return new DebuggerSupport(this);
    }

    public DebuggerSupport getDebuggerSupport() {
        return this._debugger;
    }

    static String generateMessageExchangeIdentifier(String partnerlinkName, String operationName) {
        StringBuffer sb = new StringBuffer(partnerlinkName);
        sb.append('.');
        sb.append(operationName);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeProcess(MyRoleMessageExchangeImpl mex, InvokeHandler invokeHandler, boolean enqueue) {
        boolean routed = false;
        try {
            this._hydrationLatch.latch(1);
            List<PartnerLinkMyRoleImpl> targets = this.getMyRolesForService(mex.getServiceName());
            if (targets.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            mex.getDAO().setProcess(this.getProcessDAO());
            if (!this.processInterceptors(mex, InterceptorInvoker.__onProcessInvoked)) {
                __log.debug((Object)("Aborting processing of mex " + mex + " due to interceptors."));
                boolean bl = false;
                return bl;
            }
            this.markused();
            List<PartnerLinkMyRoleImpl.RoutingInfo> routings = null;
            for (PartnerLinkMyRoleImpl target : targets) {
                routings = target.findRoute(mex);
                boolean createInstance = target.isCreateInstance(mex);
                if (mex.getStatus() != MessageExchange.Status.FAILURE && routings != null) {
                    for (PartnerLinkMyRoleImpl.RoutingInfo routing : routings) {
                        if (routing.messageRoute != null && !this.isSameDeployer(routing, this._pconf.getDeployer())) continue;
                        routed = routed || invokeHandler.invoke(target, routing, createInstance);
                    }
                }
                if (!routed) continue;
                break;
            }
            if (!routed && enqueue) {
                targets.get(targets.size() - 1).noRoutingMatch(mex, routings);
            } else {
                if (mex.getStatus() == MessageExchange.Status.REQUEST) {
                    mex.setStatus(MessageExchange.Status.ASYNC);
                }
                this.markused();
            }
        }
        finally {
            this._hydrationLatch.release(1);
        }
        return routed;
    }

    private boolean isSameDeployer(PartnerLinkMyRoleImpl.RoutingInfo routing, String deployer) {
        return this._engine._activeProcesses.get(routing.messageRoute.getTargetInstance().getProcess().getProcessId()).getConf().getDeployer().equals(deployer);
    }

    private boolean isActive() {
        return this._pconf.getState() == ProcessState.ACTIVE;
    }

    boolean invokeProcess(final MyRoleMessageExchangeImpl mex, boolean enqueue) {
        return this.invokeProcess(mex, new InvokeHandler(){

            @Override
            public boolean invoke(PartnerLinkMyRoleImpl target, PartnerLinkMyRoleImpl.RoutingInfo routing, boolean createInstance) {
                if (routing.messageRoute == null && createInstance) {
                    target.invokeNewInstance(mex, routing);
                    return true;
                }
                if (routing.messageRoute != null) {
                    BpelProcess.this._engine.acquireInstanceLock(routing.messageRoute.getTargetInstance().getInstanceId());
                    target.invokeInstance(mex, routing);
                    return true;
                }
                return false;
            }
        }, enqueue);
    }

    private List<PartnerLinkMyRoleImpl> getMyRolesForService(QName serviceName) {
        ArrayList<PartnerLinkMyRoleImpl> myRoles = new ArrayList<PartnerLinkMyRoleImpl>(5);
        for (Map.Entry<PartnerLinkMyRoleImpl, Endpoint> e : this.getEndpointToMyRoleMap().entrySet()) {
            if (!e.getValue().serviceName.equals(serviceName)) continue;
            myRoles.add(e.getKey());
        }
        return myRoles;
    }

    void initMyRoleMex(MyRoleMessageExchangeImpl mex) {
        this.markused();
        PartnerLinkMyRoleImpl target = null;
        for (Map.Entry<PartnerLinkMyRoleImpl, Endpoint> e : this.getEndpointToMyRoleMap().entrySet()) {
            if (!e.getValue().serviceName.equals(mex.getServiceName())) continue;
            target = e.getKey();
            break;
        }
        if (target != null) {
            mex.setPortOp(target._plinkDef.myRolePortType, target._plinkDef.getMyRoleOperation(mex.getOperationName()));
        } else {
            __log.warn((Object)("Couldn't find endpoint from service " + mex.getServiceName() + " when initializing a myRole mex."));
        }
    }

    String extractProperty(Element msgData, Map<String, Node> headerParts, OProcess.OPropertyAlias alias, String target) throws FaultException {
        this.markused();
        PropertyAliasEvaluationContext ectx = new PropertyAliasEvaluationContext(msgData, headerParts, alias);
        Node lValue = ectx.getRootNode();
        if (alias.location != null) {
            try {
                lValue = this._expLangRuntimeRegistry.evaluateNode(alias.location, ectx);
            }
            catch (EvaluationException ec) {
                throw new FaultException(this.getOProcess().constants.qnSelectionFailure, alias.getDescription());
            }
        }
        if (lValue == null) {
            String errmsg = __msgs.msgPropertyAliasReturnedNullSet(alias.getDescription(), target);
            if (__log.isErrorEnabled()) {
                __log.error((Object)errmsg);
            }
            throw new FaultException(this.getOProcess().constants.qnSelectionFailure, errmsg);
        }
        if (lValue.getNodeType() == 1) {
            StringBuffer val = new StringBuffer();
            NodeList nl = lValue.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                val.append(n.getNodeValue());
            }
            return val.toString();
        }
        if (lValue.getNodeType() == 3) {
            return ((Text)lValue).getWholeText();
        }
        if (lValue.getNodeType() == 2) {
            return ((Attr)lValue).getValue();
        }
        return null;
    }

    static QName getElementNameForPart(OMessageVarType.Part part) {
        return part.type instanceof OElementVarType ? ((OElementVarType)part.type).elementType : new QName(null, part.name);
    }

    public boolean processInterceptors(MyRoleMessageExchangeImpl mex, InterceptorInvoker invoker) {
        InterceptorContextImpl ictx = new InterceptorContextImpl(this._engine._contexts.dao.getConnection(), this.getProcessDAO(), this._pconf, this._engine, this);
        for (MessageExchangeInterceptor i : this._mexInterceptors) {
            if (mex.processInterceptor(i, mex, ictx, invoker)) continue;
            return false;
        }
        for (MessageExchangeInterceptor i : this.getEngine().getGlobalInterceptors()) {
            if (mex.processInterceptor(i, mex, ictx, invoker)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleJobDetails(Scheduler.JobDetails jobData) {
        boolean routed = true;
        try {
            Scheduler.JobDetails we;
            this._hydrationLatch.latch(1);
            this.markused();
            if (__log.isDebugEnabled()) {
                __log.debug((Object)ObjectPrinter.stringifyMethodEnter((String)"handleJobDetails", (Object[])new Object[]{"jobData", jobData}));
            }
            if ((we = jobData).getType() == Scheduler.JobType.INVOKE_INTERNAL || we.getType() == Scheduler.JobType.MEX_MATCHER) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(we.getType() + " event for mexid " + we.getMexId()));
                }
                MyRoleMessageExchangeImpl mex = (MyRoleMessageExchangeImpl)this._engine.getMessageExchange(we.getMexId());
                if (we.getType() == Scheduler.JobType.MEX_MATCHER && !mex.getDAO().lockPremieMessages()) {
                    boolean bl = true;
                    return bl;
                }
                routed = this.invokeProcess(mex, (Boolean)jobData.detailsExt.get("enqueue"));
                if (we.getType() != Scheduler.JobType.MEX_MATCHER) return routed;
                if (!routed) return routed;
                mex.getDAO().releasePremieMessages();
                return routed;
            }
            ProcessInstanceDAO procInstance = this.getProcessDAO().getInstance(we.getInstanceId());
            if (procInstance == null) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("handleJobDetails: no ProcessInstance found with iid " + we.getInstanceId() + "; ignoring."));
                }
                boolean bl = true;
                return bl;
            }
            BpelRuntimeContextImpl processInstance = this.createRuntimeContext(procInstance, null, null);
            switch (we.getType()) {
                case TIMER: {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("handleJobDetails: TimerWork event for process instance " + processInstance));
                    }
                    processInstance.timerEvent(we.getChannel());
                    return routed;
                }
                case RESUME: {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("handleJobDetails: ResumeWork event for iid " + we.getInstanceId()));
                    }
                    processInstance.execute();
                    return routed;
                }
                case INVOKE_RESPONSE: {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("InvokeResponse event for iid " + we.getInstanceId()));
                    }
                    processInstance.invocationResponse(we.getMexId(), we.getChannel());
                    processInstance.execute();
                    return routed;
                }
                case MATCHER: {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("Matcher event for iid " + we.getInstanceId()));
                    }
                    if (procInstance.getState() != 30 && procInstance.getState() != 40) {
                        processInstance.matcherEvent(we.getCorrelatorId(), we.getCorrelationKeySet());
                        return routed;
                    }
                    __log.debug((Object)"A matcher event was aborted. The process is already completed.");
                    boolean bl = true;
                    return bl;
                }
            }
            return routed;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    private void setRoles(OProcess oprocess) {
        OPartnerLink plink;
        this._partnerRoles = new HashMap<OPartnerLink, PartnerLinkPartnerRoleImpl>();
        this._myRoles = new HashMap<OPartnerLink, PartnerLinkMyRoleImpl>();
        this._endpointToMyRoleMap = new HashMap<PartnerLinkMyRoleImpl, Endpoint>();
        HashMap myRoleEndpoints = new HashMap();
        for (Map.Entry provide : this._pconf.getProvideEndpoints().entrySet()) {
            plink = oprocess.getPartnerLink((String)provide.getKey());
            if (plink == null) {
                String errmsg = "Error in deployment descriptor for process " + this._pid + "; reference to unknown partner link " + (String)provide.getKey();
                __log.error((Object)errmsg);
                throw new BpelEngineException(errmsg);
            }
            myRoleEndpoints.put(plink, provide.getValue());
        }
        for (Map.Entry invoke : this._pconf.getInvokeEndpoints().entrySet()) {
            plink = oprocess.getPartnerLink((String)invoke.getKey());
            if (plink == null) {
                String errmsg = "Error in deployment descriptor for process " + this._pid + "; reference to unknown partner link " + (String)invoke.getKey();
                __log.error((Object)errmsg);
                throw new BpelEngineException(errmsg);
            }
            __log.debug((Object)("Processing <invoke> element for process " + this._pid + ": partnerlink " + (String)invoke.getKey() + " --> " + invoke.getValue()));
        }
        for (OPartnerLink pl : oprocess.getAllPartnerLinks()) {
            Endpoint endpoint;
            if (pl.hasMyRole()) {
                endpoint = (Endpoint)myRoleEndpoints.get(pl);
                if (endpoint == null) {
                    throw new IllegalArgumentException("No service name for myRole plink " + pl.getName());
                }
                PartnerLinkMyRoleImpl myRole = new PartnerLinkMyRoleImpl(this, pl, endpoint);
                this._myRoles.put(pl, myRole);
                this._endpointToMyRoleMap.put(myRole, endpoint);
            }
            if (!pl.hasPartnerRole()) continue;
            endpoint = (Endpoint)this._pconf.getInvokeEndpoints().get(pl.getName());
            if (endpoint == null && pl.initializePartnerRole) {
                throw new IllegalArgumentException(pl.getName() + " must be bound to an endpoint in deploy.xml");
            }
            PartnerLinkPartnerRoleImpl partnerRole = new PartnerLinkPartnerRoleImpl(this, pl, endpoint);
            this._partnerRoles.put(pl, partnerRole);
        }
    }

    public ProcessDAO getProcessDAO() {
        return this._pconf.isTransient() ? this._engine._contexts.inMemDao.getConnection().getProcess(this._pid) : this.getEngine()._contexts.dao.getConnection().getProcess(this._pid);
    }

    static String genCorrelatorId(OPartnerLink plink, String opName) {
        return plink.getName() + "." + opName;
    }

    private OProcess deserializeCompiledProcess(InputStream is) throws Exception {
        Serializer ofh = new Serializer(is);
        OProcess compiledProcess = ofh.readOProcess();
        return compiledProcess;
    }

    public Set<Endpoint> getServiceNames() {
        HashSet<Endpoint> endpoints = new HashSet<Endpoint>();
        for (Endpoint provide : this._pconf.getProvideEndpoints().values()) {
            endpoints.add(provide);
        }
        return endpoints;
    }

    void activate(BpelEngineImpl engine) {
        this._engine = engine;
        this._sharedEps = this._engine.getSharedEndpoints();
        this._debugger = this.createDebuggerSupport();
        if (this.getInstanceMaximumCount() < Integer.MAX_VALUE) {
            this.registerMessageExchangeInterceptor(new InstanceCountThrottler());
        }
        __log.debug((Object)("Activating " + this._pid));
        for (Map.Entry entry : this._pconf.getProvideEndpoints().entrySet()) {
            Endpoint endpoint = (Endpoint)entry.getValue();
            EndpointReference initialEPR = null;
            if (this.isShareable(endpoint)) {
                initialEPR = this._sharedEps.getEndpointReference(endpoint);
                if (initialEPR == null) {
                    initialEPR = this._engine._contexts.bindingContext.activateMyRoleEndpoint(this._pid, endpoint);
                    this._sharedEps.addEndpoint(endpoint, initialEPR);
                    __log.debug((Object)("Activated " + this._pid + " myrole " + (String)entry.getKey() + ": EPR is " + initialEPR));
                }
                this._sharedEps.incrementReferenceCount(endpoint);
            } else {
                initialEPR = this._engine._contexts.bindingContext.activateMyRoleEndpoint(this._pid, endpoint);
                __log.debug((Object)("Activated " + this._pid + " myrole " + (String)entry.getKey() + ": EPR is " + initialEPR));
            }
            this._myEprs.put(endpoint, initialEPR);
        }
        __log.debug((Object)("Activated " + this._pid));
        this.markused();
    }

    void deactivate() {
        for (Endpoint endpoint : this._myEprs.keySet()) {
            if (this.isShareable(endpoint)) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("deactivating shared endpoint " + endpoint + " for pid " + this._pid));
                }
                if (this._sharedEps.decrementReferenceCount(endpoint)) continue;
                this._engine._contexts.bindingContext.deactivateMyRoleEndpoint(this._pid, endpoint);
                this._sharedEps.removeEndpoint(endpoint);
                continue;
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("deactivating non-shared endpoint " + endpoint + " for pid " + this._pid));
            }
            this._engine._contexts.bindingContext.deactivateMyRoleEndpoint(this._pid, endpoint);
        }
    }

    private boolean isShareable(Endpoint endpoint) {
        return this._pconf.isSharedService(endpoint.serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EndpointReference getInitialPartnerRoleEPR(OPartnerLink link) {
        try {
            this._hydrationLatch.latch(1);
            PartnerLinkPartnerRoleImpl prole = this._partnerRoles.get(link);
            if (prole == null) {
                throw new IllegalStateException("Unknown partner link " + link);
            }
            EndpointReference endpointReference = prole.getInitialEPR();
            return endpointReference;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Endpoint getInitialPartnerRoleEndpoint(OPartnerLink link) {
        try {
            this._hydrationLatch.latch(1);
            PartnerLinkPartnerRoleImpl prole = this._partnerRoles.get(link);
            if (prole == null) {
                throw new IllegalStateException("Unknown partner link " + link);
            }
            Endpoint endpoint = prole._initialPartner;
            return endpoint;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EndpointReference getInitialMyRoleEPR(OPartnerLink link) {
        try {
            this._hydrationLatch.latch(1);
            PartnerLinkMyRoleImpl myRole = this._myRoles.get(link);
            if (myRole == null) {
                throw new IllegalStateException("Unknown partner link " + link);
            }
            EndpointReference endpointReference = myRole.getInitialEPR();
            return endpointReference;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    public QName getPID() {
        return this._pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PartnerRoleChannel getPartnerRoleChannel(OPartnerLink partnerLink) {
        try {
            this._hydrationLatch.latch(1);
            PartnerLinkPartnerRoleImpl prole = this._partnerRoles.get(partnerLink);
            if (prole == null) {
                throw new IllegalStateException("Unknown partner link " + partnerLink);
            }
            PartnerRoleChannel partnerRoleChannel = prole._channel;
            return partnerRoleChannel;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    public void saveEvent(ProcessInstanceEvent event, ProcessInstanceDAO instanceDao) {
        this.saveEvent(event, instanceDao, null);
    }

    public void saveEvent(ProcessInstanceEvent event, ProcessInstanceDAO instanceDao, List<String> scopeNames) {
        this.markused();
        if (this._pconf.isEventEnabled(scopeNames, event.getType())) {
            this._engine.fireEvent((BpelEvent)event);
            if (instanceDao != null) {
                instanceDao.insertBpelEvent(event);
            } else {
                __log.debug((Object)"Couldn't find instance to save event, no event generated!");
            }
        }
    }

    void dehydrate() {
        try {
            this._hydrationLatch.latch(0);
        }
        finally {
            this._hydrationLatch.release(0);
        }
    }

    void hydrate() {
        try {
            this._hydrationLatch.latch(1);
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    public OProcess getOProcess() {
        try {
            this._hydrationLatch.latch(1);
            OProcess oProcess = this._oprocess;
            return oProcess;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    private Map<PartnerLinkMyRoleImpl, Endpoint> getEndpointToMyRoleMap() {
        try {
            this._hydrationLatch.latch(1);
            Map<PartnerLinkMyRoleImpl, Endpoint> map = this._endpointToMyRoleMap;
            return map;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    public ReplacementMap getReplacementMap(QName processName) {
        try {
            this._hydrationLatch.latch(1);
            if (processName.equals(this._pid)) {
                ReplacementMap replacementMap = this._replacementMap;
                return replacementMap;
            }
            OProcess oprocess = this._engine.getOProcess(processName);
            if (oprocess == null) {
                String errmsg = "The process " + this._pid + " is not available anymore.";
                __log.error((Object)errmsg);
                throw new InvalidProcessException(errmsg, 1);
            }
            this.registerExprLang(oprocess);
            ReplacementMapImpl errmsg = new ReplacementMapImpl(oprocess);
            return errmsg;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    protected BpelEngineImpl getEngine() {
        return this._engine;
    }

    public boolean isInMemory() {
        return this._pconf.isTransient();
    }

    public long getLastUsed() {
        return this._lastUsed;
    }

    QName getProcessType() {
        return this._pconf.getType();
    }

    public boolean hintIsHydrated() {
        return this._oprocess != null;
    }

    private final void markused() {
        this._lastUsed = System.currentTimeMillis();
    }

    protected BpelRuntimeContextImpl createRuntimeContext(ProcessInstanceDAO dao, PROCESS template, MyRoleMessageExchangeImpl instantiatingMessageExchange) {
        return new BpelRuntimeContextImpl(this, dao, template, instantiatingMessageExchange);
    }

    public void setExtensionRegistry(Map<String, ExtensionBundleRuntime> extensionRegistry) {
        this._extensionRegistry = extensionRegistry;
    }

    public void setFilterRegistry(Map<String, ExtensionCorrelationFilter> _filterRegistry) {
        this._filterRegistry = _filterRegistry;
    }

    private void bounceProcessDAOInMemory(BpelDAOConnection conn, QName pid, long version, OProcess oprocess) {
        if (__log.isInfoEnabled()) {
            __log.info((Object)("Creating new process DAO[mem] for " + pid + " (guid=" + oprocess.guid + ")."));
        }
        this.createProcessDAO(conn, pid, version, oprocess);
    }

    private void bounceProcessDAOInDB(BpelDAOConnection conn, QName pid, long version, OProcess oprocess) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Creating new process DAO for " + pid + " (guid=" + oprocess.guid + ")..."));
        }
        this.createProcessDAO(conn, pid, version, oprocess);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Created new process DAO for " + pid + " (guid=" + oprocess.guid + ")."));
        }
    }

    public int getInstanceInUseCount() {
        return this.hintIsHydrated() ? this._hydrationLatch.getDepth(1) : 0;
    }

    private void createProcessDAO(BpelDAOConnection conn, QName pid, long version, OProcess oprocess) {
        try {
            boolean create = true;
            ProcessDAO old = conn.getProcess(pid);
            if (old != null) {
                __log.debug((Object)("Found ProcessDAO for " + pid + " with GUID " + old.getGuid()));
                if (oprocess.guid == null) {
                    create = false;
                } else if (old.getGuid().equals(oprocess.guid)) {
                    create = false;
                }
            }
            if (create) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Creating process DAO for " + pid + " (guid=" + oprocess.guid + ")"));
                }
                ProcessDAO newDao = conn.createProcess(pid, oprocess.getQName(), oprocess.guid, (long)((int)version));
                for (String correlator : oprocess.getCorrelators()) {
                    newDao.addCorrelator(correlator);
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Created new process DAO for " + pid + " (guid=" + oprocess.guid + ")"));
                }
            }
        }
        catch (BpelEngineException ex) {
            throw ex;
        }
        catch (Exception dce) {
            __log.error((Object)"DbError", (Throwable)dce);
            throw new BpelEngineException("DbError", (Throwable)dce);
        }
    }

    private void registerExprLang(OProcess oprocess) {
        for (OExpressionLanguage elang : oprocess.expressionLanguages) {
            try {
                this._expLangRuntimeRegistry.registerRuntime(elang);
            }
            catch (ConfigurationException e) {
                String msg = __msgs.msgExpLangRegistrationError(elang.expressionLanguageUri, elang.properties);
                __log.error((Object)msg, (Throwable)e);
                throw new BpelEngineException(msg, (Throwable)e);
            }
        }
    }

    public boolean isCleanupCategoryEnabled(boolean instanceSucceeded, ProcessConf.CLEANUP_CATEGORY category) {
        return this._pconf.isCleanupCategoryEnabled(instanceSucceeded, category);
    }

    public Set<ProcessConf.CLEANUP_CATEGORY> getCleanupCategories(boolean instanceSucceeded) {
        return this._pconf.getCleanupCategories(instanceSucceeded);
    }

    public Node getProcessProperty(QName propertyName) {
        Node value = this.getEngine()._contexts.customProcessProperties.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        Map properties = this._pconf.getProcessProperties();
        if (properties != null) {
            return (Node)properties.get(propertyName);
        }
        return null;
    }

    public ProcessConf getConf() {
        return this._pconf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveInstances() {
        try {
            this._hydrationLatch.latch(1);
            if (this.isInMemory() || this._engine._contexts.scheduler.isTransacted()) {
                boolean bl = this.hasActiveInstances(this.getProcessDAO());
                return bl;
            }
            boolean bl = (Boolean)this._engine._contexts.scheduler.execTransaction((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return BpelProcess.this.hasActiveInstances(BpelProcess.this.getProcessDAO());
                }
            });
            return bl;
        }
        finally {
            this._hydrationLatch.release(1);
        }
    }

    private boolean hasActiveInstances(ProcessDAO processDAO) {
        return processDAO.getNumInstances() > 0;
    }

    public void registerMessageExchangeInterceptor(MessageExchangeInterceptor interceptor) {
        this._mexInterceptors.add(interceptor);
    }

    public void unregisterMessageExchangeInterceptor(MessageExchangeInterceptor interceptor) {
        this._mexInterceptors.remove(interceptor);
    }

    public long sizeOf() {
        long footprint = SizingAgent.deepSizeOf((Object)this);
        if (footprint == 0L) {
            footprint = this.getEstimatedHydratedSize();
        }
        for (EndpointReference myEpr : this._myEprs.values()) {
            footprint += this._engine._contexts.bindingContext.calculateSizeofService(myEpr);
        }
        return footprint;
    }

    public String getProcessProperty(QName property, String defaultValue) {
        Text text = (Text)this.getProcessProperty(property);
        if (text == null) {
            return defaultValue;
        }
        String value = text.getWholeText();
        return value == null ? defaultValue : value;
    }

    public boolean isHydrationLazy() {
        return Boolean.valueOf(this.getProcessProperty(PROP_LAZY_HYDRATE, "true"));
    }

    public boolean isHydrationLazySet() {
        return this.getProcessProperty(PROP_LAZY_HYDRATE) != null;
    }

    public int getInstanceMaximumCount() {
        return Integer.valueOf(this.getProcessProperty(PROP_MAX_INSTANCES, Integer.toString(this._engine.getInstanceThrottledMaximumCount())));
    }

    public long getEstimatedHydratedSize() {
        return this._pconf.getCBPFileSize() * 5L;
    }

    public long getTimeout(OPartnerLink partnerLink, boolean p2p) {
        long timeout;
        block6: {
            PartnerLinkPartnerRoleImpl linkPartnerRole = this._partnerRoles.get(partnerLink);
            timeout = 120000L;
            if (linkPartnerRole._initialEPR != null) {
                String property = null;
                String value = null;
                Map props = this._pconf.getEndpointProperties(linkPartnerRole._initialEPR);
                if (p2p) {
                    property = "p2p.mex.timeout";
                    value = (String)props.get(property);
                }
                if (value == null) {
                    property = "mex.timeout";
                    value = (String)props.get(property);
                }
                if (value != null) {
                    try {
                        timeout = Long.parseLong(value);
                    }
                    catch (NumberFormatException e) {
                        if (!__log.isWarnEnabled()) break block6;
                        __log.warn((Object)("Mal-formatted Property: [" + property + "=" + value + "] Default value (" + timeout + ") will be used"));
                    }
                }
            }
        }
        return timeout;
    }

    public int getVersion() {
        return Integer.parseInt(this._pid.getLocalPart().substring(this._pid.getLocalPart().lastIndexOf(45) + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doAsyncReply(MyRoleMessageExchangeImpl m, BpelRuntimeContext context) {
        block13: {
            block11: {
                block12: {
                    mex = m.getDAO();
                    pmex = null;
                    if (mex.getPipedMessageExchangeId() != null) {
                        pmex = (PartnerRoleMessageExchange)this.getEngine().getMessageExchange(mex.getPipedMessageExchangeId());
                    }
                    if (pmex == null) break block11;
                    if (BpelProcess.__log.isDebugEnabled()) {
                        BpelProcess.__log.debug((Object)("Replying to a p2p mex, myrole " + m + " - partnerole " + pmex));
                    }
                    if (pmex.getStatus() != MessageExchange.Status.ASYNC && pmex.getStatus() != MessageExchange.Status.REQUEST) break block12;
                    try {
                        switch (3.$SwitchMap$org$apache$ode$bpel$iapi$MessageExchange$Status[m.getStatus().ordinal()]) {
                            case 1: {
                                pmex.replyWithFailure(MessageExchange.FailureType.OTHER, "operation failed", null);
                                ** break;
                            }
                            case 2: {
                                fault = pmex.getOperation().getFault(m.getFault().getLocalPart());
                                if (fault == null) {
                                    BpelProcess.__log.error((Object)("process " + this + " instance " + (context != null ? context.getPid() : null) + " thrown unmapped fault in p2p communication " + m.getFault() + " " + m.getFaultExplanation() + " - converted to failure"));
                                    pmex.replyWithFailure(MessageExchange.FailureType.OTHER, "process thrown unmapped fault in p2p communication " + m.getFault() + " " + m.getFaultExplanation() + " - converted to failure", m.getFaultResponse().getMessage());
                                    ** break;
                                }
                                faultRes = pmex.createMessage(pmex.getOperation().getFault(m.getFault().getLocalPart()).getMessage().getQName());
                                faultRes.setMessage(m.getResponse().getMessage());
                                pmex.replyWithFault(m.getFault(), faultRes);
                                ** break;
                            }
                            case 3: {
                                response = pmex.createMessage(pmex.getOperation().getOutput().getMessage().getQName());
                                response.setMessage(m.getResponse().getMessage());
                                pmex.reply(response);
                                ** break;
                            }
                            default: {
                                BpelProcess.__log.warn((Object)("Unexpected state: " + m.getStatus()));
                            }
                        }
                    }
                    catch (Throwable var7_8) {
                        mex.release(this.isCleanupCategoryEnabled(m.getStatus() == MessageExchange.Status.RESPONSE, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
                        throw var7_8;
                    }
lbl34:
                    // 5 sources

                    mex.release(this.isCleanupCategoryEnabled(m.getStatus() == MessageExchange.Status.RESPONSE, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
                    break block13;
                }
                BpelProcess.__log.warn((Object)("Can't send response to a p2p mex: " + mex + " partner mex: " + pmex));
                break block13;
            }
            if (context != null) {
                context.checkInvokeExternalPermission();
            }
            this._engine._contexts.mexContext.onAsyncReply((MyRoleMessageExchange)m);
        }
    }

    public QName getCorrelationFilter(String partnerLinkName) {
        return this._pconf.getCorrelationFilter(partnerLinkName);
    }

    private class HydrationLatch
    extends NStateLatch {
        HydrationLatch() {
            super(new Runnable[2]);
            this._transitions[0] = new Runnable(){

                @Override
                public void run() {
                    HydrationLatch.this.doDehydrate();
                }
            };
            this._transitions[1] = new Runnable(){

                @Override
                public void run() {
                    HydrationLatch.this.doHydrate();
                }
            };
        }

        private void doDehydrate() {
            if (BpelProcess.this._oprocess != null) {
                BpelProcess.this._oprocess.dehydrate();
                BpelProcess.this._oprocess = null;
            }
            if (BpelProcess.this._myRoles != null) {
                BpelProcess.this._myRoles.clear();
            }
            if (BpelProcess.this._endpointToMyRoleMap != null) {
                BpelProcess.this._endpointToMyRoleMap.clear();
            }
            if (BpelProcess.this._partnerRoles != null) {
                BpelProcess.this._partnerRoles.clear();
            }
            BpelProcess.this._replacementMap = null;
            BpelProcess.this._expLangRuntimeRegistry = null;
        }

        private void doHydrate() {
            BpelProcess.this.markused();
            __log.debug((Object)("Rehydrating process " + BpelProcess.this._pconf.getProcessId()));
            try {
                InputStream inputStream = BpelProcess.this._pconf.getCBPInputStream();
                try {
                    BpelProcess.this._oprocess = BpelProcess.this.deserializeCompiledProcess(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                String errmsg = "The process " + BpelProcess.this._pid + " is no longer available.";
                __log.error((Object)errmsg, (Throwable)e);
                throw new BpelEngineException(errmsg, (Throwable)e);
            }
            if (BpelProcess.this._partnerRoles == null) {
                BpelProcess.this._partnerRoles = new HashMap();
            }
            if (BpelProcess.this._myRoles == null) {
                BpelProcess.this._myRoles = new HashMap();
            }
            if (BpelProcess.this._endpointToMyRoleMap == null) {
                BpelProcess.this._endpointToMyRoleMap = new HashMap();
            }
            if (BpelProcess.this._myEprs == null) {
                BpelProcess.this._myEprs = new HashMap();
            }
            if (BpelProcess.this._partnerChannels == null) {
                BpelProcess.this._partnerChannels = new HashMap();
            }
            if (BpelProcess.this._partnerEprs == null) {
                BpelProcess.this._partnerEprs = new HashMap();
            }
            BpelProcess.this._replacementMap = new ReplacementMapImpl(BpelProcess.this._oprocess);
            BpelProcess.this.setExtensionRegistry(BpelProcess.this._engine._contexts.extensionRegistry);
            BpelProcess.this.setFilterRegistry(BpelProcess.this._engine._contexts.correlationFilterRegistry);
            BpelProcess.this._mustUnderstandExtensions = new HashSet<String>();
            for (OProcess.OExtension extension : ((BpelProcess)BpelProcess.this)._oprocess.declaredExtensions) {
                if (extension.mustUnderstand) {
                    if (BpelProcess.this._extensionRegistry.get(extension.namespaceURI) == null) {
                        String msg = __msgs.msgExtensionMustUnderstandError(BpelProcess.this._pconf.getProcessId(), extension.namespaceURI);
                        __log.error((Object)msg);
                        throw new BpelEngineException(msg);
                    }
                    BpelProcess.this._mustUnderstandExtensions.add(extension.namespaceURI);
                    continue;
                }
                __log.warn((Object)("The process declares the extension namespace " + extension.namespaceURI + " that is unkown to the engine"));
            }
            BpelProcess.this._expLangRuntimeRegistry = new ExpressionLanguageRuntimeRegistry();
            BpelProcess.this.registerExprLang(BpelProcess.this._oprocess);
            BpelProcess.this.setRoles(BpelProcess.this._oprocess);
            BpelProcess.this.initExternalVariables();
            if (!BpelProcess.this._hydratedOnce) {
                for (PartnerLinkPartnerRoleImpl prole : BpelProcess.this._partnerRoles.values()) {
                    PartnerRoleChannel channel;
                    if (prole._initialPartner == null) continue;
                    prole._channel = channel = BpelProcess.this._engine._contexts.bindingContext.createPartnerRoleChannel(BpelProcess.this._pid, prole._plinkDef.partnerRolePortType, prole._initialPartner);
                    BpelProcess.this._partnerChannels.put(prole._initialPartner, prole._channel);
                    EndpointReference epr = channel.getInitialEndpointReference();
                    if (epr != null) {
                        prole._initialEPR = epr;
                        BpelProcess.this._partnerEprs.put(prole._initialPartner, epr);
                    }
                    __log.debug((Object)("Activated " + BpelProcess.this._pid + " partnerrole " + prole.getPartnerLinkName() + ": EPR is " + prole._initialEPR));
                }
                BpelProcess.this._engine.setProcessSize(BpelProcess.this._pid, true);
                BpelProcess.this._hydratedOnce = true;
            }
            for (PartnerLinkMyRoleImpl myrole : BpelProcess.this._myRoles.values()) {
                myrole._initialEPR = (EndpointReference)BpelProcess.this._myEprs.get(myrole._endpoint);
            }
            for (PartnerLinkPartnerRoleImpl prole : BpelProcess.this._partnerRoles.values()) {
                prole._channel = (PartnerRoleChannel)BpelProcess.this._partnerChannels.get(prole._initialPartner);
                if (BpelProcess.this._partnerEprs.get(prole._initialPartner) == null) continue;
                prole._initialEPR = (EndpointReference)BpelProcess.this._partnerEprs.get(prole._initialPartner);
            }
            if (BpelProcess.this.isInMemory()) {
                BpelProcess.this.createProcessDAO(BpelProcess.this._engine._contexts.inMemDao.getConnection(), BpelProcess.this._pid, BpelProcess.this._pconf.getVersion(), BpelProcess.this._oprocess);
            } else if (BpelProcess.this._engine._contexts.scheduler.isTransacted()) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Creating new process DAO for " + BpelProcess.this._pid + " (guid=" + ((BpelProcess)BpelProcess.this)._oprocess.guid + ")..."));
                }
                BpelProcess.this.createProcessDAO(BpelProcess.this._engine._contexts.dao.getConnection(), BpelProcess.this._pid, BpelProcess.this._pconf.getVersion(), BpelProcess.this._oprocess);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Created new process DAO for " + BpelProcess.this._pid + " (guid=" + ((BpelProcess)BpelProcess.this)._oprocess.guid + ")."));
                }
            } else {
                try {
                    BpelProcess.this._engine._contexts.scheduler.execTransaction((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            BpelProcess.this.bounceProcessDAOInDB(BpelProcess.this._engine._contexts.dao.getConnection(), BpelProcess.this._pid, BpelProcess.this._pconf.getVersion(), BpelProcess.this._oprocess);
                            return null;
                        }
                    });
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static interface InvokeHandler {
        public boolean invoke(PartnerLinkMyRoleImpl var1, PartnerLinkMyRoleImpl.RoutingInfo var2, boolean var3);
    }
}

