/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.AbstractInstanceLockManager;

public class HazelcastInstanceLockManager
extends AbstractInstanceLockManager {
    private static final Log __log = LogFactory.getLog(HazelcastInstanceLockManager.class);
    private HazelcastInstance hz;

    public HazelcastInstanceLockManager(HazelcastInstance hz) {
        this.hz = hz;
    }

    @Override
    public void lock(Long iid, int time, TimeUnit tu) throws InterruptedException, AbstractInstanceLockManager.TimeoutException {
        ILock lock;
        if (iid == null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)" Instance Id null at lock[]");
            }
            return;
        }
        String thrd = Thread.currentThread().toString();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(thrd + ": lock(iid=" + iid + ", time=" + time + (Object)((Object)tu) + ")"));
        }
        if (!(lock = this.hz.getLock(iid.toString())).tryLock((long)time, tu)) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)(thrd + ": lock(iid=" + iid + ", time=" + time + (Object)((Object)tu) + ")-->TIMEOUT"));
            }
            throw new AbstractInstanceLockManager.TimeoutException();
        }
    }

    @Override
    public void unlock(Long iid) {
        if (iid == null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)" unlock, instance id is null");
            }
            return;
        }
        String thrd = Thread.currentThread().toString();
        ILock lock = this.hz.getLock(iid.toString());
        lock.unlock();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)(thrd + " unlock(iid=" + iid + ")"));
        }
    }
}

