/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.common.InvalidMessageException;
import org.apache.ode.bpel.common.OptionalCorrelationKey;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.BpelRuntimeContextImpl;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.PartnerLinkRoleImpl;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.CorrelationMatchEvent;
import org.apache.ode.bpel.evt.CorrelationNoMatchEvent;
import org.apache.ode.bpel.evt.NewProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.extension.ExtensionCorrelationFilter;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.OdeGlobalConfig;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.InterceptorInvoker;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.PROCESS;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PartnerLinkMyRoleImpl
extends PartnerLinkRoleImpl {
    private static final Log __log = LogFactory.getLog(BpelProcess.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    public Endpoint _endpoint;

    PartnerLinkMyRoleImpl(BpelProcess process, OPartnerLink plink, Endpoint endpoint) {
        super(process, plink);
        this._endpoint = endpoint;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{PartnerLinkRole-");
        buf.append(this._plinkDef.name);
        buf.append('.');
        buf.append(this._plinkDef.myRoleName);
        buf.append(" on ");
        buf.append(this._endpoint);
        buf.append('}');
        return buf.toString();
    }

    public boolean isCreateInstance(MyRoleMessageExchangeImpl mex) {
        Operation operation = this.getMyRoleOperation(mex.getOperationName());
        if (operation == null) {
            return false;
        }
        return this._plinkDef.isCreateInstanceOperation(operation);
    }

    public List<RoutingInfo> findRoute(MyRoleMessageExchangeImpl mex) {
        List messageRoutes;
        CorrelationKeySet keySet;
        Operation operation;
        ArrayList<RoutingInfo> routingInfos = new ArrayList<RoutingInfo>();
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)(this + ":inputMsgRcvd"), (Object[])new Object[]{"messageExchange", mex}));
        }
        if ((operation = this.getMyRoleOperation(mex.getOperationName())) == null) {
            return null;
        }
        this.setMexRole(mex);
        String correlatorId = BpelProcess.genCorrelatorId(this._plinkDef, operation.getName());
        CorrelatorDAO correlator = this._process.getProcessDAO().getCorrelator(correlatorId);
        try {
            keySet = this.computeCorrelationKeys(mex);
        }
        catch (InvalidMessageException ime) {
            __log.debug((Object)"Unable to evaluate correlation keys, invalid message format. ", (Throwable)ime);
            mex.setFailure(MessageExchange.FailureType.FORMAT_ERROR, ime.getMessage(), null);
            return null;
        }
        String mySessionId = mex.getProperty("org.apache.ode.bpel.myRoleSessionId");
        String partnerSessionId = mex.getProperty("org.apache.ode.bpel.partnerRoleSessionId");
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INPUTMSG: " + correlatorId + ": MSG RCVD keys=" + keySet + " mySessionId=" + mySessionId + " partnerSessionId=" + partnerSessionId));
        }
        if ((messageRoutes = correlator.findRoute(keySet)) != null && messageRoutes.size() > 0) {
            for (MessageRouteDAO messageRoute : messageRoutes) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("INPUTMSG: " + correlatorId + ": ckeySet " + messageRoute.getCorrelationKeySet() + " route is to " + messageRoute));
                }
                routingInfos.add(new RoutingInfo(messageRoute, messageRoute.getCorrelationKeySet(), correlator, keySet));
            }
        }
        if (routingInfos.size() == 0) {
            routingInfos.add(new RoutingInfo(null, null, correlator, keySet));
        }
        return routingInfos;
    }

    public void invokeNewInstance(MyRoleMessageExchangeImpl mex, RoutingInfo routing) {
        Operation operation = this.getMyRoleOperation(mex.getOperationName());
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INPUTMSG: " + routing.correlator.getCorrelatorId() + ": routing failed, CREATING NEW INSTANCE"));
        }
        ProcessDAO processDAO = this._process.getProcessDAO();
        if (this._process._pconf.getState() == ProcessState.RETIRED) {
            throw new InvalidProcessException("Process is retired.", 1);
        }
        if (!this._process.processInterceptors(mex, InterceptorInvoker.__onNewInstanceInvoked)) {
            __log.debug((Object)("Not creating a new instance for mex " + mex + "; interceptor prevented!"));
            throw new InvalidProcessException("Cannot instantiate process '" + this._process.getPID() + "' any more.", 2);
        }
        ProcessInstanceDAO newInstance = processDAO.createInstance(routing.correlator);
        BpelRuntimeContextImpl instance = this._process.createRuntimeContext(newInstance, new PROCESS(this._process.getOProcess()), mex);
        NewProcessInstanceEvent evt = new NewProcessInstanceEvent(new QName(this._process.getOProcess().targetNamespace, this._process.getOProcess().getName()), this._process.getProcessDAO().getProcessId(), newInstance.getInstanceId());
        evt.setPortType(mex.getPortType().getQName());
        evt.setOperation(operation.getName());
        evt.setMexId(mex.getMessageExchangeId());
        this._process._debugger.onEvent((BpelEvent)evt);
        this._process.saveEvent((ProcessInstanceEvent)evt, newInstance);
        mex.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.CREATE_INSTANCE);
        newInstance.addMessageExchange(mex.getDAO());
        mex.getDAO().setInstance(newInstance);
        if (mex.getDAO().getCreateTime() == null) {
            mex.getDAO().setCreateTime(instance.getCurrentEventDateTime());
        }
        this._process._engine.acquireInstanceLock(newInstance.getInstanceId());
        instance.execute();
    }

    public void invokeInstance(MyRoleMessageExchangeImpl mex, RoutingInfo routing) {
        Operation operation = this.getMyRoleOperation(mex.getOperationName());
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INPUTMSG: " + routing.correlator.getCorrelatorId() + ": ROUTING to existing instance " + routing.messageRoute.getTargetInstance().getInstanceId()));
        }
        ProcessInstanceDAO instanceDao = routing.messageRoute.getTargetInstance();
        BpelProcess process2 = this._process._engine._activeProcesses.get(instanceDao.getProcess().getProcessId());
        BpelRuntimeContextImpl instance = process2.createRuntimeContext(instanceDao, null, null);
        instance.inputMsgMatch(routing.messageRoute.getGroupId(), routing.messageRoute.getIndex(), mex);
        routing.correlator.removeRoutes(routing.messageRoute.getGroupId(), instanceDao);
        CorrelationMatchEvent evt = new CorrelationMatchEvent(new QName(process2.getOProcess().targetNamespace, process2.getOProcess().getName()), process2.getProcessDAO().getProcessId(), instanceDao.getInstanceId(), routing.matchedKeySet);
        evt.setPortType(mex.getPortType().getQName());
        evt.setOperation(operation.getName());
        evt.setMexId(mex.getMessageExchangeId());
        process2._debugger.onEvent((BpelEvent)evt);
        process2.saveEvent((ProcessInstanceEvent)evt, instanceDao);
        mex.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.MATCHED);
        ProcessInstanceDAO processInstanceDAO = routing.messageRoute.getTargetInstance();
        processInstanceDAO.addMessageExchange(mex.getDAO());
        mex.getDAO().setInstance(processInstanceDAO);
        if (mex.getDAO().getCreateTime() == null) {
            mex.getDAO().setCreateTime(instance.getCurrentEventDateTime());
        }
        instance.execute();
    }

    public void noRoutingMatch(MyRoleMessageExchangeImpl mex, List<RoutingInfo> routings) {
        if (!mex.isAsynchronous()) {
            mex.setFailure(MessageExchange.FailureType.NOMATCH, "No process instance matching correlation keys.", null);
            if (!OdeGlobalConfig.queueInOutMessages()) {
                this._process.doAsyncReply(mex, null);
            }
        } else {
            RoutingInfo routing;
            RoutingInfo routingInfo = routing = routings != null && routings.size() > 0 ? routings.get(routings.size() - 1) : null;
            if (routing != null) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("INPUTMSG: " + routing.correlator.getCorrelatorId() + ": SAVING to DB (no match) "));
                }
                CorrelationNoMatchEvent evt = new CorrelationNoMatchEvent(mex.getPortType().getQName(), mex.getOperation().getName(), mex.getMessageExchangeId(), routing.wholeKeySet);
                evt.setProcessId(this._process.getProcessDAO().getProcessId());
                evt.setProcessName(new QName(this._process.getOProcess().targetNamespace, this._process.getOProcess().getName()));
                this._process._debugger.onEvent((BpelEvent)evt);
                mex.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.QUEUED);
                routing.correlator.enqueueMessage(mex.getDAO(), routing.wholeKeySet);
                Scheduler.JobDetails we = new Scheduler.JobDetails();
                we.setType(Scheduler.JobType.MEX_MATCHER);
                we.setProcessId(this._process.getPID());
                we.setMexId(mex.getMessageExchangeId());
                we.setInMem(Boolean.valueOf(this._process.isInMemory()));
                if (this._process.isInMemory()) {
                    this._process._engine._contexts.scheduler.scheduleVolatileJob(true, we);
                } else {
                    this._process._engine._contexts.scheduler.schedulePersistedJob(we, null);
                }
            }
        }
    }

    private void setMexRole(MyRoleMessageExchangeImpl mex) {
        Operation operation = this.getMyRoleOperation(mex.getOperationName());
        mex.getDAO().setPartnerLinkModelId(this._plinkDef.getId());
        mex.setPortOp(this._plinkDef.myRolePortType, operation);
        mex.setPattern(operation.getOutput() == null ? MessageExchange.MessageExchangePattern.REQUEST_ONLY : MessageExchange.MessageExchangePattern.REQUEST_RESPONSE);
    }

    private Operation getMyRoleOperation(String operationName) {
        return this._plinkDef.getMyRoleOperation(operationName);
    }

    private CorrelationKeySet computeCorrelationKeys(MyRoleMessageExchangeImpl mex) {
        CorrelationKey key;
        ExtensionCorrelationFilter extCorFilter;
        CorrelationKeySet keySet = new CorrelationKeySet();
        Operation operation = mex.getOperation();
        Element msg = mex.getRequest().getMessage();
        Map headerParts = mex.getRequest().getHeaderParts();
        Message msgDescription = operation.getInput().getMessage();
        QName correlationFilter = this._process.getCorrelationFilter(this._plinkDef.getName());
        if (correlationFilter != null && (extCorFilter = this.createExtensionCorrelationFilterImplementation(correlationFilter)) != null) {
            CorrelationKey extensionKey = new CorrelationKey("-2", extCorFilter.computeCorrelationValues(mex.getRequest().getMessage(), mex.getRequest().getHeader()));
            keySet.add(extensionKey);
        }
        Set csets = this._plinkDef.getNonInitiatingCorrelationSetsForOperation(operation);
        for (OScope.CorrelationSet cset : csets) {
            key = this.computeCorrelationKey(cset, (OMessageVarType)this._process.getOProcess().messageTypes.get(msgDescription.getQName()), msg, headerParts);
            keySet.add(key);
        }
        csets = this._plinkDef.getJoinningCorrelationSetsForOperation(operation);
        for (OScope.CorrelationSet cset : csets) {
            key = this.computeCorrelationKey(cset, (OMessageVarType)this._process.getOProcess().messageTypes.get(msgDescription.getQName()), msg, headerParts);
            keySet.add(key);
        }
        String mySessionId = mex.getProperty("org.apache.ode.bpel.myRoleSessionId");
        if (mySessionId != null) {
            keySet.add(new CorrelationKey("-1", new String[]{mySessionId}));
        }
        keySet.add(new CorrelationKey("tenant", new String[]{this._process.getConf().getDeployer()}));
        return keySet;
    }

    private CorrelationKey computeCorrelationKey(OScope.CorrelationSet cset, OMessageVarType messagetype, Element msg, Map<String, Node> headerParts) {
        Object key = null;
        String[] values = new String[cset.properties.size()];
        int jIdx = 0;
        for (OProcess.OProperty property : cset.properties) {
            String value;
            OProcess.OPropertyAlias alias = property.getAlias((OVarType)messagetype);
            if (alias == null) {
                throw new IllegalArgumentException("No alias matching property '" + property.name + "' with message type '" + messagetype + "'");
            }
            try {
                value = this._process.extractProperty(msg, headerParts, alias, msg.toString());
            }
            catch (FaultException fe) {
                String emsg = __msgs.msgPropertyAliasDerefFailedOnMessage(alias.getDescription(), fe.getMessage());
                __log.error((Object)emsg, (Throwable)fe);
                throw new InvalidMessageException(emsg, (Throwable)fe);
            }
            values[jIdx] = value;
            ++jIdx;
        }
        key = cset.hasJoinUseCases ? new OptionalCorrelationKey(cset.name, values) : new CorrelationKey(cset.name, values);
        return key;
    }

    public boolean isOneWayOnly() {
        PortType portType = this._plinkDef.myRolePortType;
        if (portType == null) {
            return false;
        }
        for (Operation operation : portType.getOperations()) {
            if (operation.getOutput() == null) continue;
            return false;
        }
        return true;
    }

    public ExtensionCorrelationFilter createExtensionCorrelationFilterImplementation(QName name) {
        if (name == null) {
            return null;
        }
        ExtensionCorrelationFilter filter = this._process._filterRegistry.get(name.getNamespaceURI());
        if (filter == null) {
            return null;
        }
        try {
            return filter.getExtensionCorrelationFilterInstance(name.getLocalPart());
        }
        catch (Exception e) {
            __log.error((Object)("Error getting filter: " + name), (Throwable)e);
            return null;
        }
    }

    public static class RoutingInfo {
        public MessageRouteDAO messageRoute;
        public CorrelationKeySet matchedKeySet;
        public CorrelatorDAO correlator;
        public CorrelationKeySet wholeKeySet;

        public RoutingInfo(MessageRouteDAO messageRoute, CorrelationKeySet matchedKeySet, CorrelatorDAO correlator, CorrelationKeySet wholeKeySet) {
            this.messageRoute = messageRoute;
            this.matchedKeySet = matchedKeySet;
            this.correlator = correlator;
            this.wholeKeySet = wholeKeySet;
        }
    }
}

