/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.replayer;

import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.BpelRuntimeContextImpl;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.PartnerLinkMyRoleImpl;
import org.apache.ode.bpel.engine.replayer.ReplayerContext;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.pmapi.CommunicationType;
import org.apache.ode.bpel.runtime.PROCESS;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.Selector;
import org.apache.ode.bpel.runtime.channels.ActivityRecoveryChannel;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.InvokeResponseChannel;
import org.apache.ode.bpel.runtime.channels.PickResponseChannel;
import org.apache.ode.bpel.runtime.channels.TimerResponseChannel;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReplayerBpelRuntimeContextImpl
extends BpelRuntimeContextImpl {
    private static final Log __log = LogFactory.getLog(ReplayerBpelRuntimeContextImpl.class);
    private ReplayerContext replayerContext;

    public ReplayerBpelRuntimeContextImpl(BpelProcess bpelProcess, ProcessInstanceDAO dao, PROCESS PROCESS2, MyRoleMessageExchangeImpl instantiatingMessageExchange, ReplayerContext context) {
        super(bpelProcess, dao, PROCESS2, instantiatingMessageExchange);
        this.replayerContext = context;
    }

    @Override
    public void cancel(TimerResponseChannel timerResponseChannel) {
        __log.debug((Object)("cancel " + timerResponseChannel.export()));
        super.cancel(timerResponseChannel);
    }

    @Override
    public Collection<MessageExchange> getMessageExchangeDAOs() {
        return super.getMessageExchangeDAOs();
    }

    @Override
    public void checkInvokeExternalPermission() {
        throw new IllegalStateException("Invoking external services is disabled during replaying");
    }

    @Override
    public String invoke(int aid, PartnerLinkInstance partnerLink, Operation operation, Element outgoingMessage, InvokeResponseChannel channel) throws FaultException {
        __log.debug((Object)"invoke");
        ReplayerContext.AnswerResult answerResult = this.replayerContext.answers.fetchAnswer(partnerLink.partnerLink.partnerRolePortType.getQName(), operation.getName(), outgoingMessage, this.getCurrentEventDateTime());
        if (answerResult.isLive) {
            return super.invoke(aid, partnerLink, operation, outgoingMessage, channel);
        }
        PartnerLinkDAO plinkDAO = this.fetchPartnerLinkDAO(partnerLink);
        MessageExchangeDAO mexDao = this._dao.getConnection().createMessageExchange('P');
        mexDao.setCreateTime(new Date(this.getCurrentEventDateTime().getTime() + 1L));
        mexDao.setOperation(operation.getName());
        mexDao.setPortType(partnerLink.partnerLink.partnerRolePortType.getQName());
        mexDao.setPartnerLinkModelId(partnerLink.partnerLink.getId());
        mexDao.setPartnerLink(plinkDAO);
        mexDao.setPattern((operation.getOutput() != null ? MessageExchange.MessageExchangePattern.REQUEST_RESPONSE : MessageExchange.MessageExchangePattern.REQUEST_ONLY).toString());
        mexDao.setProcess(this._dao.getProcess());
        this._dao.addMessageExchange(mexDao);
        mexDao.setInstance(this._dao);
        MessageDAO request = mexDao.createMessage(new QName("replayer", "replayer"));
        request.setData(outgoingMessage);
        mexDao.setRequest(request);
        CommunicationType.Exchange answer = answerResult.e;
        if (mexDao.getPattern().equals(MessageExchange.MessageExchangePattern.REQUEST_RESPONSE.toString())) {
            MessageDAO response;
            if (answer.isSetFault()) {
                response = mexDao.createMessage(new QName("replayer", "replayer"));
                try {
                    ReplayerBpelRuntimeContextImpl.assign(response, (XmlObject)answer.getFault());
                }
                catch (Exception e) {
                    throw new FaultException(new QName("replayer", "replayer"), (Throwable)e);
                }
                mexDao.setResponse(response);
                mexDao.setFault(answer.getFault().getType());
                mexDao.setFaultExplanation(answer.getFault().getExplanation());
                mexDao.setStatus(MessageExchange.Status.FAULT.toString());
            } else if (answer.isSetOut()) {
                response = mexDao.createMessage(new QName("replayer", "replayer"));
                try {
                    ReplayerBpelRuntimeContextImpl.assign(response, answer.getOut());
                }
                catch (Exception e) {
                    throw new FaultException(new QName("replayer", "replayer"), (Throwable)e);
                }
                mexDao.setResponse(response);
                mexDao.setStatus(MessageExchange.Status.RESPONSE.toString());
            } else if (answer.isSetFailure()) {
                mexDao.setFaultExplanation(answer.getFailure().getExplanation());
                mexDao.setStatus(MessageExchange.Status.FAILURE.toString());
            } else {
                throw new IllegalStateException("I don't have response for invoke " + answer);
            }
            final String channel2 = channel.export();
            final String mexid = mexDao.getMessageExchangeId();
            this.replayerContext.scheduler.scheduleReplayerJob(new Callable(){

                public Object call() throws Exception {
                    __log.debug((Object)("executing invoke response " + channel2));
                    ReplayerBpelRuntimeContextImpl.this.invocationResponse(mexid, channel2);
                    ReplayerBpelRuntimeContextImpl.this.execute();
                    return null;
                }
            }, this.getCurrentEventDateTime(), this);
        } else {
            mexDao.setStatus(MessageExchange.Status.COMPLETED_OK.toString());
        }
        return mexDao.getMessageExchangeId();
    }

    @Override
    public void registerTimer(final TimerResponseChannel timerChannel, final Date timeToFire) {
        __log.debug((Object)("register timer " + timerChannel + " " + timeToFire));
        final String channel = timerChannel.export();
        if (timeToFire.before(this.replayerContext.replayStartDate)) {
            this.replayerContext.scheduler.scheduleReplayerJob(new Callable(){

                public Object call() throws Exception {
                    __log.debug((Object)("executing timer resume " + timerChannel + " " + timeToFire));
                    ReplayerBpelRuntimeContextImpl.this.timerEvent(channel);
                    return null;
                }
            }, timeToFire, this);
        } else {
            super.registerTimer(timerChannel, timeToFire);
        }
    }

    @Override
    public void registerActivityForRecovery(ActivityRecoveryChannel channel, long activityId, String reason, Date dateTime, Element details, String[] actions, int retries) {
        super.registerActivityForRecovery(channel, activityId, reason, dateTime, details, actions, retries);
        this.replayerContext.checkRollbackOnFault();
    }

    @Override
    public void completedFault(FaultData faultData) {
        super.completedFault(faultData);
        this.replayerContext.checkRollbackOnFault();
    }

    @Override
    public void reply(PartnerLinkInstance plinkInstnace, String opName, String mexId, Element msg, QName fault) throws FaultException {
        String mexRef = this._imaManager.release(plinkInstnace, opName, mexId);
        if (mexRef == null) {
            throw new FaultException(this._bpelProcess.getOProcess().constants.qnMissingRequest);
        }
        MessageExchangeDAO mex = this._dao.getConnection().getMessageExchange(mexRef);
        String pipedId = mex.getPipedMessageExchangeId();
        if (pipedId != null) {
            __log.debug((Object)("instance replied for live communication:" + mexRef + " " + DOMUtils.domToString((Node)msg)));
            super.reply2(plinkInstnace, opName, mexId, msg, fault, false, mexRef);
        } else {
            MessageDAO message = mex.createMessage(plinkInstnace.partnerLink.getMyRoleOperation(opName).getOutput().getMessage().getQName());
            this.buildOutgoingMessage(message, msg);
            __log.debug((Object)("instance replied mexRef:" + mexRef + " " + DOMUtils.domToString((Node)msg)));
            mex.setResponse(message);
            mex.setStatus(MessageExchange.Status.RESPONSE.toString());
        }
    }

    @Override
    public void select(PickResponseChannel pickResponseChannel, Date timeout, boolean createInstance, Selector[] selectors) throws FaultException {
        super.select(pickResponseChannel, timeout, createInstance, selectors);
        __log.debug((Object)("select " + pickResponseChannel + " " + ObjectPrinter.toString((Object)selectors, (Object[])selectors)));
    }

    public ProcessInstanceDAO getDAO() {
        return this._dao;
    }

    public static MyRoleMessageExchangeImpl createMyRoleMex(CommunicationType.Exchange e, BpelEngineImpl engine) throws Exception {
        MyRoleMessageExchangeImpl mex = (MyRoleMessageExchangeImpl)engine.createMessageExchange(new GUID().toString(), e.getService(), e.getOperation());
        mex.getDAO().setCreateTime(e.getCreateTime().getTime());
        MessageImpl m2 = (MessageImpl)mex.createMessage(new QName("replayer", "replayer"));
        ReplayerBpelRuntimeContextImpl.assign(m2._dao, e.getIn());
        mex.getDAO().setRequest(m2._dao);
        mex.getDAO().setStatus(MessageExchange.Status.REQUEST.toString());
        return mex;
    }

    public void updateMyRoleMex(MyRoleMessageExchangeImpl m) {
        m.getDAO().setProcess(this._dao.getProcess());
        this._dao.addMessageExchange(m.getDAO());
        m.getDAO().setInstance(this._dao);
    }

    public static void assign(MessageDAO m, XmlObject o) throws Exception {
        NodeList nodes = DOMUtils.parse((InputStream)o.newInputStream(new XmlOptions().setSaveOuter())).getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Element)) continue;
            m.setData((Element)n);
        }
    }

    public void handleIncomingRequest(final MyRoleMessageExchangeImpl mex, Date currentEventDateTime) {
        __log.debug((Object)("handleIncomingRequest for mock communication " + mex));
        this.setCurrentEventDateTime(currentEventDateTime);
        this._bpelProcess.invokeProcess(mex, new BpelProcess.InvokeHandler(){

            @Override
            public boolean invoke(PartnerLinkMyRoleImpl target, PartnerLinkMyRoleImpl.RoutingInfo routing, boolean createInstance) {
                if (routing.messageRoute == null && createInstance) {
                    throw new IllegalStateException("Mock type M mex caused creation of new instance " + mex);
                }
                if (routing.messageRoute != null) {
                    if (!routing.messageRoute.getTargetInstance().getInstanceId().equals(ReplayerBpelRuntimeContextImpl.this._dao.getInstanceId())) {
                        throw new IllegalStateException("Routed target instance is not equal to replayed instance");
                    }
                    ReplayerBpelRuntimeContextImpl.this.inputMsgMatch(routing.messageRoute.getGroupId(), routing.messageRoute.getIndex(), mex);
                    routing.correlator.removeRoutes(routing.messageRoute.getGroupId(), ReplayerBpelRuntimeContextImpl.this._dao);
                    ReplayerBpelRuntimeContextImpl.this.execute();
                    return true;
                }
                return false;
            }
        }, true);
    }

    public static class TimerResume
    extends JacobRunnable {
        private static final long serialVersionUID = 198476512L;
        private final String channelId;

        public TimerResume(String channelId) {
            this.channelId = channelId;
        }

        public void run() {
            ((TimerResponseChannel)TimerResume.importChannel((String)this.channelId, TimerResponseChannel.class)).onTimeout();
        }
    }
}

