/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPickReceive;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.InvalidContextException;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.Selector;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.PickResponseChannel;
import org.apache.ode.bpel.runtime.channels.PickResponseChannelListener;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.xsd.Duration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class PICK
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(PICK.class);
    private OPickReceive _opick;
    private OPickReceive.OnAlarm _alarm = null;

    public PICK(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(self, scopeFrame, linkFrame);
        this._opick = (OPickReceive)self.o;
    }

    public void run() {
        PickResponseChannel pickResponseChannel = (PickResponseChannel)this.newChannel(PickResponseChannel.class);
        try {
            Selector[] selectors = new Selector[this._opick.onMessages.size()];
            int idx = 0;
            for (OPickReceive.OnMessage onMessage : this._opick.onMessages) {
                HashSet<OScope.CorrelationSet> matchCorrelations = new HashSet<OScope.CorrelationSet>();
                matchCorrelations.addAll(onMessage.matchCorrelations);
                for (OScope.CorrelationSet cset : onMessage.joinCorrelations) {
                    if (!this.getBpelRuntimeContext().isCorrelationInitialized(this._scopeFrame.resolve(cset))) continue;
                    matchCorrelations.add(cset);
                }
                PartnerLinkInstance pLinkInstance = this._scopeFrame.resolve(onMessage.partnerLink);
                CorrelationKeySet keySet = this.resolveCorrelationKey(pLinkInstance, matchCorrelations);
                selectors[idx] = new Selector(idx, pLinkInstance, onMessage.operation.getName(), onMessage.operation.getOutput() == null, onMessage.messageExchangeId, keySet, onMessage.route);
                ++idx;
            }
            Date timeout = null;
            for (OPickReceive.OnAlarm onAlarm : this._opick.onAlarms) {
                Date dt;
                Date date = dt = onAlarm.forExpr != null ? PICK.offsetFromNow(this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsDuration(onAlarm.forExpr, this.getEvaluationContext())) : this.getBpelRuntimeContext().getExpLangRuntime().evaluateAsDate(onAlarm.untilExpr, this.getEvaluationContext()).getTime();
                if (timeout != null && timeout.compareTo(dt) <= 0) continue;
                timeout = dt;
                this._alarm = onAlarm;
            }
            this.getBpelRuntimeContext().select(pickResponseChannel, timeout, this._opick.createInstanceFlag, selectors);
        }
        catch (FaultException e) {
            __log.error((Object)e);
            FaultData fault = this.createFault(e.getQName(), (OBase)this._opick, e.getMessage());
            this.dpe(this._opick.outgoingLinks);
            this._self.parent.completed(fault, CompensationHandler.emptySet());
            return;
        }
        catch (EvaluationException e) {
            String msg = "Unexpected evaluation error evaluating alarm.";
            __log.error((Object)msg, (Throwable)e);
            throw new InvalidProcessException(msg, e);
        }
        for (OPickReceive.OnAlarm oa : this._opick.onAlarms) {
            if (oa.equals((Object)this._alarm)) continue;
            this.dpe(oa.activity);
        }
        PICK.instance((JacobRunnable)new WAITING(pickResponseChannel));
    }

    private CorrelationKeySet resolveCorrelationKey(PartnerLinkInstance pLinkInstance, Set<OScope.CorrelationSet> matchCorrelations) throws FaultException {
        CorrelationKeySet keySet = new CorrelationKeySet();
        if (matchCorrelations.isEmpty() && !this._opick.createInstanceFlag) {
            String sessionId = this.getBpelRuntimeContext().fetchMySessionId(pLinkInstance);
            keySet.add(new CorrelationKey("-1", new String[]{sessionId}));
        } else if (!matchCorrelations.isEmpty()) {
            for (OScope.CorrelationSet cset : matchCorrelations) {
                CorrelationKey key = null;
                if (!this.getBpelRuntimeContext().isCorrelationInitialized(this._scopeFrame.resolve(cset))) {
                    if (!this._opick.createInstanceFlag) {
                        throw new FaultException(this._opick.getOwner().constants.qnCorrelationViolation, "Correlation not initialized.");
                    }
                } else {
                    key = this.getBpelRuntimeContext().readCorrelation(this._scopeFrame.resolve(cset));
                    assert (key != null);
                }
                if (key == null) continue;
                keySet.add(key);
            }
        }
        return keySet;
    }

    private static Date offsetFromNow(Duration duration) {
        Calendar cal = Calendar.getInstance();
        duration.addTo(cal);
        return cal.getTime();
    }

    private void initVariable(String mexId, OPickReceive.OnMessage onMessage) {
        Element msgEl;
        if (onMessage.variable == null) {
            return;
        }
        try {
            msgEl = this.getBpelRuntimeContext().getMyRequest(mexId);
        }
        catch (BpelEngineException e) {
            __log.error((Object)"The message exchange seems to be in an unconsistent state, you're probably missing a reply on a request/response interaction.");
            this._self.parent.failure(e.toString(), null);
            return;
        }
        Set partNames = onMessage.operation.getInput().getMessage().getParts().keySet();
        if (!(onMessage.variable.type instanceof OMessageVarType)) {
            String errmsg = "Non-message variable for receive: should have been picked up by static analysis.";
            __log.fatal((Object)errmsg);
            throw new InvalidProcessException(errmsg);
        }
        OMessageVarType vartype = (OMessageVarType)onMessage.variable.type;
        for (String pName : partNames) {
            String errmsg;
            QName partName = new QName(null, pName);
            Element msgPart = DOMUtils.findChildByName((Element)msgEl, (QName)partName);
            OMessageVarType.Part part = (OMessageVarType.Part)vartype.parts.get(pName);
            if (part == null) {
                errmsg = "Inconsistent WSDL, part " + pName + " not found in message type " + vartype.messageType;
                __log.fatal((Object)errmsg);
                throw new InvalidProcessException(errmsg);
            }
            if (msgPart == null) {
                errmsg = "Message missing part: " + pName;
                __log.fatal((Object)errmsg);
                throw new InvalidContextException(errmsg);
            }
            if (!(part.type instanceof OElementVarType)) continue;
            OElementVarType ptype = (OElementVarType)part.type;
            Element e = DOMUtils.getFirstChildElement((Element)msgPart);
            if (e == null) {
                String errmsg2 = "Message (element) part " + pName + " did not contain child element.";
                __log.fatal((Object)errmsg2);
                throw new InvalidContextException(errmsg2);
            }
            QName qn = new QName(e.getNamespaceURI(), e.getLocalName());
            if (qn.equals(ptype.elementType)) continue;
            String errmsg3 = "Message (element) part " + pName + " did not contain correct child element: expected " + ptype.elementType + " but got " + qn;
            __log.fatal((Object)errmsg3);
            throw new InvalidContextException(errmsg3);
        }
        VariableInstance vinst = this._scopeFrame.resolve(onMessage.variable);
        try {
            this.initializeVariable(vinst, msgEl);
        }
        catch (ExternalVariableModuleException e) {
            __log.error((Object)"Exception while initializing external variable", (Throwable)e);
            this._self.parent.failure(e.toString(), null);
            return;
        }
        VariableModificationEvent se = new VariableModificationEvent(vinst.declaration.name);
        se.setNewValue((Node)msgEl);
        if (this._opick.debugInfo != null) {
            se.setLineNo(this._opick.debugInfo.startLine);
        }
        this.sendEvent((ScopeEvent)se);
    }

    private class WAITING
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 1L;
        private PickResponseChannel _pickResponseChannel;

        private WAITING(PickResponseChannel pickResponseChannel) {
            this._pickResponseChannel = pickResponseChannel;
        }

        public void run() {
            WAITING.object((boolean)false, (Set)new PickResponseChannelListener(this._pickResponseChannel){
                private static final long serialVersionUID = -8237296827418738011L;

                @Override
                public void onRequestRcvd(int selectorIdx, String mexId) {
                    OPickReceive.OnMessage onMessage = (OPickReceive.OnMessage)((PICK)PICK.this)._opick.onMessages.get(selectorIdx);
                    for (OPickReceive.OnMessage onmsg : ((PICK)PICK.this)._opick.onMessages) {
                        if (onmsg.equals((Object)onMessage)) continue;
                        PICK.this.dpe(onmsg.activity);
                    }
                    if (PICK.this._alarm != null) {
                        PICK.this.dpe(((PICK)PICK.this)._alarm.activity);
                    }
                    WAITING.this.getBpelRuntimeContext().cancelOutstandingRequests(WAITING.this._pickResponseChannel.export());
                    PICK.this.initVariable(mexId, onMessage);
                    try {
                        VariableInstance vinst = PICK.this._scopeFrame.resolve(onMessage.variable);
                        WAITING.this.getBpelRuntimeContext().checkDuplicateCSets(PICK.this._scopeFrame, onMessage, vinst, mexId);
                        for (OScope.CorrelationSet cset : onMessage.initCorrelations) {
                            WAITING.this.initializeCorrelation(PICK.this._scopeFrame.resolve(cset), vinst);
                        }
                        for (OScope.CorrelationSet cset : onMessage.joinCorrelations) {
                            WAITING.this.initializeCorrelation(PICK.this._scopeFrame.resolve(cset), vinst);
                        }
                        if (onMessage.partnerLink.hasPartnerRole()) {
                            String partnersSessionId;
                            Element fromEpr;
                            if (!(WAITING.this.getBpelRuntimeContext().isPartnerRoleEndpointInitialized(PICK.this._scopeFrame.resolve(onMessage.partnerLink)) && onMessage.partnerLink.initializePartnerRole || (fromEpr = WAITING.this.getBpelRuntimeContext().getSourceEPR(mexId)) == null)) {
                                if (__log.isDebugEnabled()) {
                                    __log.debug((Object)("Received callback EPR " + DOMUtils.domToString((Node)fromEpr) + " saving it on partner link " + onMessage.partnerLink.getName()));
                                }
                                WAITING.this.getBpelRuntimeContext().writeEndpointReference(PICK.this._scopeFrame.resolve(onMessage.partnerLink), fromEpr);
                            }
                            if ((partnersSessionId = WAITING.this.getBpelRuntimeContext().getSourceSessionId(mexId)) != null) {
                                WAITING.this.getBpelRuntimeContext().initializePartnersSessionId(PICK.this._scopeFrame.resolve(onMessage.partnerLink), partnersSessionId);
                            }
                        }
                        WAITING.this.getBpelRuntimeContext().processOutstandingRequest(PICK.this._scopeFrame.resolve(onMessage.partnerLink), onMessage.operation.getName(), onMessage.messageExchangeId, mexId);
                    }
                    catch (FaultException e) {
                        __log.error((Object)e);
                        FaultData fault = WAITING.this.createFault(e.getQName(), (OBase)onMessage);
                        PICK.this._self.parent.completed(fault, CompensationHandler.emptySet());
                        PICK.this.dpe(onMessage.activity);
                        return;
                    }
                    ActivityInfo child = new ActivityInfo(WAITING.this.genMonotonic(), onMessage.activity, PICK.this._self.self, PICK.this._self.parent);
                    2.instance((JacobRunnable)WAITING.this.createChild(child, PICK.this._scopeFrame, PICK.this._linkFrame));
                }

                @Override
                public void onTimeout() {
                    for (OPickReceive.OnMessage onMessage : ((PICK)PICK.this)._opick.onMessages) {
                        PICK.this.dpe(onMessage.activity);
                    }
                    ActivityInfo child = new ActivityInfo(WAITING.this.genMonotonic(), ((PICK)PICK.this)._alarm.activity, PICK.this._self.self, PICK.this._self.parent);
                    2.instance((JacobRunnable)WAITING.this.createChild(child, PICK.this._scopeFrame, PICK.this._linkFrame));
                }

                @Override
                public void onCancel() {
                    PICK.this._self.parent.completed(null, CompensationHandler.emptySet());
                }
            }.or(new TerminationChannelListener(PICK.this._self.self){
                private static final long serialVersionUID = 4399496341785922396L;

                @Override
                public void terminate() {
                    WAITING.this.getBpelRuntimeContext().cancel(WAITING.this._pickResponseChannel);
                    1.instance((JacobRunnable)WAITING.this);
                }
            }));
        }
    }
}

