/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OInvoke;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.InvokeResponseChannel;
import org.apache.ode.bpel.runtime.channels.InvokeResponseChannelListener;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class INVOKE
extends ACTIVITY {
    private static final long serialVersionUID = 992248281026821783L;
    private static final Log __log = LogFactory.getLog(INVOKE.class);
    private OInvoke _oinvoke;
    private int _invoked;
    private Date _lastFailure;
    private String _failureReason;
    private Element _failureData;

    public INVOKE(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(self, scopeFrame, linkFrame);
        this._oinvoke = (OInvoke)this._self.o;
        this._invoked = 0;
    }

    public final void run() {
        Element outboundMsg;
        try {
            outboundMsg = this.setupOutbound(this._oinvoke, this._oinvoke.initCorrelationsInput, this._oinvoke.joinCorrelationsInput);
        }
        catch (FaultException e) {
            __log.error((Object)e);
            FaultData fault = this.createFault(e.getQName(), (OBase)this._oinvoke);
            this._self.parent.completed(fault, CompensationHandler.emptySet());
            return;
        }
        catch (ExternalVariableModuleException e) {
            __log.error((Object)e);
            this._self.parent.failure(e.toString(), null);
            return;
        }
        ++this._invoked;
        boolean isTwoWay = this._oinvoke.outputVar != null;
        try {
            if (!isTwoWay) {
                FaultData faultData = null;
                this.getBpelRuntimeContext().invoke(this._oinvoke.getId(), this._scopeFrame.resolve(this._oinvoke.partnerLink), this._oinvoke.operation, outboundMsg, null);
                this._self.parent.completed(faultData, CompensationHandler.emptySet());
            } else {
                final VariableInstance outputVar = this._scopeFrame.resolve(this._oinvoke.outputVar);
                InvokeResponseChannel invokeResponseChannel = (InvokeResponseChannel)this.newChannel(InvokeResponseChannel.class);
                final String mexId = this.getBpelRuntimeContext().invoke(this._oinvoke.getId(), this._scopeFrame.resolve(this._oinvoke.partnerLink), this._oinvoke.operation, outboundMsg, invokeResponseChannel);
                INVOKE.object((boolean)false, (Set)new InvokeResponseChannelListener(invokeResponseChannel){
                    private static final long serialVersionUID = 4496880438819196765L;

                    @Override
                    public void onResponse() {
                        Element response;
                        FaultData fault = null;
                        try {
                            response = INVOKE.this.getBpelRuntimeContext().getPartnerResponse(mexId);
                        }
                        catch (Exception e) {
                            __log.error((Object)"Exception while processing invoke response", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        try {
                            INVOKE.this.initializeVariable(outputVar, response);
                        }
                        catch (ExternalVariableModuleException e) {
                            __log.error((Object)"Exception while initializing external variable", (Throwable)e);
                            INVOKE.this._self.parent.failure(e.toString(), null);
                            return;
                        }
                        VariableModificationEvent se = new VariableModificationEvent(outputVar.declaration.name);
                        se.setNewValue((Node)response);
                        if (((INVOKE)INVOKE.this)._oinvoke.debugInfo != null) {
                            se.setLineNo(((INVOKE)INVOKE.this)._oinvoke.debugInfo.startLine);
                        }
                        INVOKE.this.sendEvent((ScopeEvent)se);
                        try {
                            for (OScope.CorrelationSet anInitCorrelationsOutput : ((INVOKE)INVOKE.this)._oinvoke.initCorrelationsOutput) {
                                INVOKE.this.initializeCorrelation(INVOKE.this._scopeFrame.resolve(anInitCorrelationsOutput), outputVar);
                            }
                            for (OScope.CorrelationSet aJoinCorrelationsOutput : ((INVOKE)INVOKE.this)._oinvoke.joinCorrelationsOutput) {
                                INVOKE.this.initializeCorrelation(INVOKE.this._scopeFrame.resolve(aJoinCorrelationsOutput), outputVar);
                            }
                            if (((INVOKE)INVOKE.this)._oinvoke.partnerLink.hasPartnerRole()) {
                                String partnersSessionId;
                                Element fromEpr;
                                if (!(INVOKE.this.getBpelRuntimeContext().isPartnerRoleEndpointInitialized(INVOKE.this._scopeFrame.resolve(((INVOKE)INVOKE.this)._oinvoke.partnerLink)) && ((INVOKE)INVOKE.this)._oinvoke.partnerLink.initializePartnerRole || (fromEpr = INVOKE.this.getBpelRuntimeContext().getSourceEPR(mexId)) == null)) {
                                    INVOKE.this.getBpelRuntimeContext().writeEndpointReference(INVOKE.this._scopeFrame.resolve(((INVOKE)INVOKE.this)._oinvoke.partnerLink), fromEpr);
                                }
                                if ((partnersSessionId = INVOKE.this.getBpelRuntimeContext().getSourceSessionId(mexId)) != null) {
                                    INVOKE.this.getBpelRuntimeContext().initializePartnersSessionId(INVOKE.this._scopeFrame.resolve(((INVOKE)INVOKE.this)._oinvoke.partnerLink), partnersSessionId);
                                }
                            }
                        }
                        catch (FaultException e) {
                            fault = INVOKE.this.createFault(e.getQName(), (OBase)INVOKE.this._oinvoke);
                        }
                        INVOKE.this._self.parent.completed(fault, CompensationHandler.emptySet());
                        INVOKE.this.getBpelRuntimeContext().releasePartnerMex(mexId, fault == null);
                    }

                    @Override
                    public void onFault() {
                        QName faultName = INVOKE.this.getBpelRuntimeContext().getPartnerFault(mexId);
                        Element msg = INVOKE.this.getBpelRuntimeContext().getPartnerResponse(mexId);
                        QName msgType = INVOKE.this.getBpelRuntimeContext().getPartnerResponseType(mexId);
                        FaultData fault = INVOKE.this.createFault(faultName, msg, (OVarType)((INVOKE)INVOKE.this)._oinvoke.getOwner().messageTypes.get(msgType), (OBase)INVOKE.this._self.o);
                        INVOKE.this._self.parent.completed(fault, CompensationHandler.emptySet());
                        INVOKE.this.getBpelRuntimeContext().releasePartnerMex(mexId, false);
                    }

                    @Override
                    public void onFailure() {
                        String reason = INVOKE.this.getBpelRuntimeContext().getPartnerFaultExplanation(mexId);
                        __log.error((Object)("Failure during invoke: " + reason));
                        try {
                            Element el = DOMUtils.stringToDOM((String)("<invokeFailure><![CDATA[" + reason + "]]></invokeFailure>"));
                            INVOKE.this._self.parent.failure(reason, el);
                        }
                        catch (Exception e) {
                            INVOKE.this._self.parent.failure(reason, null);
                        }
                        INVOKE.this.getBpelRuntimeContext().releasePartnerMex(mexId, false);
                    }
                }.or(new TerminationChannelListener(this._self.self){
                    private static final long serialVersionUID = 4219496341785922396L;

                    @Override
                    public void terminate() {
                        INVOKE.this._self.parent.completed(null, CompensationHandler.emptySet());
                    }
                }));
            }
        }
        catch (FaultException fault) {
            __log.error((Object)fault);
            FaultData faultData = this.createFault(fault.getQName(), (OBase)this._oinvoke, fault.getMessage());
            this._self.parent.completed(faultData, CompensationHandler.emptySet());
        }
    }

    private Element setupOutbound(OInvoke oinvoke, Collection<OScope.CorrelationSet> outboundInitiations, Collection<OScope.CorrelationSet> outboundJoins) throws FaultException, ExternalVariableModuleException {
        for (OScope.CorrelationSet c : outboundInitiations) {
            this.initializeCorrelation(this._scopeFrame.resolve(c), this._scopeFrame.resolve(oinvoke.inputVar));
        }
        for (OScope.CorrelationSet c : outboundJoins) {
            this.initializeCorrelation(this._scopeFrame.resolve(c), this._scopeFrame.resolve(oinvoke.inputVar));
        }
        if (oinvoke.operation.getInput().getMessage().getParts().size() > 0) {
            this.sendVariableReadEvent(this._scopeFrame.resolve(oinvoke.inputVar));
            Node outboundMsg = this.fetchVariableData(this._scopeFrame.resolve(oinvoke.inputVar), false);
            assert (outboundMsg instanceof Element);
            return (Element)outboundMsg;
        }
        return null;
    }
}

