/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.dao.ProcessManagementDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.hibernate.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessManagementDaoImpl
extends HibernateDao
implements ProcessManagementDAO {
    protected ProcessManagementDaoImpl(SessionManager sessionManager) {
        super(sessionManager, null);
    }

    public Map<ProcessManagementDAO.InstanceSummaryKey, Long> countInstancesSummary(Set<String> pids) {
        HashMap<ProcessManagementDAO.InstanceSummaryKey, Long> result = new HashMap<ProcessManagementDAO.InstanceSummaryKey, Long>();
        if (!pids.isEmpty()) {
            for (InstanceFilter.StatusKeys status : InstanceFilter.StatusKeys.values()) {
                Query query = this.getSession().getNamedQuery("COUNT_INSTANCES_BY_PROCESSES_IDS_AND_STATES");
                query.setParameterList("states", (Collection)new InstanceFilter("status=" + status.toString()).convertFilterState());
                query.setParameterList("processIds", pids);
                for (Object o : query.list()) {
                    Object[] row = (Object[])o;
                    ProcessManagementDAO.InstanceSummaryKey key = new ProcessManagementDAO.InstanceSummaryKey(row[0].toString(), status.toString());
                    result.put(key, (Long)row[1]);
                }
            }
        }
        return result;
    }

    public Map<String, ProcessManagementDAO.FailedSummaryValue> findFailedCountAndLastFailedDateForProcessIds(Set<String> pids) {
        HashMap<String, ProcessManagementDAO.FailedSummaryValue> result = new HashMap<String, ProcessManagementDAO.FailedSummaryValue>();
        if (!pids.isEmpty()) {
            Query query = this.getSession().getNamedQuery("COUNT_FAILED_INSTANCES_BY_PROCESSES_IDS_AND_STATES");
            query.setParameterList("processIds", pids);
            for (Object o : query.list()) {
                Object[] row = (Object[])o;
                result.put(row[0].toString(), new ProcessManagementDAO.FailedSummaryValue((Long)row[1], (Date)row[2]));
            }
        }
        return result;
    }
}

