/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.CommandlineSyntaxException;

public class Argument
implements CommandlineFragment {
    private String _argName;
    private String _description;
    private boolean _isOptional;
    private String _value;

    public Argument(String argName, String description, boolean optional) {
        this._argName = argName;
        this._description = description;
        this._isOptional = optional;
    }

    @Override
    public void reset() {
        this._value = null;
    }

    @Override
    public List<String> consume(List<String> s) throws CommandlineSyntaxException {
        if (s.size() == 0) {
            if (this._isOptional) {
                ArrayList<String> l = new ArrayList<String>();
                Collections.copy(l, s);
                return l;
            }
            throw new CommandlineSyntaxException("The " + this._argName + " argument is required.");
        }
        ArrayList<String> l = new ArrayList<String>(s);
        this._value = l.remove(0);
        return l;
    }

    @Override
    public boolean isOptional() {
        return this._isOptional;
    }

    public boolean isSet() {
        return this._value != null;
    }

    public String getValue() {
        return this._value;
    }

    @Override
    public String getUsage() {
        return "<" + this._argName + ">";
    }

    @Override
    public String getDescription() {
        return this._description;
    }
}

