/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.fs;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.SystemUtils;
import org.apache.ode.utils.fs.FileUtils;

public class TempFileManager {
    private static final Log __log = LogFactory.getLog(TempFileManager.class);
    private static TempFileManager __singleton;
    private static File __baseDir;
    private static File __workDir;
    private SortedSet<File> _registeredFiles = new TreeSet(Collections.reverseOrder(null));

    private static synchronized TempFileManager getInstance() {
        if (__singleton == null) {
            __singleton = new TempFileManager();
        }
        return __singleton;
    }

    private TempFileManager() {
        if (__baseDir == null) {
            String tmpDirPath = null;
            try {
                tmpDirPath = SystemUtils.javaTemporaryDirectory();
            }
            catch (SecurityException se) {
                __log.error((Object)"Unable to read system property for temporary directory setting; will use default configuration.");
                tmpDirPath = "";
            }
            File tmpDir = new File(tmpDirPath);
            if (tmpDir.exists()) {
                __baseDir = tmpDir;
            } else {
                throw new IllegalStateException("Odd system configuration - temporary working directory " + tmpDirPath + " does not exist.");
            }
        }
        try {
            File odeTmp = new File(__baseDir, "ode-" + new GUID().toString());
            if (!odeTmp.mkdir()) {
                throw new IllegalStateException("Unable to create temporary working directory in " + __baseDir.getPath());
            }
            __workDir = odeTmp;
            __log.debug((Object)("Set working directory to: " + __workDir.getAbsolutePath()));
            this._registerTemporaryFile(__workDir);
        }
        catch (SecurityException se) {
            throw new IllegalStateException("The security configuration is preventing the creation of a temporary working directory.", se);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void setWorkingDirectory(File f) {
        if (__singleton == null) {
            if (f == null) {
                __baseDir = null;
                return;
            } else {
                if (!f.isDirectory() || !f.canWrite()) throw new IllegalArgumentException("Not a writeable directory: " + f);
                __baseDir = f;
                __log.debug((Object)("Setting base working directory: " + f));
            }
            return;
        } else {
            String msg = __baseDir != null ? "Already initialized in base directory: " + __baseDir.getPath() : "Already initialized, but no base directory set.";
            throw new IllegalStateException(msg);
        }
    }

    public static synchronized File getTemporaryFile(String handle) {
        return TempFileManager.getTemporaryFile(handle, __workDir);
    }

    public static synchronized File getTemporaryFile(String handle, File parent) {
        File tmp;
        if (__singleton == null) {
            TempFileManager.getInstance();
        }
        if (handle == null) {
            handle = "temp-";
        }
        if (parent == null) {
            parent = __workDir != null ? __workDir : __baseDir;
        }
        try {
            tmp = File.createTempFile(handle + Long.toHexString(System.currentTimeMillis()), ".tmp", parent);
        }
        catch (IOException ioe) {
            __log.error((Object)("Unable to create temporary file in working directory " + (parent == null ? "<null>; " : parent.getPath() + "; ") + "falling back to current working directory."), (Throwable)ioe);
            tmp = new File(handle + new GUID().toString());
        }
        TempFileManager.registerTemporaryFile(tmp);
        return tmp;
    }

    public static synchronized File getTemporaryDirectory(String handle) {
        return TempFileManager.getTemporaryDirectory(handle, null);
    }

    public static synchronized File getTemporaryDirectory(String handle, File parent) {
        File f = TempFileManager.getTemporaryFile(handle, parent);
        f.delete();
        f.mkdirs();
        return f;
    }

    public static synchronized void registerTemporaryFile(File f) {
        TempFileManager.getInstance()._registerTemporaryFile(f);
    }

    private synchronized void _registerTemporaryFile(File f) {
        this._registeredFiles.add(f);
        __log.debug((Object)("Registered temporary file: " + f.getPath()));
    }

    public static synchronized void cleanup() {
        if (__singleton != null) {
            __singleton._cleanup();
            __singleton = null;
        } else {
            __log.debug((Object)"No cleanup necessary.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _cleanup() {
        try {
            TreeSet allFiles = new TreeSet(Collections.reverseOrder(null));
            for (File f : this._registeredFiles) {
                if (!f.exists()) continue;
                allFiles.addAll(FileUtils.directoryEntriesInPath(f));
            }
            __log.debug((Object)("cleaning up " + allFiles.size() + " files."));
            for (File f : allFiles) {
                __log.debug((Object)("deleting: " + f.getAbsolutePath()));
                if (!f.exists() || f.delete()) continue;
                __log.error((Object)("Unable to delete file " + f.getAbsolutePath() + "; this may be caused by a descriptor leak and should be reported."));
                f.deleteOnExit();
            }
        }
        finally {
            this._registeredFiles.clear();
            __workDir = null;
            __log.debug((Object)"cleanup done.");
        }
    }
}

