/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.http;

import java.util.regex.Pattern;

public class HttpUtils {
    public static final String XML_MIME_TYPE_REGEX = "((text/xml)|(application/xml)|((.*)\\+xml))(;.*)*";
    public static final String TEXT_MIME_TYPE_REGEX = "text/(?!xml(;(.*)*))(.*)";
    public static final Pattern XML_MIME_TYPE_PATTERN = Pattern.compile("((text/xml)|(application/xml)|((.*)\\+xml))(;.*)*");
    public static final Pattern TEXT_MIME_TYPE_PATTERN = Pattern.compile("text/(?!xml(;(.*)*))(.*)");

    public static boolean isXml(String contentType) {
        return XML_MIME_TYPE_PATTERN.matcher(contentType).matches();
    }

    public static boolean isText(String contentType) {
        return TEXT_MIME_TYPE_PATTERN.matcher(contentType).matches();
    }

    public static boolean bodyAllowed(int status) {
        return (status < 100 || status >= 200) && status != 204 && status != 304;
    }
}

