/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching.handlers;

import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.wso2.caching.CacheConfiguration;
import org.wso2.caching.CacheManager;
import org.wso2.caching.CachedObject;
import org.wso2.caching.CachingConstants;
import org.wso2.caching.CachingException;
import org.wso2.caching.digest.DigestGenerator;
import org.wso2.caching.handlers.CachingHandler;
import org.wso2.caching.util.FixedByteArrayOutputStream;

public class CachingInHandler
extends CachingHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        block27: {
            block28: {
                block29: {
                    CacheManager cacheManager;
                    String requestHash;
                    ConfigurationContext cfgCtx;
                    CacheConfiguration chCfg;
                    block30: {
                        AxisService axisService;
                        block32: {
                            CachedObject cachedObj;
                            OperationContext opCtx;
                            block31: {
                                block25: {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"Starting the execution of the CachingInHandler");
                                    }
                                    chCfg = null;
                                    Parameter ccfgParam = msgContext.getAxisMessage().getParameter("cacheConfiguration");
                                    if (ccfgParam != null && ccfgParam.getValue() instanceof CacheConfiguration) {
                                        chCfg = (CacheConfiguration)ccfgParam.getValue();
                                    } else {
                                        this.handleException("Unable to perform caching : Could not find the CacheConfiguration");
                                    }
                                    FixedByteArrayOutputStream fbaos = null;
                                    if (chCfg.getMaxMessageSize() > 0) {
                                        fbaos = new FixedByteArrayOutputStream(chCfg.getMaxMessageSize());
                                        try {
                                            msgContext.getEnvelope().serializeAndConsume((OutputStream)fbaos);
                                        }
                                        catch (XMLStreamException e) {
                                            this.handleException("Error in checking the message size", e);
                                        }
                                        catch (CachingException che) {
                                            if (!log.isDebugEnabled()) break block25;
                                            log.debug((Object)"Message size exceeds the upper bound for caching, request will not be cached");
                                            return Handler.InvocationResponse.CONTINUE;
                                        }
                                    }
                                }
                                if ((cfgCtx = msgContext.getConfigurationContext()) == null) break block28;
                                requestHash = null;
                                try {
                                    DigestGenerator digestGenerator = chCfg.getDigestGenerator();
                                    if (digestGenerator != null) {
                                        requestHash = digestGenerator.getDigest(msgContext);
                                    } else {
                                        this.handleException("Unable to retrieve the DigestGenerator from the CacheManager");
                                    }
                                }
                                catch (CachingException ce) {
                                    this.handleException("Unable to perform caching : Error in generating the request hash");
                                }
                                Object cmObj = cfgCtx.getPropertyNonReplicable("cacheManager");
                                if (cmObj != null && cmObj instanceof CacheManager) {
                                    cacheManager = (CacheManager)cmObj;
                                } else {
                                    ConfigurationContext configurationContext = cfgCtx;
                                    synchronized (configurationContext) {
                                        cmObj = cfgCtx.getPropertyNonReplicable("cacheManager");
                                        if (cmObj != null && cmObj instanceof CacheManager) {
                                            cacheManager = (CacheManager)cmObj;
                                        } else {
                                            if (log.isDebugEnabled()) {
                                                log.debug((Object)"Creating/recreating the CacheManager object");
                                            }
                                            cacheManager = new CacheManager();
                                            cfgCtx.setProperty("cacheManager", (Object)cacheManager);
                                        }
                                    }
                                }
                                opCtx = msgContext.getOperationContext();
                                if (opCtx == null) break block29;
                                if (!msgContext.isServerSide()) break block27;
                                opCtx.setProperty("requestHash", (Object)requestHash);
                                if (!cacheManager.containsKey(requestHash) || cacheManager.getResponseForKey(requestHash, (AbstractContext)cfgCtx) == null) break block30;
                                cachedObj = cacheManager.getResponseForKey(requestHash, (AbstractContext)cfgCtx);
                                if (cachedObj.isExpired() || cachedObj.getResponseEnvelope() == null) break block31;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Cache-hit for message-ID : " + msgContext.getMessageID()));
                                }
                                opCtx.setProperty("CachedObject", (Object)cachedObj);
                                axisService = msgContext.getAxisService();
                                if (axisService == null) break block27;
                                break block32;
                            }
                            cachedObj.expire();
                            cachedObj.setTimeout(chCfg.getTimeout());
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Existing cached response has expired. Reset cache element");
                            }
                            opCtx.setProperty("CachedObject", null);
                            cacheManager.addResponseWithKey(requestHash, cachedObj, (AbstractContext)cfgCtx);
                            cfgCtx.setProperty("cacheManager", (Object)cacheManager);
                            cfgCtx.flush();
                            return Handler.InvocationResponse.CONTINUE;
                        }
                        AxisOperation cachedOperation = axisService.getOperation(CachingConstants.CACHED_OPERATION_QNAME);
                        if (cachedOperation != null) {
                            cachedOperation.setControlOperation(true);
                            msgContext.setAxisOperation(cachedOperation);
                            break block27;
                        } else {
                            this.handleException("Unable to perform caching : Could not find the cached operation");
                        }
                        break block27;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"There are no cached responses for the request.");
                    }
                    if (cacheManager.getCacheKeys().size() != chCfg.getMaxCacheSize()) {
                        this.storeRequestToCache(msgContext, requestHash, cacheManager, chCfg);
                        return Handler.InvocationResponse.CONTINUE;
                    }
                    cacheManager.removeExpiredResponses((AbstractContext)cfgCtx);
                    if (cacheManager.getCacheKeys().size() == chCfg.getMaxCacheSize()) {
                        if (!log.isDebugEnabled()) return Handler.InvocationResponse.CONTINUE;
                        log.debug((Object)"In-memory cache is full. Unable to cache");
                        return Handler.InvocationResponse.CONTINUE;
                    }
                    this.storeRequestToCache(msgContext, requestHash, cacheManager, chCfg);
                    return Handler.InvocationResponse.CONTINUE;
                }
                this.handleException("Unable to perform caching : OperationContext not found to store cache details");
                break block27;
            }
            this.handleException("Unable to perform caching : ConfigurationContext not found to process cache");
        }
        if (!log.isDebugEnabled()) return Handler.InvocationResponse.CONTINUE;
        log.debug((Object)"CachingInHandler execution finished");
        return Handler.InvocationResponse.CONTINUE;
    }

    private void storeRequestToCache(MessageContext msgContext, String requestHash, CacheManager cacheManager, CacheConfiguration chCfg) {
        CachedObject cachedObj = new CachedObject();
        cachedObj.setRequestHash(requestHash);
        cachedObj.setTimeout(chCfg.getTimeout());
        cacheManager.addResponseWithKey(requestHash, cachedObj, (AbstractContext)msgContext.getConfigurationContext());
        msgContext.getOperationContext().setProperty("CachedObject", null);
    }
}

