/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.dao;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.cache.Cache;
import javax.cache.Caching;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.SubscriptionAlreadyExistingException;
import org.wso2.carbon.apimgt.api.dto.UserApplicationAPIUsage;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIKey;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.APIStore;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.api.model.Comment;
import org.wso2.carbon.apimgt.api.model.LifeCycleEvent;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.SubscribedAPI;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.dto.APIInfoDTO;
import org.wso2.carbon.apimgt.impl.dto.APIKeyInfoDTO;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;
import org.wso2.carbon.apimgt.impl.dto.ApplicationRegistrationWorkflowDTO;
import org.wso2.carbon.apimgt.impl.dto.TierPermissionDTO;
import org.wso2.carbon.apimgt.impl.dto.WorkflowDTO;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.token.JWTGenerator;
import org.wso2.carbon.apimgt.impl.token.TokenGenerator;
import org.wso2.carbon.apimgt.impl.utils.APIMgtDBUtil;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.utils.APIVersionComparator;
import org.wso2.carbon.apimgt.impl.utils.LRUCache;
import org.wso2.carbon.apimgt.impl.utils.RemoteUserManagerClient;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowExecutorFactory;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowStatus;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ApiMgtDAO {
    private static final Log log = LogFactory.getLog(ApiMgtDAO.class);
    public static TokenGenerator tokenGenerator;
    public static Boolean removeUserNameInJWTForAppToken;
    private static final String ENABLE_JWT_CACHE = "APIKeyManager.EnableJWTCache";
    private boolean forceCaseInsensitiveComparisons = false;

    public ApiMgtDAO() {
        APIManagerConfiguration configuration = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        if (configuration == null) {
            log.error((Object)"API Manager configuration is not initialized");
        } else {
            String enableJWTGeneration = configuration.getFirstProperty("APIConsumerAuthentication.EnableTokenGeneration");
            removeUserNameInJWTForAppToken = Boolean.parseBoolean(configuration.getFirstProperty("APIKeyManager.RemoveUserNameFromJWTForApplicationToken"));
            if (enableJWTGeneration != null && JavaUtils.isTrueExplicitly((String)enableJWTGeneration)) {
                String clazz = configuration.getFirstProperty("APIConsumerAuthentication.TokenGeneratorImpl");
                if (clazz == null) {
                    tokenGenerator = new JWTGenerator();
                } else {
                    try {
                        tokenGenerator = (TokenGenerator)Class.forName(clazz).newInstance();
                    }
                    catch (InstantiationException e) {
                        log.error((Object)("Error while instantiating class " + clazz), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        log.error((Object)e);
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)("Cannot find the class " + clazz + e));
                    }
                }
            }
        }
        String caseSensistiveComparison = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getFirstProperty("APIStore.CompareCaseInsensitively");
        if (caseSensistiveComparison != null) {
            this.forceCaseInsensitiveComparisons = Boolean.parseBoolean(caseSensistiveComparison);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getAccessKeyForAPI(String userId, String applicationName, APIInfoDTO identifier, String keyType) throws APIManagementException, IdentityException {
        String accessKey;
        block10: {
            accessKey = null;
            String loginUserName = this.getLoginUserName(userId);
            String tenantAwareUserId = MultitenantUtils.getTenantAwareUsername((String)loginUserName);
            int tenantId = IdentityUtil.getTenantIdOFUser((String)loginUserName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Searching for: " + identifier.getAPIIdentifier() + ", User: " + tenantAwareUserId + ", ApplicationName: " + applicationName + ", Tenant ID: " + tenantId));
            }
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            String sqlQuery = "SELECT    SKM.ACCESS_TOKEN AS ACCESS_TOKEN FROM    AM_SUBSCRIPTION SP,   AM_API API,   AM_SUBSCRIBER SB,   AM_APPLICATION APP,    AM_SUBSCRIPTION_KEY_MAPPING SKM WHERE    SB.USER_ID=?    AND SB.TENANT_ID=?    AND API.API_PROVIDER=?    AND API.API_NAME=?   AND API.API_VERSION=?   AND APP.NAME=?    AND SKM.KEY_TYPE=?    AND API.API_ID = SP.API_ID   AND SB.SUBSCRIBER_ID = APP.SUBSCRIBER_ID    AND APP.APPLICATION_ID = SP.APPLICATION_ID    AND SP.SUBSCRIPTION_ID = SKM.SUBSCRIPTION_ID ";
            if (this.forceCaseInsensitiveComparisons) {
                sqlQuery = "SELECT    SKM.ACCESS_TOKEN AS ACCESS_TOKEN FROM    AM_SUBSCRIPTION SP,   AM_API API,   AM_SUBSCRIBER SB,   AM_APPLICATION APP,    AM_SUBSCRIPTION_KEY_MAPPING SKM WHERE    LOWER(SB.USER_ID)=LOWER(?)    AND SB.TENANT_ID=?    AND API.API_PROVIDER=?    AND API.API_NAME=?   AND API.API_VERSION=?   AND APP.NAME=?    AND SKM.KEY_TYPE=?    AND API.API_ID = SP.API_ID   AND SB.SUBSCRIBER_ID = APP.SUBSCRIBER_ID    AND APP.APPLICATION_ID = SP.APPLICATION_ID    AND SP.SUBSCRIPTION_ID = SKM.SUBSCRIPTION_ID ";
            }
            try {
                conn = APIMgtDBUtil.getConnection();
                ps = conn.prepareStatement(sqlQuery);
                ps.setString(1, tenantAwareUserId);
                ps.setInt(2, tenantId);
                ps.setString(3, APIUtil.replaceEmailDomainBack(identifier.getProviderId()));
                ps.setString(4, identifier.getApiName());
                ps.setString(5, identifier.getVersion());
                ps.setString(6, applicationName);
                ps.setString(7, keyType);
                rs = ps.executeQuery();
                while (rs.next()) {
                    accessKey = APIUtil.decryptToken(rs.getString("ACCESS_TOKEN"));
                }
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
            }
            catch (SQLException e) {
                ApiMgtDAO.handleException("Error when executing the SQL query to read the access key for user : " + loginUserName + "of tenant(id) : " + tenantId, e);
            }
            catch (CryptoException e2) {
                ApiMgtDAO.handleException("Error when decrypting access key for user : " + loginUserName + "of tenant(id) : " + tenantId, e2);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
            }
        }
        return accessKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createApplicationRegistrationEntry(ApplicationRegistrationWorkflowDTO dto, boolean onlyKeyMappingEntry) throws APIManagementException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Application application = dto.getApplication();
        Subscriber subscriber = application.getSubscriber();
        String registrationEntry = "INSERT INTO  AM_APPLICATION_REGISTRATION (SUBSCRIBER_ID,WF_REF,APP_ID,TOKEN_TYPE,ALLOWED_DOMAINS,VALIDITY_PERIOD)   VALUES(?,?,?,?,?,?)";
        String keyMappingEntry = "INSERT INTO AM_APPLICATION_KEY_MAPPING (APPLICATION_ID,KEY_TYPE,STATE) VALUES(?,?,?)";
        try {
            conn = APIMgtDBUtil.getConnection();
            conn.setAutoCommit(false);
            if (!onlyKeyMappingEntry) {
                ps = conn.prepareStatement(registrationEntry);
                ps.setInt(1, subscriber.getId());
                ps.setString(2, dto.getWorkflowReference());
                ps.setInt(3, application.getId());
                ps.setString(4, dto.getKeyType());
                ps.setString(5, dto.getDomainList());
                ps.setLong(6, dto.getValidityTime());
                ps.execute();
                ps.close();
            }
            ps = conn.prepareStatement(keyMappingEntry);
            ps.setInt(1, application.getId());
            ps.setString(2, dto.getKeyType());
            ps.setString(3, dto.getStatus().toString());
            ps.execute();
            ps.close();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    ApiMgtDAO.handleException("Error occurred while Roling back changes done on Application Registration", e1);
                }
                ApiMgtDAO.handleException("Error occurred while creating an Application Registration Entry for Application : " + application.getName(), e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getAccessKeyForApplication(String userId, String applicationName, String keyType) throws APIManagementException, IdentityException {
        String accessKey;
        block10: {
            accessKey = null;
            String loginUserName = this.getLoginUserName(userId);
            String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
            if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
                accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromUserId(loginUserName);
            }
            int tenantId = IdentityUtil.getTenantIdOFUser((String)loginUserName);
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            String sqlQuery = "SELECT    IAT.ACCESS_TOKEN AS ACCESS_TOKEN FROM    AM_SUBSCRIBER SB,   AM_APPLICATION APP,    AM_APPLICATION_KEY_MAPPING AKM," + accessTokenStoreTable + " IAT," + "   IDN_OAUTH_CONSUMER_APPS ICA " + "WHERE " + "   SB.USER_ID=? " + "   AND SB.TENANT_ID=? " + "   AND APP.NAME=? " + "   AND AKM.KEY_TYPE=? " + "   AND SB.SUBSCRIBER_ID = APP.SUBSCRIBER_ID " + "   AND APP.APPLICATION_ID = AKM.APPLICATION_ID" + "   AND ICA.CONSUMER_KEY = AKM.CONSUMER_KEY" + "   AND ICA.USERNAME = IAT.AUTHZ_USER" + "   AND IAT.CONSUMER_KEY = AKM.CONSUMER_KEY";
            if (this.forceCaseInsensitiveComparisons) {
                sqlQuery = "SELECT    IAT.ACCESS_TOKEN AS ACCESS_TOKEN FROM    AM_SUBSCRIBER SB,   AM_APPLICATION APP,    AM_APPLICATION_KEY_MAPPING AKM," + accessTokenStoreTable + " IAT," + "   IDN_OAUTH_CONSUMER_APPS ICA " + "WHERE " + "   LOWER(SB.USER_ID)=LOWER(?) " + "   AND SB.TENANT_ID=? " + "   AND APP.NAME=? " + "   AND AKM.KEY_TYPE=? " + "   AND SB.SUBSCRIBER_ID = APP.SUBSCRIBER_ID " + "   AND APP.APPLICATION_ID = AKM.APPLICATION_ID" + "   AND ICA.CONSUMER_KEY = AKM.CONSUMER_KEY" + "   AND ICA.USERNAME = IAT.AUTHZ_USER" + "   AND IAT.CONSUMER_KEY = AKM.CONSUMER_KEY";
            }
            try {
                conn = APIMgtDBUtil.getConnection();
                ps = conn.prepareStatement(sqlQuery);
                ps.setString(1, loginUserName);
                ps.setInt(2, tenantId);
                ps.setString(3, applicationName);
                ps.setString(4, keyType);
                rs = ps.executeQuery();
                while (rs.next()) {
                    accessKey = APIUtil.decryptToken(rs.getString("ACCESS_TOKEN"));
                }
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
            }
            catch (SQLException e) {
                ApiMgtDAO.handleException("Error when executing the SQL query to read the access key for user : " + loginUserName + "of tenant(id) : " + tenantId, e);
            }
            catch (CryptoException e2) {
                ApiMgtDAO.handleException("Error when decrypting access key for user : " + loginUserName + "of tenant(id) : " + tenantId, e2);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
            }
        }
        return accessKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIInfoDTO[] getSubscribedAPIsOfUser(String userId) throws APIManagementException, IdentityException {
        String loginUserName = this.getLoginUserName(userId);
        String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)loginUserName);
        int tenantId = IdentityUtil.getTenantIdOFUser((String)loginUserName);
        ArrayList<APIInfoDTO> apiInfoDTOList = new ArrayList<APIInfoDTO>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sqlQuery = "SELECT    API.API_PROVIDER AS API_PROVIDER,   API.API_NAME AS API_NAME,   API.API_VERSION AS API_VERSION FROM    AM_SUBSCRIPTION SP,    AM_API API,   AM_SUBSCRIBER SB,    AM_APPLICATION APP WHERE    SB.USER_ID = ?    AND SB.TENANT_ID = ?    AND SB.SUBSCRIBER_ID = APP.SUBSCRIBER_ID    AND APP.APPLICATION_ID=SP.APPLICATION_ID    AND API.API_ID = SP.API_ID   AND SP.SUBS_CREATE_STATE = 'SUBSCRIBE'";
        if (this.forceCaseInsensitiveComparisons) {
            sqlQuery = "SELECT    API.API_PROVIDER AS API_PROVIDER,   API.API_NAME AS API_NAME,   API.API_VERSION AS API_VERSION FROM    AM_SUBSCRIPTION SP,    AM_API API,   AM_SUBSCRIBER SB,    AM_APPLICATION APP WHERE    LOWER(SB.USER_ID) = LOWER(?)    AND SB.TENANT_ID = ?    AND SB.SUBSCRIBER_ID = APP.SUBSCRIBER_ID    AND APP.APPLICATION_ID=SP.APPLICATION_ID    AND API.API_ID = SP.API_ID   AND SP.SUBS_CREATE_STATE = 'SUBSCRIBE'";
        }
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, tenantAwareUsername);
            ps.setInt(2, tenantId);
            rs = ps.executeQuery();
            while (rs.next()) {
                APIInfoDTO infoDTO = new APIInfoDTO();
                infoDTO.setProviderId(APIUtil.replaceEmailDomain(rs.getString("API_PROVIDER")));
                infoDTO.setApiName(rs.getString("API_NAME"));
                infoDTO.setVersion(rs.getString("API_VERSION"));
                apiInfoDTOList.add(infoDTO);
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while executing SQL", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        return apiInfoDTOList.toArray(new APIInfoDTO[apiInfoDTOList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIKeyInfoDTO[] getSubscribedUsersForAPI(APIInfoDTO apiInfoDTO) throws APIManagementException {
        APIKeyInfoDTO[] apiKeyInfoDTOs = null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sqlQuery = "SELECT    SB.USER_ID,    SB.TENANT_ID FROM    AM_SUBSCRIBER SB,    AM_APPLICATION APP,    AM_SUBSCRIPTION SP,    AM_API API WHERE    API.API_PROVIDER = ?    AND API.API_NAME = ?   AND API.API_VERSION = ?   AND SP.APPLICATION_ID = APP.APPLICATION_ID    AND APP.SUBSCRIBER_ID=SB.SUBSCRIBER_ID    AND API.API_ID = SP.API_ID   AND SP.SUBS_CREATE_STATE = 'SUBSCRIBE'";
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, APIUtil.replaceEmailDomainBack(apiInfoDTO.getProviderId()));
            ps.setString(2, apiInfoDTO.getApiName());
            ps.setString(3, apiInfoDTO.getVersion());
            rs = ps.executeQuery();
            ArrayList<APIKeyInfoDTO> apiKeyInfoList = new ArrayList<APIKeyInfoDTO>();
            while (rs.next()) {
                String userId = rs.getString("USER_ID");
                APIKeyInfoDTO apiKeyInfoDTO = new APIKeyInfoDTO();
                apiKeyInfoDTO.setUserId(userId);
                apiKeyInfoList.add(apiKeyInfoDTO);
            }
            apiKeyInfoDTOs = apiKeyInfoList.toArray(new APIKeyInfoDTO[apiKeyInfoList.size()]);
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while executing SQL", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        return apiKeyInfoDTOs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeAccessTokenStatus(String userId, APIInfoDTO apiInfoDTO, String statusEnum) throws APIManagementException, IdentityException {
        String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)userId);
        int tenantId = 0;
        IdentityUtil.getTenantIdOFUser((String)userId);
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromUserId(userId);
        }
        Connection conn = null;
        PreparedStatement ps = null;
        String sqlQuery = "UPDATE " + accessTokenStoreTable + " IAT , AM_SUBSCRIBER SB," + " AM_SUBSCRIPTION SP , AM_APPLICATION APP, AM_API API" + " SET IAT.TOKEN_STATE=?" + " WHERE SB.USER_ID=?" + " AND SB.TENANT_ID=?" + " AND API.API_PROVIDER=?" + " AND API.API_NAME=?" + " AND API.API_VERSION=?" + " AND SP.ACCESS_TOKEN=IAT.ACCESS_TOKEN" + " AND SB.SUBSCRIBER_ID=APP.SUBSCRIBER_ID" + " AND APP.APPLICATION_ID = SP.APPLICATION_ID" + " AND API.API_ID = SP.API_ID";
        if (this.forceCaseInsensitiveComparisons) {
            sqlQuery = "UPDATE " + accessTokenStoreTable + " IAT , AM_SUBSCRIBER SB," + " AM_SUBSCRIPTION SP , AM_APPLICATION APP, AM_API API" + " SET IAT.TOKEN_STATE=?" + " WHERE LOWER(SB.USER_ID)=LOWER(?)" + " AND SB.TENANT_ID=?" + " AND API.API_PROVIDER=?" + " AND API.API_NAME=?" + " AND API.API_VERSION=?" + " AND SP.ACCESS_TOKEN=IAT.ACCESS_TOKEN" + " AND SB.SUBSCRIBER_ID=APP.SUBSCRIBER_ID" + " AND APP.APPLICATION_ID = SP.APPLICATION_ID" + " AND API.API_ID = SP.API_ID";
        }
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, statusEnum);
            ps.setString(2, tenantAwareUsername);
            ps.setInt(3, tenantId);
            ps.setString(4, APIUtil.replaceEmailDomainBack(apiInfoDTO.getProviderId()));
            ps.setString(5, apiInfoDTO.getApiName());
            ps.setString(6, apiInfoDTO.getVersion());
            int count = ps.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of rows being updated : " + count));
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e1) {
                log.error((Object)"Failed to rollback the changeAccessTokenStatus operation", (Throwable)e);
            }
            ApiMgtDAO.handleException("Error while executing SQL", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public APIKeyValidationInfoDTO validateKey(String context, String version, String accessToken, String requiredAuthenticationLevel) throws APIManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("A request is received to process the token : " + accessToken + " to access" + " the context URL : " + context));
        }
        APIKeyValidationInfoDTO keyValidationInfoDTO = new APIKeyValidationInfoDTO();
        keyValidationInfoDTO.setAuthorized(false);
        boolean defaultVersionInvoked = false;
        String versionCheckStr = "   AND API.API_VERSION = ? ";
        if (version != null && version.startsWith("_default_")) {
            defaultVersionInvoked = true;
            version = version.split("_default_")[0];
        }
        String getAPISqlQuery = "SELECT   API_PROVIDER,   API_NAME    FROM AM_API   WHERE   API_VERSION = ?   AND CONTEXT = ? ";
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromAccessToken(accessToken);
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String applicationSqlQuery = "SELECT    IAT.VALIDITY_PERIOD,    IAT.TIME_CREATED ,   IAT.TOKEN_STATE,   IAT.USER_TYPE,   IAT.AUTHZ_USER,   IAT.TIME_CREATED,   IAT.TOKEN_SCOPE,   SUB.TIER_ID,   SUBS.USER_ID,   SUB.SUB_STATUS,   APP.APPLICATION_ID,   APP.NAME,   APP.APPLICATION_TIER,   AKM.KEY_TYPE,   API.API_NAME,   AKM.CONSUMER_KEY,   API.API_PROVIDER FROM " + accessTokenStoreTable + " IAT," + "   AM_SUBSCRIPTION SUB," + "   AM_SUBSCRIBER SUBS," + "   AM_APPLICATION APP," + "   AM_APPLICATION_KEY_MAPPING AKM," + "   AM_API API" + " WHERE " + "   IAT.ACCESS_TOKEN = ? " + "   AND API.CONTEXT = ? " + (defaultVersionInvoked ? "" : " AND API.API_VERSION = ? ") + "   AND IAT.CONSUMER_KEY=AKM.CONSUMER_KEY " + "   AND SUB.APPLICATION_ID = APP.APPLICATION_ID" + "   AND APP.SUBSCRIBER_ID = SUBS.SUBSCRIBER_ID" + "   AND API.API_ID = SUB.API_ID" + "   AND AKM.APPLICATION_ID=APP.APPLICATION_ID";
        try {
            block33: {
                block30: {
                    block31: {
                        block32: {
                            APIKeyValidationInfoDTO scopes;
                            conn = APIMgtDBUtil.getConnection();
                            ps = conn.prepareStatement(applicationSqlQuery);
                            String encryptedAccessToken = APIUtil.encryptToken(accessToken);
                            ps.setString(1, encryptedAccessToken);
                            ps.setString(2, context);
                            if (!defaultVersionInvoked) {
                                ps.setString(3, version);
                            }
                            if (!(rs = ps.executeQuery()).next()) break block30;
                            String status = rs.getString("TOKEN_STATE");
                            String tier = rs.getString("TIER_ID");
                            String type = rs.getString("KEY_TYPE");
                            String userType = rs.getString("USER_TYPE");
                            String subscriberName = rs.getString("USER_ID");
                            String applicationId = rs.getString("APPLICATION_ID");
                            String applicationName = rs.getString("NAME");
                            String applicationTier = rs.getString("APPLICATION_TIER");
                            String endUserName = rs.getString("AUTHZ_USER");
                            long issuedTime = rs.getTimestamp("TIME_CREATED", Calendar.getInstance(TimeZone.getTimeZone("UTC"))).getTime();
                            String scopeString = rs.getString("TOKEN_SCOPE");
                            long validityPeriod = rs.getLong("VALIDITY_PERIOD");
                            long timestampSkew = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
                            long currentTime = System.currentTimeMillis();
                            String subscriptionStatus = rs.getString("SUB_STATUS");
                            String apiName = rs.getString("API_NAME");
                            String consumerKey = rs.getString("CONSUMER_KEY");
                            String apiPublisher = rs.getString("API_PROVIDER");
                            keyValidationInfoDTO.setApiName(apiName);
                            keyValidationInfoDTO.setApiPublisher(apiPublisher);
                            keyValidationInfoDTO.setApplicationId(applicationId);
                            keyValidationInfoDTO.setApplicationName(applicationName);
                            keyValidationInfoDTO.setApplicationTier(applicationTier);
                            keyValidationInfoDTO.setConsumerKey(consumerKey);
                            keyValidationInfoDTO.setEndUserName(endUserName);
                            keyValidationInfoDTO.setIssuedTime(issuedTime);
                            keyValidationInfoDTO.setTier(tier);
                            keyValidationInfoDTO.setType(type);
                            keyValidationInfoDTO.setUserType(userType);
                            keyValidationInfoDTO.setValidityPeriod(validityPeriod);
                            keyValidationInfoDTO.setSubscriber(subscriberName);
                            keyValidationInfoDTO.setAuthorizedDomains(ApiMgtDAO.getAuthorizedDomainList(accessToken));
                            keyValidationInfoDTO.setConsumerKey(APIUtil.decryptToken(consumerKey));
                            if (scopeString != null && !"".equals(scopeString)) {
                                scopes = new HashSet(Arrays.asList(scopeString.split(" ")));
                                keyValidationInfoDTO.setScopes((Set)scopes);
                            }
                            if (subscriptionStatus.equals("BLOCKED")) {
                                keyValidationInfoDTO.setValidationStatus(900907);
                                keyValidationInfoDTO.setAuthorized(false);
                                scopes = keyValidationInfoDTO;
                                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                                return scopes;
                            }
                            if ("ON_HOLD".equals(subscriptionStatus) || "REJECTED".equals(subscriptionStatus)) {
                                keyValidationInfoDTO.setValidationStatus(900909);
                                keyValidationInfoDTO.setAuthorized(false);
                                scopes = keyValidationInfoDTO;
                                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                                return scopes;
                            }
                            if (subscriptionStatus.equals("PROD_ONLY_BLOCKED") && !"SANDBOX".equals(type)) {
                                keyValidationInfoDTO.setValidationStatus(900907);
                                keyValidationInfoDTO.setAuthorized(false);
                                scopes = keyValidationInfoDTO;
                                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                                return scopes;
                            }
                            if (requiredAuthenticationLevel.equals("Application") || requiredAuthenticationLevel.equals("Application_User")) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Access token's userType : " + userType + ".Required type : " + requiredAuthenticationLevel));
                                }
                                if (!userType.equalsIgnoreCase(requiredAuthenticationLevel)) {
                                    keyValidationInfoDTO.setValidationStatus(900905);
                                    keyValidationInfoDTO.setAuthorized(false);
                                    scopes = keyValidationInfoDTO;
                                    APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                                    return scopes;
                                }
                            }
                            if (!"ACTIVE".equals(status)) break block31;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Checking Access token: " + accessToken + " for validity." + "((currentTime - timestampSkew) > (issuedTime + validityPeriod)) : " + "((" + currentTime + "-" + timestampSkew + ")" + " > (" + issuedTime + " + " + validityPeriod + "))"));
                            }
                            if (validityPeriod == Long.MAX_VALUE || currentTime - timestampSkew <= issuedTime + validityPeriod) break block32;
                            keyValidationInfoDTO.setValidationStatus(900903);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Access token: " + accessToken + " has expired. " + "Reason ((currentTime - timestampSkew) > (issuedTime + validityPeriod)) : " + "((" + currentTime + "-" + timestampSkew + ")" + " > (" + issuedTime + " + " + validityPeriod + "))"));
                            }
                            this.updateTokenState(accessToken, conn, ps);
                            conn.commit();
                            break block33;
                        }
                        keyValidationInfoDTO.setAuthorized(true);
                        if (tokenGenerator != null) {
                            String calleeToken = null;
                            String enableJWTCache = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getFirstProperty(ENABLE_JWT_CACHE);
                            Cache jwtCache = Caching.getCacheManager((String)"API_MANAGER_CACHE").getCache("jwtCache");
                            if (enableJWTCache != null && JavaUtils.isTrueExplicitly((String)enableJWTCache)) {
                                String cacheKey = accessToken + ":" + context + ":" + version + ":" + requiredAuthenticationLevel;
                                calleeToken = (String)jwtCache.get((Object)cacheKey);
                                if (calleeToken == null) {
                                    calleeToken = this.generateJWTToken(keyValidationInfoDTO, context, version, accessToken);
                                    jwtCache.put((Object)cacheKey, (Object)calleeToken);
                                }
                            } else {
                                calleeToken = this.generateJWTToken(keyValidationInfoDTO, context, version, accessToken);
                            }
                            keyValidationInfoDTO.setEndUserToken(calleeToken);
                        }
                        break block33;
                    }
                    keyValidationInfoDTO.setValidationStatus(900904);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Access token: " + accessToken + " is inactive"));
                    }
                    break block33;
                }
                keyValidationInfoDTO.setValidationStatus(900901);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Access token: " + accessToken + " is invalid"));
                }
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
            return keyValidationInfoDTO;
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error when executing the SQL ", e);
            return keyValidationInfoDTO;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (CryptoException e2) {
                ApiMgtDAO.handleException("Error when encrypting/decrypting token(s)", e2);
                return keyValidationInfoDTO;
            }
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
    }

    private String generateJWTToken(APIKeyValidationInfoDTO keyValidationInfoDTO, String context, String version) throws APIManagementException {
        String jwtToken = tokenGenerator.generateToken(keyValidationInfoDTO, context, version);
        return jwtToken;
    }

    private String generateJWTToken(APIKeyValidationInfoDTO keyValidationInfoDTO, String context, String version, String accessToken) throws APIManagementException {
        return tokenGenerator.generateToken(keyValidationInfoDTO, context, version, accessToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApplicationAccessTokenRemainingValidityPeriod(String accessToken) throws APIManagementException {
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromAccessToken(accessToken);
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        long remainingTime = 0L;
        String applicationSqlQuery = "SELECT  IAT.VALIDITY_PERIOD,  IAT.TIME_CREATED  FROM " + accessTokenStoreTable + " IAT" + " WHERE " + " IAT.ACCESS_TOKEN = ? ";
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(applicationSqlQuery);
            ps.setString(1, accessToken);
            rs = ps.executeQuery();
            if (rs.next()) {
                long issuedTime = rs.getTimestamp("TIME_CREATED", Calendar.getInstance(TimeZone.getTimeZone("UTC"))).getTime();
                long validityPeriod = rs.getLong("VALIDITY_PERIOD");
                long timestampSkew = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
                long currentTime = System.currentTimeMillis();
                remainingTime = currentTime - (issuedTime + validityPeriod);
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error when executing the SQL ", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        return remainingTime;
    }

    public static List<String> getAuthorizedDomainList(String apiKey) throws APIManagementException {
        return Arrays.asList(ApiMgtDAO.getAuthorizedDomains(apiKey).split(","));
    }

    private void updateTokenState(String accessToken, Connection conn, PreparedStatement ps) throws SQLException, APIManagementException, CryptoException {
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromAccessToken(accessToken);
        }
        String encryptedAccessToken = APIUtil.encryptToken(accessToken);
        String UPDATE_TOKE_STATE_SQL = "UPDATE " + accessTokenStoreTable + " SET " + "   TOKEN_STATE = ? " + "   ,TOKEN_STATE_ID = ? " + "WHERE " + "   ACCESS_TOKEN = ?";
        ps = conn.prepareStatement(UPDATE_TOKE_STATE_SQL);
        ps.setString(1, "EXPIRED");
        ps.setString(2, UUID.randomUUID().toString());
        ps.setString(3, encryptedAccessToken);
        ps.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Subscriber subscriber) throws APIManagementException {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String query = "INSERT INTO AM_SUBSCRIBER (USER_ID, TENANT_ID, EMAIL_ADDRESS, DATE_SUBSCRIBED) VALUES (?,?,?,?)";
            ps = conn.prepareStatement(query, new String[]{"subscriber_id"});
            ps.setString(1, subscriber.getName());
            ps.setInt(2, subscriber.getTenantId());
            ps.setString(3, subscriber.getEmail());
            ps.setTimestamp(4, new Timestamp(subscriber.getSubscribedDate().getTime()));
            ps.executeUpdate();
            int subscriberId = 0;
            rs = ps.getGeneratedKeys();
            if (rs.next()) {
                subscriberId = Integer.valueOf(rs.getString(1));
            }
            subscriber.setId(subscriberId);
            Application defaultApp = new Application("DefaultApplication", subscriber);
            defaultApp.setTier("Unlimited");
            this.addApplication(defaultApp, subscriber.getName(), conn);
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Error while rolling back the failed operation", (Throwable)e);
                    }
                }
                ApiMgtDAO.handleException("Error in adding new subscriber: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSubscriber(Subscriber subscriber) throws APIManagementException {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String query = "UPDATE AM_SUBSCRIBER SET USER_ID=?, TENANT_ID=?, EMAIL_ADDRESS=?, DATE_SUBSCRIBED=? WHERE SUBSCRIBER_ID=?";
            ps = conn.prepareStatement(query);
            ps.setString(1, subscriber.getName());
            ps.setInt(2, subscriber.getTenantId());
            ps.setString(3, subscriber.getEmail());
            ps.setTimestamp(4, new Timestamp(subscriber.getSubscribedDate().getTime()));
            ps.setInt(5, subscriber.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error in updating subscriber: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscriber getSubscriber(int subscriberId) throws APIManagementException {
        PreparedStatement ps;
        ResultSet rs;
        Connection conn;
        block4: {
            Subscriber subscriber;
            conn = null;
            rs = null;
            ps = null;
            try {
                conn = APIMgtDBUtil.getConnection();
                String query = "SELECT USER_ID, TENANT_ID, EMAIL_ADDRESS, DATE_SUBSCRIBED FROM AM_SUBSCRIBER WHERE SUBSCRIBER_ID=?";
                ps = conn.prepareStatement(query);
                ps.setInt(1, subscriberId);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                Subscriber subscriber2 = new Subscriber(rs.getString("USER_ID"));
                subscriber2.setId(subscriberId);
                subscriber2.setTenantId(rs.getInt("TENANT_ID"));
                subscriber2.setEmail(rs.getString("EMAIL_ADDRESS"));
                subscriber2.setSubscribedDate(new Date(rs.getTimestamp("DATE_SUBSCRIBED").getTime()));
                subscriber = subscriber2;
            }
            catch (SQLException e) {
                try {
                    ApiMgtDAO.handleException("Error while retrieving subscriber: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                    throw throwable;
                }
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
            return subscriber;
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSubscription(APIIdentifier identifier, String context, int applicationId, String status) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        int subscriptionId = -1;
        int apiId = -1;
        try {
            conn = APIMgtDBUtil.getConnection();
            String getApiQuery = "SELECT API_ID FROM AM_API API WHERE API_PROVIDER = ? AND API_NAME = ? AND API_VERSION = ?";
            ps = conn.prepareStatement(getApiQuery);
            ps.setString(1, APIUtil.replaceEmailDomainBack(identifier.getProviderName()));
            ps.setString(2, identifier.getApiName());
            ps.setString(3, identifier.getVersion());
            resultSet = ps.executeQuery();
            if (resultSet.next()) {
                apiId = resultSet.getInt("API_ID");
            }
            resultSet.close();
            ps.close();
            if (apiId == -1) {
                String msg = "Unable to get the API ID for: " + identifier;
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            String checkDuplicateQuery = "SELECT SUB_STATUS, SUBS_CREATE_STATE FROM AM_SUBSCRIPTION WHERE API_ID = ? AND APPLICATION_ID = ? AND TIER_ID = ?";
            ps = conn.prepareStatement(checkDuplicateQuery);
            ps.setInt(1, apiId);
            ps.setInt(2, applicationId);
            ps.setString(3, identifier.getTier());
            resultSet = ps.executeQuery();
            if (resultSet.next()) {
                String subStatus = resultSet.getString("SUB_STATUS");
                String subCreationStatus = resultSet.getString("SUBS_CREATE_STATE");
                resultSet.close();
                ps.close();
                if ("UNBLOCKED".equals(subStatus) && "SUBSCRIBE".equals(subCreationStatus)) {
                    log.error((Object)("Subscription already exists for API " + identifier.getApiName() + " in Application " + applicationId));
                    throw new SubscriptionAlreadyExistingException("Subscription already exists for API " + identifier.getApiName() + " in Application " + applicationId);
                }
                if ("UNBLOCKED".equals(subStatus) && "UN_SUBSCRIBE".equals(subCreationStatus)) {
                    String deleteQuery = "DELETE FROM AM_SUBSCRIPTION WHERE API_ID = ? AND APPLICATION_ID = ? AND TIER_ID = ?";
                    ps = conn.prepareStatement(deleteQuery);
                    ps.setInt(1, apiId);
                    ps.setInt(2, applicationId);
                    ps.setString(3, identifier.getTier());
                    ps.executeUpdate();
                } else if ("BLOCKED".equals(subStatus)) {
                    log.error((Object)("Subscription to API " + identifier.getApiName() + " through application " + applicationId + " was blocked"));
                    throw new APIManagementException("Subscription to API " + identifier.getApiName() + " through application " + applicationId + " was blocked");
                }
            }
            resultSet.close();
            ps.close();
            String sqlQuery = "INSERT INTO AM_SUBSCRIPTION (TIER_ID,API_ID,APPLICATION_ID,SUB_STATUS, SUBS_CREATE_STATE) VALUES (?,?,?,?,?)";
            ps = conn.prepareStatement(sqlQuery, new String[]{"SUBSCRIPTION_ID"});
            if (conn.getMetaData().getDriverName().contains("PostgreSQL")) {
                ps = conn.prepareStatement(sqlQuery, new String[]{"subscription_id"});
            }
            ps.setString(1, identifier.getTier());
            ps.setInt(2, apiId);
            ps.setInt(3, applicationId);
            ps.setString(4, status != null ? status : "UNBLOCKED");
            ps.setString(5, "SUBSCRIBE");
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            while (rs.next()) {
                subscriptionId = Integer.valueOf(rs.getString(1));
            }
            ps.close();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback the add subscription ", (Throwable)e);
                    }
                }
                ApiMgtDAO.handleException("Failed to add subscriber data ", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        return subscriptionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(APIIdentifier identifier, int applicationId) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        int subscriptionId = -1;
        int apiId = -1;
        String subStatus = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String getApiQuery = "SELECT API_ID FROM AM_API API WHERE API_PROVIDER = ? AND API_NAME = ? AND API_VERSION = ?";
            ps = conn.prepareStatement(getApiQuery);
            ps.setString(1, APIUtil.replaceEmailDomainBack(identifier.getProviderName()));
            ps.setString(2, identifier.getApiName());
            ps.setString(3, identifier.getVersion());
            resultSet = ps.executeQuery();
            if (resultSet.next()) {
                apiId = resultSet.getInt("API_ID");
            }
            resultSet.close();
            ps.close();
            if (apiId == -1) {
                throw new APIManagementException("Unable to get the API ID for: " + identifier);
            }
            String subscriptionStatusQuery = "SELECT SUB_STATUS FROM AM_SUBSCRIPTION WHERE API_ID = ? AND APPLICATION_ID = ?";
            ps = conn.prepareStatement(subscriptionStatusQuery);
            ps.setInt(1, apiId);
            ps.setInt(2, applicationId);
            resultSet = ps.executeQuery();
            if (resultSet.next()) {
                subStatus = resultSet.getString("SUB_STATUS");
            }
            resultSet.close();
            ps.close();
            String updateQuery = "UPDATE AM_SUBSCRIPTION SET SUBS_CREATE_STATE = 'UN_SUBSCRIBE' WHERE API_ID = ? AND APPLICATION_ID = ?";
            String deleteQuery = "DELETE FROM AM_SUBSCRIPTION WHERE API_ID = ? AND APPLICATION_ID = ?";
            if ("BLOCKED".equals(subStatus) || "PROD_ONLY_BLOCKED".equals(subStatus)) {
                ps = conn.prepareStatement(updateQuery);
                ps.setInt(1, apiId);
                ps.setInt(2, applicationId);
            } else {
                ps = conn.prepareStatement(deleteQuery);
                ps.setInt(1, apiId);
                ps.setInt(2, applicationId);
            }
            ps.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback the add subscription ", (Throwable)e);
                    }
                }
                ApiMgtDAO.handleException("Failed to add subscriber data ", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriptionById(int subscription_id) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String sqlQuery = "DELETE FROM AM_SUBSCRIPTION WHERE SUBSCRIPTION_ID = ?";
            ps = conn.prepareStatement(sqlQuery);
            ps.setInt(1, subscription_id);
            ps.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback remove subscription ", (Throwable)e);
                    }
                }
                ApiMgtDAO.handleException("Failed to remove subscription data ", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSubscriptionStatusById(int subscriptionId) throws APIManagementException {
        String string;
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        String subscriptionStatus = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String getApiQuery = "SELECT SUB_STATUS FROM AM_SUBSCRIPTION WHERE SUBSCRIPTION_ID = ?";
            ps = conn.prepareStatement(getApiQuery);
            ps.setInt(1, subscriptionId);
            resultSet = ps.executeQuery();
            if (resultSet.next()) {
                subscriptionStatus = resultSet.getString("SUB_STATUS");
            }
            resultSet.close();
            ps.close();
            string = subscriptionStatus;
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Failed to retrieve subscription status", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
            return null;
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscriber getSubscriber(String subscriberName) throws APIManagementException {
        ResultSet result;
        PreparedStatement ps;
        Subscriber subscriber;
        Connection conn;
        block7: {
            int tenantId;
            conn = null;
            subscriber = null;
            ps = null;
            result = null;
            try {
                tenantId = IdentityUtil.getTenantIdOFUser((String)subscriberName);
            }
            catch (IdentityException e) {
                String msg = "Failed to get tenant id of user : " + subscriberName;
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            String sqlQuery = "SELECT    SUBSCRIBER_ID,    USER_ID,    TENANT_ID,    EMAIL_ADDRESS,    DATE_SUBSCRIBED FROM    AM_SUBSCRIBER WHERE    USER_ID = ?    AND TENANT_ID = ?";
            if (this.forceCaseInsensitiveComparisons) {
                sqlQuery = "SELECT    SUBSCRIBER_ID,    USER_ID,    TENANT_ID,    EMAIL_ADDRESS,    DATE_SUBSCRIBED FROM    AM_SUBSCRIBER WHERE    LOWER(USER_ID) = LOWER(?)    AND TENANT_ID = ?";
            }
            try {
                conn = APIMgtDBUtil.getConnection();
                ps = conn.prepareStatement(sqlQuery);
                ps.setString(1, subscriberName);
                ps.setInt(2, tenantId);
                result = ps.executeQuery();
                if (!result.next()) break block7;
                subscriber = new Subscriber(result.getString("EMAIL_ADDRESS"));
                subscriber.setEmail(result.getString("EMAIL_ADDRESS"));
                subscriber.setId(result.getInt("SUBSCRIBER_ID"));
                subscriber.setName(subscriberName);
                subscriber.setSubscribedDate((Date)result.getDate("DATE_SUBSCRIBED"));
                subscriber.setTenantId(result.getInt("TENANT_ID"));
            }
            catch (SQLException e) {
                try {
                    ApiMgtDAO.handleException("Failed to get Subscriber for :" + subscriberName, e);
                }
                catch (Throwable throwable) {
                    APIMgtDBUtil.closeAllConnections(ps, conn, result);
                    throw throwable;
                }
                APIMgtDBUtil.closeAllConnections(ps, conn, result);
            }
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, result);
        return subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<APIIdentifier> getAPIByConsumerKey(String accessToken) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        String getAPISql = "SELECT API.API_PROVIDER, API.API_NAME, API.API_VERSION FROM AM_SUBSCRIPTION SUB, AM_SUBSCRIPTION_KEY_MAPPING SKM,  AM_API API WHERE SKM.ACCESS_TOKEN=? AND SKM.SUBSCRIPTION_ID=SUB.SUBSCRIPTION_ID AND API.API_ID = SUB.API_ID";
        HashSet<APIIdentifier> apiList = new HashSet<APIIdentifier>();
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement nestedPS = connection.prepareStatement(getAPISql);
            String encryptedAccessToken = APIUtil.encryptToken(accessToken);
            nestedPS.setString(1, encryptedAccessToken);
            ResultSet nestedRS = nestedPS.executeQuery();
            while (nestedRS.next()) {
                apiList.add(new APIIdentifier(nestedRS.getString("API_PROVIDER"), nestedRS.getString("API_NAME"), nestedRS.getString("API_VERSION")));
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to get API ID for token: " + accessToken, e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Failed to get API ID for token: " + accessToken, e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return apiList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Set<SubscribedAPI> getSubscribedAPIs(Subscriber subscriber, String applicationName) throws APIManagementException {
        LinkedHashSet<SubscribedAPI> subscribedAPIs;
        block10: {
            ResultSet result;
            PreparedStatement ps;
            Connection connection;
            block9: {
                subscribedAPIs = new LinkedHashSet<SubscribedAPI>();
                connection = null;
                ps = null;
                result = null;
                connection = APIMgtDBUtil.getConnection();
                String sqlQuery = "SELECT    SUBS.SUBSCRIPTION_ID   ,API.API_PROVIDER AS API_PROVIDER   ,API.API_NAME AS API_NAME   ,API.API_VERSION AS API_VERSION   ,SUBS.TIER_ID AS TIER_ID   ,APP.APPLICATION_ID AS APP_ID   ,SUBS.LAST_ACCESSED AS LAST_ACCESSED   ,SUBS.SUB_STATUS AS SUB_STATUS   ,SUBS.SUBS_CREATE_STATE AS SUBS_CREATE_STATE   ,APP.NAME AS APP_NAME    ,APP.CALLBACK_URL AS CALLBACK_URL FROM    AM_SUBSCRIBER SUB,   AM_APPLICATION APP,    AM_SUBSCRIPTION SUBS,    AM_API API WHERE    SUB.USER_ID = ?    AND SUB.TENANT_ID = ?    AND SUB.SUBSCRIBER_ID=APP.SUBSCRIBER_ID    AND APP.APPLICATION_ID=SUBS.APPLICATION_ID    AND API.API_ID=SUBS.API_ID   AND APP.NAME= ?    AND SUBS.SUBS_CREATE_STATE = 'SUBSCRIBE'";
                if (this.forceCaseInsensitiveComparisons) {
                    sqlQuery = "SELECT    SUBS.SUBSCRIPTION_ID   ,API.API_PROVIDER AS API_PROVIDER   ,API.API_NAME AS API_NAME   ,API.API_VERSION AS API_VERSION   ,SUBS.TIER_ID AS TIER_ID   ,APP.APPLICATION_ID AS APP_ID   ,SUBS.LAST_ACCESSED AS LAST_ACCESSED   ,SUBS.SUB_STATUS AS SUB_STATUS   ,SUBS.SUBS_CREATE_STATE AS SUBS_CREATE_STATE   ,APP.NAME AS APP_NAME    ,APP.CALLBACK_URL AS CALLBACK_URL FROM    AM_SUBSCRIBER SUB,   AM_APPLICATION APP,    AM_SUBSCRIPTION SUBS,    AM_API API WHERE    LOWER(SUB.USER_ID) = LOWER(?)    AND SUB.TENANT_ID = ?    AND SUB.SUBSCRIBER_ID=APP.SUBSCRIBER_ID    AND APP.APPLICATION_ID=SUBS.APPLICATION_ID    AND API.API_ID=SUBS.API_ID   AND APP.NAME= ?    AND SUBS.SUBS_CREATE_STATE = 'SUBSCRIBE'";
                }
                ps = connection.prepareStatement(sqlQuery);
                ps.setString(1, subscriber.getName());
                int tenantId = IdentityUtil.getTenantIdOFUser((String)subscriber.getName());
                ps.setInt(2, tenantId);
                ps.setString(3, applicationName);
                result = ps.executeQuery();
                if (result != null) break block9;
                LinkedHashSet<SubscribedAPI> linkedHashSet = subscribedAPIs;
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                return linkedHashSet;
            }
            try {
                while (result.next()) {
                    APIIdentifier apiIdentifier = new APIIdentifier(APIUtil.replaceEmailDomain(result.getString("API_PROVIDER")), result.getString("API_NAME"), result.getString("API_VERSION"));
                    SubscribedAPI subscribedAPI = new SubscribedAPI(subscriber, apiIdentifier);
                    subscribedAPI.setSubStatus(result.getString("SUB_STATUS"));
                    subscribedAPI.setSubCreatedStatus(result.getString("SUBS_CREATE_STATE"));
                    subscribedAPI.setTier(new Tier(result.getString("TIER_ID")));
                    subscribedAPI.setLastAccessed((Date)result.getDate("LAST_ACCESSED"));
                    Application application = new Application(result.getString("APP_NAME"), subscriber);
                    subscribedAPI.setApplication(application);
                    subscribedAPIs.add(subscribedAPI);
                }
            }
            catch (SQLException e) {
                ApiMgtDAO.handleException("Failed to get SubscribedAPI of :" + subscriber.getName(), e);
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                break block10;
            }
            catch (IdentityException e2) {
                ApiMgtDAO.handleException("Failed get tenant id of user " + subscriber.getName(), e2);
                {
                    catch (Throwable throwable) {
                        APIMgtDBUtil.closeAllConnections(ps, connection, result);
                        throw throwable;
                    }
                }
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
            }
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return subscribedAPIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Set<SubscribedAPI> getSubscribedAPIs(Subscriber subscriber) throws APIManagementException {
        LinkedHashSet<SubscribedAPI> subscribedAPIs;
        block16: {
            ResultSet result;
            PreparedStatement ps;
            Connection connection;
            block15: {
                subscribedAPIs = new LinkedHashSet<SubscribedAPI>();
                connection = null;
                ps = null;
                result = null;
                String subscribedUserName = this.getLoginUserName(subscriber.getName());
                subscriber.setName(subscribedUserName);
                connection = APIMgtDBUtil.getConnection();
                String sqlQuery = "SELECT    SUBS.SUBSCRIPTION_ID   ,API.API_PROVIDER AS API_PROVIDER   ,API.API_NAME AS API_NAME   ,API.API_VERSION AS API_VERSION   ,SUBS.TIER_ID AS TIER_ID   ,APP.APPLICATION_ID AS APP_ID   ,SUBS.LAST_ACCESSED AS LAST_ACCESSED   ,SUBS.SUB_STATUS AS SUB_STATUS   ,SUBS.SUBS_CREATE_STATE AS SUBS_CREATE_STATE   ,APP.NAME AS APP_NAME    ,APP.CALLBACK_URL AS CALLBACK_URL FROM    AM_SUBSCRIBER SUB,   AM_APPLICATION APP,    AM_SUBSCRIPTION SUBS,    AM_API API WHERE    SUB.USER_ID = ?    AND SUB.TENANT_ID = ?    AND SUB.SUBSCRIBER_ID=APP.SUBSCRIBER_ID    AND APP.APPLICATION_ID=SUBS.APPLICATION_ID    AND API.API_ID=SUBS.API_ID   AND SUBS.SUBS_CREATE_STATE = 'SUBSCRIBE'";
                if (this.forceCaseInsensitiveComparisons) {
                    sqlQuery = "SELECT    SUBS.SUBSCRIPTION_ID   ,API.API_PROVIDER AS API_PROVIDER   ,API.API_NAME AS API_NAME   ,API.API_VERSION AS API_VERSION   ,SUBS.TIER_ID AS TIER_ID   ,APP.APPLICATION_ID AS APP_ID   ,SUBS.LAST_ACCESSED AS LAST_ACCESSED   ,SUBS.SUB_STATUS AS SUB_STATUS   ,SUBS.SUBS_CREATE_STATE AS SUBS_CREATE_STATE   ,APP.NAME AS APP_NAME    ,APP.CALLBACK_URL AS CALLBACK_URL FROM    AM_SUBSCRIBER SUB,   AM_APPLICATION APP,    AM_SUBSCRIPTION SUBS,    AM_API API WHERE    LOWER(SUB.USER_ID) = LOWER(?)    AND SUB.TENANT_ID = ?    AND SUB.SUBSCRIBER_ID=APP.SUBSCRIBER_ID    AND APP.APPLICATION_ID=SUBS.APPLICATION_ID    AND API.API_ID=SUBS.API_ID   AND SUBS.SUBS_CREATE_STATE = 'SUBSCRIBE'";
                }
                ps = connection.prepareStatement(sqlQuery);
                ps.setString(1, subscriber.getName());
                int tenantId = IdentityUtil.getTenantIdOFUser((String)subscriber.getName());
                ps.setInt(2, tenantId);
                result = ps.executeQuery();
                if (result != null) break block15;
                LinkedHashSet<SubscribedAPI> linkedHashSet = subscribedAPIs;
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                return linkedHashSet;
            }
            try {
                TreeMap<String, TreeSet<SubscribedAPI>> map = new TreeMap<String, TreeSet<SubscribedAPI>>();
                LRUCache<Integer, Application> applicationCache = new LRUCache<Integer, Application>(100);
                while (result.next()) {
                    APIIdentifier apiIdentifier = new APIIdentifier(APIUtil.replaceEmailDomain(result.getString("API_PROVIDER")), result.getString("API_NAME"), result.getString("API_VERSION"));
                    SubscribedAPI subscribedAPI = new SubscribedAPI(subscriber, apiIdentifier);
                    subscribedAPI.setSubStatus(result.getString("SUB_STATUS"));
                    subscribedAPI.setSubCreatedStatus(result.getString("SUBS_CREATE_STATE"));
                    String tierName = result.getString("TIER_ID");
                    subscribedAPI.setTier(new Tier(tierName));
                    subscribedAPI.setLastAccessed((Date)result.getDate("LAST_ACCESSED"));
                    int applicationId = result.getInt("APP_ID");
                    Application application = (Application)applicationCache.get(applicationId);
                    if (application == null) {
                        application = new Application(result.getString("APP_NAME"), subscriber);
                        application.setId(result.getInt("APP_ID"));
                        application.setCallbackUrl(result.getString("CALLBACK_URL"));
                        String tenantAwareUserId = subscriber.getName();
                        Set<APIKey> keys = this.getApplicationKeys(tenantAwareUserId, applicationId);
                        for (APIKey key : keys) {
                            application.addKey(key);
                        }
                        applicationCache.put(applicationId, application);
                    }
                    subscribedAPI.setApplication(application);
                    int subscriptionId = result.getInt("SUBSCRIPTION_ID");
                    Set<APIKey> apiKeys = this.getAPIKeysBySubscription(subscriptionId);
                    for (APIKey key : apiKeys) {
                        subscribedAPI.addKey(key);
                    }
                    if (!map.containsKey(application.getName())) {
                        map.put(application.getName(), new TreeSet<SubscribedAPI>(new Comparator<SubscribedAPI>(){

                            @Override
                            public int compare(SubscribedAPI o1, SubscribedAPI o2) {
                                int placement = o1.getApiId().getApiName().compareTo(o2.getApiId().getApiName());
                                if (placement == 0) {
                                    return new APIVersionComparator().compare(new API(o1.getApiId()), new API(o2.getApiId()));
                                }
                                return placement;
                            }
                        }));
                    }
                    ((Set)map.get(application.getName())).add(subscribedAPI);
                }
                for (String application : map.keySet()) {
                    Set apis = (Set)map.get(application);
                    for (SubscribedAPI api : apis) {
                        subscribedAPIs.add(api);
                    }
                }
            }
            catch (SQLException e) {
                ApiMgtDAO.handleException("Failed to get SubscribedAPI of :" + subscriber.getName(), e);
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                break block16;
            }
            catch (IdentityException e2) {
                ApiMgtDAO.handleException("Failed get tenant id of user " + subscriber.getName(), e2);
                {
                    catch (Throwable throwable) {
                        APIMgtDBUtil.closeAllConnections(ps, connection, result);
                        throw throwable;
                    }
                }
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
            }
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return subscribedAPIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<APIKey> getAPIKeysBySubscription(int subscriptionId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        String getKeysSql = "SELECT  SKM.ACCESS_TOKEN AS ACCESS_TOKEN, SKM.KEY_TYPE AS TOKEN_TYPE FROM AM_SUBSCRIPTION_KEY_MAPPING SKM WHERE SKM.SUBSCRIPTION_ID = ?";
        HashSet<APIKey> apiKeys = new HashSet<APIKey>();
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement nestedPS = connection.prepareStatement(getKeysSql);
            nestedPS.setInt(1, subscriptionId);
            ResultSet nestedRS = nestedPS.executeQuery();
            while (nestedRS.next()) {
                APIKey apiKey = new APIKey();
                String decryptedAccessToken = APIUtil.decryptToken(nestedRS.getString("ACCESS_TOKEN"));
                apiKey.setAccessToken(decryptedAccessToken);
                apiKey.setType(nestedRS.getString("TOKEN_TYPE"));
                apiKeys.add(apiKey);
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to get API keys for subscription: " + subscriptionId, e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Failed to get API keys for subscription: " + subscriptionId, e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return apiKeys;
    }

    public String getTokenScope(String consumerKey) throws APIManagementException {
        String tokenScope = null;
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            String[] keyStoreTables = APIUtil.getAvailableKeyStoreTables();
            if (keyStoreTables != null) {
                String keyStoreTable;
                String[] arr$ = keyStoreTables;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (tokenScope = this.getTokenScope(consumerKey, this.getScopeSql(keyStoreTable = arr$[i$]))) == null; ++i$) {
                }
            }
        } else {
            tokenScope = this.getTokenScope(consumerKey, this.getScopeSql(null));
        }
        return tokenScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTokenScope(String consumerKey, String getScopeSql) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        String tokenScope = null;
        try {
            consumerKey = APIUtil.encryptToken(consumerKey);
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement nestedPS = connection.prepareStatement(getScopeSql);
            nestedPS.setString(1, consumerKey);
            ResultSet nestedRS = nestedPS.executeQuery();
            if (nestedRS.next()) {
                tokenScope = nestedRS.getString("TOKEN_SCOPE");
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to get token scope from consumer key: " + consumerKey, e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Error while encrypting consumer key", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return tokenScope;
    }

    private String getScopeSql(String accessTokenStoreTable) {
        String tokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (accessTokenStoreTable != null) {
            tokenStoreTable = accessTokenStoreTable;
        }
        return "SELECT IAT.TOKEN_SCOPE AS TOKEN_SCOPE FROM " + tokenStoreTable + " IAT," + " IDN_OAUTH_CONSUMER_APPS ICA " + "WHERE" + " IAT.CONSUMER_KEY = ?" + " AND IAT.CONSUMER_KEY = ICA.CONSUMER_KEY" + " AND IAT.AUTHZ_USER = ICA.USERNAME";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isAccessTokenExists(String accessToken) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromAccessToken(accessToken);
        }
        String getTokenSql = "SELECT ACCESS_TOKEN FROM " + accessTokenStoreTable + " WHERE ACCESS_TOKEN= ? ";
        Boolean tokenExists = false;
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement getToken = connection.prepareStatement(getTokenSql);
            String encryptedAccessToken = APIUtil.encryptToken(accessToken);
            getToken.setString(1, encryptedAccessToken);
            ResultSet getTokenRS = getToken.executeQuery();
            while (getTokenRS.next()) {
                tokenExists = true;
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to check availability of the access token. ", e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Failed to check availability of the access token. ", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return tokenExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isAccessTokenRevoked(String accessToken) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromAccessToken(accessToken);
        }
        String getTokenSql = "SELECT TOKEN_STATE FROM " + accessTokenStoreTable + " WHERE ACCESS_TOKEN= ? ";
        Boolean tokenExists = false;
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement getToken = connection.prepareStatement(getTokenSql);
            String encryptedAccessToken = APIUtil.encryptToken(accessToken);
            getToken.setString(1, encryptedAccessToken);
            ResultSet getTokenRS = getToken.executeQuery();
            while (getTokenRS.next()) {
                if (getTokenRS.getString("TOKEN_STATE").equals("REVOKED")) continue;
                tokenExists = true;
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to check availability of the access token. ", e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Failed to check availability of the access token. ", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return tokenExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIKey getAccessTokenData(String accessToken) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        APIKey apiKey = new APIKey();
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromAccessToken(accessToken);
        }
        String getTokenSql = "SELECT ACCESS_TOKEN,AUTHZ_USER,TOKEN_SCOPE,CONSUMER_KEY,TIME_CREATED,VALIDITY_PERIOD FROM " + accessTokenStoreTable + " WHERE ACCESS_TOKEN= ? AND TOKEN_STATE='ACTIVE' ";
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement getToken = connection.prepareStatement(getTokenSql);
            getToken.setString(1, APIUtil.encryptToken(accessToken));
            ResultSet getTokenRS = getToken.executeQuery();
            while (getTokenRS.next()) {
                String decryptedAccessToken = APIUtil.decryptToken(getTokenRS.getString("ACCESS_TOKEN"));
                apiKey.setAccessToken(decryptedAccessToken);
                apiKey.setAuthUser(getTokenRS.getString("AUTHZ_USER"));
                apiKey.setTokenScope(getTokenRS.getString("TOKEN_SCOPE"));
                apiKey.setCreatedDate(getTokenRS.getTimestamp("TIME_CREATED").toString().split("\\.")[0]);
                String consumerKey = getTokenRS.getString("CONSUMER_KEY");
                apiKey.setConsumerKey(APIUtil.decryptToken(consumerKey));
                apiKey.setValidityPeriod(getTokenRS.getLong("VALIDITY_PERIOD"));
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to get the access token data. ", e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Failed to get the access token data. ", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return apiKey;
    }

    public Map<Integer, APIKey> getAccessTokens(String query) throws APIManagementException {
        HashMap<Integer, APIKey> tokenDataMap = new HashMap();
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            String[] keyStoreTables = APIUtil.getAvailableKeyStoreTables();
            if (keyStoreTables != null) {
                for (String keyStoreTable : keyStoreTables) {
                    Map<Integer, APIKey> tokenDataMapTmp = this.getAccessTokens(query, this.getTokenSql(keyStoreTable));
                    tokenDataMap.putAll(tokenDataMapTmp);
                }
            }
        } else {
            tokenDataMap = this.getAccessTokens(query, this.getTokenSql(null));
        }
        return tokenDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, APIKey> getAccessTokens(String query, String getTokenSql) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        HashMap<Integer, APIKey> tokenDataMap = new HashMap<Integer, APIKey>();
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement getToken = connection.prepareStatement(getTokenSql);
            ResultSet getTokenRS = getToken.executeQuery();
            while (getTokenRS.next()) {
                String accessToken = APIUtil.decryptToken(getTokenRS.getString("ACCESS_TOKEN"));
                String regex = "(?i)[a-zA-Z0-9_.-|]*" + query.trim() + "(?i)[a-zA-Z0-9_.-|]*";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(accessToken);
                Integer i = 0;
                if (!matcher.matches()) continue;
                APIKey apiKey = new APIKey();
                apiKey.setAccessToken(accessToken);
                apiKey.setAuthUser(getTokenRS.getString("AUTHZ_USER"));
                apiKey.setTokenScope(getTokenRS.getString("TOKEN_SCOPE"));
                apiKey.setCreatedDate(getTokenRS.getTimestamp("TIME_CREATED").toString().split("\\.")[0]);
                String consumerKey = getTokenRS.getString("CONSUMER_KEY");
                apiKey.setConsumerKey(APIUtil.decryptToken(consumerKey));
                apiKey.setValidityPeriod(getTokenRS.getLong("VALIDITY_PERIOD"));
                tokenDataMap.put(i, apiKey);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to get access token data. ", e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Failed to get access token data. ", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return tokenDataMap;
    }

    private String getTokenSql(String accessTokenStoreTable) {
        String tokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (accessTokenStoreTable != null) {
            tokenStoreTable = accessTokenStoreTable;
        }
        return "SELECT ACCESS_TOKEN,AUTHZ_USER,TOKEN_SCOPE,CONSUMER_KEY,TIME_CREATED,VALIDITY_PERIOD FROM " + tokenStoreTable + " WHERE TOKEN_STATE='ACTIVE' ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, APIKey> getAccessTokensByUser(String user, String loggedInUser) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        HashMap<Integer, APIKey> tokenDataMap = new HashMap<Integer, APIKey>();
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromUserId(user);
        }
        String getTokenSql = "SELECT ACCESS_TOKEN,AUTHZ_USER,TOKEN_SCOPE,CONSUMER_KEY,TIME_CREATED,VALIDITY_PERIOD FROM " + accessTokenStoreTable + " WHERE AUTHZ_USER= ? AND TOKEN_STATE='ACTIVE' ";
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement getToken = connection.prepareStatement(getTokenSql);
            getToken.setString(1, user);
            ResultSet getTokenRS = getToken.executeQuery();
            Integer i = 0;
            while (getTokenRS.next()) {
                String authorizedUser = getTokenRS.getString("AUTHZ_USER");
                if (!APIUtil.isLoggedInUserAuthorizedToRevokeToken(loggedInUser, authorizedUser)) continue;
                String accessToken = APIUtil.decryptToken(getTokenRS.getString("ACCESS_TOKEN"));
                APIKey apiKey = new APIKey();
                apiKey.setAccessToken(accessToken);
                apiKey.setAuthUser(authorizedUser);
                apiKey.setTokenScope(getTokenRS.getString("TOKEN_SCOPE"));
                apiKey.setCreatedDate(getTokenRS.getTimestamp("TIME_CREATED").toString().split("\\.")[0]);
                String consumerKey = getTokenRS.getString("CONSUMER_KEY");
                apiKey.setConsumerKey(APIUtil.decryptToken(consumerKey));
                apiKey.setValidityPeriod(getTokenRS.getLong("VALIDITY_PERIOD"));
                tokenDataMap.put(i, apiKey);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to get access token data. ", e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Failed to get access token data. ", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return tokenDataMap;
    }

    public Map<Integer, APIKey> getAccessTokensByDate(String date, boolean latest, String loggedInUser) throws APIManagementException {
        Map<Integer, APIKey> tokenDataMap = new HashMap<Integer, APIKey>();
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            String[] keyStoreTables = APIUtil.getAvailableKeyStoreTables();
            if (keyStoreTables != null) {
                for (String keyStoreTable : keyStoreTables) {
                    Map<Integer, APIKey> tokenDataMapTmp = this.getAccessTokensByDate(date, latest, this.getTokenByDateSqls(keyStoreTable), loggedInUser);
                    tokenDataMap.putAll(tokenDataMapTmp);
                }
            }
        } else {
            tokenDataMap = this.getAccessTokensByDate(date, latest, this.getTokenByDateSqls(null), loggedInUser);
        }
        return tokenDataMap;
    }

    /*
     * Exception decompiling
     */
    public Map<Integer, APIKey> getAccessTokensByDate(String date, boolean latest, String[] querySql, String loggedInUser) throws APIManagementException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[] getTokenByDateSqls(String accessTokenStoreTable) {
        String[] querySqlArr = new String[2];
        String tokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (accessTokenStoreTable != null) {
            tokenStoreTable = accessTokenStoreTable;
        }
        querySqlArr[0] = "SELECT ACCESS_TOKEN,AUTHZ_USER,TOKEN_SCOPE,CONSUMER_KEY,TIME_CREATED,VALIDITY_PERIOD FROM " + tokenStoreTable + " WHERE TOKEN_STATE='ACTIVE' AND TIME_CREATED >= ? ";
        querySqlArr[1] = "SELECT ACCESS_TOKEN,AUTHZ_USER,TOKEN_SCOPE,CONSUMER_KEY,TIME_CREATED,VALIDITY_PERIOD FROM " + tokenStoreTable + " WHERE TOKEN_STATE='ACTIVE' AND TIME_CREATED <= ? ";
        return querySqlArr;
    }

    private Set<APIKey> getApplicationKeys(String username, int applicationId) throws APIManagementException {
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromUserId(username);
        }
        HashSet<APIKey> apiKeys = new HashSet<APIKey>();
        try {
            APIKey productionKey = this.getProductionKeyOfApplication(username, applicationId, accessTokenStoreTable);
            if (productionKey != null) {
                apiKeys.add(productionKey);
            } else {
                productionKey = this.getKeyStatusOfApplication("PRODUCTION", applicationId);
                if (productionKey != null) {
                    productionKey.setType("PRODUCTION");
                    apiKeys.add(productionKey);
                }
            }
            APIKey sandboxKey = this.getSandboxKeyOfApplication(username, applicationId, accessTokenStoreTable);
            if (sandboxKey != null) {
                apiKeys.add(sandboxKey);
            } else {
                sandboxKey = this.getKeyStatusOfApplication("SANDBOX", applicationId);
                if (sandboxKey != null) {
                    sandboxKey.setType("SANDBOX");
                    apiKeys.add(sandboxKey);
                }
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to get keys for application: " + applicationId, e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Failed to get keys for application: " + applicationId, e);
        }
        return apiKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIKey getKeyStatusOfApplication(String keyType, int applicationId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        APIKey key = null;
        String sqlQuery = "SELECT STATE FROM AM_APPLICATION_KEY_MAPPING WHERE APPLICATION_ID = ? AND KEY_TYPE = ?";
        try {
            connection = APIMgtDBUtil.getConnection();
            preparedStatement = connection.prepareStatement(sqlQuery);
            preparedStatement.setInt(1, applicationId);
            preparedStatement.setString(2, keyType);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                key = new APIKey();
                key.setState(resultSet.getString("STATE"));
            }
            APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error occurred while getting the State of Access Token", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIKey getProductionKeyOfApplication(String userName, int applicationId, String accessTokenStoreTable) throws SQLException, CryptoException, APIManagementException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block3: {
            APIKey aPIKey;
            connection = null;
            preparedStatement = null;
            resultSet = null;
            String statement = " ICA.CONSUMER_KEY AS CONSUMER_KEY, ICA.CONSUMER_SECRET AS CONSUMER_SECRET, IAT.ACCESS_TOKEN AS ACCESS_TOKEN, IAT.VALIDITY_PERIOD AS VALIDITY_PERIOD, AKM.KEY_TYPE AS TOKEN_TYPE,  AKM.STATE AS STATE FROM AM_APPLICATION_KEY_MAPPING AKM," + accessTokenStoreTable + " IAT," + " IDN_OAUTH_CONSUMER_APPS ICA " + "WHERE" + " AKM.APPLICATION_ID = ? AND" + " ICA.USERNAME = ? AND" + " IAT.USER_TYPE = ? AND" + " ICA.CONSUMER_KEY = AKM.CONSUMER_KEY AND" + " IAT.CONSUMER_KEY = ICA.CONSUMER_KEY AND" + " AKM.KEY_TYPE = 'PRODUCTION' AND" + " ICA.USERNAME = IAT.AUTHZ_USER AND" + " (IAT.TOKEN_STATE = 'ACTIVE' OR" + " IAT.TOKEN_STATE = 'EXPIRED' OR" + " IAT.TOKEN_STATE = 'REVOKED')" + " ORDER BY IAT.TIME_CREATED DESC";
            String sql = null;
            String oracleSQL = null;
            String mySQLSQL = null;
            String msSQL = null;
            String postgreSQL = null;
            oracleSQL = "SELECT ICA.CONSUMER_KEY AS CONSUMER_KEY, ICA.CONSUMER_SECRET AS CONSUMER_SECRET, IAT.ACCESS_TOKEN AS ACCESS_TOKEN, IAT.VALIDITY_PERIOD AS VALIDITY_PERIOD, AKM.KEY_TYPE AS TOKEN_TYPE,  AKM.STATE AS STATE  FROM AM_APPLICATION_KEY_MAPPING AKM, " + accessTokenStoreTable + " IAT," + " IDN_OAUTH_CONSUMER_APPS ICA " + " WHERE" + " AKM.APPLICATION_ID = ? AND" + " ICA.USERNAME = ? AND" + " IAT.USER_TYPE = ? AND" + " ICA.CONSUMER_KEY = AKM.CONSUMER_KEY AND" + " IAT.CONSUMER_KEY = ICA.CONSUMER_KEY AND" + " AKM.KEY_TYPE = 'PRODUCTION' AND" + " ICA.USERNAME = IAT.AUTHZ_USER AND" + " (IAT.TOKEN_STATE = 'ACTIVE' OR" + " IAT.TOKEN_STATE = 'EXPIRED' OR" + " IAT.TOKEN_STATE = 'REVOKED')" + " AND ROWNUM < 2 " + " ORDER BY IAT.TIME_CREATED DESC";
            mySQLSQL = "SELECT" + statement + " LIMIT 1";
            msSQL = "SELECT TOP 1" + statement;
            postgreSQL = "SELECT * FROM (SELECT" + statement + ") AS TOKEN LIMIT 1";
            try {
                connection = APIMgtDBUtil.getConnection();
                sql = connection.getMetaData().getDriverName().contains("MySQL") || connection.getMetaData().getDriverName().contains("H2") ? mySQLSQL : (connection.getMetaData().getDriverName().contains("MS SQL") ? msSQL : (connection.getMetaData().getDriverName().contains("Microsoft") ? msSQL : (connection.getMetaData().getDriverName().contains("PostgreSQL") ? postgreSQL : oracleSQL)));
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setInt(1, applicationId);
                preparedStatement.setString(2, userName.toLowerCase());
                preparedStatement.setString(3, "APPLICATION");
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                APIKey apiKey = new APIKey();
                String accessToken = APIUtil.decryptToken(resultSet.getString("ACCESS_TOKEN"));
                String consumerKey = resultSet.getString("CONSUMER_KEY");
                apiKey.setConsumerKey(APIUtil.decryptToken(consumerKey));
                String consumerSecret = resultSet.getString("CONSUMER_SECRET");
                apiKey.setConsumerSecret(APIUtil.decryptToken(consumerSecret));
                apiKey.setAccessToken(accessToken);
                String authorizedDomains = ApiMgtDAO.getAuthorizedDomains(accessToken);
                apiKey.setType(resultSet.getString("TOKEN_TYPE"));
                apiKey.setAuthorizedDomains(authorizedDomains);
                apiKey.setValidityPeriod(resultSet.getLong("VALIDITY_PERIOD"));
                apiKey.setState(resultSet.getString("STATE"));
                aPIKey = apiKey;
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
            return aPIKey;
        }
        APIKey aPIKey = null;
        APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
        return aPIKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIKey getSandboxKeyOfApplication(String userName, int applicationId, String accessTokenStoreTable) throws SQLException, CryptoException, APIManagementException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block3: {
            APIKey aPIKey;
            connection = null;
            preparedStatement = null;
            resultSet = null;
            String statement = " ICA.CONSUMER_KEY AS CONSUMER_KEY, ICA.CONSUMER_SECRET AS CONSUMER_SECRET, IAT.ACCESS_TOKEN AS ACCESS_TOKEN, IAT.VALIDITY_PERIOD AS VALIDITY_PERIOD, AKM.KEY_TYPE AS TOKEN_TYPE FROM AM_APPLICATION_KEY_MAPPING AKM," + accessTokenStoreTable + " IAT," + " IDN_OAUTH_CONSUMER_APPS ICA " + "WHERE" + " AKM.APPLICATION_ID = ? AND" + " ICA.USERNAME = ? AND" + " IAT.USER_TYPE = ? AND" + " ICA.CONSUMER_KEY = AKM.CONSUMER_KEY AND" + " IAT.CONSUMER_KEY = ICA.CONSUMER_KEY AND" + " AKM.KEY_TYPE = 'SANDBOX' AND" + " ICA.USERNAME = IAT.AUTHZ_USER AND" + " (IAT.TOKEN_STATE = 'ACTIVE' OR" + " IAT.TOKEN_STATE = 'EXPIRED' OR" + " IAT.TOKEN_STATE = 'REVOKED')" + " ORDER BY IAT.TIME_CREATED DESC";
            String sql = null;
            String oracleSQL = null;
            String mySQLSQL = null;
            String msSQL = null;
            String postgreSQL = null;
            oracleSQL = "SELECT ICA.CONSUMER_KEY AS CONSUMER_KEY, ICA.CONSUMER_SECRET AS CONSUMER_SECRET, IAT.ACCESS_TOKEN AS ACCESS_TOKEN, IAT.VALIDITY_PERIOD AS VALIDITY_PERIOD, AKM.KEY_TYPE AS TOKEN_TYPE FROM AM_APPLICATION_KEY_MAPPING AKM," + accessTokenStoreTable + " IAT," + " IDN_OAUTH_CONSUMER_APPS ICA " + "WHERE" + " AKM.APPLICATION_ID = ? AND" + " ICA.USERNAME = ? AND" + " IAT.USER_TYPE = ? AND" + " ICA.CONSUMER_KEY = AKM.CONSUMER_KEY AND" + " IAT.CONSUMER_KEY = ICA.CONSUMER_KEY AND" + " AKM.KEY_TYPE = 'SANDBOX' AND" + " ICA.USERNAME = IAT.AUTHZ_USER AND" + " (IAT.TOKEN_STATE = 'ACTIVE' OR" + " IAT.TOKEN_STATE = 'EXPIRED' OR" + " IAT.TOKEN_STATE = 'REVOKED')" + " AND ROWNUM < 2 " + " ORDER BY IAT.TIME_CREATED DESC ";
            mySQLSQL = "SELECT" + statement + " LIMIT 1";
            msSQL = "SELECT TOP 1" + statement;
            postgreSQL = "SELECT * FROM (SELECT" + statement + ") AS TOKEN LIMIT 1";
            try {
                connection = APIMgtDBUtil.getConnection();
                sql = connection.getMetaData().getDriverName().contains("MySQL") || connection.getMetaData().getDriverName().contains("H2") ? mySQLSQL : (connection.getMetaData().getDriverName().contains("MS SQL") ? msSQL : (connection.getMetaData().getDriverName().contains("Microsoft") ? msSQL : (connection.getMetaData().getDriverName().contains("PostgreSQL") ? postgreSQL : oracleSQL)));
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setInt(1, applicationId);
                preparedStatement.setString(2, userName.toLowerCase());
                preparedStatement.setString(3, "APPLICATION");
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                APIKey apiKey = new APIKey();
                String accessToken = APIUtil.decryptToken(resultSet.getString("ACCESS_TOKEN"));
                String consumerKey = resultSet.getString("CONSUMER_KEY");
                apiKey.setConsumerKey(APIUtil.decryptToken(consumerKey));
                String consumerSecret = resultSet.getString("CONSUMER_SECRET");
                apiKey.setConsumerSecret(APIUtil.decryptToken(consumerSecret));
                apiKey.setAccessToken(accessToken);
                String authorizedDomains = ApiMgtDAO.getAuthorizedDomains(accessToken);
                apiKey.setType(resultSet.getString("TOKEN_TYPE"));
                apiKey.setAuthorizedDomains(authorizedDomains);
                apiKey.setValidityPeriod(resultSet.getLong("VALIDITY_PERIOD"));
                aPIKey = apiKey;
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
            return aPIKey;
        }
        APIKey aPIKey = null;
        APIMgtDBUtil.closeAllConnections(preparedStatement, connection, resultSet);
        return aPIKey;
    }

    public Set<String> getApplicationKeys(int applicationId) throws APIManagementException {
        Set<Object> apiKeys = new HashSet();
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            String[] keyStoreTables = APIUtil.getAvailableKeyStoreTables();
            if (keyStoreTables != null) {
                String keyStoreTable;
                String[] arr$ = keyStoreTables;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (apiKeys = this.getApplicationKeys(applicationId, this.getKeysSql(keyStoreTable = arr$[i$]))) == null; ++i$) {
                }
            }
        } else {
            apiKeys = this.getApplicationKeys(applicationId, this.getKeysSql(null));
        }
        return apiKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTierPermissions(String tierName, String permissionType, String roles, int tenantId) throws APIManagementException {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        int tierPermissionId = -1;
        try {
            conn = APIMgtDBUtil.getConnection();
            String getTierPermissionQuery = "SELECT TIER_PERMISSIONS_ID FROM AM_TIER_PERMISSIONS WHERE TIER = ? AND TENANT_ID = ?";
            ps = conn.prepareStatement(getTierPermissionQuery);
            ps.setString(1, tierName);
            ps.setInt(2, tenantId);
            resultSet = ps.executeQuery();
            if (resultSet.next()) {
                tierPermissionId = resultSet.getInt("TIER_PERMISSIONS_ID");
            }
            resultSet.close();
            ps.close();
            if (tierPermissionId == -1) {
                String query = "INSERT INTO AM_TIER_PERMISSIONS (TIER, PERMISSIONS_TYPE, ROLES, TENANT_ID) VALUES(?, ?, ?, ?)";
                ps = conn.prepareStatement(query);
                ps.setString(1, tierName);
                ps.setString(2, permissionType);
                ps.setString(3, roles);
                ps.setInt(4, tenantId);
                ps.execute();
            } else {
                String query = "UPDATE AM_TIER_PERMISSIONS SET TIER = ?, PERMISSIONS_TYPE = ?, ROLES = ? WHERE TIER_PERMISSIONS_ID = ? AND TENANT_ID = ?";
                ps = conn.prepareStatement(query);
                ps.setString(1, tierName);
                ps.setString(2, permissionType);
                ps.setString(3, roles);
                ps.setInt(4, tierPermissionId);
                ps.setInt(5, tenantId);
                ps.executeUpdate();
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error in updating tier permissions: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TierPermissionDTO> getTierPermissions(int tenantId) throws APIManagementException {
        Connection conn = null;
        Object rs = null;
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        HashSet<TierPermissionDTO> tierPermissions = new HashSet<TierPermissionDTO>();
        try {
            conn = APIMgtDBUtil.getConnection();
            String getTierPermissionQuery = "SELECT TIER , PERMISSIONS_TYPE , ROLES  FROM AM_TIER_PERMISSIONS WHERE TENANT_ID = ?";
            ps = conn.prepareStatement(getTierPermissionQuery);
            ps.setInt(1, tenantId);
            resultSet = ps.executeQuery();
            while (resultSet.next()) {
                TierPermissionDTO tierPermission = new TierPermissionDTO();
                tierPermission.setTierName(resultSet.getString("TIER"));
                tierPermission.setPermissionType(resultSet.getString("PERMISSIONS_TYPE"));
                String roles = resultSet.getString("ROLES");
                if (roles != null && !roles.equals("")) {
                    String[] roleList = roles.split(",");
                    tierPermission.setRoles(roleList);
                }
                tierPermissions.add(tierPermission);
            }
            resultSet.close();
            ps.close();
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Failed to get Tier permission information ", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        return tierPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TierPermissionDTO getTierPermission(String tierName, int tenantId) throws APIManagementException {
        Connection conn = null;
        Object rs = null;
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        TierPermissionDTO tierPermission = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String getTierPermissionQuery = "SELECT PERMISSIONS_TYPE , ROLES  FROM AM_TIER_PERMISSIONS WHERE TIER = ? AND TENANT_ID = ?";
            ps = conn.prepareStatement(getTierPermissionQuery);
            ps.setString(1, tierName);
            ps.setInt(2, tenantId);
            resultSet = ps.executeQuery();
            while (resultSet.next()) {
                tierPermission = new TierPermissionDTO();
                tierPermission.setTierName(tierName);
                tierPermission.setPermissionType(resultSet.getString("PERMISSIONS_TYPE"));
                String roles = resultSet.getString("ROLES");
                if (roles == null) continue;
                String[] roleList = roles.split(",");
                tierPermission.setRoles(roleList);
            }
            resultSet.close();
            ps.close();
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Failed to get Tier permission information for Tier " + tierName, e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        return tierPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getApplicationKeys(int applicationId, String getKeysSql) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        HashSet<String> apiKeys = new HashSet<String>();
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement nestedPS = connection.prepareStatement(getKeysSql);
            nestedPS.setInt(1, applicationId);
            ResultSet nestedRS = nestedPS.executeQuery();
            while (nestedRS.next()) {
                apiKeys.add(APIUtil.decryptToken(nestedRS.getString("ACCESS_TOKEN")));
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to get keys for application: " + applicationId, e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Failed to get keys for application: " + applicationId, e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return apiKeys;
    }

    private String getKeysSql(String accessTokenStoreTable) {
        String tokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (accessTokenStoreTable != null) {
            tokenStoreTable = accessTokenStoreTable;
        }
        return "SELECT  ICA.CONSUMER_KEY AS CONSUMER_KEY, ICA.CONSUMER_SECRET AS CONSUMER_SECRET, IAT.ACCESS_TOKEN AS ACCESS_TOKEN, AKM.KEY_TYPE AS TOKEN_TYPE FROM AM_APPLICATION_KEY_MAPPING AKM," + tokenStoreTable + " IAT," + " IDN_OAUTH_CONSUMER_APPS ICA " + "WHERE" + " AKM.APPLICATION_ID = ? AND" + " ICA.CONSUMER_KEY = AKM.CONSUMER_KEY AND" + " ICA.CONSUMER_KEY = IAT.CONSUMER_KEY";
    }

    public Map<String, String> getAccessTokenData(int subscriptionId) throws APIManagementException {
        Map<Object, Object> apiKeys = new HashMap();
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            String[] keyStoreTables = APIUtil.getAvailableKeyStoreTables();
            if (keyStoreTables != null) {
                String keyStoreTable;
                String[] arr$ = keyStoreTables;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (apiKeys = this.getAccessTokenData(subscriptionId, this.getKeysSqlUsingSubscriptionId(keyStoreTable = arr$[i$]))) == null; ++i$) {
                }
            }
        } else {
            apiKeys = this.getAccessTokenData(subscriptionId, this.getKeysSqlUsingSubscriptionId(null));
        }
        return apiKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getAccessTokenData(int subscriptionId, String getKeysSql) throws APIManagementException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        HashMap<String, String> apiKeys = new HashMap<String, String>();
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement nestedPS = connection.prepareStatement(getKeysSql);
            nestedPS.setInt(1, subscriptionId);
            ResultSet nestedRS = nestedPS.executeQuery();
            while (nestedRS.next()) {
                apiKeys.put("token", APIUtil.decryptToken(nestedRS.getString("ACCESS_TOKEN")));
                apiKeys.put("status", nestedRS.getString("TOKEN_STATE"));
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to get keys for application: " + subscriptionId, e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Failed to get keys for application: " + subscriptionId, e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return apiKeys;
    }

    private String getKeysSqlUsingSubscriptionId(String accessTokenStoreTable) {
        String tokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (accessTokenStoreTable != null) {
            tokenStoreTable = accessTokenStoreTable;
        }
        return "SELECT  IAT.ACCESS_TOKEN AS ACCESS_TOKEN, IAT.TOKEN_STATE AS TOKEN_STATE FROM AM_APPLICATION_KEY_MAPPING AKM, AM_SUBSCRIPTION SM," + tokenStoreTable + " IAT," + " IDN_OAUTH_CONSUMER_APPS ICA " + "WHERE" + " SM.SUBSCRIPTION_ID = ? AND" + " SM.APPLICATION_ID= AKM.APPLICATION_ID AND" + " ICA.CONSUMER_KEY = AKM.CONSUMER_KEY AND" + " ICA.CONSUMER_KEY = IAT.CONSUMER_KEY";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Subscriber> getSubscribersOfProvider(String providerName) throws APIManagementException {
        HashSet<Subscriber> subscribers = new HashSet<Subscriber>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            connection = APIMgtDBUtil.getConnection();
            String sqlQuery = "SELECT    SUBS.USER_ID AS USER_ID,   SUBS.EMAIL_ADDRESS AS EMAIL_ADDRESS,    SUBS.DATE_SUBSCRIBED AS DATE_SUBSCRIBED FROM    AM_SUBSCRIBER  SUBS,   AM_APPLICATION  APP,    AM_SUBSCRIPTION SUB,    AM_API API WHERE     SUB.APPLICATION_ID = APP.APPLICATION_ID    AND SUBS. SUBSCRIBER_ID = APP.SUBSCRIBER_ID    AND API.API_ID = SUB.API_ID    AND API.API_PROVIDER = ? AND SUB.SUBS_CREATE_STATE = 'SUBSCRIBE'";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, APIUtil.replaceEmailDomainBack(providerName));
            result = ps.executeQuery();
            while (result.next()) {
                Subscriber subscriber = new Subscriber(result.getString("EMAIL_ADDRESS"));
                subscriber.setName(result.getString("USER_ID"));
                subscriber.setSubscribedDate((Date)result.getDate("DATE_SUBSCRIBED"));
                subscribers.add(subscriber);
            }
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Failed to subscribers for :" + providerName, e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        APIMgtDBUtil.closeAllConnections(ps, connection, result);
        return subscribers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Subscriber> getSubscribersOfAPI(APIIdentifier identifier) throws APIManagementException {
        ResultSet result;
        PreparedStatement ps;
        Connection connection;
        HashSet<Subscriber> subscribers;
        block6: {
            subscribers = new HashSet<Subscriber>();
            connection = null;
            ps = null;
            result = null;
            connection = APIMgtDBUtil.getConnection();
            String sqlQuery = "SELECT DISTINCT SB.USER_ID, SB.DATE_SUBSCRIBED FROM AM_SUBSCRIBER SB, AM_SUBSCRIPTION SP,AM_APPLICATION APP,AM_API API WHERE API.API_PROVIDER=? AND API.API_NAME=? AND API.API_VERSION=? AND SP.APPLICATION_ID=APP.APPLICATION_ID AND APP.SUBSCRIBER_ID=SB.SUBSCRIBER_ID  AND API.API_ID = SP.API_ID AND SP.SUBS_CREATE_STATE = 'SUBSCRIBE'";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, APIUtil.replaceEmailDomainBack(identifier.getProviderName()));
            ps.setString(2, identifier.getApiName());
            ps.setString(3, identifier.getVersion());
            result = ps.executeQuery();
            if (result != null) break block6;
            HashSet<Subscriber> hashSet = subscribers;
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
            return hashSet;
        }
        try {
            while (result.next()) {
                Subscriber subscriber = new Subscriber(result.getString("USER_ID"));
                subscriber.setSubscribedDate((Date)result.getTimestamp("DATE_SUBSCRIBED"));
                subscribers.add(subscriber);
            }
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Failed to get subscribers for :" + identifier.getApiName(), e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        APIMgtDBUtil.closeAllConnections(ps, connection, result);
        return subscribers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAPISubscriptionCountByAPI(APIIdentifier identifier) throws APIManagementException {
        String sqlQuery = "SELECT COUNT(SUB.SUBSCRIPTION_ID) AS SUB_ID FROM AM_SUBSCRIPTION SUB, AM_API API  WHERE API.API_PROVIDER=?  AND API.API_NAME=? AND API.API_VERSION=? AND API.API_ID=SUB.API_ID AND SUB.SUBS_CREATE_STATE = 'SUBSCRIBE'";
        long subscriptions = 0L;
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            connection = APIMgtDBUtil.getConnection();
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, APIUtil.replaceEmailDomainBack(identifier.getProviderName()));
            ps.setString(2, identifier.getApiName());
            ps.setString(3, identifier.getVersion());
            result = ps.executeQuery();
            if (result == null) {
                long l = subscriptions;
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                return l;
            }
            while (result.next()) {
                subscriptions = result.getLong("SUB_ID");
            }
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to get subscription count for API", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return subscriptions;
    }

    public void updateSubscriptions(APIIdentifier identifier, String context, int applicationId) throws APIManagementException {
        this.addSubscription(identifier, context, applicationId, "UNBLOCKED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSubscription(APIIdentifier identifier, String subStatus, int applicationId) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        int apiId = -1;
        try {
            conn = APIMgtDBUtil.getConnection();
            String getApiQuery = "SELECT API_ID FROM AM_API API WHERE API_PROVIDER = ? AND API_NAME = ? AND API_VERSION = ?";
            ps = conn.prepareStatement(getApiQuery);
            ps.setString(1, APIUtil.replaceEmailDomainBack(identifier.getProviderName()));
            ps.setString(2, identifier.getApiName());
            ps.setString(3, identifier.getVersion());
            resultSet = ps.executeQuery();
            if (resultSet.next()) {
                apiId = resultSet.getInt("API_ID");
            }
            resultSet.close();
            ps.close();
            if (apiId == -1) {
                String msg = "Unable to get the API ID for: " + identifier;
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            String sqlQuery = "UPDATE AM_SUBSCRIPTION SET SUB_STATUS = ? WHERE API_ID = ? AND APPLICATION_ID = ?";
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, subStatus);
            ps.setInt(2, apiId);
            ps.setInt(3, applicationId);
            ps.execute();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback the add subscription ", (Throwable)e);
                    }
                }
                ApiMgtDAO.handleException("Failed to update subscription data ", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSubscriptionStatus(int subscriptionId, String status) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String sqlQuery = "UPDATE AM_SUBSCRIPTION SET SUB_STATUS = ? WHERE SUBSCRIPTION_ID = ?";
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, status);
            ps.setInt(2, subscriptionId);
            ps.execute();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback subscription status update ", (Throwable)e);
                    }
                }
                ApiMgtDAO.handleException("Failed to update subscription status ", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateRefreshedApplicationAccessToken(String keyType, String newAccessToken, long validityPeriod) throws IdentityException, APIManagementException {
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromAccessToken(newAccessToken);
        }
        String sqlUpdateNewAccessToken = "UPDATE " + accessTokenStoreTable + " SET USER_TYPE=?, VALIDITY_PERIOD=? " + " WHERE ACCESS_TOKEN=? AND TOKEN_SCOPE=? ";
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            connection = APIMgtDBUtil.getConnection();
            connection.setAutoCommit(false);
            prepStmt = connection.prepareStatement(sqlUpdateNewAccessToken);
            prepStmt.setString(1, "APPLICATION");
            if (validityPeriod < 0L) {
                prepStmt.setLong(2, Long.MAX_VALUE);
            } else {
                prepStmt.setLong(2, validityPeriod * 1000L);
            }
            prepStmt.setString(3, APIUtil.encryptToken(newAccessToken));
            prepStmt.setString(4, keyType);
            prepStmt.execute();
            prepStmt.close();
            connection.commit();
        }
        catch (SQLException e) {
            block13: {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (connection == null) break block13;
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the add access token ", (Throwable)e);
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
        catch (CryptoException e2) {
            block14: {
                log.error((Object)e2.getMessage(), (Throwable)e2);
                if (connection == null) break block14;
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the add access token ", (Throwable)e2);
                }
                {
                    catch (Throwable throwable) {
                        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                        throw throwable;
                    }
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateAccessAllowDomains(String accessToken, String[] accessAllowDomains) throws APIManagementException {
        String consumerKey = ApiMgtDAO.findConsumerKeyFromAccessToken(accessToken);
        String sqlDeleteAccessAllowDomains = "DELETE  FROM AM_APP_KEY_DOMAIN_MAPPING  WHERE CONSUMER_KEY=?";
        String sqlAddAccessAllowDomains = "INSERT INTO AM_APP_KEY_DOMAIN_MAPPING (CONSUMER_KEY, AUTHZ_DOMAIN)  VALUES (?,?)";
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            consumerKey = APIUtil.encryptToken(consumerKey);
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlDeleteAccessAllowDomains);
            prepStmt.setString(1, consumerKey);
            prepStmt.execute();
            prepStmt.close();
            if (accessAllowDomains != null && !accessAllowDomains[0].trim().equals("")) {
                for (int i = 0; i < accessAllowDomains.length; ++i) {
                    prepStmt = connection.prepareStatement(sqlAddAccessAllowDomains);
                    prepStmt.setString(1, consumerKey);
                    prepStmt.setString(2, accessAllowDomains[i].trim());
                    prepStmt.execute();
                    prepStmt.close();
                }
            } else {
                prepStmt = connection.prepareStatement(sqlAddAccessAllowDomains);
                prepStmt.setString(1, consumerKey);
                prepStmt.setString(2, "ALL");
                prepStmt.execute();
                prepStmt.close();
            }
            connection.commit();
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to update the access allow domains.", e);
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
        }
        catch (CryptoException e2) {
            ApiMgtDAO.handleException("Error while encrypting consumer-key", e2);
            {
                catch (Throwable throwable) {
                    APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
                    throw throwable;
                }
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String registerAccessToken(String consumerKey, String applicationName, String userId, int tenantId, APIInfoDTO apiInfoDTO, String keyType) throws IdentityException, APIManagementException {
        String loginUserName = this.getLoginUserName(userId);
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        String accessToken = OAuthUtil.getRandomNumber();
        if (APIUtil.checkUserNameAssertionEnabled()) {
            String accessTokenStrToEncode = accessToken + ":" + loginUserName;
            accessToken = Base64Utils.encode((byte[])accessTokenStrToEncode.getBytes());
            if (APIUtil.checkAccessTokenPartitioningEnabled()) {
                accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromUserId(loginUserName);
            }
        }
        String sqlAddAccessToken = "INSERT INTO " + accessTokenStoreTable + "(ACCESS_TOKEN, CONSUMER_KEY, TOKEN_STATE, TOKEN_SCOPE) " + " VALUES (?,?,?,?)";
        String getSubscriptionId = "SELECT SUBS.SUBSCRIPTION_ID FROM   AM_SUBSCRIPTION SUBS,   AM_APPLICATION APP,   AM_SUBSCRIBER SUB,   AM_API API WHERE   SUB.USER_ID = ?  AND SUB.TENANT_ID = ?  AND APP.SUBSCRIBER_ID = SUB.SUBSCRIBER_ID  AND APP.NAME = ?  AND API.API_PROVIDER = ?  AND API.API_NAME = ?  AND API.API_VERSION = ?  AND APP.APPLICATION_ID = SUBS.APPLICATION_ID  AND API.API_ID = SUBS.API_ID";
        if (this.forceCaseInsensitiveComparisons) {
            getSubscriptionId = "SELECT SUBS.SUBSCRIPTION_ID FROM   AM_SUBSCRIPTION SUBS,   AM_APPLICATION APP,   AM_SUBSCRIBER SUB,   AM_API API WHERE   LOWER(SUB.USER_ID) = LOWER(?)  AND SUB.TENANT_ID = ?  AND APP.SUBSCRIBER_ID = SUB.SUBSCRIBER_ID  AND APP.NAME = ?  AND API.API_PROVIDER = ?  AND API.API_NAME = ?  AND API.API_VERSION = ?  AND APP.APPLICATION_ID = SUBS.APPLICATION_ID  AND API.API_ID = SUBS.API_ID";
        }
        String addSubscriptionKeyMapping = "INSERT INTO AM_SUBSCRIPTION_KEY_MAPPING (SUBSCRIPTION_ID, ACCESS_TOKEN, KEY_TYPE) VALUES (?,?,?)";
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            consumerKey = APIUtil.encryptToken(consumerKey);
            connection = APIMgtDBUtil.getConnection();
            String encryptedAccessToken = APIUtil.encryptToken(accessToken);
            prepStmt = connection.prepareStatement(sqlAddAccessToken);
            prepStmt.setString(1, encryptedAccessToken);
            prepStmt.setString(2, consumerKey);
            prepStmt.setString(3, "ACTIVE");
            prepStmt.setString(4, "default");
            prepStmt.execute();
            prepStmt.close();
            int subscriptionId = -1;
            prepStmt = connection.prepareStatement(getSubscriptionId);
            prepStmt.setString(1, loginUserName);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, applicationName);
            prepStmt.setString(4, APIUtil.replaceEmailDomainBack(apiInfoDTO.getProviderId()));
            prepStmt.setString(5, apiInfoDTO.getApiName());
            prepStmt.setString(6, apiInfoDTO.getVersion());
            ResultSet getSubscriptionIdResult = prepStmt.executeQuery();
            while (getSubscriptionIdResult.next()) {
                subscriptionId = getSubscriptionIdResult.getInt(1);
            }
            prepStmt.close();
            prepStmt = connection.prepareStatement(addSubscriptionKeyMapping);
            prepStmt.setInt(1, subscriptionId);
            prepStmt.setString(2, encryptedAccessToken);
            prepStmt.setString(3, keyType);
            prepStmt.execute();
            prepStmt.close();
            connection.commit();
        }
        catch (SQLException e) {
            block14: {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (connection == null) break block14;
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the add access token ", (Throwable)e);
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
        catch (CryptoException e2) {
            block15: {
                log.error((Object)e2.getMessage(), (Throwable)e2);
                if (connection == null) break block15;
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the add access token ", (Throwable)e2);
                }
                {
                    catch (Throwable throwable) {
                        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                        throw throwable;
                    }
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRegistrationApprovalState(int appId, String keyType) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        String state = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String sqlQuery = "SELECT STATE FROM AM_APPLICATION_KEY_MAPPING WHERE APPLICATION_ID = ? AND KEY_TYPE =?";
            ps = conn.prepareStatement(sqlQuery);
            ps.setInt(1, appId);
            ps.setString(2, keyType);
            resultSet = ps.executeQuery();
            while (resultSet.next()) {
                state = resultSet.getString("STATE");
            }
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error while getting Application Registration State.", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String registerApplicationAccessToken(String consumerKey, int appId, String applicationName, String userId, String keyType, String[] accessAllowDomains, String validityTime) throws IdentityException, APIManagementException {
        String loginUserName = this.getLoginUserName(userId);
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        String accessToken = OAuthUtil.getRandomNumber();
        String refreshToken = OAuthUtil.getRandomNumber();
        if (APIUtil.checkUserNameAssertionEnabled()) {
            String accessTokenStrToEncode = accessToken + ":" + loginUserName;
            accessToken = Base64Utils.encode((byte[])accessTokenStrToEncode.getBytes());
            String refreshTokenStrToEncode = refreshToken + ":" + loginUserName;
            refreshToken = Base64Utils.encode((byte[])refreshTokenStrToEncode.getBytes());
            if (APIUtil.checkAccessTokenPartitioningEnabled()) {
                accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromUserId(loginUserName);
            }
        }
        String sqlAddAccessToken = "INSERT INTO " + accessTokenStoreTable + " (ACCESS_TOKEN, REFRESH_TOKEN, CONSUMER_KEY, TOKEN_STATE, TOKEN_SCOPE," + " AUTHZ_USER, USER_TYPE, TIME_CREATED, VALIDITY_PERIOD)  VALUES (?,?,?,?,?,?,?,?,?)";
        String addApplicationKeyMapping = "UPDATE AM_APPLICATION_KEY_MAPPING SET CONSUMER_KEY = ?, STATE =? WHERE APPLICATION_ID = ? AND KEY_TYPE = ?";
        String sqlAddAccessAllowDomains = "INSERT INTO AM_APP_KEY_DOMAIN_MAPPING (CONSUMER_KEY, AUTHZ_DOMAIN)  VALUES (?,?)";
        Connection connection = null;
        PreparedStatement prepStmt = null;
        long validityPeriod = this.getApplicationAccessTokenValidityPeriod();
        if (validityTime != null && !"".equals(validityTime)) {
            validityPeriod = (long)Double.parseDouble(validityTime);
        }
        try {
            consumerKey = APIUtil.encryptToken(consumerKey);
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlAddAccessToken);
            prepStmt.setString(1, APIUtil.encryptToken(accessToken));
            prepStmt.setString(2, APIUtil.encryptToken(refreshToken));
            prepStmt.setString(3, consumerKey);
            prepStmt.setString(4, "ACTIVE");
            prepStmt.setString(5, "default");
            prepStmt.setString(6, loginUserName.toLowerCase());
            prepStmt.setString(7, "APPLICATION");
            prepStmt.setTimestamp(8, new Timestamp(System.currentTimeMillis()), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            if (validityPeriod < 0L) {
                prepStmt.setLong(9, Long.MAX_VALUE);
            } else {
                prepStmt.setLong(9, validityPeriod * 1000L);
            }
            prepStmt.execute();
            prepStmt.close();
            prepStmt = connection.prepareStatement(addApplicationKeyMapping);
            prepStmt.setString(1, consumerKey);
            prepStmt.setString(2, "COMPLETED");
            prepStmt.setInt(3, appId);
            prepStmt.setString(4, keyType);
            prepStmt.execute();
            prepStmt.close();
            if (accessAllowDomains != null && !accessAllowDomains[0].trim().equals("")) {
                for (int i = 0; i < accessAllowDomains.length; ++i) {
                    prepStmt = connection.prepareStatement(sqlAddAccessAllowDomains);
                    prepStmt.setString(1, consumerKey);
                    prepStmt.setString(2, accessAllowDomains[i].trim());
                    prepStmt.execute();
                    prepStmt.close();
                }
            } else {
                prepStmt = connection.prepareStatement(sqlAddAccessAllowDomains);
                prepStmt.setString(1, consumerKey);
                prepStmt.setString(2, "ALL");
                prepStmt.execute();
                prepStmt.close();
            }
            connection.commit();
        }
        catch (SQLException e) {
            block18: {
                ApiMgtDAO.handleException("Error while generating the application access token for the application :" + applicationName, e);
                if (connection == null) break block18;
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the add access token ", (Throwable)e);
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
        catch (CryptoException e2) {
            block19: {
                log.error((Object)e2.getMessage(), (Throwable)e2);
                if (connection == null) break block19;
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the add access token ", (Throwable)e2);
                }
                {
                    catch (Throwable throwable) {
                        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                        throw throwable;
                    }
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApplicationRegistration(String state, String keyType, int appId) throws APIManagementException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sqlStmt = "UPDATE AM_APPLICATION_KEY_MAPPING SET STATE = ? WHERE APPLICATION_ID = ? AND KEY_TYPE = ?";
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(sqlStmt);
            ps.setString(1, state);
            ps.setInt(2, appId);
            ps.setString(3, keyType);
            ps.execute();
            ps.close();
            conn.commit();
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while updating registration entry.", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed(APIIdentifier apiIdentifier, String userId) throws APIManagementException {
        boolean isSubscribed = false;
        String loginUserName = this.getLoginUserName(userId);
        String apiId = apiIdentifier.getProviderName() + "_" + apiIdentifier.getApiName() + "_" + apiIdentifier.getVersion();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sqlQuery = "SELECT    SUBS.TIER_ID ,   API.API_PROVIDER ,   API.API_NAME ,   API.API_VERSION ,   SUBS.LAST_ACCESSED ,   SUBS.APPLICATION_ID FROM    AM_SUBSCRIPTION SUBS,   AM_SUBSCRIBER SUB,    AM_APPLICATION  APP,    AM_API API WHERE    API.API_PROVIDER  = ?   AND API.API_NAME = ?   AND API.API_VERSION = ?   AND SUB.USER_ID = ?   AND SUB.TENANT_ID = ?    AND APP.SUBSCRIBER_ID = SUB.SUBSCRIBER_ID   AND API.API_ID = SUBS.API_ID   AND SUBS.SUBS_CREATE_STATE = 'SUBSCRIBE'";
        if (this.forceCaseInsensitiveComparisons) {
            sqlQuery = "SELECT    SUBS.TIER_ID ,   API.API_PROVIDER ,   API.API_NAME ,   API.API_VERSION ,   SUBS.LAST_ACCESSED ,   SUBS.APPLICATION_ID FROM    AM_SUBSCRIPTION SUBS,   AM_SUBSCRIBER SUB,    AM_APPLICATION  APP,    AM_API API WHERE    API.API_PROVIDER  = ?   AND API.API_NAME = ?   AND API.API_VERSION = ?   AND LOWER(SUB.USER_ID) = LOWER(?)   AND SUB.TENANT_ID = ?    AND APP.SUBSCRIBER_ID = SUB.SUBSCRIBER_ID   AND API.API_ID = SUBS.API_ID   AND SUBS.SUBS_CREATE_STATE = 'SUBSCRIBE'";
        }
        try {
            int tenantId;
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, APIUtil.replaceEmailDomainBack(apiIdentifier.getProviderName()));
            ps.setString(2, apiIdentifier.getApiName());
            ps.setString(3, apiIdentifier.getVersion());
            ps.setString(4, loginUserName);
            try {
                tenantId = IdentityUtil.getTenantIdOFUser((String)loginUserName);
            }
            catch (IdentityException e) {
                String msg = "Failed to get tenant id of user : " + loginUserName;
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            ps.setInt(5, tenantId);
            rs = ps.executeQuery();
            if (rs.next()) {
                isSubscribed = true;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while checking if user has subscribed to the API ", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        return isSubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserApplicationAPIUsage[] getAllAPIUsageByProvider(String providerName) throws APIManagementException {
        UserApplicationAPIUsage[] userApplicationAPIUsageArray;
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            connection = APIMgtDBUtil.getConnection();
            String sqlQuery = "SELECT    SUBS.SUBSCRIPTION_ID AS SUBSCRIPTION_ID,    SUBS.APPLICATION_ID AS APPLICATION_ID,    SUBS.SUB_STATUS AS SUB_STATUS,    SUBS.TIER_ID AS TIER_ID,    API.API_PROVIDER AS API_PROVIDER,    API.API_NAME AS API_NAME,    API.API_VERSION AS API_VERSION,    SUBS.LAST_ACCESSED AS LAST_ACCESSED,    SUB.USER_ID AS USER_ID,    APP.NAME AS APPNAME FROM    AM_SUBSCRIPTION SUBS,    AM_APPLICATION APP,    AM_SUBSCRIBER SUB,    AM_API API WHERE    SUBS.APPLICATION_ID = APP.APPLICATION_ID    AND APP.SUBSCRIBER_ID = SUB.SUBSCRIBER_ID    AND API.API_PROVIDER = ?    AND API.API_ID = SUBS.API_ID    AND SUBS.SUBS_CREATE_STATE = 'SUBSCRIBE'ORDER BY    APP.NAME";
            ps = connection.prepareStatement(sqlQuery);
            ps.setString(1, APIUtil.replaceEmailDomainBack(providerName));
            result = ps.executeQuery();
            TreeMap<String, UserApplicationAPIUsage> userApplicationUsages = new TreeMap<String, UserApplicationAPIUsage>();
            while (result.next()) {
                int subId = result.getInt("SUBSCRIPTION_ID");
                Map<String, String> keyData = this.getAccessTokenData(subId);
                String accessToken = keyData.get("token");
                String tokenStatus = keyData.get("status");
                String userId = result.getString("USER_ID");
                String application = result.getString("APPNAME");
                int appId = result.getInt("APPLICATION_ID");
                String subStatus = result.getString("SUB_STATUS");
                String key = userId + "::" + application;
                UserApplicationAPIUsage usage = (UserApplicationAPIUsage)userApplicationUsages.get(key);
                if (usage == null) {
                    usage = new UserApplicationAPIUsage();
                    usage.setUserId(userId);
                    usage.setApplicationName(application);
                    usage.setAppId(appId);
                    usage.setAccessToken(accessToken);
                    usage.setAccessTokenStatus(tokenStatus);
                    userApplicationUsages.put(key, usage);
                }
                APIIdentifier apiId = new APIIdentifier(result.getString("API_PROVIDER"), result.getString("API_NAME"), result.getString("API_VERSION"));
                SubscribedAPI apiSubscription = new SubscribedAPI(new Subscriber(userId), apiId);
                apiSubscription.setSubStatus(subStatus);
                usage.addApiSubscriptions(apiSubscription);
            }
            userApplicationAPIUsageArray = userApplicationUsages.values().toArray(new UserApplicationAPIUsage[userApplicationUsages.size()]);
        }
        catch (SQLException e) {
            UserApplicationAPIUsage[] userApplicationAPIUsageArray2;
            try {
                ApiMgtDAO.handleException("Failed to find API Usage for :" + providerName, e);
                userApplicationAPIUsageArray2 = null;
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
            return userApplicationAPIUsageArray2;
        }
        APIMgtDBUtil.closeAllConnections(ps, connection, result);
        return userApplicationAPIUsageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Subscriber getSubscriberById(String accessToken) throws APIManagementException {
        Subscriber subscriber;
        block8: {
            Connection connection = null;
            PreparedStatement ps = null;
            ResultSet result = null;
            subscriber = null;
            String query = " SELECT SB.USER_ID, SB.DATE_SUBSCRIBED FROM AM_SUBSCRIBER SB , AM_SUBSCRIPTION SP, AM_APPLICATION APP, AM_SUBSCRIPTION_KEY_MAPPING SKM WHERE SKM.ACCESS_TOKEN=? AND SP.APPLICATION_ID=APP.APPLICATION_ID AND APP.SUBSCRIBER_ID=SB.SUBSCRIBER_ID AND SP.SUBSCRIPTION_ID=SKM.SUBSCRIPTION_ID";
            try {
                connection = APIMgtDBUtil.getConnection();
                ps = connection.prepareStatement(query);
                ps.setString(1, APIUtil.encryptToken(accessToken));
                result = ps.executeQuery();
                while (result.next()) {
                    subscriber = new Subscriber(result.getString("USER_ID"));
                    subscriber.setSubscribedDate((Date)result.getDate("DATE_SUBSCRIBED"));
                }
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
            }
            catch (SQLException e) {
                ApiMgtDAO.handleException("Failed to get Subscriber for accessToken", e);
            }
            catch (CryptoException e2) {
                ApiMgtDAO.handleException("Failed to get Subscriber for accessToken", e2);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                APIMgtDBUtil.closeAllConnections(ps, connection, result);
            }
        }
        return subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] getOAuthCredentials(String accessToken, String tokenType) throws APIManagementException {
        String consumerSecret;
        String consumerKey;
        block9: {
            String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
            if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
                accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromAccessToken(accessToken);
            }
            Connection connection = null;
            PreparedStatement prepStmt = null;
            ResultSet rs = null;
            consumerKey = null;
            consumerSecret = null;
            String sqlStmt = "SELECT  ICA.CONSUMER_KEY AS CONSUMER_KEY, ICA.CONSUMER_SECRET AS CONSUMER_SECRET FROM  IDN_OAUTH_CONSUMER_APPS ICA," + accessTokenStoreTable + " IAT" + " WHERE " + " IAT.ACCESS_TOKEN = ? AND" + " IAT.TOKEN_SCOPE = ? AND" + " IAT.CONSUMER_KEY = ICA.CONSUMER_KEY";
            try {
                connection = APIMgtDBUtil.getConnection();
                prepStmt = connection.prepareStatement(sqlStmt);
                prepStmt.setString(1, APIUtil.encryptToken(accessToken));
                prepStmt.setString(2, tokenType);
                rs = prepStmt.executeQuery();
                if (rs.next()) {
                    consumerKey = rs.getString("CONSUMER_KEY");
                    consumerSecret = rs.getString("CONSUMER_SECRET");
                    consumerKey = APIUtil.decryptToken(consumerKey);
                    consumerSecret = APIUtil.decryptToken(consumerSecret);
                }
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
            }
            catch (SQLException e) {
                ApiMgtDAO.handleException("Error when adding a new OAuth consumer.", e);
            }
            catch (CryptoException e2) {
                ApiMgtDAO.handleException("Error while encrypting/decrypting tokens/app credentials.", e2);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)prepStmt);
            }
        }
        return new String[]{consumerKey, consumerSecret};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] addOAuthConsumer(String username, int tenantId, String appName, String callbackUrl) throws IdentityOAuthAdminException, APIManagementException {
        Boolean isReuseAppName = Boolean.valueOf(ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getFirstProperty("APIStore.ReuseAppName"));
        Connection connection = null;
        PreparedStatement prepStmt = null;
        String loginUserName = this.getLoginUserName(username);
        ResultSet rs = null;
        String consumerKey = null;
        String consumerSecret = null;
        String sqlCheckStmt = "SELECT    ICA.CONSUMER_KEY AS CONSUMER_KEY,   ICA.CONSUMER_SECRET AS CONSUMER_SECRET FROM    AM_SUBSCRIBER SB,   AM_APPLICATION APP,    AM_APPLICATION_KEY_MAPPING AKM,   IDN_OAUTH_CONSUMER_APPS ICA WHERE    SB.USER_ID=?    AND SB.TENANT_ID=?    AND APP.NAME=?    AND SB.SUBSCRIBER_ID = APP.SUBSCRIBER_ID    AND AKM.APPLICATION_ID = APP.APPLICATION_ID   AND ICA.USERNAME = SB.USER_ID   AND ICA.TENANT_ID = SB.TENANT_ID   AND ICA.APP_NAME = APP.NAME";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlCheckStmt);
            prepStmt.setString(1, loginUserName.toLowerCase());
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, appName);
            rs = prepStmt.executeQuery();
            if (isReuseAppName.booleanValue() && rs.next()) {
                consumerKey = rs.getString("CONSUMER_KEY");
                consumerSecret = rs.getString("CONSUMER_SECRET");
            } else {
                String sqlStmt = "INSERT INTO IDN_OAUTH_CONSUMER_APPS (CONSUMER_KEY, CONSUMER_SECRET, USERNAME, TENANT_ID, OAUTH_VERSION, APP_NAME, CALLBACK_URL) VALUES (?,?,?,?,?,?, ?) ";
                consumerSecret = OAuthUtil.getRandomNumber();
                while (this.isDuplicateConsumer(consumerKey = OAuthUtil.getRandomNumber())) {
                }
                consumerKey = APIUtil.encryptToken(consumerKey);
                consumerSecret = APIUtil.encryptToken(consumerSecret);
                prepStmt = connection.prepareStatement(sqlStmt);
                prepStmt.setString(1, consumerKey);
                prepStmt.setString(2, consumerSecret);
                prepStmt.setString(3, loginUserName.toLowerCase());
                prepStmt.setInt(4, tenantId);
                prepStmt.setString(5, "OAuth-2.0");
                prepStmt.setString(6, appName);
                prepStmt.setString(7, callbackUrl);
                prepStmt.execute();
            }
            connection.commit();
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error when adding a new OAuth consumer.", e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Error while attempting to encrypt consumer-key, consumer-secret.", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
        }
        try {
            return new String[]{APIUtil.decryptToken(consumerKey), APIUtil.decryptToken(consumerSecret)};
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Error while decrypting consumer-key, consumer-secret", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOAuthConsumerApp(String appName, String callbackUrl) throws IdentityOAuthAdminException, APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        String sqlStmt = "UPDATE IDN_OAUTH_CONSUMER_APPS SET CALLBACK_URL = ? WHERE APP_NAME = ?";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlStmt);
            prepStmt.setString(1, callbackUrl);
            prepStmt.setString(2, appName);
            prepStmt.execute();
            connection.commit();
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error when updating OAuth consumer App for " + appName, e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isDuplicateConsumer(String consumerKey) throws APIManagementException {
        boolean isDuplicateConsumer;
        ResultSet rSet;
        PreparedStatement prepStmt;
        Connection connection;
        block6: {
            connection = null;
            prepStmt = null;
            rSet = null;
            String sqlQuery = "SELECT * FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?";
            isDuplicateConsumer = false;
            try {
                consumerKey = APIUtil.encryptToken(consumerKey);
                connection = APIMgtDBUtil.getConnection();
                prepStmt = connection.prepareStatement(sqlQuery);
                prepStmt.setString(1, consumerKey);
                rSet = prepStmt.executeQuery();
                if (!rSet.next()) break block6;
                isDuplicateConsumer = true;
            }
            catch (SQLException e) {
                ApiMgtDAO.handleException("Error when reading the application information from the persistence store.", e);
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rSet);
            }
            catch (CryptoException e2) {
                ApiMgtDAO.handleException("Error while encrypting consumer-key", e2);
                {
                    catch (Throwable throwable) {
                        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rSet);
                        throw throwable;
                    }
                }
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rSet);
            }
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rSet);
        return isDuplicateConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addApplication(Application application, String userId) throws APIManagementException {
        Connection conn = null;
        int applicationId = 0;
        String loginUserName = this.getLoginUserName(userId);
        try {
            conn = APIMgtDBUtil.getConnection();
            applicationId = this.addApplication(application, loginUserName, conn);
            conn.commit();
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the add Application ", (Throwable)e);
                }
            }
            ApiMgtDAO.handleException("Failed to add Application", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(null, conn, null);
        }
        return applicationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRating(APIIdentifier apiId, int rating, String user) throws APIManagementException {
        Connection conn = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            this.addRating(apiId, rating, user, conn);
            conn.commit();
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the add Application ", (Throwable)e);
                }
            }
            ApiMgtDAO.handleException("Failed to add Application", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(null, conn, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRating(APIIdentifier apiIdentifier, int rating, String userId, Connection conn) throws APIManagementException, SQLException {
        PreparedStatement ps = null;
        PreparedStatement psSelect = null;
        try {
            int tenantId;
            try {
                tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
            }
            catch (IdentityException e) {
                String msg = "Failed to get tenant id of user : " + userId;
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            Subscriber subscriber = this.getSubscriber(userId, tenantId, conn);
            if (subscriber == null) {
                String msg = "Could not load Subscriber records for: " + userId;
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            int apiId = -1;
            apiId = ApiMgtDAO.getAPIID(apiIdentifier, conn);
            if (apiId == -1) {
                String msg = "Could not load API record for: " + apiIdentifier.getApiName();
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            ResultSet rs = null;
            boolean userRatingExists = false;
            String sqlQuery = "SELECT RATING FROM AM_API_RATINGS  WHERE API_ID= ? AND SUBSCRIBER_ID=? ";
            psSelect = conn.prepareStatement(sqlQuery);
            psSelect.setInt(1, apiId);
            psSelect.setInt(2, subscriber.getId());
            rs = psSelect.executeQuery();
            while (rs.next()) {
                userRatingExists = true;
            }
            psSelect.close();
            String sqlAddQuery = !userRatingExists ? "INSERT INTO AM_API_RATINGS (RATING,API_ID, SUBSCRIBER_ID) VALUES (?,?,?)" : "UPDATE AM_API_RATINGS SET RATING=? WHERE API_ID= ? AND SUBSCRIBER_ID=?";
            ps = conn.prepareStatement(sqlAddQuery);
            ps.setInt(1, rating);
            ps.setInt(2, apiId);
            ps.setInt(3, subscriber.getId());
            ps.executeUpdate();
            ps.close();
            APIMgtDBUtil.closeAllConnections(ps, null, null);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to add API rating of the user:" + userId, e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAPIRating(APIIdentifier apiId, String user) throws APIManagementException {
        Connection conn = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            this.removeAPIRating(apiId, user, conn);
            conn.commit();
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the add Application ", (Throwable)e);
                }
            }
            ApiMgtDAO.handleException("Failed to add Application", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(null, conn, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAPIRating(APIIdentifier apiIdentifier, String userId, Connection conn) throws APIManagementException, SQLException {
        PreparedStatement ps = null;
        PreparedStatement psSelect = null;
        try {
            int tenantId;
            int rateId = -1;
            try {
                tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
            }
            catch (IdentityException e) {
                String msg = "Failed to get tenant id of user : " + userId;
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            Subscriber subscriber = this.getSubscriber(userId, tenantId, conn);
            if (subscriber == null) {
                String msg = "Could not load Subscriber records for: " + userId;
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            int apiId = -1;
            apiId = ApiMgtDAO.getAPIID(apiIdentifier, conn);
            if (apiId == -1) {
                String msg = "Could not load API record for: " + apiIdentifier.getApiName();
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            String sqlQuery = "SELECT RATING_ID FROM AM_API_RATINGS  WHERE API_ID= ? AND SUBSCRIBER_ID=? ";
            psSelect = conn.prepareStatement(sqlQuery);
            psSelect.setInt(1, apiId);
            psSelect.setInt(2, subscriber.getId());
            ResultSet rs = psSelect.executeQuery();
            while (rs.next()) {
                rateId = rs.getInt("RATING_ID");
            }
            psSelect.close();
            if (rateId != -1) {
                String sqlAddQuery = "DELETE FROM AM_API_RATINGS WHERE RATING_ID =? ";
                ps = conn.prepareStatement(sqlAddQuery);
                ps.setInt(1, rateId);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to delete API rating", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUserRating(APIIdentifier apiId, String user) throws APIManagementException {
        Connection conn = null;
        int userRating = 0;
        try {
            conn = APIMgtDBUtil.getConnection();
            userRating = this.getUserRating(apiId, user, conn);
            conn.commit();
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback getting user ratings ", (Throwable)e);
                }
            }
            ApiMgtDAO.handleException("Failed to get user ratings", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(null, conn, null);
        }
        return userRating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUserRating(APIIdentifier apiIdentifier, String userId, Connection conn) throws APIManagementException, SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        int userRating = 0;
        try {
            int tenantId;
            try {
                tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
            }
            catch (IdentityException e) {
                String msg = "Failed to get tenant id of user : " + userId;
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            Subscriber subscriber = this.getSubscriber(userId, tenantId, conn);
            if (subscriber == null) {
                String msg = "Could not load Subscriber records for: " + userId;
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            int apiId = -1;
            apiId = ApiMgtDAO.getAPIID(apiIdentifier, conn);
            if (apiId == -1) {
                String msg = "Could not load API record for: " + apiIdentifier.getApiName();
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            String sqlQuery = "SELECT RATING FROM AM_API_RATINGS  WHERE SUBSCRIBER_ID  = ? AND API_ID= ? ";
            ps = conn.prepareStatement(sqlQuery);
            ps.setInt(1, subscriber.getId());
            ps.setInt(2, apiId);
            rs = ps.executeQuery();
            while (rs.next()) {
                userRating = rs.getInt("RATING");
            }
            ps.close();
            APIMgtDBUtil.closeAllConnections(ps, null, null);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to add Application", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, null, null);
        }
        return userRating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getAverageRating(APIIdentifier apiId) throws APIManagementException {
        Connection conn = null;
        float avrRating = 0.0f;
        try {
            conn = APIMgtDBUtil.getConnection();
            avrRating = ApiMgtDAO.getAverageRating(apiId, conn);
            conn.commit();
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback getting user ratings ", (Throwable)e);
                }
            }
            ApiMgtDAO.handleException("Failed to get user ratings", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(null, conn, null);
        }
        return avrRating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getAverageRating(APIIdentifier apiIdentifier, Connection conn) throws APIManagementException, SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        float avrRating = 0.0f;
        try {
            int apiId = -1;
            apiId = ApiMgtDAO.getAPIID(apiIdentifier, conn);
            if (apiId == -1) {
                String msg = "Could not load API record for: " + apiIdentifier.getApiName();
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            String sqlQuery = "SELECT CAST( SUM(RATING) AS DECIMAL)/COUNT(RATING) AS RATING  FROM AM_API_RATINGS WHERE API_ID =? GROUP BY API_ID ";
            ps = conn.prepareStatement(sqlQuery);
            ps.setInt(1, apiId);
            rs = ps.executeQuery();
            while (rs.next()) {
                avrRating = rs.getFloat("RATING");
            }
            ps.close();
            APIMgtDBUtil.closeAllConnections(ps, null, null);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to add Application", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, null, null);
        }
        BigDecimal decimal = new BigDecimal(avrRating);
        return Float.valueOf(decimal.setScale(1, 0).toString()).floatValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addApplication(Application application, String userId, Connection conn) throws APIManagementException, SQLException {
        PreparedStatement ps = null;
        int applicationId = 0;
        try {
            int tenantId;
            try {
                tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
            }
            catch (IdentityException e) {
                String msg = "Failed to get tenant id of user : " + userId;
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            Subscriber subscriber = this.getSubscriber(userId, tenantId, conn);
            if (subscriber == null) {
                String msg = "Could not load Subscriber records for: " + userId;
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            String sqlQuery = "INSERT INTO AM_APPLICATION (NAME, SUBSCRIBER_ID, APPLICATION_TIER, CALLBACK_URL, DESCRIPTION, APPLICATION_STATUS) VALUES (?,?,?,?,?,?)";
            ps = conn.prepareStatement(sqlQuery, new String[]{"APPLICATION_ID"});
            if (conn.getMetaData().getDriverName().contains("PostgreSQL")) {
                ps = conn.prepareStatement(sqlQuery, new String[]{"application_id"});
            }
            ps.setString(1, application.getName());
            ps.setInt(2, subscriber.getId());
            ps.setString(3, application.getTier());
            ps.setString(4, application.getCallbackUrl());
            ps.setString(5, application.getDescription());
            if (application.getName() == "DefaultApplication") {
                ps.setString(6, "APPROVED");
            } else {
                ps.setString(6, "CREATED");
            }
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            while (rs.next()) {
                applicationId = Integer.valueOf(rs.getString(1));
            }
            ps.close();
            APIMgtDBUtil.closeAllConnections(ps, null, null);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to add Application", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, null, null);
        }
        return applicationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateApplication(Application application) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String sqlQuery = "UPDATE AM_APPLICATION SET NAME = ? , APPLICATION_TIER = ? , CALLBACK_URL = ? , DESCRIPTION = ? WHERE APPLICATION_ID = ?";
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, application.getName());
            ps.setString(2, application.getTier());
            ps.setString(3, application.getCallbackUrl());
            ps.setString(4, application.getDescription());
            ps.setInt(5, application.getId());
            ps.executeUpdate();
            ps.close();
            conn.commit();
            this.updateOAuthConsumerApp(application.getName(), application.getCallbackUrl());
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the update Application ", (Throwable)e);
                }
            }
            ApiMgtDAO.handleException("Failed to update Application", e);
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        catch (IdentityOAuthAdminException e2) {
            ApiMgtDAO.handleException("Failed to update OAuth Consumer Application", e2);
            {
                catch (Throwable throwable) {
                    APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                    throw throwable;
                }
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApplicationStatus(int applicationId, String status) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String updateSqlQuery = "UPDATE  AM_APPLICATION SET APPLICATION_STATUS = ? WHERE APPLICATION_ID = ?";
            ps = conn.prepareStatement(updateSqlQuery);
            ps.setString(1, status);
            ps.setInt(2, applicationId);
            ps.executeUpdate();
            ps.close();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback the update Application ", (Throwable)e);
                    }
                }
                ApiMgtDAO.handleException("Failed to update Application", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApplicationStatus(String appName, String userId) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        String status = null;
        int applicationId = this.getApplicationId(appName, userId);
        try {
            conn = APIMgtDBUtil.getConnection();
            String sqlQuery = "SELECT   APPLICATION_STATUS FROM   AM_APPLICATION WHERE    APPLICATION_ID= ?";
            ps = conn.prepareStatement(sqlQuery);
            ps.setInt(1, applicationId);
            resultSet = ps.executeQuery();
            while (resultSet.next()) {
                status = resultSet.getString("APPLICATION_STATUS");
            }
            ps.close();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback the update Application ", (Throwable)e);
                    }
                }
                ApiMgtDAO.handleException("Failed to update Application", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getApplicationId(String appName, String username) throws APIManagementException {
        if (username == null) {
            return 0;
        }
        Subscriber subscriber = this.getSubscriber(username);
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int appId = 0;
        String sqlQuery = "SELECT    APPLICATION_ID FROM    AM_APPLICATION WHERE    SUBSCRIBER_ID  = ? AND  NAME= ?";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setInt(1, subscriber.getId());
            prepStmt.setString(2, appName);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                appId = rs.getInt("APPLICATION_ID");
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error when getting the application id from the persistence store.", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        return appId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApplicationNameFromId(int applicationId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String appName = null;
        String sqlQuery = "SELECT NAME FROM AM_APPLICATION WHERE APPLICATION_ID = ?";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setInt(1, applicationId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                appName = rs.getString("NAME");
            }
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error when getting the application name for id " + applicationId, e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        return appName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application[] getApplications(Subscriber subscriber) throws APIManagementException {
        if (subscriber == null) {
            return null;
        }
        String subscribedUser = this.getLoginUserName(subscriber.getName());
        subscriber.setName(subscribedUser);
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Application[] applications = null;
        String sqlQuery = "SELECT    APPLICATION_ID    ,NAME   ,APPLICATION_TIER   ,SUBSCRIBER_ID     ,CALLBACK_URL     ,DESCRIPTION     ,APPLICATION_STATUS  FROM    AM_APPLICATION WHERE    SUBSCRIBER_ID  = ?";
        try {
            int tenantId;
            connection = APIMgtDBUtil.getConnection();
            try {
                tenantId = IdentityUtil.getTenantIdOFUser((String)subscriber.getName());
            }
            catch (IdentityException e) {
                String msg = "Failed to get tenant id of user : " + subscriber.getName();
                log.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
            if (subscriber.getId() == 0) {
                Subscriber subs = this.getSubscriber(subscriber.getName(), tenantId, connection);
                if (subs == null) {
                    Application[] msg = null;
                    APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                    return msg;
                }
                subscriber = subs;
            }
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setInt(1, subscriber.getId());
            rs = prepStmt.executeQuery();
            ArrayList<Application> applicationsList = new ArrayList<Application>();
            String tenantAwareUserId = subscriber.getName();
            while (rs.next()) {
                Application application = new Application(rs.getString("NAME"), subscriber);
                application.setId(rs.getInt("APPLICATION_ID"));
                application.setTier(rs.getString("APPLICATION_TIER"));
                application.setCallbackUrl(rs.getString("CALLBACK_URL"));
                application.setDescription(rs.getString("DESCRIPTION"));
                application.setStatus(rs.getString("APPLICATION_STATUS"));
                Set<APIKey> keys = this.getApplicationKeys(tenantAwareUserId, application.getId());
                for (APIKey key : keys) {
                    application.addKey(key);
                }
                applicationsList.add(application);
            }
            Collections.sort(applicationsList, new Comparator<Application>(){

                @Override
                public int compare(Application o1, Application o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            applications = applicationsList.toArray(new Application[applicationsList.size()]);
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error when reading the application information from the persistence store.", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        return applications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteApplication(Application application) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String getSubscriptionsQuery = "SELECT SUBSCRIPTION_ID FROM AM_SUBSCRIPTION WHERE APPLICATION_ID = ?";
        String getConsumerKeyQuery = "SELECT CONSUMER_KEY FROM AM_APPLICATION_KEY_MAPPING WHERE APPLICATION_ID = ?";
        String deleteKeyMappingQuery = "DELETE FROM AM_SUBSCRIPTION_KEY_MAPPING WHERE SUBSCRIPTION_ID = ?";
        String deleteSubscriptionsQuery = "DELETE FROM AM_SUBSCRIPTION WHERE APPLICATION_ID = ?";
        String deleteApplicationKeyQuery = "DELETE FROM AM_APPLICATION_KEY_MAPPING WHERE APPLICATION_ID = ?";
        String deleteDomainAppQuery = "DELETE FROM AM_APP_KEY_DOMAIN_MAPPING WHERE CONSUMER_KEY = ?";
        String deleteConsumerAppQuery = "DELETE FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY = ?";
        String deleteApplicationQuery = "DELETE FROM AM_APPLICATION WHERE APPLICATION_ID = ?";
        String deleteRegistrationEntry = "DELETE FROM AM_APPLICATION_REGISTRATION WHERE APP_ID = ?";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(getSubscriptionsQuery);
            prepStmt.setInt(1, application.getId());
            rs = prepStmt.executeQuery();
            ArrayList<Integer> subscriptions = new ArrayList<Integer>();
            while (rs.next()) {
                subscriptions.add(rs.getInt("SUBSCRIPTION_ID"));
            }
            prepStmt.close();
            rs.close();
            prepStmt = connection.prepareStatement(deleteKeyMappingQuery);
            for (Integer subscriptionId : subscriptions) {
                prepStmt.setInt(1, subscriptionId);
                prepStmt.execute();
            }
            prepStmt.close();
            prepStmt = connection.prepareStatement(deleteRegistrationEntry);
            prepStmt.setInt(1, application.getId());
            prepStmt.execute();
            prepStmt = connection.prepareStatement(deleteSubscriptionsQuery);
            prepStmt.setInt(1, application.getId());
            prepStmt.execute();
            prepStmt.close();
            prepStmt = connection.prepareStatement(getConsumerKeyQuery);
            prepStmt.setInt(1, application.getId());
            rs = prepStmt.executeQuery();
            String consumerKey = null;
            while (rs.next()) {
                consumerKey = rs.getString("CONSUMER_KEY");
            }
            prepStmt.close();
            rs.close();
            if (consumerKey != null) {
                prepStmt = connection.prepareStatement(deleteDomainAppQuery);
                prepStmt.setString(1, consumerKey);
                prepStmt.execute();
                prepStmt.close();
                prepStmt = connection.prepareStatement(deleteConsumerAppQuery);
                prepStmt.setString(1, consumerKey);
                prepStmt.execute();
                prepStmt.close();
            }
            prepStmt = connection.prepareStatement(deleteApplicationKeyQuery);
            prepStmt.setInt(1, application.getId());
            prepStmt.execute();
            prepStmt.close();
            prepStmt = connection.prepareStatement(deleteApplicationQuery);
            prepStmt.setInt(1, application.getId());
            prepStmt.execute();
            connection.commit();
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while removing application details from the database", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subscriber getSubscriber(String username, int tenantId, Connection connection) throws APIManagementException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Subscriber subscriber = null;
        String sqlQuery = this.forceCaseInsensitiveComparisons ? "SELECT    SUB.SUBSCRIBER_ID AS SUBSCRIBER_ID   ,SUB.USER_ID AS USER_ID    ,SUB.TENANT_ID AS TENANT_ID   ,SUB.EMAIL_ADDRESS AS EMAIL_ADDRESS   ,SUB.DATE_SUBSCRIBED AS DATE_SUBSCRIBED FROM    AM_SUBSCRIBER SUB WHERE LOWER(SUB.USER_ID) = LOWER(?) AND SUB.TENANT_ID = ?" : "SELECT    SUB.SUBSCRIBER_ID AS SUBSCRIBER_ID   ,SUB.USER_ID AS USER_ID    ,SUB.TENANT_ID AS TENANT_ID   ,SUB.EMAIL_ADDRESS AS EMAIL_ADDRESS   ,SUB.DATE_SUBSCRIBED AS DATE_SUBSCRIBED FROM    AM_SUBSCRIBER SUB WHERE SUB.USER_ID = ? AND SUB.TENANT_ID = ?";
        try {
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, username);
            prepStmt.setInt(2, tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                subscriber = new Subscriber(rs.getString("USER_ID"));
                subscriber.setEmail(rs.getString("EMAIL_ADDRESS"));
                subscriber.setId(rs.getInt("SUBSCRIBER_ID"));
                subscriber.setSubscribedDate((Date)rs.getDate("DATE_SUBSCRIBED"));
                subscriber.setTenantId(rs.getInt("TENANT_ID"));
                Subscriber subscriber2 = subscriber;
                APIMgtDBUtil.closeAllConnections(prepStmt, null, rs);
                return subscriber2;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, null, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error when reading the application information from the persistence store.", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, null, rs);
        }
        return subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordAPILifeCycleEvent(APIIdentifier identifier, APIStatus oldStatus, APIStatus newStatus, String userId) throws APIManagementException {
        Connection conn = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            this.recordAPILifeCycleEvent(identifier, oldStatus, newStatus, userId, conn);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to record API state change", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(null, conn, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordAPILifeCycleEvent(APIIdentifier identifier, APIStatus oldStatus, APIStatus newStatus, String userId, Connection conn) throws APIManagementException {
        int tenantId;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        int apiId = -1;
        try {
            tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
        }
        catch (IdentityException e) {
            String msg = "Failed to get tenant id of user : " + userId;
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        if (oldStatus == null && !newStatus.equals((Object)APIStatus.CREATED)) {
            String msg = "Invalid old and new state combination";
            log.error((Object)msg);
            throw new APIManagementException(msg);
        }
        if (oldStatus != null && oldStatus.equals((Object)newStatus)) {
            String msg = "No measurable differences in API state";
            log.error((Object)msg);
            throw new APIManagementException(msg);
        }
        String getAPIQuery = "SELECT API.API_ID FROM AM_API API WHERE API.API_PROVIDER = ? AND API.API_NAME = ? AND API.API_VERSION = ?";
        String sqlQuery = "INSERT INTO AM_API_LC_EVENT (API_ID, PREVIOUS_STATE, NEW_STATE, USER_ID, TENANT_ID, EVENT_DATE) VALUES (?,?,?,?,?,?)";
        try {
            ps = conn.prepareStatement(getAPIQuery);
            ps.setString(1, APIUtil.replaceEmailDomainBack(identifier.getProviderName()));
            ps.setString(2, identifier.getApiName());
            ps.setString(3, identifier.getVersion());
            resultSet = ps.executeQuery();
            if (resultSet.next()) {
                apiId = resultSet.getInt("API_ID");
            }
            resultSet.close();
            ps.close();
            if (apiId == -1) {
                String msg = "Unable to find the API: " + identifier + " in the database";
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            ps = conn.prepareStatement(sqlQuery);
            ps.setInt(1, apiId);
            if (oldStatus != null) {
                ps.setString(2, oldStatus.getStatus());
            } else {
                ps.setNull(2, 12);
            }
            ps.setString(3, newStatus.getStatus());
            ps.setString(4, userId);
            ps.setInt(5, tenantId);
            ps.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            ps.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback the API state change record", (Throwable)e);
                }
            }
            ApiMgtDAO.handleException("Failed to record API state change", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefaultAPIPublishedVersion(APIIdentifier identifier, APIStatus oldStatus, APIStatus newStatus) throws APIManagementException {
        Connection conn = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            if (!oldStatus.equals((Object)newStatus)) {
                if ((newStatus.equals((Object)APIStatus.CREATED) || newStatus.equals((Object)APIStatus.RETIRED)) && (oldStatus.equals((Object)APIStatus.PUBLISHED) || oldStatus.equals((Object)APIStatus.DEPRECATED) || oldStatus.equals((Object)APIStatus.BLOCKED))) {
                    this.setPublishedDefVersion(identifier, conn, null);
                } else if (newStatus.equals((Object)APIStatus.PUBLISHED) || newStatus.equals((Object)APIStatus.DEPRECATED) || newStatus.equals((Object)APIStatus.BLOCKED)) {
                    this.setPublishedDefVersion(identifier, conn, identifier.getVersion());
                }
            }
            conn.commit();
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to update published default API state change", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(null, conn, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LifeCycleEvent> getLifeCycleEvents(APIIdentifier apiId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String sqlQuery = "SELECT LC.API_ID AS API_ID, LC.PREVIOUS_STATE AS PREVIOUS_STATE, LC.NEW_STATE AS NEW_STATE, LC.USER_ID AS USER_ID, LC.EVENT_DATE AS EVENT_DATE FROM AM_API_LC_EVENT LC,  AM_API API WHERE API.API_PROVIDER = ? AND API.API_NAME = ? AND API.API_VERSION = ? AND API.API_ID = LC.API_ID";
        ArrayList<LifeCycleEvent> events = new ArrayList<LifeCycleEvent>();
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, APIUtil.replaceEmailDomainBack(apiId.getProviderName()));
            prepStmt.setString(2, apiId.getApiName());
            prepStmt.setString(3, apiId.getVersion());
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                LifeCycleEvent event = new LifeCycleEvent();
                event.setApi(apiId);
                String oldState = rs.getString("PREVIOUS_STATE");
                event.setOldStatus(oldState != null ? APIStatus.valueOf((String)oldState) : null);
                event.setNewStatus(APIStatus.valueOf((String)rs.getString("NEW_STATE")));
                event.setUserId(rs.getString("USER_ID"));
                event.setDate((Date)rs.getTimestamp("EVENT_DATE"));
                events.add(event);
            }
            Collections.sort(events, new Comparator<LifeCycleEvent>(){

                @Override
                public int compare(LifeCycleEvent o1, LifeCycleEvent o2) {
                    return o1.getDate().compareTo(o2.getDate());
                }
            });
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error when executing the SQL : " + sqlQuery, e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeKeysForwardCompatible(String provider, String apiName, String oldVersion, String newVersion, String context) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String getSubscriptionDataQuery = "SELECT SUB.SUBSCRIPTION_ID AS SUBSCRIPTION_ID, SUB.TIER_ID AS TIER_ID, SUB.APPLICATION_ID AS APPLICATION_ID, SUB.SUB_STATUS AS SUB_STATUS, API.CONTEXT AS CONTEXT, SKM.ACCESS_TOKEN AS ACCESS_TOKEN, SKM.KEY_TYPE AS KEY_TYPE FROM AM_SUBSCRIPTION SUB, AM_SUBSCRIPTION_KEY_MAPPING SKM,  AM_API API WHERE API.API_PROVIDER = ? AND API.API_NAME = ? AND API.API_VERSION = ? AND SKM.SUBSCRIPTION_ID = SUB.SUBSCRIPTION_ID AND API.API_ID = SUB.API_ID";
        String addSubKeyMapping = "INSERT INTO AM_SUBSCRIPTION_KEY_MAPPING (SUBSCRIPTION_ID, ACCESS_TOKEN, KEY_TYPE) VALUES (?,?,?)";
        String getApplicationDataQuery = "SELECT SUB.SUBSCRIPTION_ID AS SUBSCRIPTION_ID, SUB.TIER_ID AS TIER_ID, SUB.SUB_STATUS AS SUB_STATUS, APP.APPLICATION_ID AS APPLICATION_ID, API.CONTEXT AS CONTEXT FROM AM_SUBSCRIPTION SUB, AM_APPLICATION APP, AM_API API WHERE API.API_PROVIDER = ? AND API.API_NAME = ? AND API.API_VERSION = ? AND SUB.APPLICATION_ID = APP.APPLICATION_ID AND API.API_ID = SUB.API_ID";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(getSubscriptionDataQuery);
            prepStmt.setString(1, APIUtil.replaceEmailDomainBack(provider));
            prepStmt.setString(2, apiName);
            prepStmt.setString(3, oldVersion);
            rs = prepStmt.executeQuery();
            ArrayList<SubscriptionInfo> subscriptionData = new ArrayList<SubscriptionInfo>();
            HashSet<Integer> subscribedApplications = new HashSet<Integer>();
            while (rs.next() && !"ON_HOLD".equals(rs.getString("SUB_STATUS"))) {
                SubscriptionInfo info = new SubscriptionInfo();
                info.subscriptionId = rs.getInt("SUBSCRIPTION_ID");
                info.tierId = rs.getString("TIER_ID");
                info.context = rs.getString("CONTEXT");
                info.applicationId = rs.getInt("APPLICATION_ID");
                info.accessToken = rs.getString("ACCESS_TOKEN");
                info.tokenType = rs.getString("KEY_TYPE");
                subscriptionData.add(info);
            }
            prepStmt.close();
            rs.close();
            HashMap<Integer, Integer> subscriptionIdMap = new HashMap<Integer, Integer>();
            APIIdentifier apiId = new APIIdentifier(provider, apiName, newVersion);
            for (SubscriptionInfo info : subscriptionData) {
                try {
                    int subscriptionId;
                    if (!subscriptionIdMap.containsKey(info.subscriptionId)) {
                        apiId.setTier(info.tierId);
                        subscriptionId = this.addSubscription(apiId, context, info.applicationId, "UNBLOCKED");
                        if (subscriptionId == -1) {
                            String msg = "Unable to add a new subscription for the API: " + apiName + ":v" + newVersion;
                            log.error((Object)msg);
                            throw new APIManagementException(msg);
                        }
                        subscriptionIdMap.put(info.subscriptionId, subscriptionId);
                    }
                    subscriptionId = (Integer)subscriptionIdMap.get(info.subscriptionId);
                    prepStmt = connection.prepareStatement(addSubKeyMapping);
                    prepStmt.setInt(1, subscriptionId);
                    prepStmt.setString(2, info.accessToken);
                    prepStmt.setString(3, info.tokenType);
                    prepStmt.execute();
                    prepStmt.close();
                    subscribedApplications.add(info.applicationId);
                }
                catch (SubscriptionAlreadyExistingException e) {
                    log.error((Object)("Error while adding subscription " + e.getMessage()), (Throwable)e);
                }
            }
            prepStmt = connection.prepareStatement(getApplicationDataQuery);
            prepStmt.setString(1, APIUtil.replaceEmailDomainBack(provider));
            prepStmt.setString(2, apiName);
            prepStmt.setString(3, oldVersion);
            rs = prepStmt.executeQuery();
            while (rs.next() && !"ON_HOLD".equals(rs.getString("SUB_STATUS"))) {
                int applicationId = rs.getInt("APPLICATION_ID");
                if (subscribedApplications.contains(applicationId)) continue;
                apiId.setTier(rs.getString("TIER_ID"));
                try {
                    this.addSubscription(apiId, rs.getString("CONTEXT"), applicationId, "UNBLOCKED");
                }
                catch (SubscriptionAlreadyExistingException e) {
                    log.error((Object)("Error while adding subscription" + e.getMessage()), (Throwable)e);
                }
            }
            connection.commit();
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error when executing the SQL queries", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAPI(API api, int tenantId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "INSERT INTO AM_API (API_PROVIDER, API_NAME, API_VERSION, CONTEXT) VALUES (?,?,?,?)";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(query, new String[]{"api_id"});
            prepStmt.setString(1, APIUtil.replaceEmailDomainBack(api.getId().getProviderName()));
            prepStmt.setString(2, api.getId().getApiName());
            prepStmt.setString(3, api.getId().getVersion());
            prepStmt.setString(4, api.getContext());
            prepStmt.execute();
            rs = prepStmt.getGeneratedKeys();
            int applicationId = -1;
            if (rs.next()) {
                applicationId = rs.getInt(1);
            }
            connection.commit();
            if (api.getScopes() != null) {
                this.addScopes(api.getScopes(), applicationId, tenantId);
            }
            this.addURLTemplates(applicationId, api, connection);
            this.recordAPILifeCycleEvent(api.getId(), null, APIStatus.CREATED, APIUtil.replaceEmailDomainBack(api.getId().getProviderName()), connection);
            if (api.isDefaultVersion()) {
                this.addUpdateAPIAsDefaultVersion(api, connection);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error while adding the API: " + api.getId() + " to the database", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultVersion(APIIdentifier apiId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String oldDefaultVersion = null;
        String query = "SELECT DEFAULT_API_VERSION FROM AM_API_DEFAULT_VERSION WHERE API_NAME= ? AND API_PROVIDER= ? ";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, apiId.getApiName());
            prepStmt.setString(2, APIUtil.replaceEmailDomainBack(apiId.getProviderName()));
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                oldDefaultVersion = rs.getString("DEFAULT_API_VERSION");
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while getting default version for " + apiId.getApiName(), e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        return oldDefaultVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkflowEntry(WorkflowDTO workflow) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "INSERT INTO AM_WORKFLOWS (WF_REFERENCE, WF_TYPE, WF_STATUS, WF_CREATED_TIME, WF_STATUS_DESC, TENANT_ID, TENANT_DOMAIN, WF_EXTERNAL_REFERENCE ) VALUES (?,?,?,?,?,?,?,?)";
        try {
            Timestamp cratedDateStamp = new Timestamp(workflow.getCreatedTime());
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, workflow.getWorkflowReference());
            prepStmt.setString(2, workflow.getWorkflowType());
            prepStmt.setString(3, workflow.getStatus().toString());
            prepStmt.setTimestamp(4, cratedDateStamp);
            prepStmt.setString(5, workflow.getWorkflowDescription());
            prepStmt.setInt(6, workflow.getTenantId());
            prepStmt.setString(7, workflow.getTenantDomain());
            prepStmt.setString(8, workflow.getExternalWorkflowReference());
            prepStmt.execute();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error while adding Workflow : " + workflow.getExternalWorkflowReference() + " to the database", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkflowStatus(WorkflowDTO workflowDTO) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "UPDATE AM_WORKFLOWS SET WF_STATUS = ?, WF_STATUS_DESC = ?, WF_UPDATED_TIME = ? WHERE WF_EXTERNAL_REFERENCE = ?";
        try {
            Timestamp updatedTimeStamp = new Timestamp(workflowDTO.getUpdatedTime());
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, workflowDTO.getStatus().toString());
            prepStmt.setString(2, workflowDTO.getWorkflowDescription());
            prepStmt.setTimestamp(3, updatedTimeStamp);
            prepStmt.setString(4, workflowDTO.getExternalWorkflowReference());
            prepStmt.execute();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error while updating Workflow Status of workflow " + workflowDTO.getExternalWorkflowReference(), e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowDTO retrieveWorkflow(String workflowReference) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        WorkflowDTO workflowDTO = null;
        String query = "SELECT * FROM AM_WORKFLOWS WHERE WF_EXTERNAL_REFERENCE=?";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, workflowReference);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                workflowDTO = WorkflowExecutorFactory.getInstance().createWorkflowDTO(rs.getString("WF_TYPE"));
                workflowDTO.setStatus(WorkflowStatus.valueOf((String)rs.getString("WF_STATUS")));
                workflowDTO.setExternalWorkflowReference(rs.getString("WF_EXTERNAL_REFERENCE"));
                workflowDTO.setCreatedTime(rs.getTimestamp("WF_CREATED_TIME").getTime());
                workflowDTO.setWorkflowReference(rs.getString("WF_REFERENCE"));
                workflowDTO.setTenantDomain(rs.getString("TENANT_DOMAIN"));
                workflowDTO.setTenantId(rs.getInt("TENANT_ID"));
                workflowDTO.setWorkflowDescription(rs.getString("WF_STATUS_DESC"));
            }
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error while retrieving workflow details for " + workflowReference, e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        return workflowDTO;
    }

    private void setPublishedDefVersion(APIIdentifier apiId, Connection connection, String value) throws APIManagementException {
        String queryDefaultVersionUpdate = "UPDATE AM_API_DEFAULT_VERSION SET PUBLISHED_DEFAULT_API_VERSION = ? WHERE API_NAME = ? AND API_PROVIDER = ?";
        try {
            PreparedStatement prepStmtDefVersionUpdate = connection.prepareStatement(queryDefaultVersionUpdate);
            prepStmtDefVersionUpdate.setString(1, value);
            prepStmtDefVersionUpdate.setString(2, apiId.getApiName());
            prepStmtDefVersionUpdate.setString(3, APIUtil.replaceEmailDomainBack(apiId.getProviderName()));
            prepStmtDefVersionUpdate.execute();
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while deleting the API default version entry: " + apiId.getApiName() + " from the database", e);
        }
    }

    public void removeAPIFromDefaultVersion(APIIdentifier apiId, Connection connection) throws APIManagementException {
        String queryDefaultVersionDelete = "DELETE FROM AM_API_DEFAULT_VERSION WHERE API_NAME = ? AND API_PROVIDER = ?";
        try {
            PreparedStatement prepStmtDefVersionDelete = connection.prepareStatement(queryDefaultVersionDelete);
            prepStmtDefVersionDelete.setString(1, apiId.getApiName());
            prepStmtDefVersionDelete.setString(2, APIUtil.replaceEmailDomainBack(apiId.getProviderName()));
            prepStmtDefVersionDelete.execute();
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while deleting the API default version entry: " + apiId.getApiName() + " from the database", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPublishedDefaultVersion(APIIdentifier apiId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String publishedDefaultVersion = null;
        String query = "SELECT PUBLISHED_DEFAULT_API_VERSION FROM AM_API_DEFAULT_VERSION WHERE API_NAME= ? AND API_PROVIDER= ? ";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, apiId.getApiName());
            prepStmt.setString(2, APIUtil.replaceEmailDomainBack(apiId.getProviderName()));
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                publishedDefaultVersion = rs.getString("PUBLISHED_DEFAULT_API_VERSION");
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while getting default version for " + apiId.getApiName(), e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        return publishedDefaultVersion;
    }

    public void addUpdateAPIAsDefaultVersion(API api, Connection connection) throws APIManagementException {
        String publishedDefaultVersion = this.getPublishedDefaultVersion(api.getId());
        this.removeAPIFromDefaultVersion(api.getId(), connection);
        String queryDefaultVersionAdd = "INSERT INTO AM_API_DEFAULT_VERSION ( API_NAME , API_PROVIDER , DEFAULT_API_VERSION , PUBLISHED_DEFAULT_API_VERSION )  VALUES (?,?,?,?)";
        try {
            PreparedStatement prepStmtDefVersionAdd = connection.prepareStatement(queryDefaultVersionAdd);
            prepStmtDefVersionAdd.setString(1, api.getId().getApiName());
            prepStmtDefVersionAdd.setString(2, APIUtil.replaceEmailDomainBack(api.getId().getProviderName()));
            prepStmtDefVersionAdd.setString(3, api.getId().getVersion());
            APIStatus apistatus = api.getStatus();
            if (apistatus.equals((Object)APIStatus.PUBLISHED) || apistatus.equals((Object)APIStatus.DEPRECATED) || apistatus.equals((Object)APIStatus.BLOCKED)) {
                prepStmtDefVersionAdd.setString(4, api.getId().getVersion());
            } else {
                prepStmtDefVersionAdd.setString(4, publishedDefaultVersion);
            }
            prepStmtDefVersionAdd.execute();
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while adding the API default version entry: " + api.getId().getApiName() + " to the database", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addURLTemplates(int apiId, API api, Connection connection) throws APIManagementException {
        if (apiId == -1) {
            return;
        }
        PreparedStatement prepStmt = null;
        PreparedStatement scopePrepStmt = null;
        String query = "INSERT INTO AM_API_URL_MAPPING (API_ID,HTTP_METHOD,AUTH_SCHEME,URL_PATTERN,THROTTLING_TIER,MEDIATION_SCRIPT) VALUES (?,?,?,?,?,?)";
        String scopeQuery = "INSERT INTO IDN_OAUTH2_RESOURCE_SCOPE (RESOURCE_PATH, SCOPE_ID) VALUES (?,?)";
        try {
            prepStmt = connection.prepareStatement(query);
            scopePrepStmt = connection.prepareStatement(scopeQuery);
            for (URITemplate uriTemplate : api.getUriTemplates()) {
                if (uriTemplate.getMediationScript() != null) {
                    byte[] byteArr = uriTemplate.getMediationScript().getBytes();
                }
                prepStmt.setInt(1, apiId);
                prepStmt.setString(2, uriTemplate.getHTTPVerb());
                prepStmt.setString(3, uriTemplate.getAuthType());
                prepStmt.setString(4, uriTemplate.getUriTemplate());
                prepStmt.setString(5, uriTemplate.getThrottlingTier());
                ByteArrayInputStream is = null;
                is = uriTemplate.getMediationScript() != null ? new ByteArrayInputStream(uriTemplate.getMediationScript().getBytes()) : null;
                if (connection.getMetaData().getDriverName().contains("PostgreSQL")) {
                    if (uriTemplate.getMediationScript() != null) {
                        prepStmt.setBinaryStream(6, (InputStream)is, uriTemplate.getMediationScript().getBytes().length);
                    } else {
                        prepStmt.setBinaryStream(6, (InputStream)is, 0);
                    }
                } else {
                    prepStmt.setBinaryStream(6, is);
                }
                prepStmt.addBatch();
                if (uriTemplate.getScope() == null) continue;
                scopePrepStmt.setString(1, APIUtil.getResourceKey(api, uriTemplate));
                scopePrepStmt.setInt(2, uriTemplate.getScope().getId());
                scopePrepStmt.addBatch();
            }
            prepStmt.executeBatch();
            prepStmt.clearBatch();
            scopePrepStmt.executeBatch();
            scopePrepStmt.clearBatch();
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while adding URL template(s) to the database for API : " + api.getId().toString(), e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, null, null);
            APIMgtDBUtil.closeAllConnections(scopePrepStmt, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application getApplicationByName(String applicationName, String userId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Object workflowDTO = null;
        Subscriber subscriber = new Subscriber(userId);
        Application application = null;
        try {
            connection = APIMgtDBUtil.getConnection();
            String query = "SELECT APP.APPLICATION_ID,APP.NAME,APP.SUBSCRIBER_ID,APP.APPLICATION_TIER,APP.CALLBACK_URL,APP.DESCRIPTION, APP.SUBSCRIBER_ID,APP.APPLICATION_STATUS FROM AM_SUBSCRIBER SUB,AM_APPLICATION APP";
            String whereClause = "  WHERE SUB.USER_ID =? AND APP.NAME=? AND SUB.SUBSCRIBER_ID=APP.SUBSCRIBER_ID";
            String whereClauseCaseInSensitive = "  WHERE LOWER(SUB.USER_ID) =LOWER(?) AND APP.NAME=? AND SUB.SUBSCRIBER_ID=APP.SUBSCRIBER_ID";
            query = this.forceCaseInsensitiveComparisons ? query + whereClauseCaseInSensitive : query + whereClause;
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, userId);
            prepStmt.setString(2, applicationName);
            rs = prepStmt.executeQuery();
            application = new Application(applicationName, subscriber);
            while (rs.next()) {
                application.setDescription(rs.getString("DESCRIPTION"));
                application.setStatus(rs.getString("APPLICATION_STATUS"));
                application.setCallbackUrl(rs.getString("CALLBACK_URL"));
                application.setId(rs.getInt("APPLICATION_ID"));
                application.setTier(rs.getString("APPLICATION_TIER"));
                subscriber.setId(rs.getInt("SUBSCRIBER_ID"));
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while obtaining details of the Application : " + applicationName, e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application getApplicationById(int applicationId) throws APIManagementException {
        Application application;
        ResultSet rs;
        PreparedStatement prepStmt;
        Connection connection;
        block4: {
            connection = null;
            prepStmt = null;
            rs = null;
            Object workflowDTO = null;
            application = null;
            try {
                connection = APIMgtDBUtil.getConnection();
                String query = "SELECT APP.APPLICATION_ID,APP.NAME,APP.SUBSCRIBER_ID,APP.APPLICATION_TIER,APP.CALLBACK_URL,APP.DESCRIPTION, APP.SUBSCRIBER_ID,APP.APPLICATION_STATUS FROM AM_SUBSCRIBER SUB,AM_APPLICATION APP WHERE APPLICATION_ID = ? AND APP.SUBSCRIBER_ID = SUB.SUBSCRIBER_ID";
                prepStmt = connection.prepareStatement(query);
                prepStmt.setInt(1, applicationId);
                rs = prepStmt.executeQuery();
                if (!rs.next()) break block4;
                String applicationName = rs.getString("NAME");
                String subscriberId = rs.getString("SUBSCRIBER_ID");
                Subscriber subscriber = new Subscriber(subscriberId);
                application = new Application(applicationName, subscriber);
                application.setDescription(rs.getString("DESCRIPTION"));
                application.setStatus(rs.getString("APPLICATION_STATUS"));
                application.setCallbackUrl(rs.getString("CALLBACK_URL"));
                application.setId(rs.getInt("APPLICATION_ID"));
                application.setTier(rs.getString("APPLICATION_TIER"));
                subscriber.setId(rs.getInt("SUBSCRIBER_ID"));
            }
            catch (SQLException e) {
                try {
                    ApiMgtDAO.handleException("Error while obtaining details of the Application : " + applicationId, e);
                }
                catch (Throwable throwable) {
                    APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                    throw throwable;
                }
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
            }
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateURLTemplates(API api) throws APIManagementException {
        String deleteOldMappingsQuery;
        int apiId;
        PreparedStatement prepStmt;
        Connection connection;
        block5: {
            connection = null;
            prepStmt = null;
            apiId = -1;
            deleteOldMappingsQuery = "DELETE FROM AM_API_URL_MAPPING WHERE API_ID = ?";
            connection = APIMgtDBUtil.getConnection();
            apiId = ApiMgtDAO.getAPIID(api.getId(), connection);
            if (apiId != -1) break block5;
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
            return;
        }
        try {
            prepStmt = connection.prepareStatement(deleteOldMappingsQuery);
            prepStmt.setInt(1, apiId);
            prepStmt.execute();
            prepStmt.close();
            this.addURLTemplates(apiId, api, connection);
            connection.commit();
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error while deleting URL template(s) for API : " + api.getId().toString(), e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<URITemplate> getAllURITemplates(String apiContext, String version) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<URITemplate> uriTemplates = new ArrayList<URITemplate>();
        String query = "SELECT AUM.HTTP_METHOD,AUTH_SCHEME,URL_PATTERN,THROTTLING_TIER,MEDIATION_SCRIPT FROM AM_API_URL_MAPPING AUM, AM_API API WHERE API.CONTEXT= ? AND API.API_VERSION = ? AND AUM.API_ID = API.API_ID ORDER BY URL_MAPPING_ID";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, apiContext);
            prepStmt.setString(2, version);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                URITemplate uriTemplate = new URITemplate();
                String script = null;
                uriTemplate.setHTTPVerb(rs.getString("HTTP_METHOD"));
                uriTemplate.setAuthType(rs.getString("AUTH_SCHEME"));
                uriTemplate.setUriTemplate(rs.getString("URL_PATTERN"));
                uriTemplate.setThrottlingTier(rs.getString("THROTTLING_TIER"));
                InputStream mediationScriptBlob = rs.getBinaryStream("MEDIATION_SCRIPT");
                if (mediationScriptBlob != null) {
                    script = APIMgtDBUtil.getStringFromInputStream(mediationScriptBlob);
                }
                uriTemplate.setMediationScript(script);
                uriTemplates.add(uriTemplate);
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while fetching all URL Templates", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        return uriTemplates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAPI(API api, int tenantId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String previousDefaultVersion = this.getDefaultVersion(api.getId());
        String query = "UPDATE AM_API SET CONTEXT = ? WHERE API_PROVIDER = ? AND API_NAME = ? AND API_VERSION = ? ";
        try {
            connection = APIMgtDBUtil.getConnection();
            if (api.isApiHeaderChanged()) {
                prepStmt = connection.prepareStatement(query);
                prepStmt.setString(1, api.getContext());
                prepStmt.setString(2, APIUtil.replaceEmailDomainBack(api.getId().getProviderName()));
                prepStmt.setString(3, api.getId().getApiName());
                prepStmt.setString(4, api.getId().getVersion());
                prepStmt.execute();
            }
            if (api.isDefaultVersion() ^ api.getId().getVersion().equals(previousDefaultVersion)) {
                if (api.isDefaultVersion()) {
                    this.addUpdateAPIAsDefaultVersion(api, connection);
                } else {
                    this.removeAPIFromDefaultVersion(api.getId(), connection);
                }
            }
            connection.commit();
            this.updateScopes(api, tenantId);
            this.updateURLTemplates(api);
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error while updating the API: " + api.getId() + " in the database", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAPIID(APIIdentifier apiId, Connection connection) throws APIManagementException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int id = -1;
        String getAPIQuery = "SELECT API.API_ID FROM AM_API API WHERE API.API_PROVIDER = ? AND API.API_NAME = ? AND API.API_VERSION = ?";
        try {
            prepStmt = connection.prepareStatement(getAPIQuery);
            prepStmt.setString(1, APIUtil.replaceEmailDomainBack(apiId.getProviderName()));
            prepStmt.setString(2, apiId.getApiName());
            prepStmt.setString(3, apiId.getVersion());
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                id = rs.getInt("API_ID");
            }
            if (id == -1) {
                String msg = "Unable to find the API: " + apiId + " in the database";
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, null, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while locating API: " + apiId + " from the database", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, null, rs);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAPI(APIIdentifier apiId) throws APIManagementException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int id = -1;
        String deleteLCEventQuery = "DELETE FROM AM_API_LC_EVENT WHERE API_ID=? ";
        String deleteCommentQuery = "DELETE FROM AM_API_COMMENTS WHERE API_ID=? ";
        String deleteRatingsQuery = "DELETE FROM AM_API_RATINGS WHERE API_ID=? ";
        String deleteSubscriptionQuery = "DELETE FROM AM_SUBSCRIPTION WHERE API_ID=?";
        String deleteExternalAPIStoresQuery = "DELETE FROM AM_EXTERNAL_STORES WHERE API_ID=?";
        String deleteAPIQuery = "DELETE FROM AM_API WHERE API_PROVIDER=? AND API_NAME=? AND API_VERSION=? ";
        String deleteURLTemplateQuery = "DELETE FROM AM_API_URL_MAPPING WHERE API_ID = ?";
        try {
            connection = APIMgtDBUtil.getConnection();
            id = ApiMgtDAO.getAPIID(apiId, connection);
            this.removeAPIScope(apiId);
            prepStmt = connection.prepareStatement(deleteSubscriptionQuery);
            prepStmt.setInt(1, id);
            prepStmt.execute();
            prepStmt = connection.prepareStatement(deleteCommentQuery);
            prepStmt.setInt(1, id);
            prepStmt.execute();
            prepStmt = connection.prepareStatement(deleteRatingsQuery);
            prepStmt.setInt(1, id);
            prepStmt.execute();
            prepStmt = connection.prepareStatement(deleteLCEventQuery);
            prepStmt.setInt(1, id);
            prepStmt.execute();
            prepStmt = connection.prepareStatement(deleteExternalAPIStoresQuery);
            prepStmt.setInt(1, id);
            prepStmt.execute();
            prepStmt = connection.prepareStatement(deleteAPIQuery);
            prepStmt.setString(1, APIUtil.replaceEmailDomainBack(apiId.getProviderName()));
            prepStmt.setString(2, apiId.getApiName());
            prepStmt.setString(3, apiId.getVersion());
            prepStmt.execute();
            prepStmt = connection.prepareStatement(deleteURLTemplateQuery);
            prepStmt.setInt(1, id);
            prepStmt.execute();
            String curDefaultVersion = this.getDefaultVersion(apiId);
            String pubDefaultVersion = this.getPublishedDefaultVersion(apiId);
            if (apiId.getVersion().equals(curDefaultVersion)) {
                this.removeAPIFromDefaultVersion(apiId, connection);
            } else if (apiId.getVersion().equals(pubDefaultVersion)) {
                this.setPublishedDefVersion(apiId, connection, null);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error while removing the API: " + apiId + " from the database", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void revokeAccessToken(String key) throws APIManagementException {
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromAccessToken(key);
        }
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String query = "UPDATE " + accessTokenStoreTable + " SET TOKEN_STATE='REVOKED' WHERE ACCESS_TOKEN= ? ";
            ps = conn.prepareStatement(query);
            ps.setString(1, APIUtil.encryptToken(key));
            ps.execute();
            conn.commit();
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error in revoking access token: " + e.getMessage(), e);
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        catch (CryptoException e2) {
            ApiMgtDAO.handleException("Error in revoking access token: " + e2.getMessage(), e2);
            {
                catch (Throwable throwable) {
                    APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                    throw throwable;
                }
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<APIIdentifier> getAPIByAccessToken(String accessToken) throws APIManagementException {
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromAccessToken(accessToken);
        }
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        String getAPISql = "SELECT AMA.API_ID,API_NAME,API_PROVIDER,API_VERSION FROM AM_API AMA," + accessTokenStoreTable + " ACT, AM_APPLICATION_KEY_MAPPING AKM, " + "AM_SUBSCRIPTION AMS WHERE ACT.ACCESS_TOKEN=? " + "AND ACT.CONSUMER_KEY=AKM.CONSUMER_KEY AND AKM.APPLICATION_ID=AMS.APPLICATION_ID AND " + "AMA.API_ID=AMS.API_ID";
        HashSet<APIIdentifier> apiList = new HashSet<APIIdentifier>();
        try {
            connection = APIMgtDBUtil.getConnection();
            PreparedStatement nestedPS = connection.prepareStatement(getAPISql);
            nestedPS.setString(1, APIUtil.encryptToken(accessToken));
            ResultSet nestedRS = nestedPS.executeQuery();
            while (nestedRS.next()) {
                apiList.add(new APIIdentifier(APIUtil.replaceEmailDomain(nestedRS.getString("API_PROVIDER")), nestedRS.getString("API_NAME"), nestedRS.getString("API_VERSION")));
            }
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to get API ID for token: " + accessToken, e);
        }
        catch (CryptoException e) {
            ApiMgtDAO.handleException("Failed to get API ID for token: " + accessToken, e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, connection, result);
        }
        return apiList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application[] getApplicationsByTier(String tier) throws APIManagementException {
        if (tier == null) {
            return null;
        }
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Application[] applications = null;
        String sqlQuery = "SELECT DISTINCT AMS.APPLICATION_ID,NAME,SUBSCRIBER_ID FROM AM_SUBSCRIPTION AMS,AM_APPLICATION AMA WHERE TIER_ID=? AND AMS.APPLICATION_ID=AMA.APPLICATION_ID";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, tier);
            rs = prepStmt.executeQuery();
            ArrayList applicationsList = new ArrayList();
            while (rs.next()) {
                Application application = new Application(rs.getString("NAME"), this.getSubscriber(rs.getString("SUBSCRIBER_ID")));
                application.setId(rs.getInt("APPLICATION_ID"));
            }
            Collections.sort(applicationsList, new Comparator<Application>(){

                @Override
                public int compare(Application o1, Application o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            applications = applicationsList.toArray(new Application[applicationsList.size()]);
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error when reading the application information from the persistence store.", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
        return applications;
    }

    private static void handleException(String msg, Throwable t) throws APIManagementException {
        log.error((Object)msg, t);
        throw new APIManagementException(msg, t);
    }

    public String createJWTTokenString(String context, String version, APIKeyValidationInfoDTO keyValidationInfoDTO) throws APIManagementException {
        String calleeToken = null;
        if (tokenGenerator != null) {
            calleeToken = this.generateJWTToken(keyValidationInfoDTO, context, version);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"JWT generator not properly initialized. JWT token will not present in validation info");
        }
        return calleeToken;
    }

    public String createJWTTokenString(String context, String version, APIKeyValidationInfoDTO keyValidationInfoDTO, String accessToken) throws APIManagementException {
        String calleeToken = null;
        if (tokenGenerator != null) {
            calleeToken = this.generateJWTToken(keyValidationInfoDTO, context, version, accessToken);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"JWT generator not properly initialized. JWT token will not present in validation info");
        }
        return calleeToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getURITemplatesPerAPIAsString(APIIdentifier identifier) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        int apiId = -1;
        LinkedHashMap<String, String> urlMappings = new LinkedHashMap<String, String>();
        try {
            conn = APIMgtDBUtil.getConnection();
            apiId = ApiMgtDAO.getAPIID(identifier, conn);
            String sqlQuery = "SELECT URL_PATTERN,HTTP_METHOD,AUTH_SCHEME,THROTTLING_TIER ,MEDIATION_SCRIPT FROM AM_API_URL_MAPPING WHERE API_ID = ? ORDER BY URL_MAPPING_ID ASC ";
            ps = conn.prepareStatement(sqlQuery);
            ps.setInt(1, apiId);
            resultSet = ps.executeQuery();
            while (resultSet.next()) {
                String script = null;
                String uriPattern = resultSet.getString("URL_PATTERN");
                String httpMethod = resultSet.getString("HTTP_METHOD");
                String authScheme = resultSet.getString("AUTH_SCHEME");
                String throttlingTier = resultSet.getString("THROTTLING_TIER");
                InputStream mediationScriptBlob = resultSet.getBinaryStream("MEDIATION_SCRIPT");
                if (mediationScriptBlob != null && (script = APIMgtDBUtil.getStringFromInputStream(mediationScriptBlob)).isEmpty()) {
                    script = null;
                }
                urlMappings.put(uriPattern + "::" + httpMethod + "::" + authScheme + "::" + throttlingTier + "::" + script, null);
            }
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback the add subscription ", (Throwable)e);
                    }
                }
                ApiMgtDAO.handleException("Failed to add subscriber data ", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        return urlMappings;
    }

    public static boolean isDomainRestricted(String apiKey, String clientDomain) throws APIManagementException {
        List<String> authorizedDomains;
        boolean restricted = true;
        if (clientDomain != null) {
            clientDomain = clientDomain.trim();
        }
        if ((authorizedDomains = Arrays.asList(ApiMgtDAO.getAuthorizedDomains(apiKey).split(","))).contains("ALL") || authorizedDomains.contains(clientDomain)) {
            restricted = false;
        }
        return restricted;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAuthorizedDomains(String accessToken) throws APIManagementException {
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
            accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromAccessToken(accessToken);
        }
        String authorizedDomains = "";
        String accessAllowDomainsSql = "SELECT a.AUTHZ_DOMAIN  FROM AM_APP_KEY_DOMAIN_MAPPING  a  INNER JOIN " + accessTokenStoreTable + " b " + " ON a.CONSUMER_KEY = b.CONSUMER_KEY " + " WHERE b.ACCESS_TOKEN = ? ";
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(accessAllowDomainsSql);
            prepStmt.setString(1, APIUtil.encryptToken(accessToken));
            rs = prepStmt.executeQuery();
            boolean first = true;
            while (rs.next()) {
                String domain = rs.getString(1);
                if (first) {
                    authorizedDomains = domain;
                    first = false;
                    continue;
                }
                authorizedDomains = authorizedDomains + "," + domain;
            }
            prepStmt.close();
        }
        catch (SQLException e) {
            try {
                throw new APIManagementException("Error in retrieving access allowing domain list from table.", (Throwable)e);
                catch (CryptoException e2) {
                    throw new APIManagementException("Error in retrieving access allowing domain list from table.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
                throw throwable;
            }
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        return authorizedDomains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String findConsumerKeyFromAccessToken(String accessToken) throws APIManagementException {
        String consumerKey;
        block10: {
            String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
            if (APIUtil.checkAccessTokenPartitioningEnabled() && APIUtil.checkUserNameAssertionEnabled()) {
                accessTokenStoreTable = APIUtil.getAccessTokenStoreTableFromAccessToken(accessToken);
            }
            Connection connection = null;
            PreparedStatement smt = null;
            ResultSet rs = null;
            consumerKey = null;
            try {
                String getConsumerKeySql = "SELECT CONSUMER_KEY  FROM " + accessTokenStoreTable + " WHERE ACCESS_TOKEN=?";
                connection = APIMgtDBUtil.getConnection();
                smt = connection.prepareStatement(getConsumerKeySql);
                smt.setString(1, APIUtil.encryptToken(accessToken));
                rs = smt.executeQuery();
                while (rs.next()) {
                    consumerKey = rs.getString(1);
                }
                if (consumerKey != null) {
                    consumerKey = APIUtil.decryptToken(consumerKey);
                }
                APIMgtDBUtil.closeAllConnections(smt, connection, rs);
            }
            catch (SQLException e) {
                ApiMgtDAO.handleException("Error while getting authorized domians.", e);
            }
            catch (CryptoException e2) {
                ApiMgtDAO.handleException("Error while getting authorized domians.", e2);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                APIMgtDBUtil.closeAllConnections(smt, connection, rs);
            }
        }
        return consumerKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addComment(APIIdentifier identifier, String commentText, String user) throws APIManagementException {
        Connection connection = null;
        ResultSet resultSet = null;
        PreparedStatement prepStmt = null;
        int commentId = -1;
        int apiId = -1;
        try {
            connection = APIMgtDBUtil.getConnection();
            String getApiQuery = "SELECT API_ID FROM AM_API API WHERE API_PROVIDER = ? AND API_NAME = ? AND API_VERSION = ?";
            prepStmt = connection.prepareStatement(getApiQuery);
            prepStmt.setString(1, APIUtil.replaceEmailDomainBack(identifier.getProviderName()));
            prepStmt.setString(2, identifier.getApiName());
            prepStmt.setString(3, identifier.getVersion());
            resultSet = prepStmt.executeQuery();
            if (resultSet.next()) {
                apiId = resultSet.getInt("API_ID");
            }
            resultSet.close();
            prepStmt.close();
            if (apiId == -1) {
                String msg = "Unable to get the API ID for: " + identifier;
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            String addCommentQuery = "INSERT INTO AM_API_COMMENTS (COMMENT_TEXT,COMMENTED_USER,DATE_COMMENTED,API_ID) VALUES (?,?,?,?)";
            prepStmt = connection.prepareStatement(addCommentQuery, new String[]{"comment_id"});
            prepStmt.setString(1, commentText);
            prepStmt.setString(2, user);
            prepStmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()), Calendar.getInstance());
            prepStmt.setInt(4, apiId);
            prepStmt.executeUpdate();
            ResultSet rs = prepStmt.getGeneratedKeys();
            while (rs.next()) {
                commentId = Integer.valueOf(rs.getString(1));
            }
            prepStmt.close();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Failed to rollback the add comment ", (Throwable)e);
                    }
                }
                ApiMgtDAO.handleException("Failed to add comment data, for  " + identifier.getApiName() + "-" + identifier.getVersion(), e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, resultSet);
        return commentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comment[] getComments(APIIdentifier identifier) throws APIManagementException {
        ArrayList<Comment> commentList = new ArrayList<Comment>();
        Connection connection = null;
        ResultSet resultSet = null;
        PreparedStatement prepStmt = null;
        String sqlQuery = "SELECT    AM_API_COMMENTS.COMMENT_TEXT AS COMMENT_TEXT,   AM_API_COMMENTS.COMMENTED_USER AS COMMENTED_USER,   AM_API_COMMENTS.DATE_COMMENTED AS DATE_COMMENTED FROM    AM_API_COMMENTS,    AM_API API WHERE    API.API_PROVIDER = ?    AND API.API_NAME = ?    AND API.API_VERSION  = ?    AND API.API_ID = AM_API_COMMENTS.API_ID";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, APIUtil.replaceEmailDomainBack(identifier.getProviderName()));
            prepStmt.setString(2, identifier.getApiName());
            prepStmt.setString(3, identifier.getVersion());
            resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                Comment comment = new Comment();
                comment.setText(resultSet.getString("COMMENT_TEXT"));
                comment.setUser(resultSet.getString("COMMENTED_USER"));
                comment.setCreatedTime(new Date(resultSet.getTimestamp("DATE_COMMENTED").getTime()));
                commentList.add(comment);
            }
        }
        catch (SQLException e) {
            try {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to retrieve comments ", (Throwable)e);
                }
                ApiMgtDAO.handleException("Failed to retrieve comments for  " + identifier.getApiName() + "-" + identifier.getVersion(), e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, resultSet);
        return commentList.toArray(new Comment[commentList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isContextExist(String context) {
        Connection connection = null;
        ResultSet resultSet = null;
        PreparedStatement prepStmt = null;
        String sql = "SELECT CONTEXT FROM AM_API  WHERE CONTEXT= ?";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, context);
            resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                if (resultSet.getString(1) == null) continue;
                boolean bl = true;
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, resultSet);
                return bl;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, resultSet);
        }
        catch (SQLException e) {
            log.error((Object)"Failed to retrieve the API Context ", (Throwable)e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, resultSet);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAllAvailableContexts() {
        ArrayList<String> contexts = new ArrayList<String>();
        Connection connection = null;
        ResultSet resultSet = null;
        PreparedStatement prepStmt = null;
        String sql = "SELECT CONTEXT FROM AM_API ";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(sql);
            resultSet = prepStmt.executeQuery();
            while (resultSet.next()) {
                contexts.add(resultSet.getString("CONTEXT"));
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Failed to retrieve the API Context ", (Throwable)e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, resultSet);
        return contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateAppRegistrationWorkflowDTO(ApplicationRegistrationWorkflowDTO workflowDTO) throws APIManagementException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Application application = null;
        Subscriber subscriber = null;
        String registrationEntry = "SELECT APP.APPLICATION_ID,APP.NAME,APP.SUBSCRIBER_ID,APP.APPLICATION_TIER,REG.TOKEN_TYPE,APP.CALLBACK_URL,APP.DESCRIPTION,APP.APPLICATION_STATUS,SUB.USER_ID,REG.ALLOWED_DOMAINS,REG.VALIDITY_PERIOD FROM AM_APPLICATION_REGISTRATION REG,AM_APPLICATION APP,AM_SUBSCRIBER SUB WHERE REG.SUBSCRIBER_ID=SUB.SUBSCRIBER_ID AND REG.APP_ID = APP.APPLICATION_ID AND REG.WF_REF=?";
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(registrationEntry);
            ps.setString(1, workflowDTO.getExternalWorkflowReference());
            rs = ps.executeQuery();
            while (rs.next()) {
                subscriber = new Subscriber(rs.getString("USER_ID"));
                subscriber.setId(rs.getInt("SUBSCRIBER_ID"));
                application = new Application(rs.getString("NAME"), subscriber);
                application.setId(rs.getInt("APPLICATION_ID"));
                application.setApplicationWorkFlowStatus(rs.getString("APPLICATION_STATUS"));
                application.setCallbackUrl(rs.getString("CALLBACK_URL"));
                application.setDescription(rs.getString("DESCRIPTION"));
                application.setTier(rs.getString("APPLICATION_TIER"));
                workflowDTO.setApplication(application);
                workflowDTO.setKeyType(rs.getString("TOKEN_TYPE"));
                workflowDTO.setUserName(subscriber.getName());
                workflowDTO.setDomainList(rs.getString("ALLOWED_DOMAINS"));
                workflowDTO.setValidityTime(rs.getLong("VALIDITY_PERIOD"));
            }
            ps.close();
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error occurred while retrieving an Application Registration Entry for Workflow : " + workflowDTO.getExternalWorkflowReference(), e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationRegistrationWorkflowDTO populateAppRegistrationWorkflowDTO(int appId) throws APIManagementException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ApplicationRegistrationWorkflowDTO workflowDTO = null;
        String registrationEntry = "SELECT REG.TOKEN_TYPE,REG.ALLOWED_DOMAINS,REG.VALIDITY_PERIOD FROM AM_APPLICATION_REGISTRATION REG, AM_APPLICATION APP  WHERE REG.APP_ID = APP.APPLICATION_ID AND APP.APPLICATION_ID=?";
        try {
            conn = APIMgtDBUtil.getConnection();
            ps = conn.prepareStatement(registrationEntry);
            ps.setInt(1, appId);
            rs = ps.executeQuery();
            while (rs.next()) {
                workflowDTO = (ApplicationRegistrationWorkflowDTO)WorkflowExecutorFactory.getInstance().createWorkflowDTO("AM_APPLICATION_REGISTRATION_PRODUCTION");
                workflowDTO.setKeyType(rs.getString("TOKEN_TYPE"));
                workflowDTO.setDomainList(rs.getString("ALLOWED_DOMAINS"));
                workflowDTO.setValidityTime(rs.getLong("VALIDITY_PERIOD"));
            }
            ps.close();
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error occurred while retrieving an Application Registration Entry for Application ID : " + appId, e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        return workflowDTO;
    }

    private boolean isUserLoggedInEmail(String userId) {
        return userId.contains("@");
    }

    private boolean isSecondaryLogin(String userId) {
        Map loginConfiguration = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getLoginConfiguration();
        if (loginConfiguration.get("EmailLogin") != null) {
            Map emailConf = (Map)loginConfiguration.get("EmailLogin");
            if ("true".equalsIgnoreCase((String)emailConf.get("primary"))) {
                return !this.isUserLoggedInEmail(userId);
            }
            if ("false".equalsIgnoreCase((String)emailConf.get("primary"))) {
                return this.isUserLoggedInEmail(userId);
            }
        }
        if (loginConfiguration.get("UserIdLogin") != null) {
            Map userIdConf = (Map)loginConfiguration.get("UserIdLogin");
            if ("true".equalsIgnoreCase((String)userIdConf.get("primary"))) {
                return this.isUserLoggedInEmail(userId);
            }
            if ("false".equalsIgnoreCase((String)userIdConf.get("primary"))) {
                return !this.isUserLoggedInEmail(userId);
            }
        }
        return false;
    }

    private String getPrimaryloginFromSecondary(String login) throws APIManagementException {
        Map loginConfiguration = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getLoginConfiguration();
        String claimURI = null;
        String username = null;
        if (this.isUserLoggedInEmail(login)) {
            Map emailConf = (Map)loginConfiguration.get("EmailLogin");
            claimURI = (String)emailConf.get("ClaimUri");
        } else {
            Map userIdConf = (Map)loginConfiguration.get("UserIdLogin");
            claimURI = (String)userIdConf.get("ClaimUri");
        }
        try {
            RemoteUserManagerClient rmUserlient = new RemoteUserManagerClient(login);
            String[] user = rmUserlient.getUserList(claimURI, login);
            if (user.length > 0) {
                username = user[0].toString();
            }
        }
        catch (Exception e) {
            ApiMgtDAO.handleException("Error while retriivng the primaryLogin name using seconadry loginanme : " + login, e);
        }
        return username;
    }

    private String getLoginUserName(String userID) throws APIManagementException {
        String primaryLogin = userID;
        if (this.isSecondaryLogin(userID)) {
            primaryLogin = this.getPrimaryloginFromSecondary(userID);
        }
        return primaryLogin;
    }

    private long getApplicationAccessTokenValidityPeriod() {
        return OAuthServerConfiguration.getInstance().getApplicationAccessTokenValidityPeriodInSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean addExternalAPIStoresDetails(APIIdentifier apiId, Set<APIStore> apiStoreSet) throws APIManagementException {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean state = false;
        try {
            conn = APIMgtDBUtil.getConnection();
            String sqlQuery = "INSERT INTO AM_EXTERNAL_STORES (API_ID, STORE_ID,STORE_DISPLAY_NAME, STORE_ENDPOINT,STORE_TYPE) VALUES (?,?,?,?,?)";
            int apiIdentifier = ApiMgtDAO.getAPIID(apiId, conn);
            if (apiIdentifier == -1) {
                String msg = "Could not load API record for: " + apiId.getApiName();
                log.error((Object)msg);
            }
            ps = conn.prepareStatement(sqlQuery);
            Iterator<APIStore> it = apiStoreSet.iterator();
            while (it.hasNext()) {
                APIStore storeObject;
                APIStore store = storeObject = it.next();
                ps.setInt(1, apiIdentifier);
                ps.setString(2, store.getName());
                ps.setString(3, store.getDisplayName());
                ps.setString(4, store.getEndpoint());
                ps.setString(5, store.getType());
                ps.addBatch();
            }
            ps.executeBatch();
            conn.commit();
            state = true;
            APIMgtDBUtil.closeAllConnections(ps, conn, null);
            return state;
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback storing external apistore details ", (Throwable)e);
                }
            }
            log.error((Object)"Failed to store external apistore details", (Throwable)e);
            state = false;
            APIMgtDBUtil.closeAllConnections(ps, conn, null);
            return state;
        }
        catch (APIManagementException e2) {
            log.error((Object)"Failed to store external apistore details", (Throwable)e2);
            state = false;
            return state;
            {
                catch (Throwable throwable) {}
            }
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, null);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean deleteExternalAPIStoresDetails(APIIdentifier apiId, Set<APIStore> apiStoreSet) throws APIManagementException {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean state = false;
        try {
            conn = APIMgtDBUtil.getConnection();
            String sqlQuery = "DELETE FROM AM_EXTERNAL_STORES WHERE API_ID=? AND STORE_ID=? AND STORE_TYPE=?";
            int apiIdentifier = ApiMgtDAO.getAPIID(apiId, conn);
            if (apiIdentifier == -1) {
                String msg = "Could not load API record for: " + apiId.getApiName();
                log.error((Object)msg);
            }
            ps = conn.prepareStatement(sqlQuery);
            Iterator<APIStore> it = apiStoreSet.iterator();
            while (it.hasNext()) {
                APIStore storeObject;
                APIStore store = storeObject = it.next();
                ps.setInt(1, apiIdentifier);
                ps.setString(2, store.getName());
                ps.setString(3, store.getType());
                ps.addBatch();
            }
            ps.executeBatch();
            conn.commit();
            state = true;
            APIMgtDBUtil.closeAllConnections(ps, conn, null);
            return state;
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback deleting external apistore details ", (Throwable)e);
                }
            }
            log.error((Object)"Failed to delete external apistore details", (Throwable)e);
            state = false;
            APIMgtDBUtil.closeAllConnections(ps, conn, null);
            return state;
        }
        catch (APIManagementException e2) {
            log.error((Object)"Failed to delete external apistore details", (Throwable)e2);
            state = false;
            return state;
            {
                catch (Throwable throwable) {}
            }
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, null);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExternalAPIStoresDetails(APIIdentifier apiId, Set<APIStore> apiStoreSet) throws APIManagementException {
        Connection conn = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            this.updateExternalAPIStoresDetails(apiId, apiStoreSet, conn);
            conn.commit();
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback updating external apistore details ", (Throwable)e);
                }
            }
            log.error((Object)"Failed to update external apistore details", (Throwable)e);
        }
        catch (APIManagementException e) {
            log.error((Object)"Failed to updating external apistore details", (Throwable)e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(null, conn, null);
        }
    }

    public void updateExternalAPIStoresDetails(APIIdentifier apiIdentifier, Set<APIStore> apiStoreSet, Connection conn) throws APIManagementException, SQLException {
        try {
            conn = APIMgtDBUtil.getConnection();
            String sqlQuery = "UPDATE AM_EXTERNAL_STORES SET    STORE_ENDPOINT = ?    ,STORE_TYPE = ? WHERE    API_ID = ? AND STORE_ID=?";
            PreparedStatement ps = conn.prepareStatement(sqlQuery);
            int apiId = ApiMgtDAO.getAPIID(apiIdentifier, conn);
            if (apiId == -1) {
                String msg = "Could not load API record for: " + apiIdentifier.getApiName();
                log.error((Object)msg);
            }
            Iterator<APIStore> it = apiStoreSet.iterator();
            while (it.hasNext()) {
                APIStore storeObject;
                APIStore store = storeObject = it.next();
                ps.setString(1, store.getEndpoint());
                ps.setString(2, store.getType());
                ps.setInt(3, apiId);
                ps.setString(4, store.getName());
                ps.addBatch();
            }
            ps.executeBatch();
            ps.clearBatch();
        }
        catch (SQLException e) {
            log.error((Object)"Error while updating External APIStore details to the database for API : ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<APIStore> getExternalAPIStoresDetails(APIIdentifier apiId) throws APIManagementException {
        Connection conn = null;
        HashSet<APIStore> storesSet = new HashSet();
        try {
            conn = APIMgtDBUtil.getConnection();
            storesSet = this.getExternalAPIStoresDetails(apiId, conn);
            conn.commit();
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    log.error((Object)"Failed to rollback getting external apistore details ", (Throwable)e);
                }
            }
            log.error((Object)"Failed to get external apistore details", (Throwable)e);
        }
        catch (APIManagementException e) {
            log.error((Object)"Failed to get external apistore details", (Throwable)e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(null, conn, null);
        }
        return storesSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<APIStore> getExternalAPIStoresDetails(APIIdentifier apiIdentifier, Connection conn) throws APIManagementException, SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<APIStore> storesSet = new HashSet<APIStore>();
        try {
            conn = APIMgtDBUtil.getConnection();
            String sqlQuery = "SELECT    ES.STORE_ID,    ES.STORE_DISPLAY_NAME,    ES.STORE_ENDPOINT,    ES.STORE_TYPE FROM    AM_EXTERNAL_STORES ES WHERE    ES.API_ID = ? ";
            ps = conn.prepareStatement(sqlQuery);
            int apiId = ApiMgtDAO.getAPIID(apiIdentifier, conn);
            if (apiId == -1) {
                String msg = "Could not load API record for: " + apiIdentifier.getApiName();
                log.error((Object)msg);
                throw new APIManagementException(msg);
            }
            ps.setInt(1, apiId);
            rs = ps.executeQuery();
            while (rs.next()) {
                APIStore store = new APIStore();
                store.setName(rs.getString("STORE_ID"));
                store.setDisplayName(rs.getString("STORE_DISPLAY_NAME"));
                store.setEndpoint(rs.getString("STORE_ENDPOINT"));
                store.setType(rs.getString("STORE_TYPE"));
                store.setPublished(true);
                storesSet.add(store);
            }
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error while getting External APIStore details from the database for  the API : " + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion(), e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, rs);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        return storesSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScopes(Set<?> objects, int api_id, int tenantID) throws APIManagementException {
        Connection conn = null;
        PreparedStatement ps = null;
        PreparedStatement ps2 = null;
        ResultSet rs = null;
        String scopeEntry = "INSERT INTO  IDN_OAUTH2_SCOPE (SCOPE_KEY, NAME , DESCRIPTION, TENANT_ID, ROLES)  VALUES(?,?,?,?,?)";
        String scopeLink = "INSERT INTO  AM_API_SCOPES (API_ID, SCOPE_ID)  VALUES(?,?)";
        try {
            conn = APIMgtDBUtil.getConnection();
            conn.setAutoCommit(false);
            String scopeId = "SCOPE_ID";
            if (conn.getMetaData().getDriverName().contains("PostgreSQL")) {
                scopeId = scopeId.toLowerCase();
            }
            if (objects != null) {
                for (Object object : objects) {
                    ps = conn.prepareStatement(scopeEntry, new String[]{scopeId});
                    ps2 = conn.prepareStatement(scopeLink);
                    if (object instanceof URITemplate) {
                        URITemplate uriTemplate = (URITemplate)object;
                        if (uriTemplate.getScope() == null) continue;
                        ps.setString(1, uriTemplate.getScope().getKey());
                        ps.setString(2, uriTemplate.getScope().getName());
                        ps.setString(3, uriTemplate.getScope().getDescription());
                        ps.setInt(4, tenantID);
                        ps.setString(5, uriTemplate.getScope().getRoles());
                        ps.execute();
                        rs = ps.getGeneratedKeys();
                        if (rs.next()) {
                            uriTemplate.getScope().setId(rs.getInt(1));
                        }
                        ps.close();
                        ps2.setInt(1, api_id);
                        ps2.setInt(2, uriTemplate.getScope().getId());
                        ps2.execute();
                        ps2.close();
                        conn.commit();
                        continue;
                    }
                    if (!(object instanceof Scope)) continue;
                    Scope scope = (Scope)object;
                    ps.setString(1, scope.getKey());
                    ps.setString(2, scope.getName());
                    ps.setString(3, scope.getDescription());
                    ps.setInt(4, tenantID);
                    ps.setString(5, scope.getRoles());
                    ps.execute();
                    rs = ps.getGeneratedKeys();
                    if (rs.next()) {
                        scope.setId(rs.getInt(1));
                    }
                    ps.close();
                    ps2.setInt(1, api_id);
                    ps2.setInt(2, scope.getId());
                    ps2.execute();
                    ps2.close();
                    conn.commit();
                }
            }
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e1) {
                ApiMgtDAO.handleException("Error occurred while Roling back changes done on Scopes Creation", e1);
            }
            ApiMgtDAO.handleException("Error occurred while creating scopes ", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Scope> getAPIScopes(APIIdentifier identifier) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        LinkedHashSet<Scope> scopes = new LinkedHashSet<Scope>();
        int apiId = -1;
        try {
            conn = APIMgtDBUtil.getConnection();
            apiId = ApiMgtDAO.getAPIID(identifier, conn);
            String sqlQuery = "SELECT A.SCOPE_ID, A.SCOPE_KEY, A.NAME, A.DESCRIPTION, A.ROLES FROM IDN_OAUTH2_SCOPE AS A INNER JOIN AM_API_SCOPES AS B ON A.SCOPE_ID = B.SCOPE_ID WHERE B.API_ID = ?";
            if (conn.getMetaData().getDriverName().contains("Oracle")) {
                sqlQuery = "SELECT A.SCOPE_ID, A.SCOPE_KEY, A.NAME, A.DESCRIPTION, A.ROLES FROM IDN_OAUTH2_SCOPE A INNER JOIN AM_API_SCOPES B ON A.SCOPE_ID = B.SCOPE_ID WHERE B.API_ID = ?";
            }
            ps = conn.prepareStatement(sqlQuery);
            ps.setInt(1, apiId);
            resultSet = ps.executeQuery();
            while (resultSet.next()) {
                Scope scope = new Scope();
                scope.setId(resultSet.getInt(1));
                scope.setKey(resultSet.getString(2));
                scope.setName(resultSet.getString(3));
                scope.setDescription(resultSet.getString(4));
                scope.setRoles(resultSet.getString(5));
                scopes.add(scope);
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to retrieve api scopes ", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        return scopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Scope> getAPIScopesByScopeKey(String scopeKey, int tenantId) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        LinkedHashSet<Scope> scopes = new LinkedHashSet<Scope>();
        try {
            conn = APIMgtDBUtil.getConnection();
            String sqlQuery = "SELECT IAS.SCOPE_ID, IAS.SCOPE_KEY, IAS.NAME, IAS.DESCRIPTION, IAS.TENANT_ID, IAS.ROLES FROM IDN_OAUTH2_SCOPE IAS WHERE SCOPE_KEY = ? AND TENANT_ID = ?";
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, scopeKey);
            ps.setInt(2, tenantId);
            resultSet = ps.executeQuery();
            while (resultSet.next()) {
                Scope scope = new Scope();
                scope.setId(resultSet.getInt("SCOPE_ID"));
                scope.setKey(resultSet.getString("SCOPE_KEY"));
                scope.setName(resultSet.getString("NAME"));
                scope.setDescription(resultSet.getString("DESCRIPTION"));
                scope.setRoles(resultSet.getString("ROLES"));
                scopes.add(scope);
            }
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Failed to retrieve api scopes ", e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        return scopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateScopes(API api, int tenantId) throws APIManagementException {
        String deleteScopes;
        int apiId;
        PreparedStatement prepStmt;
        Connection connection;
        block5: {
            connection = null;
            prepStmt = null;
            apiId = -1;
            deleteScopes = "DELETE FROM IDN_OAUTH2_SCOPE WHERE SCOPE_ID IN ( SELECT SCOPE_ID FROM AM_API_SCOPES WHERE API_ID = ? )";
            connection = APIMgtDBUtil.getConnection();
            apiId = ApiMgtDAO.getAPIID(api.getId(), connection);
            if (apiId != -1) break block5;
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
            return;
        }
        try {
            prepStmt = connection.prepareStatement(deleteScopes);
            prepStmt.setInt(1, apiId);
            prepStmt.execute();
            prepStmt.close();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Error while deleting Scopes for API : " + api.getId().toString(), e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
        }
        APIMgtDBUtil.closeAllConnections(prepStmt, connection, null);
        this.addScopes(api.getUriTemplates(), apiId, tenantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getResourceToScopeMapping(APIIdentifier identifier) throws APIManagementException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        HashMap<String, String> map = new HashMap<String, String>();
        int apiId = -1;
        try {
            conn = APIMgtDBUtil.getConnection();
            apiId = ApiMgtDAO.getAPIID(identifier, conn);
            String sqlQuery = "SELECT RS.RESOURCE_PATH, S.SCOPE_KEY FROM IDN_OAUTH2_RESOURCE_SCOPE RS INNER JOIN IDN_OAUTH2_SCOPE S ON S.SCOPE_ID = RS.SCOPE_ID INNER JOIN AM_API_SCOPES A ON A.SCOPE_ID = RS.SCOPE_ID WHERE A.API_ID = ? ";
            ps = conn.prepareStatement(sqlQuery);
            ps.setInt(1, apiId);
            resultSet = ps.executeQuery();
            while (resultSet.next()) {
                map.put(resultSet.getString(1), resultSet.getString(2));
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Failed to retrieve api scopes ", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> getScopeRolesOfApplication(String consumerKey) throws APIManagementException {
        HashMap<String, String> hashMap;
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        try {
            conn = APIMgtDBUtil.getConnection();
            String sqlQuery = "SELECT IOS.SCOPE_KEY, IOS.ROLES FROM IDN_OAUTH2_SCOPE IOS, AM_APPLICATION_KEY_MAPPING AKM, AM_SUBSCRIPTION SUB, AM_API_SCOPES SCOPE WHERE AKM.CONSUMER_KEY = ? AND AKM.APPLICATION_ID = SUB.APPLICATION_ID AND SUB.API_ID = SCOPE.API_ID AND SCOPE.SCOPE_ID = IOS.SCOPE_ID";
            ps = conn.prepareStatement(sqlQuery);
            ps.setString(1, consumerKey);
            resultSet = ps.executeQuery();
            HashMap<String, String> scopes = new HashMap<String, String>();
            while (resultSet.next()) {
                scopes.put(resultSet.getString("SCOPE_KEY"), resultSet.getString("ROLES"));
            }
            hashMap = scopes;
        }
        catch (SQLException e) {
            try {
                ApiMgtDAO.handleException("Failed to retrieve scopes of applicaltion " + consumerKey, e);
            }
            catch (Throwable throwable) {
                APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
                throw throwable;
            }
            APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
            return null;
        }
        APIMgtDBUtil.closeAllConnections(ps, conn, resultSet);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAPIScope(APIIdentifier apiIdentifier) throws APIManagementException {
        Set<Scope> scopes = ApiMgtDAO.getAPIScopes(apiIdentifier);
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int scopeId = -1;
        int apiId = -1;
        String deleteAPIScopeQuery = "DELETE FROM AM_API_SCOPES WHERE API_ID = ?";
        String deleteOauth2ScopeQuery = "DELETE FROM IDN_OAUTH2_SCOPE  WHERE SCOPE_ID = ?";
        String deleteOauth2ResourceScopeQuery = "DELETE FROM IDN_OAUTH2_RESOURCE_SCOPE  WHERE SCOPE_ID = ?";
        try {
            connection = APIMgtDBUtil.getConnection();
            prepStmt = connection.prepareStatement(deleteAPIScopeQuery);
            prepStmt.setInt(1, apiId);
            prepStmt.execute();
            if (!scopes.isEmpty()) {
                Iterator<Scope> scopeItr = scopes.iterator();
                while (scopeItr.hasNext()) {
                    scopeId = scopeItr.next().getId();
                    prepStmt = connection.prepareStatement(deleteOauth2ResourceScopeQuery);
                    prepStmt.setInt(1, scopeId);
                    prepStmt.execute();
                    prepStmt = connection.prepareStatement(deleteOauth2ScopeQuery);
                    prepStmt.setInt(1, scopeId);
                    prepStmt.execute();
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            ApiMgtDAO.handleException("Error while removing the scopes for the API: " + apiIdentifier.getApiName() + " from the database", e);
        }
        finally {
            APIMgtDBUtil.closeAllConnections(prepStmt, connection, rs);
        }
    }

    private static class SubscriptionInfo {
        private int subscriptionId;
        private String tierId;
        private String context;
        private int applicationId;
        private String accessToken;
        private String tokenType;

        private SubscriptionInfo() {
        }
    }
}

