/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ServiceContext;
import org.wso2.carbon.apimgt.handlers.security.stub.APIAuthenticationServiceStub;
import org.wso2.carbon.apimgt.handlers.security.stub.types.APIKeyMapping;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.dto.Environment;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;

public class APIAuthenticationAdminClient {
    private APIAuthenticationServiceStub stub;

    public APIAuthenticationAdminClient(Environment environment) throws AxisFault {
        this.stub = new APIAuthenticationServiceStub(null, this.getServiceEndpointToClearCache(environment, "APIAuthenticationService"));
        this.setup((Stub)this.stub, environment);
    }

    public void invalidateKeys(List<APIKeyMapping> mappings) throws AxisFault {
        try {
            this.stub.invalidateKeys(mappings.toArray(new APIKeyMapping[mappings.size()]));
        }
        catch (Exception e) {
            throw new AxisFault("Error while invalidating API keys", (Throwable)e);
        }
    }

    public void invalidateOAuthKeys(String consumerKey, String authUser) throws AxisFault {
        try {
            this.stub.invalidateOAuthKeys(consumerKey, authUser);
        }
        catch (Exception e) {
            throw new AxisFault("Error while invalidating API keys", (Throwable)e);
        }
    }

    public void invalidateResourceCache(String apiContext, String apiVersion, String resourceURLContext, String httpVerb) throws AxisFault {
        try {
            this.stub.invalidateResourceCache(apiContext, apiVersion, resourceURLContext, httpVerb);
        }
        catch (Exception e) {
            throw new AxisFault("Error while invalidating API keys", (Throwable)e);
        }
    }

    protected void setup(Stub stub, Environment environment) throws AxisFault {
        Boolean keyMgtKeyCacheEnabled;
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        String cookie = null;
        boolean loggedIn = false;
        String keyMgtKeyCacheEnabledString = config.getFirstProperty("APIKeyManager.EnableKeyMgtValidationInfoCache");
        if (keyMgtKeyCacheEnabledString != null && (keyMgtKeyCacheEnabled = Boolean.valueOf(Boolean.parseBoolean(keyMgtKeyCacheEnabledString))).booleanValue()) {
            loggedIn = true;
            cookie = this.loginKeyMgt();
        }
        if (!loggedIn) {
            loggedIn = true;
            cookie = this.loginGateway(environment);
        }
        ServiceClient client = stub._getServiceClient();
        Options options = client.getOptions();
        options.setTimeOutInMilliSeconds(900000L);
        options.setProperty("SO_TIMEOUT", (Object)900000);
        options.setProperty("CONNECTION_TIMEOUT", (Object)900000);
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    private String loginGateway(Environment environment) throws AxisFault {
        String host;
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        String user = environment.getUserName();
        String password = environment.getPassword();
        String url = environment.getServerURL();
        if (url == null || user == null || password == null) {
            throw new AxisFault("Required API gateway admin configuration unspecified");
        }
        try {
            host = new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            throw new AxisFault("API gateway URL is malformed", (Throwable)e);
        }
        AuthenticationAdminStub authAdminStub = new AuthenticationAdminStub(null, url + "AuthenticationAdmin");
        ServiceClient client = authAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        try {
            authAdminStub.login(user, password, host);
            ServiceContext serviceContext = authAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
            String sessionCookie = (String)serviceContext.getProperty("Cookie");
            return sessionCookie;
        }
        catch (RemoteException e) {
            throw new AxisFault("Error while contacting the authentication admin services", (Throwable)e);
        }
        catch (LoginAuthenticationExceptionException e) {
            throw new AxisFault("Error while authenticating against the API gateway admin", (Throwable)e);
        }
    }

    private String loginKeyMgt() throws AxisFault {
        String host;
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        String user = config.getFirstProperty("APIKeyManager.Username");
        String password = config.getFirstProperty("APIKeyManager.Password");
        String url = config.getFirstProperty("APIKeyManager.ServerURL");
        if (url == null || user == null || password == null) {
            throw new AxisFault("Required API keyMgt admin configuration unspecified");
        }
        try {
            host = new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            throw new AxisFault("API KeyMgt URL is malformed", (Throwable)e);
        }
        AuthenticationAdminStub authAdminStub = new AuthenticationAdminStub(null, url + "AuthenticationAdmin");
        ServiceClient client = authAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        try {
            authAdminStub.login(user, password, host);
            ServiceContext serviceContext = authAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
            String sessionCookie = (String)serviceContext.getProperty("Cookie");
            return sessionCookie;
        }
        catch (RemoteException e) {
            throw new AxisFault("Error while contacting the authentication admin services", (Throwable)e);
        }
        catch (LoginAuthenticationExceptionException e) {
            throw new AxisFault("Error while authenticating against the API keyMgt admin", (Throwable)e);
        }
    }

    private String getServiceEndpointToClearCache(Environment environment, String serviceName) {
        Boolean keyMgtKeyCacheEnabled;
        Boolean gatewayKeyCacheEnabled;
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        String gatewayKeyCacheEnabledString = config.getFirstProperty("APIGateway.EnableGatewayKeyCache");
        if (gatewayKeyCacheEnabledString != null && (gatewayKeyCacheEnabled = Boolean.valueOf(Boolean.parseBoolean(gatewayKeyCacheEnabledString))).booleanValue()) {
            return environment.getServerURL() + serviceName;
        }
        String keyMgtKeyCacheEnabledString = config.getFirstProperty("APIKeyManager.EnableKeyMgtValidationInfoCache");
        if (keyMgtKeyCacheEnabledString != null && (keyMgtKeyCacheEnabled = Boolean.valueOf(Boolean.parseBoolean(keyMgtKeyCacheEnabledString))).booleanValue()) {
            String url = config.getFirstProperty("APIKeyManager.ServerURL");
            return url + serviceName;
        }
        String url = environment.getServerURL();
        return url + serviceName;
    }
}

