/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.APIConstants;

public class APIDescriptionGenUtil {
    private static Log log = LogFactory.getLog(APIDescriptionGenUtil.class);
    private static final String DESCRIPTION = "Allows [1] request(s) per minute.";

    public static String generateDescriptionFromPolicy(OMElement policy) throws APIManagementException {
        OMElement maxCount = null;
        OMElement timeUnit = null;
        try {
            maxCount = policy.getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_CONTROL_ELEMENT).getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_MAXIMUM_COUNT_ELEMENT);
            timeUnit = policy.getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_CONTROL_ELEMENT).getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_UNIT_TIME_ELEMENT);
            if (maxCount.getText().isEmpty() || timeUnit.getText().isEmpty()) {
                String msg = APIConstants.THROTTLE_MAXIMUM_COUNT_ELEMENT.toString() + "or" + APIConstants.THROTTLE_UNIT_TIME_ELEMENT.toString() + " element data found empty in " + "the policy.";
                log.warn((Object)msg);
                throw new APIManagementException(msg);
            }
            long requestPerMinute = Long.parseLong(maxCount.getText().trim()) * 60000L / Long.parseLong(timeUnit.getText().trim());
            if (requestPerMinute >= 1L) {
                String description = DESCRIPTION.replaceAll("\\[1\\]", Long.toString(requestPerMinute));
                return description;
            }
            return DESCRIPTION;
        }
        catch (NullPointerException npe) {
            String msg = "Policy could not be parsed correctly based on http://schemas.xmlsoap.org/ws/2004/09/policy specification";
            log.warn((Object)msg);
            throw new APIManagementException(msg);
        }
    }

    public static Map<String, Object> getTierAttributes(OMElement policy) throws APIManagementException {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        OMElement attributes = null;
        try {
            OMElement tier = policy.getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.THROTTLE_CONTROL_ELEMENT).getFirstChildWithName(APIConstants.POLICY_ELEMENT).getFirstChildWithName(APIConstants.POLICY_ELEMENT);
            if (tier != null) {
                attributes = tier.getFirstChildWithName(APIConstants.THROTTLE_ATTRIBUTES_ELEMENT);
            }
            if (attributes == null) {
                return attributesMap;
            }
            Iterator childElements = attributes.getChildElements();
            while (childElements.hasNext()) {
                OMElement element = (OMElement)childElements.next();
                String displayName = element.getAttributeValue(new QName("displayName"));
                String localName = element.getLocalName();
                String attrName = displayName != null ? displayName : localName;
                String attrValue = element.getText();
                attributesMap.put(attrName, attrValue);
            }
        }
        catch (NullPointerException npe) {
            String msg = "Policy could not be parsed correctly based on http://schemas.xmlsoap.org/ws/2004/09/policy specification";
            log.warn((Object)msg);
            throw new APIManagementException(msg);
        }
        return attributesMap;
    }
}

