/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import com.ibm.wsdl.extensions.http.HTTPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12AddressImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.xml.WSDLWriter;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.xml.EndpointElement;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class APIMWSDLReader {
    private static javax.wsdl.factory.WSDLFactory wsdlFactoryInstance;
    private String baseURI;
    private static final String JAVAX_WSDL_VERBOSE_MODE = "javax.wsdl.verbose";
    private static final Log log;

    public APIMWSDLReader(String baseURI) {
        this.baseURI = baseURI;
    }

    private static javax.wsdl.factory.WSDLFactory getWsdlFactoryInstance() throws WSDLException {
        if (null == wsdlFactoryInstance) {
            wsdlFactoryInstance = javax.wsdl.factory.WSDLFactory.newInstance();
        }
        return wsdlFactoryInstance;
    }

    public OMElement readAndCleanWsdl(API api) throws APIManagementException {
        try {
            Definition wsdlDefinition = this.readWSDLFile();
            this.setServiceDefinition(wsdlDefinition, api);
            WSDLWriter writer = APIMWSDLReader.getWsdlFactoryInstance().newWSDLWriter();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            writer.writeWSDL(wsdlDefinition, (OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            OMElement wsdlElement = APIUtil.buildOMElement(byteArrayInputStream);
            return wsdlElement;
        }
        catch (Exception e) {
            String msg = " Error occurs when change the addres URL of the WSDL";
            log.error((Object)msg);
            throw new APIManagementException(msg, (Throwable)e);
        }
    }

    public OMElement readAndCleanWsdl2(API api) throws APIManagementException {
        try {
            Description wsdlDefinition = this.readWSDL2File();
            this.setServiceDefinitionForWSDL2(wsdlDefinition, api);
            org.apache.woden.WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            writer.writeWSDL(wsdlDefinition.toElement(), (OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            OMElement wsdlElement = APIUtil.buildOMElement(byteArrayInputStream);
            return wsdlElement;
        }
        catch (Exception e) {
            String msg = " Error occurs when change the addres URL of the WSDL";
            log.error((Object)msg);
            throw new APIManagementException(msg, (Throwable)e);
        }
    }

    private Description readWSDL2File() throws APIManagementException, WSDLException {
        javax.wsdl.xml.WSDLReader reader = APIMWSDLReader.getWsdlFactoryInstance().newWSDLReader();
        reader.setFeature(JAVAX_WSDL_VERBOSE_MODE, false);
        reader.setFeature("javax.wsdl.importDocuments", false);
        try {
            WSDLFactory wFactory = WSDLFactory.newInstance();
            WSDLReader wReader = wFactory.newWSDLReader();
            wReader.setFeature("http://ws.apache.org/woden/features/validation", true);
            Description wsdlDefinition1 = wReader.readWSDL(this.baseURI);
            return wsdlDefinition1;
        }
        catch (org.apache.woden.WSDLException e) {
            e.printStackTrace();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reading  the WSDL. Base uri is " + this.baseURI));
            }
            return null;
        }
    }

    private void setServiceDefinitionForWSDL2(Description definition, API api) throws APIManagementException {
        Service[] serviceMap = definition.getServices();
        URL addressURI = null;
        try {
            block2: for (Service svc : serviceMap) {
                Endpoint[] portMap;
                for (Endpoint endpoint : portMap = svc.getEndpoints()) {
                    EndpointElement element = endpoint.toElement();
                    addressURI = endpoint.getAddress().toURL();
                    if (addressURI == null) continue block2;
                    String endpointTransport = this.determineURLTransport(endpoint.getAddress().getScheme(), api.getTransports());
                    this.setAddressUrl(element, new URI(APIUtil.getGatewayendpoint(endpointTransport) + api.getContext() + "/" + api.getId().getVersion()));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occured while getting the wsdl address location", (Throwable)e);
            throw new APIManagementException((Throwable)e);
        }
    }

    private Definition readWSDLFile() throws APIManagementException, WSDLException {
        javax.wsdl.xml.WSDLReader reader = APIMWSDLReader.getWsdlFactoryInstance().newWSDLReader();
        reader.setFeature(JAVAX_WSDL_VERBOSE_MODE, false);
        reader.setFeature("javax.wsdl.importDocuments", false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading  the WSDL. Base uri is " + this.baseURI));
        }
        Definition wsdlDefinition = reader.readWSDL(this.baseURI);
        return wsdlDefinition;
    }

    private Definition readWSDLFile(API api) throws APIManagementException, WSDLException {
        javax.wsdl.xml.WSDLReader reader = APIMWSDLReader.getWsdlFactoryInstance().newWSDLReader();
        reader.setFeature(JAVAX_WSDL_VERBOSE_MODE, false);
        reader.setFeature("javax.wsdl.importDocuments", false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading  the WSDL. Base uri is " + this.baseURI));
        }
        Definition wsdlDefinition = reader.readWSDL(api.getWsdlUrl());
        return wsdlDefinition;
    }

    private void setServiceDefinition(Definition definition, API api) throws APIManagementException {
        Map serviceMap = definition.getAllServices();
        Iterator serviceItr = serviceMap.entrySet().iterator();
        URL addressURI = null;
        try {
            while (serviceItr.hasNext()) {
                Map.Entry svcEntry = serviceItr.next();
                javax.wsdl.Service svc = (javax.wsdl.Service)svcEntry.getValue();
                Map portMap = svc.getPorts();
                for (Map.Entry portEntry : portMap.entrySet()) {
                    ExtensibilityElement extensibilityElement;
                    Port port = (Port)portEntry.getValue();
                    List extensibilityElementList = port.getExtensibilityElements();
                    for (int i = 0; i < extensibilityElementList.size() && (addressURI = new URL(this.getAddressUrl(extensibilityElement = (ExtensibilityElement)port.getExtensibilityElements().get(i)))) != null; ++i) {
                        String endpointTransport = this.determineURLTransport(addressURI.getProtocol(), api.getTransports());
                        this.setAddressUrl(extensibilityElement, endpointTransport, api);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occured while getting the wsdl address location", (Throwable)e);
            throw new APIManagementException((Throwable)e);
        }
    }

    private String getAddressUrl(ExtensibilityElement exElement) throws APIManagementException {
        if (exElement instanceof SOAP12AddressImpl) {
            return ((SOAP12AddressImpl)exElement).getLocationURI();
        }
        if (exElement instanceof SOAPAddressImpl) {
            return ((SOAPAddressImpl)exElement).getLocationURI();
        }
        if (exElement instanceof HTTPAddressImpl) {
            return ((HTTPAddressImpl)exElement).getLocationURI();
        }
        String msg = "Unsupported WSDL errors!";
        log.error((Object)msg);
        throw new APIManagementException(msg);
    }

    private void setAddressUrl(ExtensibilityElement exElement, String transports, API api) throws APIManagementException {
        if (exElement instanceof SOAP12AddressImpl) {
            ((SOAP12AddressImpl)exElement).setLocationURI(APIUtil.getGatewayendpoint(transports) + api.getContext() + "/" + api.getId().getVersion());
        } else if (exElement instanceof SOAPAddressImpl) {
            ((SOAPAddressImpl)exElement).setLocationURI(APIUtil.getGatewayendpoint(transports) + api.getContext() + "/" + api.getId().getVersion());
        } else if (exElement instanceof HTTPAddressImpl) {
            ((HTTPAddressImpl)exElement).setLocationURI(APIUtil.getGatewayendpoint(transports) + api.getContext() + "/" + api.getId().getVersion());
        } else {
            String msg = "Unsupported WSDL errors!";
            log.error((Object)msg);
            throw new APIManagementException(msg);
        }
    }

    private void setAddressUrl(EndpointElement endpoint, URI uri) throws APIManagementException {
        endpoint.setAddress(uri);
    }

    public static String toString(ByteArrayInputStream is) {
        int size = is.available();
        char[] theChars = new char[size];
        byte[] bytes = new byte[size];
        is.read(bytes, 0, size);
        int i = 0;
        while (i < size) {
            theChars[i] = (char)(bytes[i++] & 0xFF);
        }
        return new String(theChars);
    }

    private String determineURLTransport(String scheme, String transports) {
        if (transports.equals("http,https") || transports.equals("https,http")) {
            if (scheme.equals("http")) {
                return "http";
            }
            if (scheme.startsWith("https")) {
                return "https";
            }
        }
        return transports;
    }

    static {
        log = LogFactory.getLog(APIMWSDLReader.class);
    }
}

