/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.DBConfiguration;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.LocalDatabaseCreator;

public final class APIMgtDBUtil {
    private static final Log log = LogFactory.getLog(APIMgtDBUtil.class);
    private static volatile DataSource dataSource = null;
    private static final String DB_CHECK_SQL = "SELECT * FROM AM_SUBSCRIBER";
    private static final String DB_CONFIG = "Database.";
    private static final String DB_DRIVER = "Database.Driver";
    private static final String DB_URL = "Database.URL";
    private static final String DB_USER = "Database.Username";
    private static final String DB_PASSWORD = "Database.Password";
    private static final String DATA_SOURCE_NAME = "DataSourceName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() throws Exception {
        if (dataSource != null) {
            return;
        }
        Class<APIMgtDBUtil> clazz = APIMgtDBUtil.class;
        synchronized (APIMgtDBUtil.class) {
            if (dataSource == null) {
                APIManagerConfiguration config;
                String dataSourceName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Initializing data source");
                }
                if ((dataSourceName = (config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration()).getFirstProperty(DATA_SOURCE_NAME)) != null) {
                    try {
                        InitialContext ctx = new InitialContext();
                        dataSource = (DataSource)ctx.lookup(dataSourceName);
                    }
                    catch (NamingException e) {
                        throw new APIManagementException("Error while looking up the data source: " + dataSourceName);
                    }
                } else {
                    DBConfiguration configuration = APIMgtDBUtil.getDBConfig(config);
                    String dbUrl = configuration.getDbUrl();
                    String driver = configuration.getDriverName();
                    String username = configuration.getUserName();
                    String password = configuration.getPassword();
                    if (dbUrl == null || driver == null || username == null || password == null) {
                        log.warn((Object)"Required DB configuration parameters unspecified. So API Store and API Publisher will not work as expected.");
                    }
                    BasicDataSource basicDataSource = new BasicDataSource();
                    basicDataSource.setDriverClassName(driver);
                    basicDataSource.setUrl(dbUrl);
                    basicDataSource.setUsername(username);
                    basicDataSource.setPassword(password);
                    dataSource = basicDataSource;
                }
            }
            APIMgtDBUtil.setupAPIManagerDatabase();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void setupAPIManagerDatabase() throws Exception {
        String value = System.getProperty("setup");
        if (value != null) {
            LocalDatabaseCreator databaseCreator = new LocalDatabaseCreator(dataSource);
            try {
                if (!databaseCreator.isDatabaseStructureCreated(DB_CHECK_SQL)) {
                    databaseCreator.createRegistryDatabase();
                } else {
                    log.info((Object)"APIManager database already exists. Not creating a new database.");
                }
            }
            catch (Exception e) {
                String msg = "Error in creating the APIManager database";
                throw new Exception(msg, e);
            }
        }
    }

    public static Connection getConnection() throws SQLException {
        if (dataSource != null) {
            return dataSource.getConnection();
        }
        throw new SQLException("Data source is not configured properly.");
    }

    public static void closeAllConnections(PreparedStatement preparedStatement, Connection connection, ResultSet resultSet) {
        APIMgtDBUtil.closeConnection(connection);
        APIMgtDBUtil.closeResultSet(resultSet);
        APIMgtDBUtil.closeStatement(preparedStatement);
    }

    private static void closeConnection(Connection dbConnection) {
        if (dbConnection != null) {
            try {
                dbConnection.close();
            }
            catch (SQLException e) {
                log.warn((Object)("Database error. Could not close database connection. Continuing with others. - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.warn((Object)("Database error. Could not close ResultSet  - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void closeStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.warn((Object)("Database error. Could not close PreparedStatement. Continuing with others. - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static DBConfiguration getDBConfig(APIManagerConfiguration config) {
        DBConfiguration dbConfiguration = new DBConfiguration();
        dbConfiguration.setDbUrl(config.getFirstProperty(DB_URL));
        dbConfiguration.setDriverName(config.getFirstProperty(DB_DRIVER));
        dbConfiguration.setUserName(config.getFirstProperty(DB_USER));
        dbConfiguration.setPassword(config.getFirstProperty(DB_PASSWORD));
        return dbConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromInputStream(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

