/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheConfiguration;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.doc.model.APIDefinition;
import org.wso2.carbon.apimgt.api.doc.model.APIResource;
import org.wso2.carbon.apimgt.api.doc.model.Operation;
import org.wso2.carbon.apimgt.api.doc.model.Parameter;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.APIStore;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DocumentationType;
import org.wso2.carbon.apimgt.api.model.Provider;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.auth.manager.RemoteAuthorizationManager;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;
import org.wso2.carbon.apimgt.impl.dto.Environment;
import org.wso2.carbon.apimgt.impl.internal.APIManagerComponent;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.APIDescriptionGenUtil;
import org.wso2.carbon.apimgt.impl.utils.APIMWSDLReader;
import org.wso2.carbon.apimgt.impl.utils.APINameComparator;
import org.wso2.carbon.apimgt.impl.utils.APIStoreNameComparator;
import org.wso2.carbon.apimgt.keymgt.client.SubscriberKeyMgtClient;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.ExceptionException;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.LoggedUserInfo;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.LoggedUserInfoAdminStub;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.endpoints.EndpointManager;
import org.wso2.carbon.governance.api.endpoints.dataobjects.Endpoint;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.registry.api.Collection;
import org.wso2.carbon.registry.app.Utils;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.realm.RegistryAuthorizationManager;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.solr.SolrClient;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.FileUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.xml.sax.SAXException;

public final class APIUtil {
    private static final Log log = LogFactory.getLog(APIUtil.class);
    private static boolean isContextCacheInitialized = false;
    private static Set<Integer> registryInitializedTenants = new HashSet<Integer>();
    private static GenericArtifactManager genericArtifactManager;

    public static API getAPI(GovernanceArtifact artifact, Registry registry) throws APIManagementException {
        API api;
        try {
            Tag[] tag;
            String providerName = artifact.getAttribute("overview_provider");
            String apiName = artifact.getAttribute("overview_name");
            String apiVersion = artifact.getAttribute("overview_version");
            APIIdentifier apiId = new APIIdentifier(providerName, apiName, apiVersion);
            api = new API(apiId);
            String artifactPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)artifact.getId());
            api.setRating(APIUtil.getAverageRating(apiId));
            api.setDescription(artifact.getAttribute("overview_description"));
            api.setLastUpdated(registry.get(artifactPath).getLastModified());
            api.setUrl(artifact.getAttribute("overview_endpointURL"));
            api.setSandboxUrl(artifact.getAttribute("overview_sandboxURL"));
            api.setStatus(APIUtil.getApiStatus(artifact.getAttribute("overview_status")));
            api.setThumbnailUrl(artifact.getAttribute("overview_thumbnail"));
            api.setWsdlUrl(artifact.getAttribute("overview_wsdl"));
            api.setWadlUrl(artifact.getAttribute("overview_wadl"));
            api.setTechnicalOwner(artifact.getAttribute("overview_technicalOwner"));
            api.setTechnicalOwnerEmail(artifact.getAttribute("overview_technicalOwnerEmail"));
            api.setBusinessOwner(artifact.getAttribute("overview_businessOwner"));
            api.setBusinessOwnerEmail(artifact.getAttribute("overview_businessOwnerEmail"));
            api.setVisibility(artifact.getAttribute("overview_visibility"));
            api.setVisibleRoles(artifact.getAttribute("overview_visibleRoles"));
            api.setVisibleTenants(artifact.getAttribute("overview_visibleTenants"));
            api.setEndpointSecured(Boolean.parseBoolean(artifact.getAttribute("overview_endpointSecured")));
            api.setEndpointUTUsername(artifact.getAttribute("overview_endpointUsername"));
            api.setEndpointUTPassword(artifact.getAttribute("overview_endpointPpassword"));
            api.setTransports(artifact.getAttribute("overview_transports"));
            api.setInSequence(artifact.getAttribute("overview_inSequence"));
            api.setOutSequence(artifact.getAttribute("overview_outSequence"));
            api.setFaultSequence(artifact.getAttribute("overview_faultSequence"));
            api.setResponseCache(artifact.getAttribute("overview_responseCaching"));
            api.setImplementation(artifact.getAttribute("overview_implementation"));
            int cacheTimeout = 300;
            try {
                cacheTimeout = Integer.parseInt(artifact.getAttribute("overview_cacheTimeout"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            api.setCacheTimeout(cacheTimeout);
            api.setEndpointConfig(artifact.getAttribute("overview_endpointConfig"));
            api.setRedirectURL(artifact.getAttribute("overview_redirectURL"));
            api.setApiOwner(artifact.getAttribute("overview_apiOwner"));
            api.setAdvertiseOnly(Boolean.parseBoolean(artifact.getAttribute("overview_advertiseOnly")));
            api.setSubscriptionAvailability(artifact.getAttribute("overview_subscriptionAvailability"));
            api.setSubscriptionAvailableTenants(artifact.getAttribute("overview_tenants"));
            api.setDestinationStatsEnabled(artifact.getAttribute("overview_destinationStatsEnabled"));
            String tenantDomainName = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack(providerName));
            int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomainName);
            HashSet<Tier> availableTier = new HashSet<Tier>();
            String tiers = artifact.getAttribute("overview_tier");
            Map<String, Tier> definedTiers = APIUtil.getTiers(tenantId);
            if (tiers != null && !"".equals(tiers)) {
                String[] tierNames;
                for (String tierName : tierNames = tiers.split("\\|\\|")) {
                    Tier definedTier = definedTiers.get(tierName);
                    if (definedTier != null) {
                        availableTier.add(definedTier);
                        continue;
                    }
                    log.warn((Object)("Unknown tier: " + tierName + " found on API: " + apiName));
                }
            }
            api.addAvailableTiers(availableTier);
            api.setContext(artifact.getAttribute("overview_context"));
            api.setLatest(Boolean.valueOf(artifact.getAttribute("overview_isLatest")).booleanValue());
            LinkedHashSet<URITemplate> uriTemplates = new LinkedHashSet<URITemplate>();
            ArrayList<String> uriTemplateNames = new ArrayList<String>();
            Set<Scope> scopes = ApiMgtDAO.getAPIScopes(api.getId());
            api.setScopes(scopes);
            HashMap<String, String> urlPatternsSet = ApiMgtDAO.getURITemplatesPerAPIAsString(api.getId());
            HashMap<String, String> resourceScopes = ApiMgtDAO.getResourceToScopeMapping(api.getId());
            Set<String> urlPatternsKeySet = urlPatternsSet.keySet();
            for (String urlPattern : urlPatternsKeySet) {
                URITemplate uriTemplate = new URITemplate();
                String[] urlPatternComponents = urlPattern.split("::");
                String uTemplate = urlPatternComponents.length >= 1 ? urlPatternComponents[0] : null;
                String method = urlPatternComponents.length >= 2 ? urlPatternComponents[1] : null;
                String authType = urlPatternComponents.length >= 3 ? urlPatternComponents[2] : null;
                String throttlingTier = urlPatternComponents.length >= 4 ? urlPatternComponents[3] : null;
                String mediationScript = urlPatternComponents.length >= 5 ? urlPatternComponents[4] : null;
                uriTemplate.setHTTPVerb(method);
                uriTemplate.setAuthType(authType);
                uriTemplate.setThrottlingTier(throttlingTier);
                uriTemplate.setHttpVerbs(method);
                uriTemplate.setAuthTypes(authType);
                uriTemplate.setUriTemplate(uTemplate);
                uriTemplate.setResourceURI(api.getUrl());
                uriTemplate.setResourceSandboxURI(api.getSandboxUrl());
                uriTemplate.setThrottlingTiers(throttlingTier);
                uriTemplate.setMediationScript(mediationScript);
                String resourceScopeKey = APIUtil.getResourceKey(api.getContext(), apiVersion, uTemplate, method);
                uriTemplate.setScopes(APIUtil.findScopeByKey(scopes, resourceScopes.get(resourceScopeKey)));
                if (uriTemplateNames.contains(uTemplate)) {
                    for (URITemplate tmp : uriTemplates) {
                        if (!uTemplate.equals(tmp.getUriTemplate())) continue;
                        tmp.setHttpVerbs(method);
                        tmp.setAuthTypes(authType);
                        tmp.setThrottlingTiers(throttlingTier);
                        resourceScopeKey = APIUtil.getResourceKey(api.getContext(), apiVersion, uTemplate, method);
                        tmp.setScopes(APIUtil.findScopeByKey(scopes, resourceScopes.get(resourceScopeKey)));
                        break;
                    }
                } else {
                    uriTemplates.add(uriTemplate);
                }
                uriTemplateNames.add(uTemplate);
            }
            api.setUriTemplates(uriTemplates);
            api.setAsDefaultVersion(Boolean.valueOf(artifact.getAttribute("overview_isDefaultVersion")).booleanValue());
            HashSet<String> tags = new HashSet<String>();
            for (Tag tag1 : tag = registry.getTags(artifactPath)) {
                tags.add(tag1.getTagName());
            }
            api.addTags(tags);
            api.setLastUpdated(registry.get(artifactPath).getLastModified());
            api.setImplementation(artifact.getAttribute("overview_implementation"));
        }
        catch (GovernanceException e) {
            String msg = "Failed to get API for artifact ";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (RegistryException e) {
            String msg = "Failed to get LastAccess time or Rating";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (UserStoreException e) {
            String msg = "Failed to get User Realm of API Provider";
            throw new APIManagementException(msg, (Throwable)e);
        }
        return api;
    }

    public static API getAPIForPublishing(GovernanceArtifact artifact, Registry registry) throws APIManagementException {
        API api;
        try {
            Tag[] tag;
            String providerName = artifact.getAttribute("overview_provider");
            String apiName = artifact.getAttribute("overview_name");
            String apiVersion = artifact.getAttribute("overview_version");
            APIIdentifier apiId = new APIIdentifier(providerName, apiName, apiVersion);
            api = new API(apiId);
            String artifactPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)artifact.getId());
            api.setRating(APIUtil.getAverageRating(apiId));
            api.setDescription(artifact.getAttribute("overview_description"));
            api.setLastUpdated(registry.get(artifactPath).getLastModified());
            api.setUrl(artifact.getAttribute("overview_endpointURL"));
            api.setSandboxUrl(artifact.getAttribute("overview_sandboxURL"));
            api.setStatus(APIUtil.getApiStatus(artifact.getAttribute("overview_status")));
            api.setThumbnailUrl(artifact.getAttribute("overview_thumbnail"));
            api.setWsdlUrl(artifact.getAttribute("overview_wsdl"));
            api.setWadlUrl(artifact.getAttribute("overview_wadl"));
            api.setTechnicalOwner(artifact.getAttribute("overview_technicalOwner"));
            api.setTechnicalOwnerEmail(artifact.getAttribute("overview_technicalOwnerEmail"));
            api.setBusinessOwner(artifact.getAttribute("overview_businessOwner"));
            api.setBusinessOwnerEmail(artifact.getAttribute("overview_businessOwnerEmail"));
            api.setVisibility(artifact.getAttribute("overview_visibility"));
            api.setVisibleRoles(artifact.getAttribute("overview_visibleRoles"));
            api.setVisibleTenants(artifact.getAttribute("overview_visibleTenants"));
            api.setEndpointSecured(Boolean.parseBoolean(artifact.getAttribute("overview_endpointSecured")));
            api.setEndpointUTUsername(artifact.getAttribute("overview_endpointUsername"));
            api.setEndpointUTPassword(artifact.getAttribute("overview_endpointPpassword"));
            api.setTransports(artifact.getAttribute("overview_transports"));
            api.setInSequence(artifact.getAttribute("overview_inSequence"));
            api.setOutSequence(artifact.getAttribute("overview_outSequence"));
            api.setFaultSequence(artifact.getAttribute("overview_faultSequence"));
            api.setResponseCache(artifact.getAttribute("overview_responseCaching"));
            api.setImplementation(artifact.getAttribute("overview_implementation"));
            int cacheTimeout = 300;
            try {
                cacheTimeout = Integer.parseInt(artifact.getAttribute("overview_cacheTimeout"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            api.setCacheTimeout(cacheTimeout);
            api.setEndpointConfig(artifact.getAttribute("overview_endpointConfig"));
            api.setRedirectURL(artifact.getAttribute("overview_redirectURL"));
            api.setApiOwner(artifact.getAttribute("overview_apiOwner"));
            api.setAdvertiseOnly(Boolean.parseBoolean(artifact.getAttribute("overview_advertiseOnly")));
            api.setSubscriptionAvailability(artifact.getAttribute("overview_subscriptionAvailability"));
            api.setSubscriptionAvailableTenants(artifact.getAttribute("overview_tenants"));
            api.setDestinationStatsEnabled(artifact.getAttribute("overview_destinationStatsEnabled"));
            String tenantDomainName = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack(providerName));
            int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomainName);
            HashSet<Tier> availableTier = new HashSet<Tier>();
            String tiers = artifact.getAttribute("overview_tier");
            Map<String, Tier> definedTiers = APIUtil.getTiers(tenantId);
            if (tiers != null && !"".equals(tiers)) {
                String[] tierNames;
                for (String tierName : tierNames = tiers.split("\\|\\|")) {
                    Tier definedTier = definedTiers.get(tierName);
                    if (definedTier != null) {
                        availableTier.add(definedTier);
                        continue;
                    }
                    log.warn((Object)("Unknown tier: " + tierName + " found on API: " + apiName));
                }
            }
            api.addAvailableTiers(availableTier);
            api.setContext(artifact.getAttribute("overview_context"));
            api.setLatest(Boolean.valueOf(artifact.getAttribute("overview_isLatest")).booleanValue());
            LinkedHashSet<URITemplate> uriTemplates = new LinkedHashSet<URITemplate>();
            ArrayList<String> uriTemplateNames = new ArrayList<String>();
            Set<Scope> scopes = ApiMgtDAO.getAPIScopes(api.getId());
            api.setScopes(scopes);
            HashMap<String, String> urlPatternsSet = ApiMgtDAO.getURITemplatesPerAPIAsString(api.getId());
            HashMap<String, String> resourceScopes = ApiMgtDAO.getResourceToScopeMapping(api.getId());
            Set<String> urlPatternsKeySet = urlPatternsSet.keySet();
            for (String urlPattern : urlPatternsKeySet) {
                URITemplate uriTemplate = new URITemplate();
                String[] urlPatternComponents = urlPattern.split("::");
                String uTemplate = urlPatternComponents.length >= 1 ? urlPatternComponents[0] : null;
                String method = urlPatternComponents.length >= 2 ? urlPatternComponents[1] : null;
                String authType = urlPatternComponents.length >= 3 ? urlPatternComponents[2] : null;
                String throttlingTier = urlPatternComponents.length >= 4 ? urlPatternComponents[3] : null;
                String mediationScript = urlPatternComponents.length >= 5 ? urlPatternComponents[4] : null;
                uriTemplate.setHTTPVerb(method);
                uriTemplate.setAuthType(authType);
                uriTemplate.setThrottlingTier(throttlingTier);
                uriTemplate.setHttpVerbs(method);
                uriTemplate.setAuthTypes(authType);
                uriTemplate.setUriTemplate(uTemplate);
                uriTemplate.setResourceURI(api.getUrl());
                uriTemplate.setResourceSandboxURI(api.getSandboxUrl());
                uriTemplate.setThrottlingTiers(throttlingTier);
                uriTemplate.setMediationScript(mediationScript);
                uriTemplate.setMediationScripts(method, mediationScript);
                String resourceScopeKey = APIUtil.getResourceKey(api.getContext(), apiVersion, uTemplate, method);
                uriTemplate.setScopes(APIUtil.findScopeByKey(scopes, resourceScopes.get(resourceScopeKey)));
                if (uriTemplateNames.contains(uTemplate)) {
                    for (URITemplate tmp : uriTemplates) {
                        if (!uTemplate.equals(tmp.getUriTemplate())) continue;
                        tmp.setHttpVerbs(method);
                        tmp.setAuthTypes(authType);
                        tmp.setThrottlingTiers(throttlingTier);
                        tmp.setMediationScripts(method, mediationScript);
                        resourceScopeKey = APIUtil.getResourceKey(api.getContext(), apiVersion, uTemplate, method);
                        tmp.setScopes(APIUtil.findScopeByKey(scopes, resourceScopes.get(resourceScopeKey)));
                        break;
                    }
                } else {
                    uriTemplates.add(uriTemplate);
                }
                uriTemplateNames.add(uTemplate);
            }
            if (api.getImplementation().equalsIgnoreCase("INLINE")) {
                for (URITemplate template : uriTemplates) {
                    template.setMediationScript(template.getAggregatedMediationScript());
                }
            }
            api.setUriTemplates(uriTemplates);
            api.setAsDefaultVersion(Boolean.valueOf(artifact.getAttribute("overview_isDefaultVersion")).booleanValue());
            HashSet<String> tags = new HashSet<String>();
            for (Tag tag1 : tag = registry.getTags(artifactPath)) {
                tags.add(tag1.getTagName());
            }
            api.addTags(tags);
            api.setLastUpdated(registry.get(artifactPath).getLastModified());
            api.setImplementation(artifact.getAttribute("overview_implementation"));
        }
        catch (GovernanceException e) {
            String msg = "Failed to get API for artifact ";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (RegistryException e) {
            String msg = "Failed to get LastAccess time or Rating";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (UserStoreException e) {
            String msg = "Failed to get User Realm of API Provider";
            throw new APIManagementException(msg, (Throwable)e);
        }
        return api;
    }

    public static API getAPI(GovernanceArtifact artifact) throws APIManagementException {
        API api;
        try {
            String providerName = artifact.getAttribute("overview_provider");
            String apiName = artifact.getAttribute("overview_name");
            String apiVersion = artifact.getAttribute("overview_version");
            api = new API(new APIIdentifier(providerName, apiName, apiVersion));
            api.setRating(APIUtil.getAverageRating(api.getId()));
            api.setThumbnailUrl(artifact.getAttribute("overview_thumbnail"));
            api.setStatus(APIUtil.getApiStatus(artifact.getAttribute("overview_status")));
            api.setContext(artifact.getAttribute("overview_context"));
            api.setVisibility(artifact.getAttribute("overview_visibility"));
            api.setVisibleRoles(artifact.getAttribute("overview_visibleRoles"));
            api.setVisibleTenants(artifact.getAttribute("overview_visibleTenants"));
            api.setTransports(artifact.getAttribute("overview_transports"));
            api.setInSequence(artifact.getAttribute("overview_inSequence"));
            api.setOutSequence(artifact.getAttribute("overview_outSequence"));
            api.setFaultSequence(artifact.getAttribute("overview_faultSequence"));
            api.setDescription(artifact.getAttribute("overview_description"));
            api.setResponseCache(artifact.getAttribute("overview_responseCaching"));
            int cacheTimeout = 300;
            try {
                cacheTimeout = Integer.parseInt(artifact.getAttribute("overview_cacheTimeout"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            api.setCacheTimeout(cacheTimeout);
            api.setRedirectURL(artifact.getAttribute("overview_redirectURL"));
            api.setApiOwner(artifact.getAttribute("overview_apiOwner"));
            api.setAdvertiseOnly(Boolean.parseBoolean(artifact.getAttribute("overview_advertiseOnly")));
            api.setEndpointConfig(artifact.getAttribute("overview_endpointConfig"));
            api.setSubscriptionAvailability(artifact.getAttribute("overview_subscriptionAvailability"));
            api.setSubscriptionAvailableTenants(artifact.getAttribute("overview_tenants"));
            api.setDestinationStatsEnabled(artifact.getAttribute("overview_destinationStatsEnabled"));
            api.setAsDefaultVersion(Boolean.valueOf(artifact.getAttribute("overview_isDefaultVersion")).booleanValue());
            api.setImplementation(artifact.getAttribute("overview_implementation"));
            ArrayList<URITemplate> urlPatternsList = ApiMgtDAO.getAllURITemplates(api.getContext(), api.getId().getVersion());
            HashSet<URITemplate> uriTemplates = new HashSet<URITemplate>(urlPatternsList);
            for (URITemplate uriTemplate : uriTemplates) {
                uriTemplate.setResourceURI(api.getUrl());
                uriTemplate.setResourceSandboxURI(api.getSandboxUrl());
            }
            api.setUriTemplates(uriTemplates);
        }
        catch (GovernanceException e) {
            String msg = "Failed to get API from artifact ";
            throw new APIManagementException(msg, (Throwable)e);
        }
        return api;
    }

    public static Provider getProvider(GenericArtifact artifact) throws APIManagementException {
        Provider provider;
        try {
            provider = new Provider(artifact.getAttribute("overview_name"));
            provider.setDescription(artifact.getAttribute("overview_description"));
            provider.setEmail(artifact.getAttribute("overview_email"));
        }
        catch (GovernanceException e) {
            String msg = "Failed to get provider ";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return provider;
    }

    public static Set<Scope> getScopeByScopeKey(String scopeKey, String provider) throws APIManagementException {
        Set<Scope> scopeList = null;
        String tenantDomainName = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack(provider));
        try {
            int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomainName);
            scopeList = ApiMgtDAO.getAPIScopesByScopeKey(scopeKey, tenantId);
        }
        catch (UserStoreException e) {
            APIUtil.handleException("Error while retrieving Scopes");
        }
        return scopeList;
    }

    public static GenericArtifact createAPIArtifactContent(GenericArtifact artifact, API api) throws APIManagementException {
        try {
            String[] keys;
            String apiStatus = api.getStatus().getStatus();
            artifact.setAttribute("overview_name", api.getId().getApiName());
            artifact.setAttribute("overview_version", api.getId().getVersion());
            artifact.setAttribute("overview_isDefaultVersion", String.valueOf(api.isDefaultVersion()));
            artifact.setAttribute("overview_context", api.getContext());
            artifact.setAttribute("overview_provider", api.getId().getProviderName());
            artifact.setAttribute("overview_description", api.getDescription());
            artifact.setAttribute("overview_endpointURL", api.getUrl());
            artifact.setAttribute("overview_sandboxURL", api.getSandboxUrl());
            artifact.setAttribute("overview_wsdl", api.getWsdlUrl());
            artifact.setAttribute("overview_wadl", api.getWadlUrl());
            artifact.setAttribute("overview_thumbnail", api.getThumbnailUrl());
            artifact.setAttribute("overview_status", apiStatus);
            artifact.setAttribute("overview_technicalOwner", api.getTechnicalOwner());
            artifact.setAttribute("overview_technicalOwnerEmail", api.getTechnicalOwnerEmail());
            artifact.setAttribute("overview_businessOwner", api.getBusinessOwner());
            artifact.setAttribute("overview_businessOwnerEmail", api.getBusinessOwnerEmail());
            artifact.setAttribute("overview_visibility", api.getVisibility());
            artifact.setAttribute("overview_visibleRoles", api.getVisibleRoles());
            artifact.setAttribute("overview_visibleTenants", api.getVisibleTenants());
            artifact.setAttribute("overview_endpointSecured", Boolean.toString(api.isEndpointSecured()));
            artifact.setAttribute("overview_endpointUsername", api.getEndpointUTUsername());
            artifact.setAttribute("overview_endpointPpassword", api.getEndpointUTPassword());
            artifact.setAttribute("overview_transports", api.getTransports());
            artifact.setAttribute("overview_inSequence", api.getInSequence());
            artifact.setAttribute("overview_outSequence", api.getOutSequence());
            artifact.setAttribute("overview_faultSequence", api.getFaultSequence());
            artifact.setAttribute("overview_responseCaching", api.getResponseCache());
            artifact.setAttribute("overview_cacheTimeout", Integer.toString(api.getCacheTimeout()));
            artifact.setAttribute("overview_redirectURL", api.getRedirectURL());
            artifact.setAttribute("overview_apiOwner", api.getApiOwner());
            artifact.setAttribute("overview_advertiseOnly", Boolean.toString(api.isAdvertiseOnly()));
            artifact.setAttribute("overview_endpointConfig", api.getEndpointConfig());
            artifact.setAttribute("overview_subscriptionAvailability", api.getSubscriptionAvailability());
            artifact.setAttribute("overview_tenants", api.getSubscriptionAvailableTenants());
            artifact.setAttribute("overview_destinationStatsEnabled", api.getDestinationStatsEnabled());
            artifact.setAttribute("overview_implementation", api.getImplementation());
            String tiers = "";
            for (Tier tier : api.getAvailableTiers()) {
                tiers = tiers + tier.getName() + "||";
            }
            if (!"".equals(tiers)) {
                tiers = tiers.substring(0, tiers.length() - 2);
                artifact.setAttribute("overview_tier", tiers);
            }
            if ("PUBLISHED".equals(apiStatus)) {
                artifact.setAttribute("overview_isLatest", "true");
            }
            for (String key : keys = artifact.getAttributeKeys()) {
                if (!key.contains("URITemplate")) continue;
                artifact.removeAttribute(key);
            }
            Set uriTemplateSet = api.getUriTemplates();
            int i = 0;
            for (URITemplate uriTemplate : uriTemplateSet) {
                artifact.addAttribute("URITemplate_urlPattern" + i, uriTemplate.getUriTemplate());
                artifact.addAttribute("URITemplate_httpVerb" + i, uriTemplate.getHTTPVerb());
                artifact.addAttribute("URITemplate_authType" + i, uriTemplate.getAuthType());
                ++i;
            }
        }
        catch (GovernanceException e) {
            String msg = "Failed to create API for : " + api.getId().getApiName();
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return artifact;
    }

    public static Documentation getDocumentation(GenericArtifact artifact) throws APIManagementException {
        Documentation documentation;
        try {
            String docType = artifact.getAttribute("overview_type");
            DocumentationType type = docType.equalsIgnoreCase(DocumentationType.HOWTO.getType()) ? DocumentationType.HOWTO : (docType.equalsIgnoreCase(DocumentationType.PUBLIC_FORUM.getType()) ? DocumentationType.PUBLIC_FORUM : (docType.equalsIgnoreCase(DocumentationType.SUPPORT_FORUM.getType()) ? DocumentationType.SUPPORT_FORUM : (docType.equalsIgnoreCase(DocumentationType.API_MESSAGE_FORMAT.getType()) ? DocumentationType.API_MESSAGE_FORMAT : (docType.equalsIgnoreCase(DocumentationType.SAMPLES.getType()) ? DocumentationType.SAMPLES : DocumentationType.OTHER))));
            documentation = new Documentation(type, artifact.getAttribute("overview_name"));
            documentation.setSummary(artifact.getAttribute("overview_summary"));
            String visibilityAttr = artifact.getAttribute("overview_visibility");
            Documentation.DocumentVisibility documentVisibility = Documentation.DocumentVisibility.API_LEVEL;
            if (visibilityAttr != null) {
                if (visibilityAttr.equals(Documentation.DocumentVisibility.API_LEVEL.name())) {
                    documentVisibility = Documentation.DocumentVisibility.API_LEVEL;
                } else if (visibilityAttr.equals(Documentation.DocumentVisibility.PRIVATE.name())) {
                    documentVisibility = Documentation.DocumentVisibility.PRIVATE;
                } else if (visibilityAttr.equals(Documentation.DocumentVisibility.OWNER_ONLY.name())) {
                    documentVisibility = Documentation.DocumentVisibility.OWNER_ONLY;
                }
            }
            documentation.setVisibility(documentVisibility);
            Documentation.DocumentSourceType docSourceType = Documentation.DocumentSourceType.INLINE;
            String artifactAttribute = artifact.getAttribute("overview_sourceType");
            if (artifactAttribute.equals(Documentation.DocumentSourceType.URL.name())) {
                docSourceType = Documentation.DocumentSourceType.URL;
            } else if (artifactAttribute.equals(Documentation.DocumentSourceType.FILE.name())) {
                docSourceType = Documentation.DocumentSourceType.FILE;
            }
            documentation.setSourceType(docSourceType);
            if (artifact.getAttribute("overview_sourceType").equals("URL")) {
                documentation.setSourceUrl(artifact.getAttribute("overview_sourceURL"));
            }
            if (docSourceType == Documentation.DocumentSourceType.FILE) {
                documentation.setFilePath(APIUtil.prependWebContextRoot(artifact.getAttribute("overview_filePath")));
            }
            if (documentation.getType() == DocumentationType.OTHER) {
                documentation.setOtherTypeName(artifact.getAttribute("overview_otherTypeName"));
            }
        }
        catch (GovernanceException e) {
            throw new APIManagementException("Failed to get documentation from artifact", (Throwable)e);
        }
        return documentation;
    }

    public static Documentation getDocumentation(GenericArtifact artifact, String docCreatorName) throws APIManagementException {
        Documentation documentation;
        try {
            String docType = artifact.getAttribute("overview_type");
            DocumentationType type = docType.equalsIgnoreCase(DocumentationType.HOWTO.getType()) ? DocumentationType.HOWTO : (docType.equalsIgnoreCase(DocumentationType.PUBLIC_FORUM.getType()) ? DocumentationType.PUBLIC_FORUM : (docType.equalsIgnoreCase(DocumentationType.SUPPORT_FORUM.getType()) ? DocumentationType.SUPPORT_FORUM : (docType.equalsIgnoreCase(DocumentationType.API_MESSAGE_FORMAT.getType()) ? DocumentationType.API_MESSAGE_FORMAT : (docType.equalsIgnoreCase(DocumentationType.SAMPLES.getType()) ? DocumentationType.SAMPLES : DocumentationType.OTHER))));
            documentation = new Documentation(type, artifact.getAttribute("overview_name"));
            documentation.setSummary(artifact.getAttribute("overview_summary"));
            Documentation.DocumentSourceType docSourceType = Documentation.DocumentSourceType.INLINE;
            String artifactAttribute = artifact.getAttribute("overview_sourceType");
            if (artifactAttribute.equals(Documentation.DocumentSourceType.URL.name())) {
                docSourceType = Documentation.DocumentSourceType.URL;
            } else if (artifactAttribute.equals(Documentation.DocumentSourceType.FILE.name())) {
                docSourceType = Documentation.DocumentSourceType.FILE;
            }
            documentation.setSourceType(docSourceType);
            if (artifact.getAttribute("overview_sourceType").equals("URL")) {
                documentation.setSourceUrl(artifact.getAttribute("overview_sourceURL"));
            }
            if (docSourceType == Documentation.DocumentSourceType.FILE) {
                String filePath = APIUtil.prependTenantPrefix(artifact.getAttribute("overview_filePath"), docCreatorName);
                documentation.setFilePath(APIUtil.prependWebContextRoot(filePath));
            }
            if (documentation.getType() == DocumentationType.OTHER) {
                documentation.setOtherTypeName(artifact.getAttribute("overview_otherTypeName"));
            }
        }
        catch (GovernanceException e) {
            throw new APIManagementException("Failed to get documentation from artifact", (Throwable)e);
        }
        return documentation;
    }

    public static APIStatus getApiStatus(String status) throws APIManagementException {
        APIStatus apiStatus = null;
        for (APIStatus aStatus : APIStatus.values()) {
            if (!aStatus.getStatus().equals(status)) continue;
            apiStatus = aStatus;
        }
        return apiStatus;
    }

    public static String prependTenantPrefix(String postfixUrl, String username) {
        String tenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack(username));
        if (!tenantDomain.equals("carbon.super")) {
            String tenantPrefix = "/t/";
            if (tenantDomain != null) {
                postfixUrl = tenantPrefix + tenantDomain + postfixUrl;
            }
        }
        return postfixUrl;
    }

    public static String prependWebContextRoot(String postfixUrl) {
        String webContext = CarbonUtils.getServerConfiguration().getFirstProperty("WebContextRoot");
        if (webContext != null && !webContext.equals("/")) {
            postfixUrl = webContext + postfixUrl;
        }
        return postfixUrl;
    }

    public static String getIconPath(APIIdentifier identifier) {
        String artifactPath = "/apimgt/applicationdata/icons/" + identifier.getProviderName() + "/" + identifier.getApiName() + "/" + identifier.getVersion();
        return artifactPath + "/" + "icon";
    }

    public static String getDocumentationFilePath(APIIdentifier identifier, String fileName) {
        String contentPath = APIUtil.getAPIDocPath(identifier) + "files" + "/" + fileName;
        return contentPath;
    }

    public static String getAPIDefinitionFilePath(String apiName, String apiVersion, String apiProvider) {
        String resourcePath = "/apimgt/applicationdata/api-docs/" + apiName + "-" + apiVersion + "-" + apiProvider + "/" + "api-doc.json";
        return resourcePath;
    }

    public static String getSwagger12DefinitionFilePath(String apiName, String apiVersion, String apiProvider) {
        String resourcePath = "/apimgt/applicationdata/api-docs/" + apiName + "-" + apiVersion + "-" + apiProvider + "/" + "1.2";
        return resourcePath;
    }

    public static String getAPIPath(APIIdentifier identifier) {
        return "/apimgt/applicationdata/provider/" + identifier.getProviderName() + "/" + identifier.getApiName() + "/" + identifier.getVersion() + "/api";
    }

    public static String getAPIProviderPath(APIIdentifier identifier) {
        return "/apimgt/applicationdata/provider/" + identifier.getProviderName();
    }

    public static String getAPIDocPath(APIIdentifier apiId) {
        return "/apimgt/applicationdata/provider/" + apiId.getProviderName() + "/" + apiId.getApiName() + "/" + apiId.getVersion() + "/" + "documentation" + "/";
    }

    public static String getAPIDocContentPath(APIIdentifier apiId, String documentationName) {
        return APIUtil.getAPIDocPath(apiId) + "contents" + "/" + documentationName;
    }

    public static GenericArtifact createDocArtifactContent(GenericArtifact artifact, APIIdentifier apiId, Documentation documentation) throws APIManagementException {
        try {
            artifact.setAttribute("overview_name", documentation.getName());
            artifact.setAttribute("overview_summary", documentation.getSummary());
            artifact.setAttribute("overview_type", documentation.getType().getType());
            artifact.setAttribute("overview_visibility", documentation.getVisibility().name());
            Documentation.DocumentSourceType sourceType = documentation.getSourceType();
            switch (sourceType) {
                case INLINE: {
                    sourceType = Documentation.DocumentSourceType.INLINE;
                    break;
                }
                case URL: {
                    sourceType = Documentation.DocumentSourceType.URL;
                    break;
                }
                case FILE: {
                    sourceType = Documentation.DocumentSourceType.FILE;
                    APIUtil.setFilePermission(documentation.getFilePath());
                }
            }
            artifact.setAttribute("overview_sourceType", sourceType.name());
            artifact.setAttribute("overview_sourceURL", documentation.getSourceUrl());
            artifact.setAttribute("overview_filePath", documentation.getFilePath());
            artifact.setAttribute("overview_otherTypeName", documentation.getOtherTypeName());
            String basePath = apiId.getProviderName() + "/" + apiId.getApiName() + "/" + apiId.getVersion();
            artifact.setAttribute("overview_apiBasePath", basePath);
        }
        catch (GovernanceException e) {
            String msg = "Filed to create doc artifact content from :" + documentation.getName();
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return artifact;
    }

    public static GenericArtifactManager getArtifactManager(Registry registry, String key) throws APIManagementException {
        GenericArtifactManager artifactManager = null;
        try {
            GovernanceUtils.loadGovernanceArtifacts((UserRegistry)((UserRegistry)registry));
            if (GovernanceUtils.findGovernanceArtifactConfiguration((String)key, (Registry)registry) != null) {
                artifactManager = new GenericArtifactManager(registry, key);
            }
        }
        catch (RegistryException e) {
            String msg = "Failed to initialize GenericArtifactManager";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return artifactManager;
    }

    private static void handleException(String msg) throws APIManagementException {
        log.error((Object)msg);
        throw new APIManagementException(msg);
    }

    public static void handleException(String msg, Throwable t) throws APIManagementException {
        log.error((Object)msg, t);
        throw new APIManagementException(msg, t);
    }

    public static SubscriberKeyMgtClient getKeyManagementClient() throws APIManagementException {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        String url = config.getFirstProperty("APIKeyManager.ServerURL");
        if (url == null) {
            APIUtil.handleException("API key manager URL unspecified");
        }
        String username = config.getFirstProperty("APIKeyManager.Username");
        String password = config.getFirstProperty("APIKeyManager.Password");
        if (username == null || password == null) {
            APIUtil.handleException("Authentication credentials for API key manager unspecified");
        }
        try {
            return new SubscriberKeyMgtClient(url, username, password);
        }
        catch (Exception e) {
            APIUtil.handleException("Error while initializing the subscriber key management client", e);
            return null;
        }
    }

    public static String createWSDL(Registry registry, API api) throws RegistryException, APIManagementException {
        try {
            String wsdlResourcePath = "/apimgt/applicationdata/wsdls/" + api.getId().getProviderName() + "--" + api.getId().getApiName() + api.getId().getVersion() + ".wsdl";
            String absoluteWSDLResourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)APIUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance")) + wsdlResourcePath;
            APIMWSDLReader wsdlreader = new APIMWSDLReader(api.getWsdlUrl());
            OMElement wsdlContentEle = null;
            String wsdRegistryPath = null;
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            wsdRegistryPath = tenantDomain.equalsIgnoreCase("carbon.super") ? "/registry/resource" + absoluteWSDLResourcePath : "/t/" + tenantDomain + "/" + "registry" + "/" + "resource" + absoluteWSDLResourcePath;
            Resource wsdlResource = registry.newResource();
            if (!api.getWsdlUrl().matches(wsdRegistryPath)) {
                if (APIUtil.isWSDL2Document(api.getWsdlUrl())) {
                    wsdlContentEle = wsdlreader.readAndCleanWsdl2(api);
                    wsdlResource.setContent((Object)wsdlContentEle.toString());
                } else {
                    wsdlContentEle = wsdlreader.readAndCleanWsdl(api);
                    wsdlResource.setContent((Object)wsdlContentEle.toString());
                }
                registry.put(wsdlResourcePath, wsdlResource);
                APIUtil.setResourcePermissions(api.getId().getProviderName(), null, null, wsdlResourcePath);
            }
            api.setWsdlUrl(APIUtil.getRegistryResourceHTTPPermlink(absoluteWSDLResourcePath));
            return wsdlResourcePath;
        }
        catch (RegistryException e) {
            String msg = "Failed to add WSDL " + api.getWsdlUrl() + " to the registry";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (APIManagementException e) {
            String msg = "Failed to reset the WSDL : " + api.getWsdlUrl();
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
    }

    private static boolean isWSDL2Document(String url) throws APIManagementException {
        boolean isWsdl2;
        block7: {
            URL wsdl = null;
            isWsdl2 = false;
            try {
                wsdl = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new APIManagementException("Malformed URL encountered", (Throwable)e);
            }
            BufferedReader in = null;
            try {
                String inputLine;
                in = new BufferedReader(new InputStreamReader(wsdl.openStream()));
                StringBuilder urlContent = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    String wsdl2NameSpace = "http://www.w3.org/ns/wsdl";
                    urlContent.append(inputLine);
                    isWsdl2 = urlContent.indexOf(wsdl2NameSpace) > 0;
                }
                in.close();
                if (!isWsdl2) break block7;
                WSDLReader wsdlReader20 = null;
                try {
                    wsdlReader20 = WSDLFactory.newInstance().newWSDLReader();
                    wsdlReader20.readWSDL(url);
                }
                catch (WSDLException e) {
                    throw new APIManagementException("Error while reading WSDL Document", (Throwable)e);
                }
            }
            catch (IOException e) {
                throw new APIManagementException("Error Reading Input from Stream", (Throwable)e);
            }
        }
        return isWsdl2;
    }

    public static String getGatewayendpoint(String transports) {
        String gatewayURLs = null;
        String gatewayURL = null;
        List gatewayEnvironments = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getApiGatewayEnvironments();
        if (gatewayEnvironments.size() > 1) {
            for (int i = 0; i < gatewayEnvironments.size(); ++i) {
                if (!"production".equals(((Environment)gatewayEnvironments.get(i)).getType())) continue;
                gatewayURLs = ((Environment)gatewayEnvironments.get(i)).getApiGatewayEndpoint();
                gatewayURL = APIUtil.extractHTTPSEndpoint(gatewayURLs, transports);
                break;
            }
        } else {
            gatewayURLs = ((Environment)gatewayEnvironments.get(0)).getApiGatewayEndpoint();
            gatewayURL = APIUtil.extractHTTPSEndpoint(gatewayURLs, transports);
        }
        return gatewayURL;
    }

    private static String extractHTTPSEndpoint(String gatewayURLs, String transports) {
        int j;
        String gatewayURL = null;
        String gatewayHTTPURL = null;
        String gatewayHTTPSURL = null;
        boolean httpsEnabled = false;
        String[] gatewayURLsArray = gatewayURLs.split(",");
        String[] transportsArray = transports.split(",");
        for (j = 0; j < transportsArray.length; ++j) {
            if (!transportsArray[j].toString().startsWith("https")) continue;
            httpsEnabled = true;
        }
        if (gatewayURLsArray.length > 1) {
            for (j = 0; j < gatewayURLsArray.length; ++j) {
                if (gatewayURLsArray[j].toString().startsWith("https:")) {
                    gatewayHTTPSURL = gatewayURLsArray[j].toString();
                    continue;
                }
                gatewayHTTPURL = gatewayURLsArray[j].toString();
            }
            gatewayURL = httpsEnabled ? gatewayHTTPSURL : gatewayHTTPURL;
        } else {
            gatewayURL = gatewayURLs;
        }
        return gatewayURL;
    }

    public static String createEndpoint(String endpointUrl, Registry registry) throws APIManagementException {
        try {
            EndpointManager endpointManager = new EndpointManager(registry);
            Endpoint endpoint = endpointManager.newEndpoint(endpointUrl);
            endpointManager.addEndpoint(endpoint);
            return GovernanceUtils.getArtifactPath((Registry)registry, (String)endpoint.getId());
        }
        catch (RegistryException e) {
            String msg = "Failed to import endpoint " + endpointUrl + " to registry ";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
    }

    public static Map<String, Tier> getTiers() throws APIManagementException {
        TreeMap<String, Tier> tiers = new TreeMap<String, Tier>();
        try {
            APIManagerConfiguration config;
            UserRegistry registry = ServiceReferenceHolder.getInstance().getRegistryService().getGovernanceSystemRegistry();
            if (registry.resourceExists("/apimgt/applicationdata/tiers.xml")) {
                Resource resource = registry.get("/apimgt/applicationdata/tiers.xml");
                String content = new String((byte[])resource.getContent());
                OMElement element = AXIOMUtil.stringToOM((String)content);
                OMElement assertion = element.getFirstChildWithName(APIConstants.ASSERTION_ELEMENT);
                Iterator policies = assertion.getChildrenWithName(APIConstants.POLICY_ELEMENT);
                while (policies.hasNext()) {
                    String desc;
                    OMElement policy = (OMElement)policies.next();
                    OMElement id = policy.getFirstChildWithName(APIConstants.THROTTLE_ID_ELEMENT);
                    String displayName = null;
                    if (id.getAttribute(APIConstants.THROTTLE_ID_DISPLAY_NAME_ELEMENT) != null) {
                        displayName = id.getAttributeValue(APIConstants.THROTTLE_ID_DISPLAY_NAME_ELEMENT);
                    }
                    if (displayName == null) {
                        displayName = id.getText();
                    }
                    Tier tier = new Tier(id.getText());
                    tier.setPolicyContent(policy.toString().getBytes());
                    tier.setDisplayName(displayName);
                    try {
                        desc = APIDescriptionGenUtil.generateDescriptionFromPolicy(policy);
                    }
                    catch (APIManagementException ex) {
                        desc = "Tire Description is not available";
                    }
                    Map<String, Object> tierAttributes = APIDescriptionGenUtil.getTierAttributes(policy);
                    if (tierAttributes != null && tierAttributes.size() != 0) {
                        tier.setTierAttributes(APIDescriptionGenUtil.getTierAttributes(policy));
                    }
                    tier.setDescription(desc);
                    if (tier.getName().equalsIgnoreCase("Unauthenticated")) continue;
                    tiers.put(tier.getName(), tier);
                }
            }
            if (Boolean.parseBoolean((config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration()).getFirstProperty("TierManagement.EnableUnlimitedTier"))) {
                Tier tier = new Tier("Unlimited");
                tier.setDescription("Allows unlimited requests");
                tier.setDisplayName("Unlimited");
                tiers.put(tier.getName(), tier);
            }
        }
        catch (RegistryException e) {
            String msg = "Error while retrieving API tiers from registry";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String msg = "Malformed XML found in the API tier policy resource";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return tiers;
    }

    public static Set<APIStore> getExternalStores(int tenantId) throws APIManagementException {
        HashSet<APIStore> externalAPIStores = new HashSet<APIStore>();
        try {
            UserRegistry registry = ServiceReferenceHolder.getInstance().getRegistryService().getGovernanceSystemRegistry(tenantId);
            if (registry.resourceExists("/apimgt/externalstores/external-api-stores.xml")) {
                Resource resource = registry.get("/apimgt/externalstores/external-api-stores.xml");
                String content = new String((byte[])resource.getContent());
                OMElement element = AXIOMUtil.stringToOM((String)content);
                Iterator apistoreIterator = element.getChildrenWithLocalName("ExternalAPIStore");
                while (apistoreIterator.hasNext()) {
                    APIStore store = new APIStore();
                    OMElement storeElem = (OMElement)apistoreIterator.next();
                    String type = storeElem.getAttributeValue(new QName("type"));
                    store.setType(type);
                    String name = storeElem.getAttributeValue(new QName("id"));
                    if (name == null) {
                        try {
                            throw new APIManagementException("The ExternalAPIStore name attribute is not defined in api-manager.xml.");
                        }
                        catch (APIManagementException e) {
                            // empty catch block
                        }
                    }
                    store.setName(name);
                    OMElement configDisplayName = storeElem.getFirstChildWithName(new QName("DisplayName"));
                    String displayName = configDisplayName != null ? APIUtil.replaceSystemProperty(configDisplayName.getText()) : name;
                    store.setDisplayName(displayName);
                    store.setEndpoint(APIUtil.replaceSystemProperty(storeElem.getFirstChildWithName(new QName("Endpoint")).getText()));
                    store.setPublished(false);
                    if ("wso2".equals(type)) {
                        OMElement password = storeElem.getFirstChildWithName(new QName("Password"));
                        if (password != null) {
                            String key = "ExternalAPIStores.ExternalAPIStore.Password_" + name;
                            String value = password.getText();
                            store.setPassword(APIUtil.replaceSystemProperty(value));
                            store.setUsername(APIUtil.replaceSystemProperty(storeElem.getFirstChildWithName(new QName("Username")).getText()));
                        } else {
                            try {
                                throw new APIManagementException("The user-credentials of API Publisher is not defined in the <ExternalAPIStore> config of api-manager.xml.");
                            }
                            catch (APIManagementException e) {
                                // empty catch block
                            }
                        }
                    }
                    externalAPIStores.add(store);
                }
            }
        }
        catch (RegistryException e) {
            String msg = "Error while retrieving External Stores Configuration from registry";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String msg = "Malformed XML found in the External Stores Configuration resource";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return externalAPIStores;
    }

    public static APIStore getExternalAPIStore(String apiStoreName, int tenantId) throws APIManagementException {
        Set<APIStore> externalAPIStoresConfig = APIUtil.getExternalStores(tenantId);
        APIStore apiStore = null;
        for (APIStore apiStoreConfig : externalAPIStoresConfig) {
            if (!apiStoreConfig.getName().equals(apiStoreName)) continue;
            apiStore = apiStoreConfig;
        }
        return apiStore;
    }

    public static Map<String, Tier> getTiers(int tenantId) throws APIManagementException {
        TreeMap<String, Tier> tiers = new TreeMap<String, Tier>();
        try {
            APIManagerConfiguration config;
            UserRegistry registry = ServiceReferenceHolder.getInstance().getRegistryService().getGovernanceSystemRegistry(tenantId);
            if (registry.resourceExists("/apimgt/applicationdata/tiers.xml")) {
                Resource resource = registry.get("/apimgt/applicationdata/tiers.xml");
                String content = new String((byte[])resource.getContent());
                OMElement element = AXIOMUtil.stringToOM((String)content);
                OMElement assertion = element.getFirstChildWithName(APIConstants.ASSERTION_ELEMENT);
                Iterator policies = assertion.getChildrenWithName(APIConstants.POLICY_ELEMENT);
                while (policies.hasNext()) {
                    String desc;
                    OMElement policy = (OMElement)policies.next();
                    OMElement id = policy.getFirstChildWithName(APIConstants.THROTTLE_ID_ELEMENT);
                    String displayName = null;
                    if (id.getAttribute(APIConstants.THROTTLE_ID_DISPLAY_NAME_ELEMENT) != null) {
                        displayName = id.getAttributeValue(APIConstants.THROTTLE_ID_DISPLAY_NAME_ELEMENT);
                    }
                    if (displayName == null) {
                        displayName = id.getText();
                    }
                    Tier tier = new Tier(id.getText());
                    tier.setPolicyContent(policy.toString().getBytes());
                    tier.setDisplayName(displayName);
                    try {
                        desc = APIDescriptionGenUtil.generateDescriptionFromPolicy(policy);
                    }
                    catch (APIManagementException ex) {
                        desc = "Tire Description is not available";
                    }
                    Map<String, Object> tierAttributes = APIDescriptionGenUtil.getTierAttributes(policy);
                    if (tierAttributes != null && tierAttributes.size() != 0) {
                        tier.setTierAttributes(APIDescriptionGenUtil.getTierAttributes(policy));
                    }
                    tier.setDescription(desc);
                    if (tier.getName().equalsIgnoreCase("Unauthenticated")) continue;
                    tiers.put(tier.getName(), tier);
                }
            }
            if (Boolean.parseBoolean((config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration()).getFirstProperty("TierManagement.EnableUnlimitedTier"))) {
                Tier tier = new Tier("Unlimited");
                tier.setDescription("Allows unlimited requests");
                tier.setDisplayName("Unlimited");
                tiers.put(tier.getName(), tier);
            }
        }
        catch (RegistryException e) {
            String msg = "Error while retrieving API tiers from registry";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String msg = "Malformed XML found in the API tier policy resource";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return tiers;
    }

    public static String getTierDisplayName(int tenantId, String tierName) throws APIManagementException {
        String displayName = null;
        try {
            UserRegistry registry = ServiceReferenceHolder.getInstance().getRegistryService().getGovernanceSystemRegistry(tenantId);
            if (registry.resourceExists("/apimgt/applicationdata/tiers.xml")) {
                Resource resource = registry.get("/apimgt/applicationdata/tiers.xml");
                String content = new String((byte[])resource.getContent());
                OMElement element = AXIOMUtil.stringToOM((String)content);
                OMElement assertion = element.getFirstChildWithName(APIConstants.ASSERTION_ELEMENT);
                Iterator policies = assertion.getChildrenWithName(APIConstants.POLICY_ELEMENT);
                while (policies.hasNext()) {
                    OMElement policy = (OMElement)policies.next();
                    OMElement id = policy.getFirstChildWithName(APIConstants.THROTTLE_ID_ELEMENT);
                    if (id.getText().equals(tierName)) {
                        if (id.getAttribute(APIConstants.THROTTLE_ID_DISPLAY_NAME_ELEMENT) != null) {
                            displayName = id.getAttributeValue(APIConstants.THROTTLE_ID_DISPLAY_NAME_ELEMENT);
                            continue;
                        }
                        if (displayName != null) continue;
                        displayName = id.getText();
                        continue;
                    }
                    if (!"Unlimited".equals(tierName)) continue;
                    displayName = "Unlimited";
                }
            }
        }
        catch (RegistryException e) {
            String msg = "Error while retrieving API tiers from registry";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String msg = "Malformed XML found in the API tier policy resource";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return displayName;
    }

    public static void checkPermission(String username, String permission) throws APIManagementException {
        if (username == null) {
            throw new APIManagementException("Attempt to execute privileged operation as the anonymous user");
        }
        String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
        try {
            boolean authorized;
            if (!tenantDomain.equals("carbon.super")) {
                int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
                AuthorizationManager manager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager();
                authorized = manager.isUserAuthorized(MultitenantUtils.getTenantAwareUsername((String)username), permission, "ui.execute");
            } else {
                authorized = RemoteAuthorizationManager.getInstance().isUserAuthorized(MultitenantUtils.getTenantAwareUsername((String)username), permission);
            }
            if (!authorized) {
                throw new APIManagementException("User '" + username + "' does not have the " + "required permission: " + permission);
            }
        }
        catch (UserStoreException e) {
            throw new APIManagementException("Error while checking the user:" + username + " authorized or not", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public static boolean checkPermissionQuietly(String username, String permission) {
        try {
            APIUtil.checkPermission(username, permission);
            return true;
        }
        catch (APIManagementException e) {
            return false;
        }
    }

    public static LoggedUserInfo getLoggedInUserInfo(String cookie, String serviceUrl) throws RemoteException, ExceptionException {
        LoggedUserInfoAdminStub stub = new LoggedUserInfoAdminStub(null, serviceUrl + "LoggedUserInfoAdmin");
        ServiceClient client = stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
        LoggedUserInfo userInfo = stub.getUserInfo();
        return userInfo;
    }

    public static String[] getListOfRoles(String username) throws APIManagementException {
        if (username == null) {
            throw new APIManagementException("Attempt to execute privileged operation as the anonymous user");
        }
        return RemoteAuthorizationManager.getInstance().getRolesOfUser(username);
    }

    public static String[] getListOfRolesQuietly(String username) {
        try {
            return APIUtil.getListOfRoles(username);
        }
        catch (APIManagementException e) {
            return new String[0];
        }
    }

    private static void setFilePermission(String filePath) throws APIManagementException {
        try {
            filePath = filePath.replaceFirst("/registry/resource/", "");
            AuthorizationManager accessControlAdmin = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(-1234).getAuthorizationManager();
            if (!accessControlAdmin.isRoleAuthorized("system/wso2.anonymous.role", filePath, "http://www.wso2.org/projects/registry/actions/get")) {
                accessControlAdmin.authorizeRole("system/wso2.anonymous.role", filePath, "http://www.wso2.org/projects/registry/actions/get");
            }
        }
        catch (UserStoreException e) {
            throw new APIManagementException("Error while setting up permissions for file location", (Throwable)e);
        }
    }

    public static API getAPI(GovernanceArtifact artifact, Registry registry, APIIdentifier oldId) throws APIManagementException {
        API api;
        try {
            Tag[] tag;
            String providerName = artifact.getAttribute("overview_provider");
            String apiName = artifact.getAttribute("overview_name");
            String apiVersion = artifact.getAttribute("overview_version");
            api = new API(new APIIdentifier(providerName, apiName, apiVersion));
            String artifactPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)artifact.getId());
            BigDecimal bigDecimal = new BigDecimal(registry.getAverageRating(artifactPath));
            BigDecimal res = bigDecimal.setScale(1, RoundingMode.HALF_UP);
            api.setRating(res.floatValue());
            api.setDescription(artifact.getAttribute("overview_description"));
            api.setLastUpdated(registry.get(artifactPath).getLastModified());
            api.setUrl(artifact.getAttribute("overview_endpointURL"));
            api.setSandboxUrl(artifact.getAttribute("overview_sandboxURL"));
            api.setStatus(APIUtil.getApiStatus(artifact.getAttribute("overview_status")));
            api.setThumbnailUrl(artifact.getAttribute("overview_thumbnail"));
            api.setWsdlUrl(artifact.getAttribute("overview_wsdl"));
            api.setWadlUrl(artifact.getAttribute("overview_wadl"));
            api.setTechnicalOwner(artifact.getAttribute("overview_technicalOwner"));
            api.setTechnicalOwnerEmail(artifact.getAttribute("overview_technicalOwnerEmail"));
            api.setBusinessOwner(artifact.getAttribute("overview_businessOwner"));
            api.setBusinessOwnerEmail(artifact.getAttribute("overview_businessOwnerEmail"));
            api.setEndpointSecured(Boolean.parseBoolean(artifact.getAttribute("overview_endpointSecured")));
            api.setEndpointUTUsername(artifact.getAttribute("overview_endpointUsername"));
            api.setEndpointUTPassword(artifact.getAttribute("overview_endpointPpassword"));
            api.setTransports(artifact.getAttribute("overview_transports"));
            api.setEndpointConfig(artifact.getAttribute("overview_endpointConfig"));
            api.setRedirectURL(artifact.getAttribute("overview_redirectURL"));
            api.setApiOwner(artifact.getAttribute("overview_apiOwner"));
            api.setAdvertiseOnly(Boolean.parseBoolean(artifact.getAttribute("overview_advertiseOnly")));
            api.setSubscriptionAvailability(artifact.getAttribute("overview_subscriptionAvailability"));
            api.setSubscriptionAvailableTenants(artifact.getAttribute("overview_tenants"));
            api.setResponseCache(artifact.getAttribute("overview_responseCaching"));
            api.setImplementation(artifact.getAttribute("overview_implementation"));
            api.setVisibility(artifact.getAttribute("overview_visibility"));
            int cacheTimeout = 300;
            try {
                cacheTimeout = Integer.parseInt(artifact.getAttribute("overview_cacheTimeout"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            api.setDestinationStatsEnabled(artifact.getAttribute("overview_destinationStatsEnabled"));
            String tenantDomainName = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack(providerName));
            int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomainName);
            HashSet<Tier> availableTier = new HashSet<Tier>();
            String tiers = artifact.getAttribute("overview_tier");
            Map<String, Tier> definedTiers = APIUtil.getTiers(tenantId);
            if (tiers != null && !"".equals(tiers)) {
                String[] tierNames;
                for (String tierName : tierNames = tiers.split("\\|\\|")) {
                    Tier definedTier = definedTiers.get(tierName);
                    if (definedTier != null) {
                        availableTier.add(definedTier);
                        continue;
                    }
                    log.warn((Object)("Unknown tier: " + tierName + " found on API: " + apiName));
                }
            }
            api.addAvailableTiers(availableTier);
            api.setContext(artifact.getAttribute("overview_context"));
            api.setLatest(Boolean.valueOf(artifact.getAttribute("overview_isLatest")).booleanValue());
            ArrayList<URITemplate> urlPatternsList = ApiMgtDAO.getAllURITemplates(api.getContext(), oldId.getVersion());
            HashSet<URITemplate> uriTemplates = new HashSet<URITemplate>(urlPatternsList);
            for (URITemplate uriTemplate : uriTemplates) {
                uriTemplate.setResourceURI(api.getUrl());
                uriTemplate.setResourceSandboxURI(api.getSandboxUrl());
            }
            api.setUriTemplates(uriTemplates);
            HashSet<String> tags = new HashSet<String>();
            for (Tag tag1 : tag = registry.getTags(artifactPath)) {
                tags.add(tag1.getTagName());
            }
            api.addTags(tags);
            api.setLastUpdated(registry.get(artifactPath).getLastModified());
            api.setAsDefaultVersion(Boolean.valueOf(artifact.getAttribute("overview_isDefaultVersion")).booleanValue());
        }
        catch (GovernanceException e) {
            String msg = "Failed to get API fro artifact ";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (RegistryException e) {
            String msg = "Failed to get LastAccess time or Rating";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (UserStoreException e) {
            String msg = "Failed to get User Realm of API Provider";
            throw new APIManagementException(msg, (Throwable)e);
        }
        return api;
    }

    public static boolean checkAccessTokenPartitioningEnabled() {
        return OAuthServerConfiguration.getInstance().isAccessTokenPartitioningEnabled();
    }

    public static boolean checkUserNameAssertionEnabled() {
        return OAuthServerConfiguration.getInstance().isUserNameAssertionEnabled();
    }

    public static String[] getAvailableKeyStoreTables() throws APIManagementException {
        String[] keyStoreTables = new String[]{};
        Map<String, String> domainMappings = APIUtil.getAvailableUserStoreDomainMappings();
        if (domainMappings != null) {
            keyStoreTables = new String[domainMappings.size()];
            int i = 0;
            for (Map.Entry<String, String> e : domainMappings.entrySet()) {
                String value = e.getValue();
                keyStoreTables[i] = "IDN_OAUTH2_ACCESS_TOKEN_" + value.trim();
                ++i;
            }
        }
        return keyStoreTables;
    }

    public static Map<String, String> getAvailableUserStoreDomainMappings() throws APIManagementException {
        HashMap<String, String> userStoreDomainMap = new HashMap<String, String>();
        String domainsStr = OAuthServerConfiguration.getInstance().getAccessTokenPartitioningDomains();
        if (domainsStr != null) {
            String[] userStoreDomainsArr;
            for (String anUserStoreDomainsArr : userStoreDomainsArr = domainsStr.split(",")) {
                String[] mapping = anUserStoreDomainsArr.trim().split(":");
                if (mapping.length < 2) {
                    throw new APIManagementException("Domain mapping has not defined");
                }
                userStoreDomainMap.put(mapping[1].trim(), mapping[0].trim());
            }
        }
        return userStoreDomainMap;
    }

    public static String getAccessTokenStoreTableFromUserId(String userId) throws APIManagementException {
        String[] strArr;
        String accessTokenStoreTable = "IDN_OAUTH2_ACCESS_TOKEN";
        if (userId != null && (strArr = userId.split("/")) != null && strArr.length > 1) {
            String userStore = strArr[0];
            Map<String, String> availableDomainMappings = APIUtil.getAvailableUserStoreDomainMappings();
            if (availableDomainMappings != null && availableDomainMappings.containsKey(userStore)) {
                accessTokenStoreTable = accessTokenStoreTable + "_" + availableDomainMappings.get(userStore);
            }
        }
        return accessTokenStoreTable;
    }

    public static String getAccessTokenStoreTableFromAccessToken(String apiKey) throws APIManagementException {
        String userId = APIUtil.getUserIdFromAccessToken(apiKey);
        return APIUtil.getAccessTokenStoreTableFromUserId(userId);
    }

    public static String getUserIdFromAccessToken(String apiKey) {
        String userId = null;
        String decodedKey = new String(Base64.decodeBase64((byte[])apiKey.getBytes()));
        String[] tmpArr = decodedKey.split(":");
        if (tmpArr != null && tmpArr.length == 2) {
            userId = tmpArr[1];
        }
        return userId;
    }

    public static boolean isAccessTokenExpired(APIKeyValidationInfoDTO accessTokenDO) {
        long validityPeriod = accessTokenDO.getValidityPeriod();
        long issuedTime = accessTokenDO.getIssuedTime();
        long timestampSkew = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
        long currentTime = System.currentTimeMillis();
        if (validityPeriod != Long.MAX_VALUE && currentTime - timestampSkew > issuedTime + validityPeriod) {
            accessTokenDO.setValidationStatus(900903);
            if (accessTokenDO.getEndUserToken() != null) {
                log.info((Object)("Token " + accessTokenDO.getEndUserToken() + " expired."));
            }
            return true;
        }
        return false;
    }

    public static String replaceEmailDomain(String input) {
        if (input != null && input.contains("@")) {
            input = input.replace("@", "-AT-");
        }
        return input;
    }

    public static String replaceEmailDomainBack(String input) {
        if (input != null && input.contains("-AT-")) {
            input = input.replace("-AT-", "@");
        }
        return input;
    }

    public static void copyResourcePermissions(String username, String sourceArtifactPath, String targetArtifactPath) throws APIManagementException {
        String sourceResourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(APIUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + sourceArtifactPath));
        String targetResourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(APIUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + targetArtifactPath));
        String tenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack(username));
        try {
            int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
            AuthorizationManager authManager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager();
            String[] allowedRoles = authManager.getAllowedRolesForResource(sourceResourcePath, "http://www.wso2.org/projects/registry/actions/get");
            if (allowedRoles != null) {
                for (String allowedRole : allowedRoles) {
                    authManager.authorizeRole(allowedRole, targetResourcePath, "http://www.wso2.org/projects/registry/actions/get");
                }
            }
        }
        catch (UserStoreException e) {
            throw new APIManagementException("Error while adding role permissions to API", (Throwable)e);
        }
    }

    public static void setResourcePermissions(String username, String visibility, String[] roles, String artifactPath) throws APIManagementException {
        try {
            String resourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(APIUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + artifactPath));
            String tenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack(username));
            if (!tenantDomain.equals("carbon.super")) {
                int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
                RegistryAuthorizationManager authorizationManager = new RegistryAuthorizationManager(ServiceReferenceHolder.getUserRealm());
                resourcePath = authorizationManager.computePathOnMount(resourcePath);
                AuthorizationManager authManager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager();
                if (visibility != null && visibility.equalsIgnoreCase("restricted")) {
                    boolean isRoleEveryOne = false;
                    if (roles != null && roles.length == 1 && roles[0].equals("")) {
                        authManager.authorizeRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                        isRoleEveryOne = true;
                    } else {
                        for (String role : roles) {
                            if (role.equalsIgnoreCase("internal/everyone")) {
                                isRoleEveryOne = true;
                            }
                            authManager.authorizeRole(role, resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                        }
                    }
                    if (!isRoleEveryOne) {
                        authManager.denyRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    }
                    authManager.denyRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                } else if (visibility != null && visibility.equalsIgnoreCase("private")) {
                    authManager.authorizeRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    authManager.denyRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                } else if (visibility != null && visibility.equalsIgnoreCase("OWNER_ONLY")) {
                    if (roles == null) {
                        authManager.denyRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                        authManager.denyRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    } else {
                        for (String role : roles) {
                            authManager.denyRole(role, resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                        }
                    }
                } else {
                    authManager.authorizeRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    authManager.authorizeRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                }
            } else {
                RegistryAuthorizationManager authorizationManager = new RegistryAuthorizationManager(ServiceReferenceHolder.getUserRealm());
                if (visibility != null && visibility.equalsIgnoreCase("restricted")) {
                    boolean isRoleEveryOne = false;
                    for (String role : roles) {
                        if (role.equalsIgnoreCase("internal/everyone")) {
                            isRoleEveryOne = true;
                        }
                        authorizationManager.authorizeRole(role, resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    }
                    if (!isRoleEveryOne) {
                        authorizationManager.denyRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    }
                    authorizationManager.denyRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                } else if (visibility != null && visibility.equalsIgnoreCase("private")) {
                    authorizationManager.authorizeRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    authorizationManager.denyRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                } else if (visibility != null && visibility.equalsIgnoreCase("OWNER_ONLY")) {
                    if (roles == null) {
                        authorizationManager.denyRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                        authorizationManager.denyRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    } else {
                        for (String role : roles) {
                            authorizationManager.denyRole(role, resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                        }
                    }
                } else {
                    authorizationManager.authorizeRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    authorizationManager.authorizeRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                }
            }
        }
        catch (UserStoreException e) {
            throw new APIManagementException("Error while adding role permissions to API", (Throwable)e);
        }
    }

    public static void loadTenantAPIPolicy(String tenant, int tenantID) throws APIManagementException {
        try {
            RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
            UserRegistry govRegistry = registryService.getGovernanceSystemRegistry(tenantID);
            if (govRegistry.resourceExists("/apimgt/applicationdata/tiers.xml")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Tier policies already uploaded to the tenant's registry space");
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding API tier policies to the tenant's registry");
            }
            InputStream inputStream = APIManagerComponent.class.getResourceAsStream("/tiers/default-tiers.xml");
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            Resource resource = govRegistry.newResource();
            resource.setContent((Object)data);
            govRegistry.put("/apimgt/applicationdata/tiers.xml", resource);
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while saving policy information to the registry", (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading policy file content", (Throwable)e);
        }
    }

    public static void loadTenantExternalStoreConfig(int tenantID) throws APIManagementException {
        try {
            RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
            UserRegistry govRegistry = registryService.getGovernanceSystemRegistry(tenantID);
            if (govRegistry.resourceExists("/apimgt/externalstores/external-api-stores.xml")) {
                log.debug((Object)"External Stores configuration already uploaded to the registry");
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding External Stores configuration to the tenant's registry");
            }
            InputStream inputStream = APIManagerComponent.class.getResourceAsStream("/externalstores/default-external-api-stores.xml");
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            Resource resource = govRegistry.newResource();
            resource.setContent((Object)data);
            govRegistry.put("/apimgt/externalstores/external-api-stores.xml", resource);
            AuthorizationManager authManager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantID).getAuthorizationManager();
            String resourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(APIUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + "/apimgt/externalstores/external-api-stores.xml"));
            authManager.denyRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while saving External Stores configuration information to the registry", (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading External Stores configuration file content", (Throwable)e);
        }
        catch (UserStoreException e) {
            throw new APIManagementException("Error while setting permission to External Stores configuration file", (Throwable)e);
        }
    }

    public static void loadTenantGAConfig(int tenantID) throws APIManagementException {
        try {
            RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
            UserRegistry govRegistry = registryService.getGovernanceSystemRegistry(tenantID);
            if (govRegistry.resourceExists("/apimgt/statistics/ga-config.xml")) {
                log.debug((Object)"Google Analytics configuration already uploaded to the registry");
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding Google Analytics configuration to the tenant's registry");
            }
            InputStream inputStream = APIManagerComponent.class.getResourceAsStream("/statistics/default-ga-config.xml");
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            Resource resource = govRegistry.newResource();
            resource.setContent((Object)data);
            govRegistry.put("/apimgt/statistics/ga-config.xml", resource);
            AuthorizationManager authManager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantID).getAuthorizationManager();
            String resourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(APIUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + "/apimgt/statistics/ga-config.xml"));
            authManager.denyRole("internal/everyone", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while saving Google Analytics configuration information to the registry", (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading Google Analytics configuration file content", (Throwable)e);
        }
        catch (UserStoreException e) {
            throw new APIManagementException("Error while setting permission to Google Analytics configuration file", (Throwable)e);
        }
    }

    public static void loadTenantWorkFlowExtensions(int tenantID) throws APIManagementException {
        try {
            RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
            UserRegistry govRegistry = registryService.getGovernanceSystemRegistry(tenantID);
            if (govRegistry.resourceExists("/apimgt/applicationdata/workflow-extensions.xml")) {
                log.debug((Object)"External Stores configuration already uploaded to the registry");
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding External Stores configuration to the tenant's registry");
            }
            InputStream inputStream = APIManagerComponent.class.getResourceAsStream("/workflowextensions/default-workflow-extensions.xml");
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            Resource resource = govRegistry.newResource();
            resource.setContent((Object)data);
            resource.setMediaType("workflow-config");
            govRegistry.put("/apimgt/applicationdata/workflow-extensions.xml", resource);
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while saving External Stores configuration information to the registry", (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading External Stores configuration file content", (Throwable)e);
        }
    }

    public static void loadTenantSelfSignUpConfigurations(int tenantId) throws APIManagementException {
        try {
            RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
            UserRegistry govRegistry = registryService.getGovernanceSystemRegistry(tenantId);
            if (govRegistry.resourceExists("/apimgt/applicationdata/sign-up-config.xml")) {
                log.debug((Object)"Self signup configuration already uploaded to the registry");
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding Self signup configuration to the tenant's registry");
            }
            InputStream inputStream = tenantId == -1234 ? APIManagerComponent.class.getResourceAsStream("/signupconfigurations/default-sign-up-config.xml") : APIManagerComponent.class.getResourceAsStream("/signupconfigurations/tenant-sign-up-config.xml");
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            Resource resource = govRegistry.newResource();
            resource.setContent((Object)data);
            resource.setMediaType("signup-config");
            govRegistry.put("/apimgt/applicationdata/sign-up-config.xml", resource);
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while saving Self signup configuration information to the registry", (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading Self signup configuration file content", (Throwable)e);
        }
    }

    public static void createSelfSignUpRoles(int tenantId) throws APIManagementException {
        try {
            RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
            UserRegistry govRegistry = registryService.getGovernanceSystemRegistry(tenantId);
            if (govRegistry.resourceExists("/apimgt/applicationdata/sign-up-config.xml")) {
                Resource resource = govRegistry.get("/apimgt/applicationdata/sign-up-config.xml");
                InputStream content = resource.getContentStream();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                Document dc = parser.parse(content);
                boolean enableSignup = Boolean.parseBoolean(dc.getElementsByTagName("EnableSignup").item(0).getFirstChild().getNodeValue());
                String signUpDomain = dc.getElementsByTagName("SignUpDomain").item(0).getFirstChild().getNodeValue();
                if (enableSignup) {
                    int roleLength = dc.getElementsByTagName("RoleName").getLength();
                    for (int i = 0; i < roleLength; ++i) {
                        String roleName = dc.getElementsByTagName("RoleName").item(i).getFirstChild().getNodeValue();
                        boolean isExternalRole = Boolean.parseBoolean(dc.getElementsByTagName("IsExternalRole").item(i).getFirstChild().getNodeValue());
                        if (roleName == null) continue;
                        roleName = isExternalRole && signUpDomain != null ? signUpDomain.toUpperCase() + "/" + roleName : "Internal/" + roleName;
                        APIUtil.createSubscriberRole(roleName, tenantId);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding Self signup configuration to the tenant's registry");
            }
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while getting Self signup role information from the registry", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new APIManagementException("Error while getting Self signup role information from the registry", (Throwable)e);
        }
        catch (SAXException e) {
            throw new APIManagementException("Error while getting Self signup role information from the registry", (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error while getting Self signup role information from the registry", (Throwable)e);
        }
    }

    public static void addBamServerProfile(String bamServerURL, String bamServerUser, String bamServerPassword, String bamServerThriftPort, int tenantId) throws APIManagementException {
        RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
        try {
            UserRegistry registry = registryService.getConfigSystemRegistry(tenantId);
            log.debug((Object)"Adding Bam Server Profile to the registry");
            InputStream inputStream = APIManagerComponent.class.getResourceAsStream("/bam/profile/bam-profile.xml");
            String bamProfile = IOUtils.toString((InputStream)inputStream);
            int strIndex = bamServerURL.indexOf("://");
            int endIndex = bamServerURL.lastIndexOf(":");
            bamServerURL = bamServerURL.substring(strIndex + 3, endIndex);
            bamServerPassword = APIUtil.encryptPassword(bamServerPassword);
            int bamServerThriftPortVal = Integer.parseInt(bamServerThriftPort);
            String bamServerThriftAuthPort = String.valueOf(bamServerThriftPortVal + 100);
            String bamProfileConfig = bamProfile.replaceAll("\\[1\\]", bamServerURL).replaceAll("\\[2\\]", bamServerThriftAuthPort).replaceAll("\\[3\\]", bamServerThriftPort).replaceAll("\\[4\\]", bamServerUser).replaceAll("\\[5\\]", bamServerPassword);
            Resource resource = registry.newResource();
            resource.setContent((Object)bamProfileConfig);
            registry.put("bamServerProfiles/bam-profile", resource);
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while adding BAM Server Profile configuration information to the registry", (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading BAM Server Profile configuration configuration file content", (Throwable)e);
        }
    }

    public static void writeDefinedSequencesToTenantRegistry(int tenantID) throws APIManagementException {
        try {
            RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
            UserRegistry govRegistry = registryService.getGovernanceSystemRegistry(tenantID);
            if (govRegistry.resourceExists("/apimgt/customsequences/in/")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Defined sequences have already been added to the tenant's registry");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Adding defined sequences to the tenant's registry.");
                }
                InputStream inSeqStream = APIManagerComponent.class.getResourceAsStream("/definedsequences/in/log_in_message.xml");
                byte[] inSeqData = IOUtils.toByteArray((InputStream)inSeqStream);
                Resource inSeqResource = govRegistry.newResource();
                inSeqResource.setContent((Object)inSeqData);
                govRegistry.put("/apimgt/customsequences/in/log_in_message.xml", inSeqResource);
                InputStream outSeqStream = APIManagerComponent.class.getResourceAsStream("/definedsequences/out/log_out_message.xml");
                byte[] outSeqData = IOUtils.toByteArray((InputStream)outSeqStream);
                Resource outSeqResource = govRegistry.newResource();
                outSeqResource.setContent((Object)outSeqData);
                govRegistry.put("/apimgt/customsequences/out/log_out_message.xml", outSeqResource);
            }
            if (govRegistry.resourceExists("/apimgt/customsequences/fault/")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Defined fault sequences have already been added to the tenant's registry");
                }
                return;
            }
            InputStream faultSeqStream = APIManagerComponent.class.getResourceAsStream("/definedsequences/fault/json_fault.xml");
            byte[] faultSeqData = IOUtils.toByteArray((InputStream)faultSeqStream);
            Resource faultSeqResource = govRegistry.newResource();
            faultSeqResource.setContent((Object)faultSeqData);
            govRegistry.put("/apimgt/customsequences/fault/json_fault.xml", faultSeqResource);
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while saving defined sequences to the tenant's registry ", (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading defined sequence ", (Throwable)e);
        }
    }

    public static void loadloadTenantAPIRXT(String tenant, int tenantID) throws APIManagementException {
        String[] rxtFilePaths;
        RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
        UserRegistry registry = null;
        try {
            registry = registryService.getGovernanceSystemRegistry(tenantID);
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error when create registry instance ", (Throwable)e);
        }
        String rxtDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "rxts";
        File file = new File(rxtDir);
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".rxt");
            }
        };
        for (String rxtPath : rxtFilePaths = file.list(filenameFilter)) {
            String msg;
            String resourcePath = "/_system/governance/repository/components/org.wso2.carbon.governance/types/" + rxtPath;
            String govRelativePath = RegistryUtils.getRelativePathToOriginal((String)resourcePath, (String)APIUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance"));
            try {
                RegistryAuthorizationManager authorizationManager = new RegistryAuthorizationManager(ServiceReferenceHolder.getUserRealm());
                resourcePath = authorizationManager.computePathOnMount(resourcePath);
                AuthorizationManager authManager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantID).getAuthorizationManager();
                if (registry.resourceExists(govRelativePath)) {
                    authManager.authorizeRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    continue;
                }
                String rxt = FileUtil.readFileToString((String)(rxtDir + File.separator + rxtPath));
                Resource resource = registry.newResource();
                resource.setContent((Object)rxt.getBytes());
                resource.setMediaType("application/vnd.wso2.registry-ext-type+xml");
                registry.put(govRelativePath, resource);
                authManager.authorizeRole("system/wso2.anonymous.role", resourcePath, "http://www.wso2.org/projects/registry/actions/get");
            }
            catch (UserStoreException e) {
                throw new APIManagementException("Error while adding role permissions to API", (Throwable)e);
            }
            catch (IOException e) {
                msg = "Failed to read rxt files";
                throw new APIManagementException(msg, (Throwable)e);
            }
            catch (RegistryException e) {
                msg = "Failed to add rxt to registry ";
                throw new APIManagementException(msg, (Throwable)e);
            }
        }
    }

    public static String setDomainNameToUppercase(String username) {
        String[] nameParts;
        if (username != null && (nameParts = username.split("/")).length > 1) {
            username = nameParts[0].toUpperCase() + "/" + nameParts[1];
        }
        return username;
    }

    public static void createSubscriberRole(String roleName, int tenantId) throws APIManagementException {
        String[] permissions = new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"};
        try {
            UserStoreManager manager;
            RealmService realmService = ServiceReferenceHolder.getInstance().getRealmService();
            if (tenantId < 0) {
                UserRealm realm = realmService.getBootstrapRealm();
                manager = realm.getUserStoreManager();
            } else {
                org.wso2.carbon.user.api.UserRealm tenantRealm = realmService.getTenantUserRealm(tenantId);
                manager = tenantRealm.getUserStoreManager();
            }
            if (!manager.isExistingRole(roleName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating subscriber role: " + roleName));
                }
                Permission[] subscriberPermissions = new Permission[]{new Permission("/permission/admin/login", "ui.execute"), new Permission("/permission/admin/manage/api/subscribe", "ui.execute")};
                String tenantAdminName = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getRealmConfiguration().getAdminUserName();
                String[] userList = new String[]{tenantAdminName};
                manager.addRole(roleName, userList, subscriberPermissions);
            }
        }
        catch (UserStoreException e) {
            throw new APIManagementException("Error while creating subscriber role: " + roleName + " - " + "Self registration might not function properly.", (Throwable)e);
        }
    }

    public void setupSelfRegistration(APIManagerConfiguration config, int tenantId) throws APIManagementException {
        boolean enabled = Boolean.parseBoolean(config.getFirstProperty("SelfSignUp.Enabled"));
        if (!enabled) {
            return;
        }
        String role = "Internal/" + config.getFirstProperty("SelfSignUp.SubscriberRoleName");
        if (role.equals("Internal/")) {
            throw new APIManagementException("Required subscriber role parameter missing in the self sign up configuration");
        }
        String[] permissions = new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"};
        try {
            UserStoreManager manager;
            RealmService realmService = ServiceReferenceHolder.getInstance().getRealmService();
            if (tenantId < 0) {
                UserRealm realm = realmService.getBootstrapRealm();
                manager = realm.getUserStoreManager();
            } else {
                org.wso2.carbon.user.api.UserRealm tenantRealm = realmService.getTenantUserRealm(tenantId);
                manager = tenantRealm.getUserStoreManager();
            }
            if (!manager.isExistingRole(role)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating subscriber role: " + role));
                }
                Permission[] subscriberPermissions = new Permission[]{new Permission("/permission/admin/login", "ui.execute"), new Permission("/permission/admin/manage/api/subscribe", "ui.execute")};
                String tenantAdminName = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getRealmConfiguration().getAdminUserName();
                String[] userList = new String[]{tenantAdminName};
                manager.addRole(role, userList, subscriberPermissions);
            }
        }
        catch (UserStoreException e) {
            throw new APIManagementException("Error while creating subscriber role: " + role + " - " + "Self registration might not function properly.", (Throwable)e);
        }
    }

    public static String removeAnySymbolFromUriTempate(String uriTemplate) {
        int anySymbolIndex;
        if (uriTemplate != null && (anySymbolIndex = uriTemplate.indexOf("/*")) != -1) {
            return uriTemplate.substring(0, anySymbolIndex);
        }
        return uriTemplate;
    }

    public static float getAverageRating(APIIdentifier apiId) throws APIManagementException {
        return ApiMgtDAO.getAverageRating(apiId);
    }

    public static List<Tenant> getAllTenantsWithSuperTenant() throws UserStoreException {
        Tenant[] tenants = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getAllTenants();
        ArrayList<Tenant> tenantArrayList = new ArrayList<Tenant>();
        for (Tenant t : tenants) {
            tenantArrayList.add(t);
        }
        Tenant superAdminTenant = new Tenant();
        superAdminTenant.setDomain("carbon.super");
        superAdminTenant.setId(-1234);
        superAdminTenant.setAdminName("wso2.anonymous.user");
        tenantArrayList.add(superAdminTenant);
        return tenantArrayList;
    }

    public static boolean isLoggedInUserAuthorizedToRevokeToken(String loggedInUser, String authorizedUser) {
        String loggedUserTenantDomain = MultitenantUtils.getTenantDomain((String)loggedInUser);
        String authorizedUserTenantDomain = MultitenantUtils.getTenantDomain((String)authorizedUser);
        if (loggedUserTenantDomain.equals("carbon.super") && authorizedUserTenantDomain.equals("carbon.super")) {
            return true;
        }
        return loggedUserTenantDomain.equals(authorizedUserTenantDomain);
    }

    public static int getApplicationId(String appName, String userId) throws APIManagementException {
        return new ApiMgtDAO().getApplicationId(appName, userId);
    }

    public static boolean isAPIManagementEnabled() {
        return Boolean.parseBoolean(CarbonUtils.getServerConfiguration().getFirstProperty("APIManagement.Enabled"));
    }

    public static boolean isLoadAPIContextsAtStartup() {
        return Boolean.parseBoolean(CarbonUtils.getServerConfiguration().getFirstProperty("APIManagement.LoadAPIContextsInServerStartup"));
    }

    public static Set<APIStore> getExternalAPIStores(int tenantId) throws APIManagementException {
        TreeSet<APIStore> apistoreSet = new TreeSet<APIStore>(new APIStoreNameComparator());
        apistoreSet.addAll(APIUtil.getExternalStores(tenantId));
        if (apistoreSet.size() != 0) {
            return apistoreSet;
        }
        return null;
    }

    public static boolean isAllowDisplayAPIsWithMultipleStatus() {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        String displayAllAPIs = config.getFirstProperty("APIStore.DisplayAllAPIs");
        if (displayAllAPIs == null) {
            log.warn((Object)"The configurations related to show deprecated APIs in APIStore are missing in api-manager.xml.");
            return false;
        }
        return Boolean.parseBoolean(displayAllAPIs);
    }

    public static boolean isAllowDisplayMultipleVersions() {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        String displayMultiVersions = config.getFirstProperty("APIStore.DisplayMultipleVersions");
        if (displayMultiVersions == null) {
            log.warn((Object)"The configurations related to show multiple versions of API in APIStore are missing in api-manager.xml.");
            return false;
        }
        return Boolean.parseBoolean(displayMultiVersions);
    }

    public static Set<APIStore> getExternalAPIStores(Set<APIStore> inputStores, int tenantId) throws APIManagementException {
        TreeSet<APIStore> apiStores = new TreeSet<APIStore>(new APIStoreNameComparator());
        apiStores.addAll(APIUtil.getExternalStores(tenantId));
        boolean exists = false;
        if (apiStores.size() != 0) {
            for (APIStore store : apiStores) {
                for (APIStore inputStore : inputStores) {
                    if (!inputStore.getName().equals(store.getName())) continue;
                    exists = true;
                }
                if (!exists) {
                    inputStores.add(store);
                }
                exists = false;
            }
        }
        return inputStores;
    }

    public static boolean isAPIsPublishToExternalAPIStores(int tenantId) throws APIManagementException {
        return APIUtil.getExternalStores(tenantId).size() != 0;
    }

    public static boolean isAPIGatewayKeyCacheEnabled() {
        try {
            APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
            String serviceURL = config.getFirstProperty("APIGateway.EnableGatewayKeyCache");
            return Boolean.parseBoolean(serviceURL);
        }
        catch (Exception e) {
            log.error((Object)("Did not found valid API Validation Information cache configuration. Use default configuration" + e));
            return true;
        }
    }

    public static Cache getAPIContextCache() {
        CacheManager contextCacheManager = Caching.getCacheManager((String)"API_CONTEXT_CACHE_MANAGER").getCache("apiContextCache").getCacheManager();
        if (!isContextCacheInitialized) {
            isContextCacheInitialized = true;
            return contextCacheManager.createCacheBuilder("API_CONTEXT_CACHE_MANAGER").setExpiry(CacheConfiguration.ExpiryType.MODIFIED, new CacheConfiguration.Duration(TimeUnit.DAYS, 3650L)).setStoreByValue(false).build();
        }
        return Caching.getCacheManager((String)"API_CONTEXT_CACHE_MANAGER").getCache("apiContextCache");
    }

    public static Set<String> getActiveTenantDomains() throws UserStoreException {
        HashSet<String> tenantDomains = null;
        Tenant[] tenants = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getAllTenants();
        if (tenants == null || tenants.length == 0) {
            return tenantDomains;
        }
        tenantDomains = new HashSet<String>();
        for (Tenant tenant : tenants) {
            if (!tenant.isActive()) continue;
            tenantDomains.add(tenant.getDomain());
        }
        if (tenantDomains.size() > 0) {
            tenantDomains.add("carbon.super");
        }
        return tenantDomains;
    }

    public static String[] getRoleNames(String username) throws APIManagementException {
        String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
        try {
            if (!tenantDomain.equals("carbon.super")) {
                int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
                org.wso2.carbon.user.api.UserStoreManager manager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
                return manager.getRoleNames();
            }
            return RemoteAuthorizationManager.getInstance().getRoleNames();
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while getting all the roles", (Throwable)e);
            return null;
        }
    }

    public static String createSwagger12JSONContent(API api) throws APIManagementException {
        JSONParser parser = new JSONParser();
        String pathJsonTemplate = "{\n    \"path\": \"\",\n    \"operations\": []\n}";
        String operationJsonTemplate = "{\n    \"method\": \"\",\n    \"parameters\": []\n}";
        String apiJsonTemplate = "{\n    \"apiVersion\": \"\",\n    \"swaggerVersion\": \"1.2\",\n    \"apis\": [],\n    \"info\": {\n        \"title\": \"\",\n        \"description\": \"\",\n        \"termsOfServiceUrl\": \"\",\n        \"contact\": \"\",\n        \"license\": \"\",\n        \"licenseUrl\": \"\"\n    },\n    \"authorizations\": {\n        \"oauth2\": {\n            \"type\": \"oauth2\",\n            \"scopes\": []\n        }\n    }\n}";
        String apiResourceJsontemplate = "{\n    \"apiVersion\": \"\",\n    \"swaggerVersion\": \"1.2\",\n    \"resourcePath\":\"\",\n    \"apis\": [],\n    \"info\": {\n        \"title\": \"\",\n        \"description\": \"\",\n        \"termsOfServiceUrl\": \"\",\n        \"contact\": \"\",\n        \"license\": \"\",\n        \"licenseUrl\": \"\"\n    },\n    \"authorizations\": {\n        \"oauth2\": {\n            \"type\": \"oauth2\",\n            \"scopes\": []\n        }\n    }\n}";
        APIIdentifier identifier = api.getId();
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        Environment environment = (Environment)config.getApiGatewayEnvironments().get(0);
        String endpoints = environment.getApiGatewayEndpoint();
        String[] endpointsSet = endpoints.split(",");
        String apiContext = api.getContext();
        String version = identifier.getVersion();
        Set uriTemplates = api.getUriTemplates();
        String description = api.getDescription();
        if (endpointsSet.length < 1) {
            throw new APIManagementException("Error in creating JSON representation of the API" + identifier.getApiName());
        }
        description = description == null || description.equals("") ? "" : description.trim();
        HashMap<String, ArrayList<String>> resourceNamepaths = new HashMap<String, ArrayList<String>>();
        HashMap<String, JSONObject> resourceNameJSONs = new HashMap<String, JSONObject>();
        HashMap<String, ArrayList> resourcePathJSONs = new HashMap<String, ArrayList>();
        ArrayList apis = new ArrayList();
        JSONObject mainAPIJson = null;
        try {
            JSONObject jsonOb;
            String resourcePath;
            mainAPIJson = (JSONObject)parser.parse(apiJsonTemplate);
            for (URITemplate uRITemplate : uriTemplates) {
                String[] httpVerbs;
                ArrayList<String> resourcePaths;
                Object parameters = null;
                String path = uRITemplate.getUriTemplate();
                if (path != null && (path.equals("/*") || path.equals("/"))) {
                    path = "/*";
                }
                int resourceNameEndIndex = path.indexOf("/", 1);
                String resourceName = "/default";
                if (resourceNameEndIndex != -1) {
                    resourceName = path.substring(1, resourceNameEndIndex);
                }
                if (!resourceName.startsWith("/")) {
                    resourceName = "/" + resourceName;
                }
                if (resourceNamepaths.get(resourceName) != null) {
                    String[] httpVerbs2;
                    resourcePaths = (ArrayList<String>)resourceNamepaths.get(resourceName);
                    if (!resourcePaths.contains(path)) {
                        resourcePaths.add(path);
                    }
                    String httpVerbsStrng = uRITemplate.getMethodsAsString();
                    for (String httpVerb : httpVerbs2 = httpVerbsStrng.split(" ")) {
                        final JSONObject operationJson = (JSONObject)parser.parse(operationJsonTemplate);
                        operationJson.put((Object)"method", (Object)httpVerb);
                        operationJson.put((Object)"auth_type", (Object)uRITemplate.getAuthType());
                        operationJson.put((Object)"throttling_tier", (Object)uRITemplate.getThrottlingTier());
                        if (resourcePathJSONs.get(path) != null) {
                            ((List)resourcePathJSONs.get(path)).add(operationJson);
                            continue;
                        }
                        resourcePathJSONs.put(path, new ArrayList<JSONObject>(){
                            {
                                this.add(operationJson);
                            }
                        });
                    }
                    resourceNamepaths.put(resourceName, resourcePaths);
                    continue;
                }
                JSONObject resourcePathJson = (JSONObject)parser.parse(apiResourceJsontemplate);
                resourcePathJson.put((Object)"apiVersion", (Object)version);
                resourcePathJson.put((Object)"resourcePath", (Object)resourceName);
                resourceNameJSONs.put(resourceName, resourcePathJson);
                resourcePaths = new ArrayList<String>();
                resourcePaths.add(path);
                String httpVerbsStrng = uRITemplate.getMethodsAsString();
                for (String httpVerb : httpVerbs = httpVerbsStrng.split(" ")) {
                    final JSONObject operationJson = (JSONObject)parser.parse(operationJsonTemplate);
                    operationJson.put((Object)"method", (Object)httpVerb);
                    operationJson.put((Object)"auth_type", (Object)uRITemplate.getAuthType());
                    operationJson.put((Object)"throttling_tier", (Object)uRITemplate.getThrottlingTier());
                    if (resourcePathJSONs.get(path) != null) {
                        ((List)resourcePathJSONs.get(path)).add(operationJson);
                        continue;
                    }
                    resourcePathJSONs.put(path, new ArrayList<JSONObject>(){
                        {
                            this.add(operationJson);
                        }
                    });
                }
                resourceNamepaths.put(resourceName, resourcePaths);
            }
            for (Map.Entry entry : resourceNamepaths.entrySet()) {
                resourcePath = (String)entry.getKey();
                jsonOb = (JSONObject)resourceNameJSONs.get(resourcePath);
                List pathItems = (List)entry.getValue();
                for (String pathItem : pathItems) {
                    JSONObject pathJson = (JSONObject)parser.parse(pathJsonTemplate);
                    pathJson.put((Object)"path", (Object)pathItem);
                    List methodJsons = (List)resourcePathJSONs.get(pathItem);
                    for (JSONObject methodJson : methodJsons) {
                        JSONArray operations = (JSONArray)pathJson.get((Object)"operations");
                        operations.add((Object)methodJson);
                    }
                    JSONArray apis1 = (JSONArray)jsonOb.get((Object)"apis");
                    apis1.add((Object)pathJson);
                }
            }
            mainAPIJson.put((Object)"apiVersion", (Object)version);
            ((JSONObject)mainAPIJson.get((Object)"info")).put((Object)"description", (Object)description);
            for (Map.Entry entry : resourceNamepaths.entrySet()) {
                resourcePath = (String)entry.getKey();
                jsonOb = (JSONObject)resourceNameJSONs.get(resourcePath);
                JSONArray apis1 = (JSONArray)mainAPIJson.get((Object)"apis");
                JSONObject pathjob = new JSONObject();
                pathjob.put((Object)"path", (Object)resourcePath);
                pathjob.put((Object)"description", (Object)"");
                pathjob.put((Object)"file", (Object)jsonOb);
                apis1.add((Object)pathjob);
            }
        }
        catch (ParseException e) {
            throw new APIManagementException("Error while generating swagger 1.2 resource for api " + api.getId().getProviderName() + "-" + api.getId().getApiName() + "-" + api.getId().getVersion(), (Throwable)e);
        }
        return mainAPIJson.toJSONString();
    }

    public static String createSwaggerJSONContent(API api) throws APIManagementException {
        APIIdentifier identifier = api.getId();
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        Environment environment = (Environment)config.getApiGatewayEnvironments().get(0);
        String endpoints = environment.getApiGatewayEndpoint();
        String[] endpointsSet = endpoints.split(",");
        String apiContext = api.getContext();
        String version = identifier.getVersion();
        Set uriTemplates = api.getUriTemplates();
        String description = api.getDescription();
        String urlPrefix = apiContext + "/" + version;
        if (endpointsSet.length < 1) {
            throw new APIManagementException("Error in creating JSON representation of the API" + identifier.getApiName());
        }
        description = description == null || description.equals("") ? "" : description.trim();
        HashMap uriTemplateDefinitions = new HashMap();
        ArrayList<APIResource> apis = new ArrayList<APIResource>();
        for (URITemplate template : uriTemplates) {
            Operation op;
            Parameter authParam;
            Parameter payLoadParam;
            Parameter queryParam;
            String httpVerb;
            List<Operation> ops;
            ArrayList<Parameter> parameters = null;
            String path = urlPrefix + APIUtil.removeAnySymbolFromUriTempate(template.getUriTemplate());
            if (uriTemplateDefinitions.get(path) != null) {
                ops = (List)uriTemplateDefinitions.get(path);
                parameters = new ArrayList();
                httpVerb = template.getHTTPVerb();
                if (httpVerb.equals("GET") || httpVerb.equals("DELETE")) {
                    queryParam = new Parameter("Query Parameters", "Request Query Parameters", "body", false, false, "String");
                    parameters.add(queryParam);
                } else {
                    payLoadParam = new Parameter("Payload", "Request Payload", "body", false, false, "String");
                    parameters.add(payLoadParam);
                }
                authParam = new Parameter("Authorization", "OAuth2 Authorization Header", "header", false, false, "String");
                parameters.add(authParam);
                if (httpVerb.equals("OPTIONS")) continue;
                op = new Operation(httpVerb, description, description, parameters);
                ops.add(op);
                continue;
            }
            ops = new ArrayList();
            parameters = new ArrayList<Parameter>();
            httpVerb = template.getHTTPVerb();
            if (httpVerb.equals("GET") || httpVerb.equals("DELETE")) {
                queryParam = new Parameter("Query Parameters", "Request Query Parameters", "body", false, false, "String");
                parameters.add(queryParam);
            } else {
                payLoadParam = new Parameter("Payload", "Request Payload", "body", false, false, "String");
                parameters.add(payLoadParam);
            }
            authParam = new Parameter("Authorization", "OAuth2 Authorization Header", "header", false, false, "String");
            parameters.add(authParam);
            if (!httpVerb.equals("OPTIONS")) {
                op = new Operation(httpVerb, description, description, parameters);
                ops.add(op);
            }
            uriTemplateDefinitions.put(path, ops);
        }
        Set resPaths = uriTemplateDefinitions.keySet();
        for (String resPath : resPaths) {
            APIResource apiResource = new APIResource(resPath, description, (List)uriTemplateDefinitions.get(resPath));
            apis.add(apiResource);
        }
        APIDefinition apidefinition = new APIDefinition(version, "1.1", endpointsSet[0], apiContext, apis);
        Gson gson = new Gson();
        return gson.toJson((Object)apidefinition);
    }

    public static int getTenantId(String userName) {
        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        RealmService realmService = ServiceReferenceHolder.getInstance().getRealmService();
        if (realmService == null) {
            return -1234;
        }
        try {
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            return tenantId;
        }
        catch (UserStoreException e) {
            log.error((Object)e);
            return -1;
        }
    }

    public static String getUserNameWithTenantSuffix(String userName) {
        String userNameWithTenantPrefix = userName;
        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        if (userName != null && !userName.contains("@") && "carbon.super".equals(tenantDomain)) {
            userNameWithTenantPrefix = userName + "@" + tenantDomain;
        }
        return userNameWithTenantPrefix;
    }

    public static OMElement buildOMElement(InputStream inputStream) throws Exception {
        StAXOMBuilder builder;
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            builder = new StAXOMBuilder(parser);
        }
        catch (XMLStreamException e) {
            String msg = "Error in initializing the parser.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return builder.getDocumentElement();
    }

    public static OMElement getCustomSequence(String sequenceName, int tenantId, String direction) throws APIManagementException {
        Collection seqCollection = null;
        try {
            UserRegistry registry = ServiceReferenceHolder.getInstance().getRegistryService().getGovernanceSystemRegistry(tenantId);
            if ("in".equals(direction)) {
                seqCollection = (Collection)registry.get("/apimgt/customsequences/in/");
            } else if ("out".equals(direction)) {
                seqCollection = (Collection)registry.get("/apimgt/customsequences/out/");
            } else if ("fault".equals(direction)) {
                seqCollection = (Collection)registry.get("/apimgt/customsequences/fault/");
            }
            if (seqCollection != null) {
                String[] childPaths = seqCollection.getChildren();
                for (int i = 0; i < childPaths.length; ++i) {
                    Resource sequence = registry.get(childPaths[i]);
                    OMElement seqElment = APIUtil.buildOMElement(sequence.getContentStream());
                    if (!sequenceName.equals(seqElment.getAttributeValue(new QName("name")))) continue;
                    return seqElment;
                }
            }
        }
        catch (Exception e) {
            String msg = "Issue is in accessing the Registry";
            log.error((Object)msg);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return null;
    }

    public static String getSequenceExtensionName(API api) {
        String seqExt = api.getId().getProviderName() + "--" + api.getId().getApiName() + ":v" + api.getId().getVersion();
        return seqExt;
    }

    public static String decryptToken(String token) throws CryptoException {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        if (Boolean.parseBoolean(config.getFirstProperty("APIKeyManager.EncryptPersistedTokens"))) {
            return new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(token));
        }
        return token;
    }

    public static String encryptToken(String token) throws CryptoException {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        if (Boolean.parseBoolean(config.getFirstProperty("APIKeyManager.EncryptPersistedTokens"))) {
            return CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(token.getBytes());
        }
        return token;
    }

    public static void loadTenantRegistry(int tenantId) throws RegistryException {
        TenantRegistryLoader tenantRegistryLoader = APIManagerComponent.getTenantRegistryLoader();
        ServiceReferenceHolder.getInstance().getIndexLoaderService().loadTenantIndex(tenantId);
        tenantRegistryLoader.loadTenantRegistry(tenantId);
    }

    public static String getRegistryResourceHTTPPermlink(String path) {
        String webContext;
        String schemeHttp = "http";
        String schemeHttps = "https";
        ConfigurationContextService contetxservice = ServiceReferenceHolder.getContextService();
        int port = CarbonUtils.getTransportProxyPort((ConfigurationContext)contetxservice.getServerConfigContext(), (String)schemeHttp);
        if (port == -1) {
            port = CarbonUtils.getTransportPort((ConfigurationContext)contetxservice.getServerConfigContext(), (String)schemeHttp);
        }
        if (port == -1) {
            port = CarbonUtils.getTransportProxyPort((ConfigurationContext)contetxservice.getServerConfigContext(), (String)schemeHttps);
        }
        if (port == -1) {
            port = CarbonUtils.getTransportPort((ConfigurationContext)contetxservice.getServerConfigContext(), (String)schemeHttps);
        }
        if ((webContext = ServerConfiguration.getInstance().getFirstProperty("WebContextRoot")) == null || webContext.equals("/")) {
            webContext = "";
        }
        RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
        String version = "";
        if (registryService == null) {
            log.error((Object)"Registry Service has not been set.");
        } else if (path != null) {
            try {
                String[] versions = registryService.getRegistry("wso2.system.user", CarbonContext.getThreadLocalCarbonContext().getTenantId()).getVersions(path);
                if (versions != null && versions.length > 0) {
                    version = versions[0].substring(versions[0].lastIndexOf(";version:"));
                }
            }
            catch (RegistryException e) {
                log.error((Object)("An error occurred while determining the latest version of the resource at the given path: " + path), (Throwable)e);
            }
        }
        if (port != -1 && path != null) {
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
            return webContext + (tenantDomain != null && !"carbon.super".equals(tenantDomain) ? "/t/" + tenantDomain : "") + "/registry/resource" + Utils.encodeRegistryPath((String)path) + version;
        }
        return null;
    }

    public static boolean isSandboxEndpointsExists(API api) {
        JSONParser parser = new JSONParser();
        JSONObject config = null;
        try {
            config = (JSONObject)parser.parse(api.getEndpointConfig());
            if (config.containsKey((Object)"sandbox_endpoints")) {
                return true;
            }
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse endpoint config JSON", (Throwable)e);
        }
        catch (ClassCastException e) {
            log.error((Object)"Unable to parse endpoint config JSON", (Throwable)e);
        }
        return false;
    }

    public static boolean isProductionEndpointsExists(API api) {
        JSONParser parser = new JSONParser();
        JSONObject config = null;
        try {
            config = (JSONObject)parser.parse(api.getEndpointConfig());
            if (config.containsKey((Object)"production_endpoints")) {
                return true;
            }
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse endpoint config JSON", (Throwable)e);
        }
        catch (ClassCastException e) {
            log.error((Object)"Unable to parse endpoint config JSON", (Throwable)e);
        }
        return false;
    }

    public static API getAPIInformation(GovernanceArtifact artifact, Registry registry) throws APIManagementException {
        API api;
        try {
            String providerName = artifact.getAttribute("overview_provider");
            String apiName = artifact.getAttribute("overview_name");
            String apiVersion = artifact.getAttribute("overview_version");
            api = new API(new APIIdentifier(providerName, apiName, apiVersion));
            api.setThumbnailUrl(artifact.getAttribute("overview_thumbnail"));
            api.setStatus(APIUtil.getApiStatus(artifact.getAttribute("overview_status")));
            api.setContext(artifact.getAttribute("overview_context"));
            api.setVisibility(artifact.getAttribute("overview_visibility"));
            api.setVisibleRoles(artifact.getAttribute("overview_visibleRoles"));
            api.setVisibleTenants(artifact.getAttribute("overview_visibleTenants"));
            api.setTransports(artifact.getAttribute("overview_transports"));
            api.setInSequence(artifact.getAttribute("overview_inSequence"));
            api.setOutSequence(artifact.getAttribute("overview_outSequence"));
            api.setFaultSequence(artifact.getAttribute("overview_faultSequence"));
            api.setDescription(artifact.getAttribute("overview_description"));
            api.setRedirectURL(artifact.getAttribute("overview_redirectURL"));
            api.setApiOwner(artifact.getAttribute("overview_apiOwner"));
            api.setAdvertiseOnly(Boolean.parseBoolean(artifact.getAttribute("overview_advertiseOnly")));
        }
        catch (GovernanceException e) {
            String msg = "Failed to get API fro artifact ";
            throw new APIManagementException(msg, (Throwable)e);
        }
        return api;
    }

    public static String getResourceInfoDTOCacheKey(String apiContext, String apiVersion, String resourceUri, String httpMethod) {
        return apiContext + "/" + apiVersion + resourceUri + ":" + httpMethod;
    }

    public static String getResourceKey(API api, URITemplate template) {
        return APIUtil.getResourceKey(api.getContext(), api.getId().getVersion(), template.getUriTemplate(), template.getHTTPVerb());
    }

    public static String getResourceKey(String apiContext, String apiVersion, String resourceUri, String httpMethod) {
        return apiContext + "/" + apiVersion + resourceUri + ":" + httpMethod;
    }

    public static Scope findScopeByKey(Set<Scope> scopes, String key) {
        for (Scope scope : scopes) {
            if (!scope.getKey().equals(key)) continue;
            return scope;
        }
        return null;
    }

    public static String getAPIInfoDTOCacheKey(String apiContext, String apiVersion) {
        return apiContext + "/" + apiVersion;
    }

    public static String getAccessTokenCacheKey(String accessToken, String apiContext, String apiVersion, String resourceUri, String httpVerb, String authLevel) {
        return accessToken + ":" + apiContext + "/" + apiVersion + resourceUri + ":" + httpVerb + ":" + authLevel;
    }

    private static String replaceSystemProperty(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        while (indexOfStartingChars < text.indexOf("${") && (indexOfStartingChars = text.indexOf("${")) != -1 && (indexOfClosingBrace = text.indexOf(125)) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(sysProp);
            if (propValue != null) {
                text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
            if (!sysProp.equals("carbon.home") || propValue == null || !propValue.equals(".")) continue;
            text = new File(".").getAbsolutePath() + File.separator + text;
        }
        return text;
    }

    public static String encryptPassword(String plainTextPassword) throws APIManagementException {
        try {
            return CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(plainTextPassword.getBytes());
        }
        catch (CryptoException e) {
            String errorMsg = "Error while encrypting the password. " + e.getMessage();
            throw new APIManagementException(errorMsg, (Throwable)e);
        }
    }

    public static Map<Documentation, API> searchAPIsByDoc(Registry registry, int tenantID, String username, String searchTerm, String searchType) throws APIManagementException {
        ArrayList<API> apiSortedList = new ArrayList<API>();
        HashMap<Documentation, API> apiDocMap = new HashMap<Documentation, API>();
        try {
            GenericArtifactManager artifactManager = APIUtil.getArtifactManager(registry, "api");
            GenericArtifactManager docArtifactManager = APIUtil.getArtifactManager(registry, "document");
            SolrClient client = SolrClient.getInstance();
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("path", "*/apimgt/applicationdata/provider*");
            fields.put("mediaType", "*");
            SolrDocumentList documentList = client.query(searchTerm, tenantID, fields);
            AuthorizationManager manager = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(tenantID).getAuthorizationManager();
            username = MultitenantUtils.getTenantAwareUsername((String)username);
            for (SolrDocument document : documentList) {
                String filePath = (String)document.getFieldValue("path_s");
                int index = filePath.indexOf("/apimgt");
                filePath = filePath.substring(index);
                Association[] associations = registry.getAllAssociations(filePath);
                API api = null;
                Documentation doc = null;
                for (Association association : associations) {
                    boolean isAuthorized = false;
                    String documentationPath = association.getSourcePath();
                    String path = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(APIUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + documentationPath));
                    isAuthorized = "wso2.anonymous.user".equalsIgnoreCase(username) ? manager.isRoleAuthorized("system/wso2.anonymous.role", path, "http://www.wso2.org/projects/registry/actions/get") : manager.isUserAuthorized(username, path, "http://www.wso2.org/projects/registry/actions/get");
                    if (isAuthorized) {
                        Association[] docAssociations;
                        Resource docResource = registry.get(documentationPath);
                        String docArtifactId = docResource.getUUID();
                        if (docArtifactId != null) {
                            GenericArtifact docArtifact = docArtifactManager.getGenericArtifact(docArtifactId);
                            doc = APIUtil.getDocumentation(docArtifact);
                        }
                        if ((docAssociations = registry.getAssociations(documentationPath, "document")).length > 0) {
                            isAuthorized = false;
                            String apiPath = docAssociations[0].getSourcePath();
                            path = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)(APIUtil.getMountedPath(RegistryContext.getBaseInstance(), "/_system/governance") + apiPath));
                            isAuthorized = "wso2.anonymous.user".equalsIgnoreCase(username) ? manager.isRoleAuthorized("system/wso2.anonymous.role", path, "http://www.wso2.org/projects/registry/actions/get") : manager.isUserAuthorized(username, path, "http://www.wso2.org/projects/registry/actions/get");
                            if (isAuthorized) {
                                Resource resource = registry.get(apiPath);
                                String apiArtifactId = resource.getUUID();
                                if (apiArtifactId != null) {
                                    GenericArtifact apiArtifact = artifactManager.getGenericArtifact(apiArtifactId);
                                    api = APIUtil.getAPI((GovernanceArtifact)apiArtifact, registry);
                                    apiSortedList.add(api);
                                } else {
                                    throw new GovernanceException("artifact id is null of " + apiPath);
                                }
                            }
                        }
                    }
                    if (doc == null || api == null) continue;
                    apiDocMap.put(doc, api);
                }
            }
        }
        catch (IndexerException e) {
            APIUtil.handleException("Failed to search APIs with type Doc", e);
        }
        catch (RegistryException e) {
            APIUtil.handleException("Failed to search APIs with type Doc", e);
        }
        catch (UserStoreException e) {
            APIUtil.handleException("Failed to search APIs with type Doc", e);
        }
        return apiDocMap;
    }

    public static Map<String, Object> searchAPIsByURLPattern(Registry registry, String searchTerm, int start, int end) throws APIManagementException {
        TreeSet<API> apiSet = new TreeSet<API>(new APINameComparator());
        ArrayList<API> apiList = new ArrayList<API>();
        final String searchValue = searchTerm.trim();
        HashMap<String, Object> result = new HashMap<String, Object>();
        int totalLength = 0;
        HashMap<String, 4> listMap = new HashMap<String, 4>();
        Object[] genericArtifacts = new GenericArtifact[]{};
        GenericArtifactManager artifactManager = null;
        try {
            artifactManager = APIUtil.getArtifactManager(registry, "api");
            PaginationContext.init((int)0, (int)10000, (String)"ASC", (String)"overview_name", (int)Integer.MAX_VALUE);
            if (artifactManager != null) {
                for (int i = 0; i < 20; ++i) {
                    String criteria = "URITemplate_urlPattern" + i;
                    listMap.put(criteria, new ArrayList<String>(){
                        {
                            this.add(searchValue);
                        }
                    });
                    genericArtifacts = (GenericArtifact[])ArrayUtils.addAll((Object[])genericArtifacts, (Object[])artifactManager.findGenericArtifacts(listMap));
                }
                if (genericArtifacts == null || genericArtifacts.length == 0) {
                    result.put("apis", apiSet);
                    result.put("length", 0);
                    return result;
                }
                totalLength = genericArtifacts.length;
                StringBuilder apiNames = new StringBuilder();
                for (Object artifact : genericArtifacts) {
                    if (apiNames.indexOf(artifact.getAttribute("overview_name")) < 0) {
                        API api;
                        String status = artifact.getAttribute("overview_status");
                        if (APIUtil.isAllowDisplayAPIsWithMultipleStatus()) {
                            if (status.equals("PUBLISHED") || status.equals("DEPRECATED")) {
                                api = APIUtil.getAPI((GovernanceArtifact)artifact, registry);
                                apiList.add(api);
                                apiNames.append(api.getId().getApiName());
                            }
                        } else if (status.equals("PUBLISHED")) {
                            api = APIUtil.getAPI((GovernanceArtifact)artifact, registry);
                            apiList.add(api);
                            apiNames.append(api.getId().getApiName());
                        }
                    }
                    totalLength = apiList.size();
                }
                if (totalLength <= start + end - 1) {
                    end = totalLength;
                }
                for (int i = start; i < end; ++i) {
                    apiSet.add((API)apiList.get(i));
                }
            }
        }
        catch (APIManagementException e) {
            APIUtil.handleException("Failed to search APIs with input url-pattern", e);
        }
        catch (GovernanceException e) {
            APIUtil.handleException("Failed to search APIs with input url-pattern", e);
        }
        result.put("apis", apiSet);
        result.put("length", totalLength);
        return result;
    }

    public static boolean isValidWSDLURL(String wsdlURL) {
        if (wsdlURL != null && !"".equals(wsdlURL) && wsdlURL.contains("http:") | wsdlURL.contains("https:") | wsdlURL.contains("file:")) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("WSDL url validation failed. Provided wsdl url is not valid url: " + wsdlURL));
        }
        return false;
    }

    public static void loadTenantConfig(String tenantDomain) {
        try {
            ConfigurationContext ctx = ServiceReferenceHolder.getContextService().getServerConfigContext();
            TenantAxisUtils.getTenantAxisConfiguration((String)tenantDomain, (ConfigurationContext)ctx);
        }
        catch (Exception e) {
            log.error((Object)("Error while creating axis configuration for tenant " + tenantDomain), (Throwable)e);
        }
    }

    public static void checkClientDomainAuthorized(APIKeyValidationInfoDTO apiKeyValidationInfoDTO, String clientDomain) throws APIManagementException {
        List authorizedDomains;
        if (clientDomain != null) {
            clientDomain = clientDomain.trim();
        }
        if (!(authorizedDomains = apiKeyValidationInfoDTO.getAuthorizedDomains()).contains("ALL") && !authorizedDomains.contains(clientDomain)) {
            log.error((Object)("Unauthorized client domain :" + clientDomain + ". Only \"" + authorizedDomains + "\" domains are authorized to access the API."));
            throw new APIManagementException("Unauthorized client domain :" + clientDomain + ". Only \"" + authorizedDomains + "\" domains are authorized to access the API.");
        }
    }

    public static String getMountedPath(RegistryContext registryContext, String path) {
        List mounts;
        if (registryContext != null && path != null && (mounts = registryContext.getMounts()) != null) {
            for (Mount mount : mounts) {
                if (!path.equals(mount.getPath())) continue;
                return mount.getTargetPath();
            }
        }
        return path;
    }
}

