/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.io.File;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class LocalDatabaseCreator
extends DatabaseCreator {
    private DataSource dataSource;
    private static final Log log = LogFactory.getLog(LocalDatabaseCreator.class);

    public LocalDatabaseCreator(DataSource dataSource) {
        super(dataSource);
        this.dataSource = dataSource;
    }

    public void createRegistryDatabase() throws Exception {
        String databaseType = DatabaseCreator.getDatabaseType((Connection)this.dataSource.getConnection());
        String dbscriptName = this.getDbScriptLocation(databaseType);
        String scripPath = this.getDbScriptLocation(databaseType);
        File scripFile = new File(scripPath);
        if (!scripFile.exists()) {
            return;
        }
        super.createRegistryDatabase();
    }

    protected String getDbScriptLocation(String databaseType) {
        String scriptName = databaseType + ".sql";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading database script from :" + scriptName));
        }
        String carbonHome = System.getProperty("carbon.home");
        return carbonHome + "/dbscripts/apimgt/" + scriptName;
    }
}

