/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.impl.dto.Environment;
import org.wso2.carbon.apimgt.impl.template.APITemplateBuilder;
import org.wso2.carbon.apimgt.impl.utils.AbstractAPIGatewayAdminClient;
import org.wso2.carbon.rest.api.stub.RestApiAdminStub;
import org.wso2.carbon.rest.api.stub.types.carbon.APIData;

public class RESTAPIAdminClient
extends AbstractAPIGatewayAdminClient {
    private RestApiAdminStub restApiAdminStub;
    private String qualifiedName;
    private String qualifiedDefaultApiName;
    private Environment environment;

    public RESTAPIAdminClient(APIIdentifier apiId, Environment environment) throws AxisFault {
        this.qualifiedName = apiId.getProviderName() + "--" + apiId.getApiName() + ":v" + apiId.getVersion();
        this.qualifiedDefaultApiName = apiId.getProviderName() + "--" + apiId.getApiName();
        String providerDomain = apiId.getProviderName();
        providerDomain = providerDomain.replace("-AT-", "@");
        this.restApiAdminStub = new RestApiAdminStub(null, environment.getServerURL() + "RestApiAdmin");
        this.setup((Stub)this.restApiAdminStub, environment);
        this.environment = environment;
    }

    public void addApi(APITemplateBuilder builder, String tenantDomain) throws AxisFault {
        try {
            String apiConfig = builder.getConfigStringForTemplate(this.environment);
            if (tenantDomain != null && !"".equals(tenantDomain) && !tenantDomain.equals("carbon.super")) {
                this.restApiAdminStub.addApiForTenant(apiConfig, tenantDomain);
            } else {
                this.restApiAdminStub.addApiFromString(apiConfig);
            }
        }
        catch (Exception e) {
            throw new AxisFault("Error while adding new API", (Throwable)e);
        }
    }

    public void addPrototypeApiScriptImpl(APITemplateBuilder builder, String tenantDomain) throws AxisFault {
        try {
            String apiConfig = builder.getConfigStringForPrototypeScriptAPI(this.environment);
            if (tenantDomain != null && !"".equals(tenantDomain) && !tenantDomain.equals("carbon.super")) {
                this.restApiAdminStub.addApiForTenant(apiConfig, tenantDomain);
            } else {
                this.restApiAdminStub.addApiFromString(apiConfig);
            }
        }
        catch (Exception e) {
            throw new AxisFault("Error while adding new API", (Throwable)e);
        }
    }

    public void addDefaultAPI(APITemplateBuilder builder, String tenantDomain, String defaultVersion) throws AxisFault {
        try {
            String apiConfig = builder.getConfigStringForDefaultAPITemplate(defaultVersion);
            if (tenantDomain != null && !"".equals(tenantDomain) && !tenantDomain.equals("carbon.super")) {
                this.restApiAdminStub.addApiForTenant(apiConfig, tenantDomain);
            } else {
                this.restApiAdminStub.addApiFromString(apiConfig);
            }
        }
        catch (Exception e) {
            throw new AxisFault("Error while adding API", (Throwable)e);
        }
    }

    public APIData getApi(String tenantDomain) throws AxisFault {
        try {
            APIData apiData = tenantDomain != null && !"".equals(tenantDomain) && !tenantDomain.equals("carbon.super") ? this.restApiAdminStub.getApiForTenant(this.qualifiedName, tenantDomain) : this.restApiAdminStub.getApiByName(this.qualifiedName);
            return apiData;
        }
        catch (Exception e) {
            throw new AxisFault("Error while obtaining API information from gateway", (Throwable)e);
        }
    }

    public APIData getDefaultApi(String tenantDomain) throws AxisFault {
        try {
            APIData apiData = tenantDomain != null && !"".equals(tenantDomain) && !tenantDomain.equals("carbon.super") ? this.restApiAdminStub.getApiForTenant(this.qualifiedDefaultApiName, tenantDomain) : this.restApiAdminStub.getApiByName(this.qualifiedDefaultApiName);
            return apiData;
        }
        catch (Exception e) {
            throw new AxisFault("Error while obtaining API information from gateway", (Throwable)e);
        }
    }

    public void updateApi(APITemplateBuilder builder, String tenantDomain) throws AxisFault {
        try {
            String apiConfig = builder.getConfigStringForTemplate(this.environment);
            if (tenantDomain != null && !"".equals(tenantDomain) && !tenantDomain.equals("carbon.super")) {
                this.restApiAdminStub.updateApiForTenant(this.qualifiedName, apiConfig, tenantDomain);
            } else {
                this.restApiAdminStub.updateApiFromString(this.qualifiedName, apiConfig);
            }
        }
        catch (Exception e) {
            throw new AxisFault("Error while updating API", (Throwable)e);
        }
    }

    public void updateApiForInlineScript(APITemplateBuilder builder, String tenantDomain) throws AxisFault {
        try {
            String apiConfig = builder.getConfigStringForPrototypeScriptAPI(this.environment);
            if (tenantDomain != null && !"".equals(tenantDomain) && !tenantDomain.equals("carbon.super")) {
                this.restApiAdminStub.updateApiForTenant(this.qualifiedName, apiConfig, tenantDomain);
            } else {
                this.restApiAdminStub.updateApiFromString(this.qualifiedName, apiConfig);
            }
        }
        catch (Exception e) {
            throw new AxisFault("Error while updating API", (Throwable)e);
        }
    }

    public void updateDefaultApi(APITemplateBuilder builder, String tenantDomain, String defaultVersion) throws AxisFault {
        try {
            String apiConfig = builder.getConfigStringForDefaultAPITemplate(defaultVersion);
            if (tenantDomain != null && !"".equals(tenantDomain) && !tenantDomain.equals("carbon.super")) {
                this.restApiAdminStub.updateApiForTenant(this.qualifiedDefaultApiName, apiConfig, tenantDomain);
            } else {
                this.restApiAdminStub.updateApiFromString(this.qualifiedDefaultApiName, apiConfig);
            }
        }
        catch (Exception e) {
            throw new AxisFault("Error while updating API", (Throwable)e);
        }
    }

    public void deleteApi(String tenantDomain) throws AxisFault {
        try {
            if (tenantDomain != null && !"".equals(tenantDomain) && !tenantDomain.equals("carbon.super")) {
                this.restApiAdminStub.deleteApiForTenant(this.qualifiedName, tenantDomain);
            } else {
                this.restApiAdminStub.deleteApi(this.qualifiedName);
            }
        }
        catch (Exception e) {
            throw new AxisFault("Error while deleting API", (Throwable)e);
        }
    }

    public void deleteDefaultApi(String tenantDomain) throws AxisFault {
        try {
            if (tenantDomain != null && !"".equals(tenantDomain) && !tenantDomain.equals("carbon.super")) {
                this.restApiAdminStub.deleteApiForTenant(this.qualifiedDefaultApiName, tenantDomain);
            } else {
                this.restApiAdminStub.deleteApi(this.qualifiedDefaultApiName);
            }
        }
        catch (Exception e) {
            throw new AxisFault("Error while deleting API", (Throwable)e);
        }
    }
}

