/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.io.File;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.um.ws.api.stub.RemoteUserStoreManagerServiceStub;
import org.wso2.carbon.utils.CarbonUtils;

public class RemoteUserManagerClient {
    private static int TIMEOUT_IN_MILLIS = 900000;
    private RemoteUserStoreManagerServiceStub userStoreManagerStub;

    public RemoteUserManagerClient(String cookie) throws APIManagementException {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        String serviceURL = config.getFirstProperty("AuthManager.ServerURL");
        String username = config.getFirstProperty("AuthManager.Username");
        String password = config.getFirstProperty("AuthManager.Password");
        if (serviceURL == null || username == null || password == null) {
            throw new APIManagementException("Required connection details for authentication");
        }
        try {
            String clientRepo = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "client";
            String clientAxisConf = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "conf" + File.separator + "axis2" + File.separator + "axis2_client.xml";
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)clientRepo, (String)clientAxisConf);
            this.userStoreManagerStub = new RemoteUserStoreManagerServiceStub(configContext, serviceURL + "RemoteUserStoreManagerService");
            ServiceClient svcClient = this.userStoreManagerStub._getServiceClient();
            CarbonUtils.setBasicAccessSecurityHeaders((String)username, (String)password, (boolean)true, (ServiceClient)svcClient);
            Options options = svcClient.getOptions();
            options.setTimeOutInMilliSeconds((long)TIMEOUT_IN_MILLIS);
            options.setProperty("SO_TIMEOUT", (Object)TIMEOUT_IN_MILLIS);
            options.setProperty("CONNECTION_TIMEOUT", (Object)TIMEOUT_IN_MILLIS);
            options.setCallTransportCleanup(true);
            options.setManageSession(true);
            options.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            throw new APIManagementException("Error while initializing the remote user store manager stub", (Throwable)axisFault);
        }
    }

    public String[] getUserList(String claim, String claimValue) throws APIManagementException {
        try {
            String[] user = this.userStoreManagerStub.getUserList(claim, claimValue, null);
            return user;
        }
        catch (Exception e) {
            throw new APIManagementException("Error when retriving userlist", (Throwable)e);
        }
    }
}

