/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.Caching;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.dto.UserRegistrationConfigDTO;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SelfSignUpUtil {
    private static final Log log = LogFactory.getLog(SelfSignUpUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserRegistrationConfigDTO getSignupConfiguration(String tenantDomain) throws APIManagementException {
        UserRegistrationConfigDTO config = null;
        String currentFlowDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        boolean isTenantFlowStarted = false;
        try {
            if (tenantDomain != null && !"carbon.super".equals(tenantDomain) && !currentFlowDomain.equals(tenantDomain)) {
                isTenantFlowStarted = true;
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            }
            String cacheName = tenantDomain + "_" + "selfSignupCache";
            Cache signupConfigCache = Caching.getCacheManager((String)"API_MANAGER_CACHE").getCache("selfSignupCache");
            config = (UserRegistrationConfigDTO)signupConfigCache.get((Object)cacheName);
            if (config == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cache miss for " + cacheName));
                }
                config = SelfSignUpUtil.getSignupConfigurationFromRegistry(tenantDomain);
                signupConfigCache.put((Object)cacheName, (Object)config);
            }
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return config;
    }

    private static UserRegistrationConfigDTO getSignupConfigurationFromRegistry(String tenantDomain) throws APIManagementException {
        UserRegistrationConfigDTO config = null;
        try {
            Registry registry = (Registry)PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
            if (registry.resourceExists("/apimgt/applicationdata/sign-up-config.xml")) {
                Resource resource = registry.get("/apimgt/applicationdata/sign-up-config.xml");
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                String configXml = new String((byte[])resource.getContent());
                InputSource configInputSource = new InputSource();
                configInputSource.setCharacterStream(new StringReader(configXml.trim()));
                Document doc = builder.parse(configInputSource);
                NodeList nodes = doc.getElementsByTagName("SelfSignUp");
                if (nodes.getLength() > 0) {
                    config = new UserRegistrationConfigDTO();
                    config.setSignUpDomain(((Element)nodes.item(0)).getElementsByTagName("SignUpDomain").item(0).getTextContent());
                    config.setAdminUserName(((Element)nodes.item(0)).getElementsByTagName("AdminUserName").item(0).getTextContent());
                    config.setAdminPassword(((Element)nodes.item(0)).getElementsByTagName("AdminPassword").item(0).getTextContent());
                    config.setSignUpEnabled(Boolean.parseBoolean(((Element)nodes.item(0)).getElementsByTagName("EnableSignup").item(0).getTextContent()));
                    Element roleListParent = (Element)((Element)nodes.item(0)).getElementsByTagName("SignUpRoles").item(0);
                    NodeList rolesEl = roleListParent.getElementsByTagName("SignUpRole");
                    for (int i = 0; i < rolesEl.getLength(); ++i) {
                        Element tmpEl = (Element)rolesEl.item(i);
                        String tmpRole = tmpEl.getElementsByTagName("RoleName").item(0).getTextContent();
                        boolean tmpIsExternal = Boolean.parseBoolean(tmpEl.getElementsByTagName("IsExternalRole").item(0).getTextContent());
                        config.getRoles().put(tmpRole, tmpIsExternal);
                    }
                }
            }
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error while reading registry/apimgt/applicationdata/sign-up-config.xml", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new APIManagementException("Error while parsing configuration/apimgt/applicationdata/sign-up-config.xml", (Throwable)e);
        }
        catch (SAXException e) {
            throw new APIManagementException("Error while parsing configuration/apimgt/applicationdata/sign-up-config.xml", (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error while parsing configuration/apimgt/applicationdata/sign-up-config.xml", (Throwable)e);
        }
        return config;
    }

    public static boolean isUserNameWithAllowedDomainName(String userName, UserRealm realm) throws APIManagementException {
        int index = userName.indexOf(47);
        if (index > 0) {
            try {
                return !realm.getRealmConfiguration().isRestrictedDomainForSlefSignUp(userName.substring(0, index));
            }
            catch (UserStoreException e) {
                throw new APIManagementException(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    public static List<String> getRoleNames(UserRegistrationConfigDTO config) {
        ArrayList<String> roleNamesArr = new ArrayList<String>();
        Map roles = config.getRoles();
        for (Map.Entry entry : roles.entrySet()) {
            String roleName = (Boolean)entry.getValue() != false ? config.getSignUpDomain().toUpperCase() + "/" + (String)entry.getKey() : "Internal/" + (String)entry.getKey();
            roleNamesArr.add(roleName);
        }
        return roleNamesArr;
    }

    public static String getDomainSpecificUserName(String username, UserRegistrationConfigDTO signupConfig) {
        String modifiedUsername = null;
        if (signupConfig != null && signupConfig.getSignUpDomain() != "") {
            int index = username.indexOf("/");
            modifiedUsername = index > 0 ? signupConfig.getSignUpDomain().toUpperCase() + "/" + username.substring(index + 1) : signupConfig.getSignUpDomain().toUpperCase() + "/" + username;
        }
        return modifiedUsername;
    }
}

