/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.startup.publisher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.activation.FileTypeMap;
import javax.cache.Cache;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DocumentationType;
import org.wso2.carbon.apimgt.api.model.Icon;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.APIManagerFactory;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.startup.publisher.internal.DataHolder;
import org.wso2.carbon.apimgt.startup.publisher.internal.ServiceReferenceHolder;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.ServerStartupHandler;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class APIManagerStartupPublisher
implements ServerStartupHandler {
    private static final Log log = LogFactory.getLog(APIManagerStartupPublisher.class);
    Cache contextCache = APIUtil.getAPIContextCache();
    APIProvider provider;
    protected Registry registry;
    private static final String httpPort = "mgt.transport.http.port";
    private static final String hostName = "carbon.local.ip";

    public void invoke() {
        APIManagerConfiguration configuration;
        if (log.isDebugEnabled()) {
            log.info((Object)"Startup Publisher Invoked");
        }
        if (Boolean.parseBoolean((configuration = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration()).getFirstProperty("StartupAPIPublisher.Enabled"))) {
            String apiVersion;
            String apiProvider;
            String apiContext;
            int i;
            List localAPIAuthTypes;
            List localAPIDocumentURLs;
            List localAPIIconPaths;
            List localAPIVersions;
            List localAPIProviders;
            List apiContexts = configuration.getProperty("StartupAPIPublisher.APIs.API.Context");
            List apiProviders = configuration.getProperty("StartupAPIPublisher.APIs.API.Provider");
            List apiVersions = configuration.getProperty("StartupAPIPublisher.APIs.API.Version");
            List apiEndpoints = configuration.getProperty("StartupAPIPublisher.APIs.API.Endpoint");
            List apiIconPaths = configuration.getProperty("StartupAPIPublisher.APIs.API.IconPath");
            List apiDocumentURLs = configuration.getProperty("StartupAPIPublisher.APIs.API.DocumentURL");
            List apiAuthTypes = configuration.getProperty("StartupAPIPublisher.APIs.API.AuthType");
            List localAPIContexts = configuration.getProperty("StartupAPIPublisher.LocalAPIs.LocalAPI.Context");
            if (!this.isValidLocalAPIConfig(localAPIContexts, localAPIProviders = configuration.getProperty("StartupAPIPublisher.LocalAPIs.LocalAPI.Provider"), localAPIVersions = configuration.getProperty("StartupAPIPublisher.LocalAPIs.LocalAPI.Version"), localAPIIconPaths = configuration.getProperty("StartupAPIPublisher.LocalAPIs.LocalAPI.IconPath"), localAPIDocumentURLs = configuration.getProperty("StartupAPIPublisher.LocalAPIs.LocalAPI.DocumentURL"), localAPIAuthTypes = configuration.getProperty("StartupAPIPublisher.LocalAPIs.LocalAPI.AuthType")) && !this.isValidAPIConfig(apiProviders, apiVersions, apiEndpoints, apiContexts, apiIconPaths, apiDocumentURLs, apiAuthTypes)) {
                log.error((Object)"Invalid StartupAPIPublisher configuration");
                return;
            }
            if (apiContexts != null) {
                for (i = 0; i < apiContexts.size(); ++i) {
                    try {
                        apiContext = (String)apiContexts.get(i);
                        apiProvider = (String)apiProviders.get(i);
                        apiVersion = (String)apiVersions.get(i);
                        String apiEndpoint = (String)apiEndpoints.get(i);
                        String iconPath = (String)apiIconPaths.get(i);
                        String documentURL = (String)apiDocumentURLs.get(i);
                        String authType = (String)apiAuthTypes.get(i);
                        String apiName = null;
                        if (apiProvider == null || apiVersion == null || apiContext == null || apiEndpoint == null || iconPath == null || documentURL == null || authType == null) {
                            log.error((Object)"Invalid StartupAPIPublisher configuration");
                            return;
                        }
                        if (!apiContext.startsWith("/")) {
                            apiName = apiContext;
                            apiContext = "/" + apiContext;
                        } else {
                            apiName = apiContext.substring(1);
                        }
                        this.createAPIAtServerStartup(apiName, apiProvider, apiVersion, apiEndpoint, apiContext, iconPath, documentURL, authType);
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        log.error((Object)"Invalid StartupAPIPublisher configuration");
                    }
                }
            }
            if (localAPIContexts != null) {
                for (i = 0; i < localAPIContexts.size(); ++i) {
                    try {
                        apiContext = (String)localAPIContexts.get(i);
                        apiProvider = (String)localAPIProviders.get(i);
                        apiVersion = (String)localAPIVersions.get(i);
                        String iconPath = (String)localAPIIconPaths.get(i);
                        String documentURL = (String)localAPIDocumentURLs.get(i);
                        String authType = (String)localAPIAuthTypes.get(i);
                        String apiName = null;
                        if (apiProvider == null || apiVersion == null || apiContext == null || iconPath == null || documentURL == null || authType == null) {
                            log.error((Object)"Invalid StartupAPIPublisher configuration");
                            return;
                        }
                        if (!apiContext.startsWith("/")) {
                            apiName = apiContext;
                            apiContext = "/" + apiContext;
                        } else {
                            apiName = apiContext.substring(1);
                        }
                        String apiEndpoint = "http://" + System.getProperty(hostName) + ":" + System.getProperty(httpPort) + apiContext;
                        this.createAPIAtServerStartup(apiName, apiProvider, apiVersion, apiEndpoint, apiContext, iconPath, documentURL, authType);
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        log.error((Object)"Invalid StartupAPIPublisher configuration");
                    }
                }
            }
        }
    }

    private void createAPIAtServerStartup(String apiName, String apiProvider, String apiVersion, String apiEndpoint, String apiContext, String iconPath, String documentURL, String authType) {
        if (this.contextCache.get((Object)apiContext) != null || ApiMgtDAO.isContextExist(apiContext)) {
            if (log.isDebugEnabled()) {
                log.info((Object)("API Context " + apiContext + " already exists"));
            }
            return;
        }
        try {
            API api = this.createAPIModel(apiName, apiProvider, apiVersion, apiEndpoint, apiContext, iconPath, documentURL, authType);
            if (api != null) {
                this.addAPI(api, documentURL);
                log.info((Object)("Successfully Created API " + apiName + "-" + apiVersion));
            }
        }
        catch (APIManagementException e) {
            log.error((Object)e);
        }
        catch (RegistryException e) {
            log.error((Object)e);
        }
    }

    private API createAPIModel(String apiName, String apiProvider, String apiVersion, String apiEndpoint, String apiContext, String iconPath, String documentURL, String authType) throws APIManagementException {
        API api = null;
        try {
            this.provider = APIManagerFactory.getInstance().getAPIProvider(apiProvider);
            APIIdentifier identifier = new APIIdentifier(apiProvider, apiName, apiVersion);
            api = new API(identifier);
            api.setContext(apiContext);
            api.setUrl(apiEndpoint);
            api.setUriTemplates(this.getURITemplates(apiEndpoint, authType));
            api.setVisibility("public");
            api.addAvailableTiers(this.provider.getTiers());
            api.setEndpointSecured(false);
            api.setStatus(APIStatus.PUBLISHED);
            api.setTransports("http,https");
            File file = null;
            if (!"none".equals(iconPath)) {
                file = new File(iconPath);
                String absolutePath = file.getAbsolutePath();
                Icon icon = new Icon(this.getImageInputStream(absolutePath), this.getImageContentType(absolutePath));
                String thumbPath = APIUtil.getIconPath(identifier);
                String thumbnailUrl = this.provider.addIcon(thumbPath, icon);
                api.setThumbnailUrl(APIUtil.prependTenantPrefix(thumbnailUrl, apiProvider));
                APIUtil.setResourcePermissions(apiProvider, null, null, thumbPath);
            }
        }
        catch (APIManagementException e) {
            this.handleException("Error while initializing API Provider", (Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleException("Error while reading image from icon path", e);
        }
        return api;
    }

    private void addAPI(API api, String documentURL) throws RegistryException, APIManagementException {
        ApiMgtDAO apiMgtDAO = new ApiMgtDAO();
        try {
            this.registry = DataHolder.getRegistryService().getGovernanceSystemRegistry();
            this.createAPIArtifact(api);
            int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            apiMgtDAO.addAPI(api, tenantId);
            if (!"none".equals(documentURL)) {
                Documentation doc = new Documentation(DocumentationType.HOWTO, "Wiki Documentation");
                doc.setSourceType(Documentation.DocumentSourceType.URL);
                doc.setSourceUrl(documentURL);
                this.createDocumentation(api, doc);
            }
            if (APIUtil.isAPIManagementEnabled()) {
                Boolean apiContext = null;
                if (this.contextCache.get((Object)api.getContext()) != null) {
                    apiContext = Boolean.parseBoolean(this.contextCache.get((Object)api.getContext()).toString());
                }
                if (apiContext == null) {
                    this.contextCache.put((Object)api.getContext(), (Object)true);
                }
            }
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error in adding API :" + api.getId().getApiName(), (Throwable)e);
        }
        catch (RegistryException e) {
            throw e;
        }
    }

    private void createAPIArtifact(API api) throws APIManagementException {
        GenericArtifactManager artifactManager = APIUtil.getArtifactManager(this.registry, "api");
        try {
            String path;
            this.registry.beginTransaction();
            GenericArtifact genericArtifact = artifactManager.newGovernanceArtifact(new QName(api.getId().getApiName()));
            GenericArtifact artifact = APIUtil.createAPIArtifactContent(genericArtifact, api);
            artifactManager.addGenericArtifact(artifact);
            String artifactPath = GovernanceUtils.getArtifactPath((Registry)this.registry, (String)artifact.getId());
            String providerPath = APIUtil.getAPIProviderPath(api.getId());
            this.registry.addAssociation(providerPath, artifactPath, "provides");
            Set tagSet = api.getTags();
            if (tagSet != null && tagSet.size() > 0) {
                for (String tag : tagSet) {
                    this.registry.applyTag(artifactPath, tag);
                }
            }
            if (api.getUrl() != null && !"".equals(api.getUrl()) && (path = APIUtil.createEndpoint(api.getUrl(), this.registry)) != null) {
                this.registry.addAssociation(artifactPath, path, "depends");
            }
            String apiStatus = api.getStatus().getStatus();
            this.saveAPIStatus(artifactPath, apiStatus);
            String visibleRolesList = api.getVisibleRoles();
            String[] visibleRoles = new String[]{};
            if (visibleRolesList != null) {
                visibleRoles = visibleRolesList.split(",");
            }
            APIUtil.setResourcePermissions(api.getId().getProviderName(), api.getVisibility(), visibleRoles, artifactPath);
            this.registry.commitTransaction();
            this.createUpdateAPIDefinition(api);
        }
        catch (RegistryException e) {
            try {
                this.registry.rollbackTransaction();
            }
            catch (RegistryException re) {
                this.handleException("Error while rolling back the transaction for API: " + api.getId().getApiName(), (Exception)((Object)re));
            }
            this.handleException("Error while performing registry transaction operation", (Exception)((Object)e));
        }
    }

    private void createDocumentation(API api, Documentation documentation) throws APIManagementException {
        try {
            APIIdentifier apiId = api.getId();
            GenericArtifactManager artifactManager = new GenericArtifactManager(this.registry, "document");
            GenericArtifact artifact = artifactManager.newGovernanceArtifact(new QName(documentation.getName()));
            artifactManager.addGenericArtifact(APIUtil.createDocArtifactContent(artifact, apiId, documentation));
            String apiPath = APIUtil.getAPIPath(apiId);
            this.registry.addAssociation(apiPath, artifact.getPath(), "document");
            String visibleRolesList = api.getVisibleRoles();
            String[] visibleRoles = new String[]{};
            if (visibleRolesList != null) {
                visibleRoles = visibleRolesList.split(",");
            }
            APIUtil.setResourcePermissions(apiId.getProviderName(), api.getVisibility(), visibleRoles, artifact.getPath());
        }
        catch (RegistryException e) {
            this.handleException("Failed to add documentation", (Exception)((Object)e));
        }
    }

    private void createUpdateAPIDefinition(API api) throws APIManagementException {
        APIIdentifier identifier = api.getId();
        try {
            String jsonText = APIUtil.createSwaggerJSONContent(api);
            String resourcePath = APIUtil.getAPIDefinitionFilePath(identifier.getApiName(), identifier.getVersion(), identifier.getProviderName());
            Resource resource = this.registry.newResource();
            resource.setContent((Object)jsonText);
            resource.setMediaType("application/json");
            this.registry.put(resourcePath, resource);
            APIUtil.setResourcePermissions(api.getId().getProviderName(), null, null, resourcePath);
        }
        catch (RegistryException e) {
            this.handleException("Error while adding API Definition for " + identifier.getApiName() + "-" + identifier.getVersion(), (Exception)((Object)e));
        }
        catch (APIManagementException e) {
            this.handleException("Error while adding API Definition for " + identifier.getApiName() + "-" + identifier.getVersion(), (Exception)((Object)e));
        }
    }

    private void saveAPIStatus(String artifactId, String apiStatus) throws APIManagementException {
        try {
            Resource resource = this.registry.get(artifactId);
            if (resource != null) {
                String propValue = resource.getProperty("STATUS");
                if (propValue == null) {
                    resource.addProperty("STATUS", apiStatus);
                } else {
                    resource.setProperty("STATUS", apiStatus);
                }
                this.registry.put(artifactId, resource);
            }
        }
        catch (RegistryException e) {
            this.handleException("Error while adding API", (Exception)((Object)e));
        }
    }

    private Set<URITemplate> getURITemplates(String endpoint, String authType) {
        LinkedHashSet<URITemplate> uriTemplates = new LinkedHashSet<URITemplate>();
        String[] httpVerbs = new String[]{"GET", "POST", "PUT", "DELETE", "OPTIONS"};
        if (authType.equals("None")) {
            for (int i = 0; i < 5; ++i) {
                URITemplate template = new URITemplate();
                template.setAuthType("None");
                template.setHTTPVerb(httpVerbs[i]);
                template.setResourceURI(endpoint);
                template.setUriTemplate("/*");
                uriTemplates.add(template);
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                URITemplate template = new URITemplate();
                if (i != 4) {
                    template.setAuthType("Any");
                } else {
                    template.setAuthType("None");
                }
                template.setHTTPVerb(httpVerbs[i]);
                template.setResourceURI(endpoint);
                template.setUriTemplate("/*");
                uriTemplates.add(template);
            }
        }
        return uriTemplates;
    }

    private void handleException(String msg, Exception e) throws APIManagementException {
        log.error((Object)msg, (Throwable)e);
        throw new APIManagementException(msg, (Throwable)e);
    }

    private InputStream getImageInputStream(String imageAbsolutePath) throws IOException {
        RandomAccessFile file1 = new RandomAccessFile(imageAbsolutePath, "r");
        return new FileInputStream(file1.getFD());
    }

    private String getImageContentType(String imageAbsolutePath) {
        String fileName = new File(imageAbsolutePath).getName();
        return FileTypeMap.getDefaultFileTypeMap().getContentType(fileName);
    }

    private boolean isValidLocalAPIConfig(List<String> localAPIContexts, List<String> localAPIProviders, List<String> localApiVersions, List<String> localAPIIconPaths, List<String> localAPIDocumentURLs, List<String> localAPIAuthTypes) {
        return localAPIContexts != null && localAPIProviders != null && localApiVersions != null && localAPIIconPaths != null && localAPIDocumentURLs != null && localAPIAuthTypes != null;
    }

    private boolean isValidAPIConfig(List<String> apiProviders, List<String> apiVersions, List<String> apiEndpoints, List<String> apiContexts, List<String> apiIconPaths, List<String> apiDocumentURLs, List<String> apiAuthTypes) {
        return apiProviders != null && apiVersions != null && apiEndpoints != null && apiContexts != null && apiIconPaths != null && apiDocumentURLs != null && apiAuthTypes != null;
    }

    private static DocumentationType getDocType(String docType) {
        DocumentationType docsType = null;
        for (DocumentationType type : DocumentationType.values()) {
            if (!type.getType().equalsIgnoreCase(docType)) continue;
            docsType = type;
        }
        return docsType;
    }
}

