/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.startup.publisher.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.apimgt.impl.APIManagerConfigurationService;
import org.wso2.carbon.apimgt.startup.publisher.APIManagerStartupPublisher;
import org.wso2.carbon.apimgt.startup.publisher.internal.DataHolder;
import org.wso2.carbon.apimgt.startup.publisher.internal.ServiceReferenceHolder;
import org.wso2.carbon.core.ServerStartupHandler;
import org.wso2.carbon.registry.core.service.RegistryService;

public class APIManagerStartupPublisherComponent {
    private static final Log log = LogFactory.getLog(APIManagerStartupPublisherComponent.class);

    protected void activate(ComponentContext ctx) {
        BundleContext bundleContext = ctx.getBundleContext();
        bundleContext.registerService(ServerStartupHandler.class.getName(), (Object)new APIManagerStartupPublisher(), null);
        if (log.isDebugEnabled()) {
            log.info((Object)"Activating API Manager Startup Publisher Component");
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deactivating API manager Startup component");
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        if (registryService != null && log.isDebugEnabled()) {
            log.debug((Object)"Registry service initialized");
        }
        DataHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        DataHolder.setRegistryService(null);
    }

    protected void setAPIManagerConfigurationService(APIManagerConfigurationService service) {
        log.debug((Object)"API manager configuration service bound to the API usage handler");
        ServiceReferenceHolder.getInstance().setAPIManagerConfigurationService(service);
    }

    protected void unsetAPIManagerConfigurationService(APIManagerConfigurationService service) {
        log.debug((Object)"API manager configuration service unbound from the API usage handler");
        ServiceReferenceHolder.getInstance().setAPIManagerConfigurationService(null);
    }
}

