/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.sample.internal;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.caching.CarbonCachingService;

@Component(name="org.wso2.carbon.caching.sample.internal.CachingSampleServiceComponent", immediate=true)
public class CachingSampleServiceComponent {
    private static final Logger log = LoggerFactory.getLogger(CachingSampleServiceComponent.class);
    private Duration cacheExpiry = new Duration(TimeUnit.MINUTES, 15L);
    private CarbonCachingService cachingService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        String cacheName = "CachingSample.cache";
        String key = "k";
        String value = "v";
        try {
            this.getCache(cacheName).put((Object)key, (Object)value);
            log.info("Cache put succeeded");
            log.info("Cache get: key=" + key + ", value=" + (String)this.getCache(cacheName).get((Object)key));
            this.getCache(cacheName).remove((Object)key);
            log.info("Cache delete succeeded");
            log.info("Cache get: key=" + key + ", value=" + (String)this.getCache(cacheName).get((Object)key));
            log.info("CachingSample is activated");
        }
        catch (Throwable e) {
            log.error("Could not activate CachingSample bundle", e);
        }
    }

    @Reference(name="carbon-caching.service", service=CarbonCachingService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="removeCachingService")
    protected void addCachingService(CarbonCachingService cachingService, Map<String, ?> properties) {
        this.cachingService = cachingService;
    }

    protected void removeCachingService(CarbonCachingService cachingService, Map<String, ?> properties) {
        this.cachingService = null;
    }

    private Cache<String, String> getCache(String cacheName) {
        CachingProvider provider = this.cachingService.getCachingProvider();
        CacheManager cacheManager = provider.getCacheManager();
        Cache<String, String> cache = cacheManager.getCache(cacheName, String.class, String.class);
        if (cache == null) {
            cache = this.initCache(cacheName, cacheManager);
        }
        return cache;
    }

    private Cache<String, String> initCache(String name, CacheManager cacheManager) {
        MutableConfiguration config = new MutableConfiguration();
        config.setStoreByValue(true).setTypes(String.class, String.class).setExpiryPolicyFactory(AccessedExpiryPolicy.factoryOf((Duration)this.cacheExpiry)).setStatisticsEnabled(false);
        return cacheManager.createCache(name, (Configuration)config);
    }
}

