/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tryit.wadl.generator;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.ast.ApplicationNode;
import org.jvnet.ws.wadl.ast.MethodNode;
import org.jvnet.ws.wadl.ast.RepresentationNode;
import org.jvnet.ws.wadl.ast.ResourceNode;
import org.wso2.carbon.tryit.wadl.data.SwaggerImplementation;
import org.wso2.carbon.tryit.wadl.data.apis;
import org.wso2.carbon.tryit.wadl.data.operations;
import org.wso2.carbon.tryit.wadl.data.parameters;

public class ApiGenerator {
    private SwaggerImplementation implementation = new SwaggerImplementation();
    private List<apis> apis = new ArrayList<apis>();

    public String CreateJsonString(ApplicationNode applicationNode) throws Exception {
        String basePath = ((ResourceNode)applicationNode.getResources().get(0)).getPathSegment().getTemplate();
        this.implementation.setBasePath(basePath);
        this.implementation.setApiVersion("1.0");
        this.implementation.setSwaggerVersion("1.1");
        this.implementation.setResourcePath(basePath);
        List nodeList = ((ResourceNode)applicationNode.getResources().get(0)).getChildResources();
        this.readResources(nodeList, "");
        this.implementation.setApis(this.apis);
        Gson gson = new Gson();
        return gson.toJson((Object)this.implementation);
    }

    public void readResources(List<ResourceNode> nodeList, String parentPath) {
        boolean onlyOnce = true;
        for (ResourceNode rn : nodeList) {
            List mnList = rn.getMethods();
            String path = parentPath + rn.getPathSegment().getTemplate();
            if (rn.getChildResources().isEmpty()) {
                onlyOnce = true;
                apis aps = new apis();
                aps.setPath(path);
                aps.setDescription("..............");
                ArrayList<operations> operationsList = new ArrayList<operations>();
                List templateParameters = rn.getPathSegment().getTemplateParameters();
                ArrayList<parameters> paramsList = new ArrayList<parameters>();
                for (Param p : templateParameters) {
                    parameters pm = new parameters();
                    pm.setName(p.getName());
                    pm.setAllowMultiple("false");
                    pm.setDataType(p.getType().getLocalPart());
                    pm.setRequired("true");
                    pm.setDescription("....");
                    if (rn.getPathSegment().getTemplate().contains("{")) {
                        pm.setParamType("path");
                    } else {
                        pm.setParamType("body");
                    }
                    paramsList.add(pm);
                }
                for (MethodNode mn : mnList) {
                    operations opr = new operations();
                    List supportedInputs = mn.getSupportedInputs();
                    if (supportedInputs.size() > 0) {
                        String[] inputMethods = new String[supportedInputs.size()];
                        int x = 0;
                        for (RepresentationNode rs : supportedInputs) {
                            inputMethods[x] = rs.getMediaType();
                            ++x;
                        }
                        opr.setSupportedContentTypes(inputMethods);
                    }
                    opr.setHttpMethod(mn.getName());
                    opr.setNickname("....");
                    opr.setNotes("....");
                    operationsList.add(opr);
                    List paramList = mn.getMatrixParameters();
                    for (Param param : paramList) {
                    }
                    if (onlyOnce) {
                        parameters pr = new parameters();
                        pr.setName("DefaultParam");
                        pr.setAllowMultiple("false");
                        pr.setDataType("string");
                        pr.setRequired("false");
                        pr.setDescription("Put request parameters here");
                        pr.setParamType("body");
                        paramsList.add(pr);
                        onlyOnce = false;
                    }
                    opr.setParameters(paramsList);
                }
                aps.setOperations(operationsList);
                this.apis.add(aps);
            }
            if (rn.getChildResources().isEmpty()) continue;
            this.readResources(rn.getChildResources(), path);
        }
    }
}

