/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tryit.wadl.generator;

import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.net.URI;
import org.jvnet.ws.wadl.ast.ApplicationNode;
import org.jvnet.ws.wadl.ast.InvalidWADLException;
import org.jvnet.ws.wadl.ast.WadlAstBuilder;
import org.jvnet.ws.wadl.util.MessageListener;
import org.w3c.dom.Element;
import org.wso2.carbon.tryit.wadl.generator.ApiGenerator;
import org.xml.sax.InputSource;

public class WADLReader {
    public String readWADLFromUrl(String urlString) throws Exception {
        return this.validateWADL(urlString);
    }

    private String validateWADL(String uri) throws Exception {
        WadlAstBuilder builder = new WadlAstBuilder(new WadlAstBuilder.SchemaCallback(){

            public void processSchema(InputSource is) {
            }

            public void processSchema(String s, Element element) {
            }
        }, new MessageListener(){

            public void warning(String message, Throwable throwable) {
            }

            public void info(String message) {
            }

            public void error(String message, Throwable throwable) {
            }
        });
        try {
            ApplicationNode applicationNode = builder.buildAst(new URI(uri));
            ApiGenerator apiGenerator = new ApiGenerator();
            return apiGenerator.CreateJsonString(applicationNode);
        }
        catch (ConnectException e) {
            String msg = "Invalid WADL uri found " + uri;
            throw new Exception(msg, e);
        }
        catch (InvalidWADLException e) {
            String msg = "Invalid WADL definition found";
            throw new Exception(msg, e);
        }
        catch (FileNotFoundException e) {
            String msg = "WADL not found/Invalid grammar import/s found";
            throw new Exception(msg, e);
        }
        catch (Exception e) {
            String msg = "Unexpected error occured while adding WADL from " + uri;
            throw new Exception(msg, e);
        }
    }
}

