/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tryit;

import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.wsdl2form.WSDL2FormGenerator;

public class TryitRequestProcessor
implements HttpGetRequestProcessor {
    private static Log log = LogFactory.getLog(TryitRequestProcessor.class);

    public void process(CarbonHttpRequest request, CarbonHttpResponse response, ConfigurationContext configurationContext) throws Exception {
        OutputStream outputStream = response.getOutputStream();
        String requestURL = request.getRequestURL() + "?" + request.getQueryString();
        String serviceParameter = request.getParameter("service");
        String endpointParameter = request.getParameter("endpoint");
        String operationParameter = request.getParameter("operation");
        response.addHeader("Content-Type", "text/html; charset=utf-8");
        try {
            StreamResult result = new StreamResult(outputStream);
            String str = WSDL2FormGenerator.getInstance().getInternalTryit((Result)result, configurationContext, requestURL, serviceParameter, operationParameter, endpointParameter, true);
            if (!str.equals("SUCCESSFULL")) {
                response.setRedirect(str);
            }
        }
        catch (CarbonException e) {
            log.error((Object)e);
            if (e.getMessage().equals("SERVICE_INACTIVE")) {
                response.setStatus(404);
                outputStream.write("<h4>Requested Service is inactive. Cannot generate stubs.</h4>".getBytes());
                outputStream.flush();
            }
            if (e.getMessage().equals("SERVICE_NOT_FOUND")) {
                response.setStatus(503);
                outputStream.write("<h4>Service cannot be found. Cannot display <em>Stub</em>.</h4>".getBytes());
                outputStream.flush();
            }
            response.setError(404);
            outputStream.write(("<h4>" + e.getMessage() + "</h4>").getBytes());
            outputStream.flush();
        }
    }
}

