/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mex.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.mex.MexException;

public class KeyUtil {
    public static X509Certificate getCertificateToIncludeInMex(String serviceName) throws MexException, KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        X509Certificate cert = null;
        ServerConfiguration config = ServerConfiguration.getInstance();
        String path = new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath();
        String password = config.getFirstProperty("Security.KeyStore.Password");
        String keyalias = config.getFirstProperty("Security.KeyStore.KeyAlias");
        String storeType = config.getFirstProperty("Security.KeyStore.Type");
        FileInputStream ksIn = new FileInputStream(path);
        BufferedInputStream ksbufin = new BufferedInputStream(ksIn);
        KeyStore store = KeyStore.getInstance(storeType);
        store.load(ksbufin, password.toCharArray());
        cert = (X509Certificate)store.getCertificate(keyalias);
        return cert;
    }
}

