/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.sts.STSDeploymentInterceptor;
import org.wso2.carbon.sts.internal.STSServiceDataHolder;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.IOStreamUtils;
import org.wso2.carbon.utils.deployment.Axis2ServiceRegistry;
import org.wso2.carbon.utils.deployment.BundleClassLoader;

public class STSDeploymentListener
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(STSDeploymentListener.class);
    private static String componentsDirPath;

    public void createdConfigurationContext(ConfigurationContext configContext) {
        AxisService service = null;
        try {
            service = configContext.getAxisConfiguration().getService("wso2carbon-sts");
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
        if (service == null) {
            configContext.getAxisConfiguration().addObservers((AxisObserver)new STSDeploymentInterceptor());
            Bundle bundle = STSServiceDataHolder.getInstance().getBundle();
            AxisServiceGroup serviceGroup = this.createService(bundle, configContext);
            if (serviceGroup != null) {
                try {
                    configContext.getAxisConfiguration().addServiceGroup(serviceGroup);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)("Error occurs while adding wso2carbon-sts service group in to axis2configuration of tenant " + CarbonContext.getThreadLocalCarbonContext().getTenantId()), (Throwable)axisFault);
                }
            }
        }
    }

    private AxisServiceGroup createService(Bundle bundle, ConfigurationContext configContext) {
        Enumeration enumeration = bundle.findEntries("META-INF", "*services.xml", true);
        AxisServiceGroup serviceGroup = null;
        AxisConfiguration axisConfiguration = configContext.getAxisConfiguration();
        if (enumeration != null && enumeration.hasMoreElements()) {
            try {
                serviceGroup = new AxisServiceGroup(axisConfiguration);
                BundleClassLoader loader = new BundleClassLoader(bundle, Axis2ServiceRegistry.class.getClassLoader());
                URL url = (URL)enumeration.nextElement();
                Dictionary headers = bundle.getHeaders();
                String bundleSymbolicName = (String)headers.get("Bundle-SymbolicName");
                serviceGroup.setServiceGroupName(bundleSymbolicName);
                serviceGroup.setServiceGroupClassLoader((ClassLoader)loader);
                InputStream inputStream = url.openStream();
                DescriptionBuilder builder = new DescriptionBuilder(inputStream, configContext);
                OMElement rootElement = builder.buildOM();
                String elementName = rootElement.getLocalName();
                HashMap wsdlServicesMap = this.processWSDL(bundle);
                if (wsdlServicesMap != null && wsdlServicesMap.size() > 0) {
                    for (AxisService service : wsdlServicesMap.values()) {
                        Iterator operations = service.getOperations();
                        while (operations.hasNext()) {
                            AxisOperation axisOperation = (AxisOperation)operations.next();
                            axisConfiguration.getPhasesInfo().setOperationPhases(axisOperation);
                        }
                    }
                }
                if ("service".equals(elementName)) {
                    AxisService axisService = new AxisService(bundleSymbolicName);
                    axisService.setParent(serviceGroup);
                    axisService.setClassLoader((ClassLoader)loader);
                    ServiceBuilder serviceBuilder = new ServiceBuilder(configContext, axisService);
                    serviceBuilder.setWsdlServiceMap(wsdlServicesMap);
                    AxisService service = serviceBuilder.populateService(rootElement);
                    ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
                    serviceList.add(service);
                    DeploymentEngine.addServiceGroup((AxisServiceGroup)serviceGroup, serviceList, null, null, (AxisConfiguration)axisConfiguration);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Deployed wso2carbon-sts service");
                    }
                } else if ("serviceGroup".equals(elementName)) {
                    ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, wsdlServicesMap, configContext);
                    ArrayList serviceList = groupBuilder.populateServiceGroup(serviceGroup);
                    DeploymentEngine.addServiceGroup((AxisServiceGroup)serviceGroup, (ArrayList)serviceList, null, null, (AxisConfiguration)axisConfiguration);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Deployed wso2carbon-sts service group ");
                    }
                }
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Error occur while deploying wso2carbon-sts service for tenant " + CarbonContext.getThreadLocalCarbonContext().getTenantId()), (Throwable)axisFault);
            }
            catch (XMLStreamException e) {
                log.error((Object)("Error occur while deploying wso2carbon-sts service for tenant " + CarbonContext.getThreadLocalCarbonContext().getTenantId()), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("Error occur while deploying wso2carbon-sts service for tenant " + CarbonContext.getThreadLocalCarbonContext().getTenantId()), (Throwable)e);
            }
        }
        return serviceGroup;
    }

    private HashMap processWSDL(Bundle bundle) throws IOException, XMLStreamException {
        File bundleFile;
        Enumeration enumeration = bundle.findEntries("META-INF", "*.wsdl", true);
        if (enumeration == null) {
            return new HashMap();
        }
        String bundleLocation = bundle.getLocation();
        if (bundleLocation.startsWith("reference:")) {
            bundleLocation = bundleLocation.substring("reference:".length());
        }
        String[] subStrings = bundleLocation.split("/");
        String bundleFileName = subStrings[subStrings.length - 1];
        URL bundleURL = new URL(bundleLocation);
        if (bundleURL.getProtocol().equals("file")) {
            bundleFile = new File(bundleURL.getFile());
        } else {
            InputStream bundleStream = bundleURL.openStream();
            String tempBundleDirPath = System.getProperty("java.io.tmpdir") + File.separator + "bundles";
            File tempBundleDir = new File(tempBundleDirPath);
            if (!tempBundleDir.exists() && !tempBundleDir.mkdir()) {
                log.warn((Object)("Could not create temp bundle directory " + tempBundleDir.getAbsolutePath()));
                return new HashMap();
            }
            bundleFile = new File(tempBundleDirPath, bundleFileName);
            FileOutputStream bundleFileOutputSteam = new FileOutputStream(bundleFile);
            IOStreamUtils.copyInputStream((InputStream)bundleStream, (OutputStream)bundleFileOutputSteam);
        }
        if (!bundleFile.exists()) {
            bundleFile = new File(componentsDirPath + File.separator + bundleURL.getFile());
        }
        if (!bundleFile.exists()) {
            return new HashMap();
        }
        DeploymentFileData deploymentFileData = new DeploymentFileData(bundleFile);
        ArchiveReader archiveReader = new ArchiveReader();
        return archiveReader.processWSDLs(deploymentFileData);
    }

    static {
        String carbonRepo = System.getenv("CARBON_REPOSITORY");
        if (carbonRepo == null) {
            carbonRepo = System.getProperty("carbon.repository");
        }
        if (carbonRepo == null) {
            carbonRepo = System.getProperty("carbon.home") + File.separator + "repository";
        }
        componentsDirPath = carbonRepo + File.separator + "components";
    }
}

