/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sts.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.sts.STSDeploymentInterceptor;
import org.wso2.carbon.sts.STSDeploymentListener;
import org.wso2.carbon.sts.internal.STSServiceDataHolder;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

public class STSServiceComponent {
    private static final Log log = LogFactory.getLog(STSServiceComponent.class);

    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Carbon STS bundle is activated");
        }
        try {
            BundleContext bundleCtx = ctxt.getBundleContext();
            STSServiceDataHolder.getInstance().setBundle(bundleCtx.getBundle());
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("org.apache.axis2.osgi.config.service", AxisObserver.class.getName());
            ctxt.getBundleContext().registerService(AxisObserver.class.getName(), (Object)new STSDeploymentInterceptor(), props);
            bundleCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new STSDeploymentListener(), null);
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while updating carbon STS service", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Carbon STS bundle is deactivated");
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Carbon STS bundle");
        }
        try {
            STSServiceDataHolder.getInstance().setRegistryService(registryService);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to get a reference to the Registry", e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        STSServiceDataHolder.getInstance().setRegistryService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Carbon STS bundle");
        }
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the RealmService");
        }
        STSServiceDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the RealmService");
        }
        STSServiceDataHolder.getInstance().setRealmService(null);
    }
}

