/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.feature.generate;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.wso2.maven.p2.beans.CarbonArtifact;
import org.wso2.maven.p2.exceptions.CarbonArtifactNotFoundException;
import org.wso2.maven.p2.exceptions.MissingRequiredPropertyException;
import org.wso2.maven.p2.feature.generate.Bundle;
import org.wso2.maven.p2.feature.generate.Feature;
import org.wso2.maven.p2.feature.generate.FeatureResourceBundle;
import org.wso2.maven.p2.feature.generate.utils.FeatureFileGeneratorUtils;
import org.wso2.maven.p2.utils.BundleUtils;
import org.wso2.maven.p2.utils.DependencyResolver;
import org.wso2.maven.p2.utils.FileManagementUtil;
import org.xml.sax.SAXException;

public class FeatureGenerator {
    private final FeatureResourceBundle resourceBundle;
    private final MavenProject project;
    private final MavenProjectHelper projectHelper;
    private File rowOutputFolder;
    private File featureIdFolder;
    private File pluginsFolder;
    private File featureXmlFile;
    private File p2InfFile;
    private File featurePropertyFile;
    private File featureManifestFile;
    private File featureZipFile;
    private Map<String, CarbonArtifact> dependentBundles;
    private Map<String, CarbonArtifact> dependentFeatures;
    private Log log;

    public FeatureGenerator(FeatureResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.log = resourceBundle.getLog();
        this.project = resourceBundle.getProject();
        this.projectHelper = resourceBundle.getProjectHelper();
    }

    public void generate() throws MojoExecutionException, MojoFailureException {
        try {
            this.resolveMavenProjectDependencies();
            this.populateRequiredArtifactData();
            this.setupTempOutputFolderStructure();
            this.copyFeatureResources();
            this.generateFeatureOutputFiles();
            this.copyAllIncludedArtifacts();
            this.createFeatureArchive();
            this.deployArtifact();
            this.performMopUp();
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        catch (CarbonArtifactNotFoundException | MissingRequiredPropertyException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void resolveMavenProjectDependencies() throws IOException {
        this.log.info((CharSequence)"Inspecting maven dependencies.");
        List<HashMap<String, CarbonArtifact>> artifacts = DependencyResolver.getDependenciesForProject(this.project, this.resourceBundle.getRepositorySystem(), this.resourceBundle.getRemoteRepositories(), this.resourceBundle.getLocalRepository());
        this.dependentBundles = artifacts.get(0);
        this.dependentFeatures = artifacts.get(1);
    }

    private void populateRequiredArtifactData() throws CarbonArtifactNotFoundException {
        this.populateBundleDataFromCache();
        this.populateFeatureDataFromCache();
    }

    private void populateBundleDataFromCache() throws CarbonArtifactNotFoundException {
        for (Bundle bundle : this.resourceBundle.getBundles()) {
            String key = bundle.getSymbolicName() + "_" + bundle.getOSGIVersion();
            CarbonArtifact artifact = this.dependentBundles.get(key);
            if (artifact == null) {
                key = bundle.getSymbolicName() + "_" + bundle.getVersion();
                artifact = this.dependentBundles.get(key);
            }
            if (artifact == null) {
                throw new CarbonArtifactNotFoundException("Bundle " + key + " is not found in project dependency list");
            }
            artifact.copyTo(bundle);
        }
    }

    private void populateFeatureDataFromCache() throws CarbonArtifactNotFoundException {
        for (Feature feature : this.resourceBundle.getIncludeFeatures()) {
            String key = feature.getId() + ".feature" + "_" + feature.getVersion();
            CarbonArtifact artifact = this.dependentFeatures.get(key);
            if (artifact == null) {
                throw new CarbonArtifactNotFoundException("Feature " + key + " is not found in project dependency list");
            }
            artifact.copyTo(feature);
        }
    }

    private void generateFeatureOutputFiles() throws IOException, ParserConfigurationException, SAXException, TransformerException, MissingRequiredPropertyException {
        FeatureFileGeneratorUtils.createFeatureXml(this.resourceBundle, this.featureXmlFile);
        FeatureFileGeneratorUtils.createPropertiesFile(this.resourceBundle, this.featurePropertyFile);
        FeatureFileGeneratorUtils.createManifestMFFile(this.resourceBundle, this.featureManifestFile);
        FeatureFileGeneratorUtils.createP2Inf(this.resourceBundle, this.p2InfFile);
    }

    private void setupTempOutputFolderStructure() throws IOException {
        this.log.info((CharSequence)"Setting up folder structure");
        File destFolder = new File(this.project.getBasedir(), "target");
        this.rowOutputFolder = new File(destFolder, "raw");
        File featuresParentDir = new File(this.rowOutputFolder, "features");
        this.featureIdFolder = new File(featuresParentDir, this.resourceBundle.getId() + "_" + BundleUtils.getOSGIVersion(this.resourceBundle.getVersion()));
        this.pluginsFolder = new File(this.rowOutputFolder, "plugins");
        File featureMetaInfFolder = new File(this.featureIdFolder, "META-INF");
        this.featureXmlFile = new File(this.featureIdFolder, "feature.xml");
        this.featurePropertyFile = new File(this.featureIdFolder, "feature.properties");
        this.p2InfFile = new File(this.featureIdFolder, "p2.inf");
        this.featureManifestFile = new File(featureMetaInfFolder, "MANIFEST.MF");
        this.featureZipFile = new File(destFolder, this.project.getArtifactId() + "-" + this.project.getVersion() + ".zip");
        if (!featureMetaInfFolder.mkdirs()) {
            throw new IOException("Unable to create folder " + featureMetaInfFolder.getAbsolutePath());
        }
        if (!this.pluginsFolder.mkdirs()) {
            throw new IOException("Unable to create folder " + this.pluginsFolder.getAbsolutePath());
        }
    }

    private void copyAllIncludedArtifacts() throws IOException {
        this.copyBundles();
        this.copyIncludedFeatures();
    }

    private void copyBundles() throws IOException {
        List<Bundle> bundles = this.resourceBundle.getBundles();
        if (bundles.size() > 0) {
            this.log.info((CharSequence)"Copying bundle dependencies");
            for (Bundle bundle : bundles) {
                try {
                    this.log.info((CharSequence)("   " + bundle.toOSGIString()));
                    String bundleName = bundle.getSymbolicName() + "-" + bundle.getBundleVersion() + ".jar";
                    FileUtils.copyFile((File)bundle.getArtifact().getFile(), (File)new File(this.pluginsFolder, bundleName));
                }
                catch (IOException e) {
                    throw new IOException("Unable copy dependency: " + bundle.getArtifactId(), e);
                }
            }
        }
    }

    private void copyIncludedFeatures() throws IOException {
        List<Feature> features = this.resourceBundle.getIncludeFeatures();
        if (features.size() > 0) {
            this.log.info((CharSequence)"Extracting features:");
            for (Feature includedFeature : features) {
                try {
                    this.log.info((CharSequence)("Extracting feature " + includedFeature.getGroupId() + ":" + includedFeature.getArtifactId()));
                    FileManagementUtil.unzip(includedFeature.getArtifact().getFile(), this.rowOutputFolder);
                }
                catch (IOException e) {
                    throw new IOException("Error occurred when extracting the Feature Artifact: " + includedFeature.getGroupId() + ":" + includedFeature.getArtifactId(), e);
                }
            }
        }
    }

    private void createFeatureArchive() {
        this.log.info((CharSequence)("Generating feature archive: " + this.featureZipFile.getAbsolutePath()));
        FileManagementUtil.zipFolder(this.rowOutputFolder.getAbsolutePath(), this.featureZipFile.getAbsolutePath(), this.resourceBundle.getLog());
    }

    private void deployArtifact() {
        if (this.featureZipFile != null && this.featureZipFile.exists()) {
            this.project.getArtifact().setFile(this.featureZipFile);
            this.projectHelper.attachArtifact(this.project, "zip", null, this.featureZipFile);
        }
    }

    private void copyFeatureResources() throws IOException {
        List resources = this.project.getResources();
        for (Resource resource : resources) {
            String sourcePath = resource.getDirectory();
            if (!Paths.get(sourcePath, new String[0]).toFile().exists()) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(resource.getDirectory());
            if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
                scanner.setIncludes(resource.getIncludes().toArray(new String[resource.getIncludes().size()]));
            } else {
                scanner.setIncludes(new String[]{"**/**"});
            }
            List excludes = resource.getExcludes();
            if (excludes != null && !excludes.isEmpty()) {
                scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            this.log.info((CharSequence)("   " + resource.getDirectory()));
            for (String name : includedFiles) {
                File fromPath = new File(sourcePath, name);
                File toPath = new File(this.featureIdFolder, name);
                try {
                    if (fromPath.isDirectory() && !toPath.exists()) {
                        if (toPath.mkdirs()) continue;
                        throw new IOException("Unable create directory: " + toPath.getAbsolutePath());
                    }
                    FileManagementUtil.copy(fromPath, toPath);
                }
                catch (IOException e) {
                    throw new IOException("Unable copy resources: " + resource.getDirectory(), e);
                }
            }
        }
    }

    private void performMopUp() {
        try {
            FileUtils.deleteDirectory((File)this.rowOutputFolder);
        }
        catch (IOException e) {
            this.log.warn((Throwable)new IOException("Unable complete mop up operation", e));
        }
    }
}

