/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.feature.generate;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.wso2.maven.p2.feature.generate.Advice;
import org.wso2.maven.p2.feature.generate.Bundle;
import org.wso2.maven.p2.feature.generate.Feature;
import org.wso2.maven.p2.feature.generate.FeatureGenerator;
import org.wso2.maven.p2.feature.generate.FeatureResourceBundle;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PACKAGE)
public class FeatureGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.artifactId}")
    private String id;
    @Parameter(defaultValue="${project.version}")
    private String version;
    @Parameter(defaultValue="${project.name}")
    private String label;
    @Parameter(defaultValue="${project.description}")
    private String description;
    @Parameter(defaultValue="%providerName")
    private String providerName;
    @Parameter(defaultValue="%copyright")
    private String copyright;
    @Parameter(defaultValue="%licenseURL")
    private String licenceUrl;
    @Parameter(defaultValue="%license")
    private String licence;
    @Parameter
    private File manifest;
    @Parameter
    private File propertyFile;
    @Parameter
    private Properties properties;
    @Parameter
    private List<Bundle> bundles;
    @Parameter
    private List<Feature> importFeatures;
    @Parameter
    private List<Feature> includeFeatures;
    @Parameter
    private List<Advice> adviceFileContents;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        FeatureGenerator featureGenerator = this.constructFeatureGenerator();
        featureGenerator.generate();
    }

    public FeatureGenerator constructFeatureGenerator() {
        FeatureResourceBundle resourceBundle = new FeatureResourceBundle();
        resourceBundle.setId(this.id);
        resourceBundle.setVersion(this.version);
        resourceBundle.setLabel(this.label);
        resourceBundle.setDescription(this.description);
        resourceBundle.setProviderName(this.providerName);
        resourceBundle.setCopyright(this.copyright);
        resourceBundle.setLicence(this.licence);
        resourceBundle.setLicenceUrl(this.licenceUrl);
        resourceBundle.setManifest(this.manifest);
        resourceBundle.setPropertyFile(this.propertyFile);
        resourceBundle.setProperties(this.properties);
        resourceBundle.setBundles(this.bundles);
        resourceBundle.setImportFeatures(this.importFeatures);
        resourceBundle.setIncludeFeatures(this.includeFeatures);
        resourceBundle.setAdviceFileContent(this.adviceFileContents);
        resourceBundle.setRepositorySystem(this.repositorySystem);
        resourceBundle.setLocalRepository(this.localRepository);
        resourceBundle.setRemoteRepositories(this.remoteRepositories);
        resourceBundle.setProject(this.project);
        resourceBundle.setProjectHelper(this.projectHelper);
        resourceBundle.setLog(this.getLog());
        return new FeatureGenerator(resourceBundle);
    }
}

