/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.feature.generate.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.maven.p2.exceptions.MissingRequiredPropertyException;
import org.wso2.maven.p2.feature.generate.Advice;
import org.wso2.maven.p2.feature.generate.Bundle;
import org.wso2.maven.p2.feature.generate.Feature;
import org.wso2.maven.p2.feature.generate.FeatureResourceBundle;
import org.wso2.maven.p2.utils.BundleUtils;
import org.wso2.maven.p2.utils.P2Utils;
import org.wso2.maven.p2.utils.PropertyReplacer;
import org.xml.sax.SAXException;

public class FeatureFileGeneratorUtils {
    private static final String LINE_SEPARATOR = System.lineSeparator();

    public static void createPropertiesFile(FeatureResourceBundle resourceBundle, File featurePropertyFile) throws IOException, MissingRequiredPropertyException {
        Properties props = FeatureFileGeneratorUtils.getProperties(resourceBundle);
        if (!props.isEmpty()) {
            try (FileOutputStream propertyFileStream = new FileOutputStream(featurePropertyFile);){
                resourceBundle.getLog().info((CharSequence)"Generating feature properties");
                props.store(propertyFileStream, "Properties of " + resourceBundle.getId());
            }
            catch (IOException e) {
                throw new IOException("Unable to create the feature.properties file", e);
            }
        }
    }

    private static Properties getProperties(FeatureResourceBundle resourceBundle) throws IOException, MissingRequiredPropertyException {
        Properties props = resourceBundle.getProperties();
        Properties propertiesFromFiles = FeatureFileGeneratorUtils.getMergedPropertiesFromFiles(resourceBundle);
        if (props != null) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> propertiesFromFiles.setProperty(key.toString(), value.toString())));
        }
        resourceBundle.setProperties(propertiesFromFiles);
        return propertiesFromFiles;
    }

    private static Properties getMergedPropertiesFromFiles(FeatureResourceBundle resourceBundle) throws IOException, MissingRequiredPropertyException {
        List<String> missingProperties;
        Throwable throwable;
        FileInputStream propertyFileStream;
        Properties props = new Properties();
        File propertyFileFromResourceDir = resourceBundle.getPropertyFileInResourceDir();
        File propertyFileFromConfig = resourceBundle.getPropertyFile();
        if (propertyFileFromResourceDir.exists()) {
            propertyFileStream = new FileInputStream(propertyFileFromResourceDir);
            throwable = null;
            try {
                props.load(propertyFileStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (propertyFileStream != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)propertyFileStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)propertyFileStream).close();
                    }
                }
            }
        }
        if (propertyFileFromConfig != null && propertyFileFromConfig.exists()) {
            propertyFileStream = new FileInputStream(propertyFileFromConfig);
            throwable = null;
            try {
                props.load(propertyFileStream);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (propertyFileStream != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)propertyFileStream).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((InputStream)propertyFileStream).close();
                    }
                }
            }
        }
        if ((missingProperties = FeatureFileGeneratorUtils.getMissingMandatoryProperties(props)).size() > 0) {
            String exceptionMessage = "Mandatory properties " + missingProperties.toString() + " are missing in provided property file(s)";
            if (missingProperties.size() == 1) {
                exceptionMessage = "Mandatory property \"" + missingProperties.get(0) + "\" is missing in provided property file(s)";
            }
            throw new MissingRequiredPropertyException(exceptionMessage);
        }
        return props;
    }

    private static List<String> getMissingMandatoryProperties(Properties props) {
        Stream<String> mandatoryFields = Stream.of("license");
        ArrayList<String> missingMandatoryFields = new ArrayList<String>();
        mandatoryFields.forEach(key -> {
            if (!props.containsKey(key)) {
                missingMandatoryFields.add((String)key);
            }
        });
        return missingMandatoryFields;
    }

    public static void createManifestMFFile(FeatureResourceBundle resourceBundle, File featureManifestFile) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(featureManifestFile), "UTF-8");
             PrintWriter pw = new PrintWriter(writer);){
            resourceBundle.getLog().info((CharSequence)"Generating MANIFEST.MF");
            pw.print("Manifest-Version: 1.0" + LINE_SEPARATOR + LINE_SEPARATOR);
        }
        catch (IOException e) {
            throw new IOException("Unable to create manifest file", e);
        }
    }

    public static void createP2Inf(FeatureResourceBundle resourceBundle, File p2InfFile) throws IOException {
        List<Advice> list = resourceBundle.getAdviceFileContent();
        List<String> p2infStringList = null;
        if (p2InfFile.exists()) {
            p2infStringList = FeatureFileGeneratorUtils.readAdviceFile(p2InfFile.getAbsolutePath());
            resourceBundle.getLog().info((CharSequence)"Updating Advice file (p2.inf)");
        } else {
            resourceBundle.getLog().info((CharSequence)"Generating Advice file (p2.inf)");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(p2InfFile.getAbsolutePath()), "UTF-8");
             PrintWriter pw = new PrintWriter(writer);){
            Properties properties = new Properties();
            properties.setProperty("feature.version", BundleUtils.getOSGIVersion(resourceBundle.getVersion()));
            if (p2infStringList != null && p2infStringList.size() > 0) {
                p2infStringList.forEach(p2InfEntry -> pw.write(PropertyReplacer.replaceProperties(p2InfEntry, properties) + LINE_SEPARATOR));
            }
            if (list != null && list.size() != 0) {
                int nextIndex = P2Utils.getLastIndexOfProperties(p2InfFile) + 1;
                for (Advice category : list) {
                    pw.write(LINE_SEPARATOR + "properties." + nextIndex + ".name=" + category.getName());
                    pw.write(LINE_SEPARATOR + "properties." + nextIndex + ".value=" + category.getValue());
                    ++nextIndex;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            resourceBundle.getLog().error((CharSequence)"Unable to read p2.inf file. Unsupported encoding in existing file.");
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Unable to create/open p2.inf file", e);
        }
    }

    private static List<String> readAdviceFile(String absolutePath) throws IOException {
        ArrayList<String> stringList = new ArrayList<String>();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(absolutePath), "UTF-8");
             BufferedReader br = new BufferedReader(reader);){
            String inputLine;
            while ((inputLine = br.readLine()) != null) {
                stringList.add(inputLine);
            }
        }
        catch (IOException e) {
            throw new IOException("Error while reading from p2.inf file", e);
        }
        return stringList;
    }

    public static void createFeatureXml(FeatureResourceBundle resourceBundle, File featureXmlFile) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Element includeElement;
        Node require;
        NodeList licenseTags;
        NodeList copyrightTags;
        NodeList descriptionTags;
        resourceBundle.getLog().info((CharSequence)"Generating feature manifest");
        Document document = FeatureFileGeneratorUtils.getManifestDocument(resourceBundle.getManifest());
        Element rootElement = document.getDocumentElement();
        if (rootElement == null) {
            rootElement = document.createElement("feature");
            document.appendChild(rootElement);
        }
        if (!rootElement.hasAttribute("id")) {
            rootElement.setAttribute("id", resourceBundle.getId());
        }
        if (!rootElement.hasAttribute("label")) {
            rootElement.setAttribute("label", resourceBundle.getLabel());
        }
        if (!rootElement.hasAttribute("version")) {
            rootElement.setAttribute("version", BundleUtils.getOSGIVersion(resourceBundle.getVersion()));
        }
        if (!rootElement.hasAttribute("provider-name")) {
            rootElement.setAttribute("provider-name", resourceBundle.getProviderName());
        }
        if ((descriptionTags = rootElement.getElementsByTagName("description")).getLength() == 0) {
            Element description = document.createElement("description");
            description.setTextContent(resourceBundle.getDescription());
            rootElement.appendChild(description);
        }
        if ((copyrightTags = rootElement.getElementsByTagName("copyright")).getLength() == 0) {
            Element copyright = document.createElement("copyright");
            copyright.setTextContent(resourceBundle.getCopyright());
            rootElement.appendChild(copyright);
        }
        if ((licenseTags = rootElement.getElementsByTagName("license")).getLength() == 0) {
            Element license = document.createElement("license");
            license.setAttribute("url", resourceBundle.getLicenceUrl());
            license.setTextContent(resourceBundle.getLicence());
            rootElement.appendChild(license);
        }
        List<Bundle> processedMissingPlugins = FeatureFileGeneratorUtils.getMissingPlugins(resourceBundle.getBundles(), document);
        List<Feature> missingImportFeatures = FeatureFileGeneratorUtils.getMissingImportFeatures(resourceBundle.getImportFeatures(), document, "feature");
        List<Feature> includedFeatures = resourceBundle.getIncludeFeatures();
        for (Bundle bundle : processedMissingPlugins) {
            Iterator<Feature> plugin = document.createElement("plugin");
            plugin.setAttribute("id", bundle.getSymbolicName());
            plugin.setAttribute("version", bundle.getBundleVersion());
            plugin.setAttribute("unpack", "false");
            rootElement.appendChild((Node)((Object)plugin));
        }
        NodeList requireNodes = document.getElementsByTagName("require");
        if (requireNodes == null || requireNodes.getLength() == 0) {
            require = document.createElement("require");
            rootElement.appendChild(require);
        } else {
            require = requireNodes.item(0);
        }
        missingImportFeatures.stream().filter(feature -> !feature.isOptional()).forEach(feature -> {
            Element plugin = document.createElement("import");
            plugin.setAttribute("feature", feature.getId());
            plugin.setAttribute("version", feature.getFeatureVersion());
            if (P2Utils.isPatch(feature.getCompatibility())) {
                plugin.setAttribute("patch", "true");
            } else {
                plugin.setAttribute("match", P2Utils.getMatchRule(feature.getCompatibility()));
            }
            require.appendChild(plugin);
        });
        for (Feature includedFeature : includedFeatures) {
            includeElement = document.createElement("includes");
            includeElement.setAttribute("id", includedFeature.getId());
            includeElement.setAttribute("version", includedFeature.getFeatureVersion());
            includeElement.setAttribute("optional", Boolean.toString(includedFeature.isOptional()));
            rootElement.appendChild(includeElement);
        }
        for (Feature feature2 : missingImportFeatures) {
            if (!feature2.isOptional()) continue;
            includeElement = document.createElement("includes");
            includeElement.setAttribute("id", feature2.getId());
            includeElement.setAttribute("version", feature2.getFeatureVersion());
            includeElement.setAttribute("optional", Boolean.toString(feature2.isOptional()));
            rootElement.appendChild(includeElement);
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(featureXmlFile);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerConfigurationException("Unable to create feature manifest", e);
        }
    }

    private static Document getManifestDocument(File manifest) throws ParserConfigurationException, SAXException, IOException {
        Document document;
        block18: {
            DocumentBuilder documentBuilder;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new ParserConfigurationException("Unable to load feature manifest");
            }
            if (manifest != null && manifest.exists()) {
                try (FileInputStream manifestFileStream = new FileInputStream(manifest);){
                    Document document2 = documentBuilder.parse(manifestFileStream);
                    break block18;
                }
                catch (SAXException e) {
                    throw new SAXException("Unable to parse feature manifest", e);
                }
                catch (IOException e) {
                    throw new IOException("Unable to load feature manifest", e);
                }
            }
            document = documentBuilder.newDocument();
        }
        return document;
    }

    private static List<Bundle> getMissingPlugins(List<Bundle> bundles, Document document) {
        if (bundles == null || bundles.size() == 0) {
            return new ArrayList<Bundle>();
        }
        HashMap missingPlugins = new HashMap();
        bundles.forEach(bundle -> missingPlugins.put(bundle.getArtifactId(), bundle));
        NodeList existingPlugins = document.getDocumentElement().getElementsByTagName("plugin");
        for (int i = 0; i < existingPlugins.getLength(); ++i) {
            Node node = existingPlugins.item(i);
            Node namedItem = node.getAttributes().getNamedItem("id");
            if (namedItem == null || namedItem.getTextContent() == null || !missingPlugins.containsKey(namedItem.getTextContent())) continue;
            missingPlugins.remove(namedItem.getTextContent());
        }
        return new ArrayList<Bundle>(missingPlugins.values());
    }

    private static List<Feature> getMissingImportFeatures(List<Feature> processedImportItemsList, Document document, String itemType) {
        if (processedImportItemsList == null) {
            return new ArrayList<Feature>();
        }
        HashMap<String, Feature> missingImportItems = new HashMap<String, Feature>();
        for (Feature item : processedImportItemsList) {
            missingImportItems.put(item.getId(), item);
        }
        NodeList requireNodeList = document.getDocumentElement().getElementsByTagName("require");
        if (requireNodeList.getLength() == 0) {
            return new ArrayList<Feature>(missingImportItems.values());
        }
        Node requireNode = requireNodeList.item(0);
        if (requireNode instanceof Element) {
            Element requireElement = (Element)requireNode;
            NodeList importNodes = requireElement.getElementsByTagName("import");
            for (int i = 0; i < importNodes.getLength(); ++i) {
                Node node = importNodes.item(i);
                Node namedItem = node.getAttributes().getNamedItem(itemType);
                if (namedItem == null || namedItem.getTextContent() == null || !missingImportItems.containsKey(namedItem.getTextContent())) continue;
                missingImportItems.remove(namedItem.getTextContent());
            }
        }
        return new ArrayList<Feature>(missingImportItems.values());
    }
}

