/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.feature.install;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.launching.EquinoxLauncher;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.plugins.p2.director.DirectorMojo;
import org.eclipse.tycho.plugins.p2.director.runtime.StandaloneDirectorRuntimeFactory;
import org.wso2.maven.p2.feature.install.Feature;
import org.wso2.maven.p2.feature.install.FeatureInstallResourceBundle;
import org.wso2.maven.p2.feature.install.FeatureInstaller;

@Mojo(name="install", defaultPhase=LifecyclePhase.PACKAGE)
public class FeatureInstallMojo
extends AbstractMojo {
    @Parameter(required=true)
    private String destination;
    @Parameter(required=true)
    private String runtime;
    @Parameter
    private URL repositoryURL;
    @Parameter(required=true)
    private List<Feature> features;
    @Parameter(defaultValue="true")
    private boolean deleteOldRuntimeFiles = true;
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Component
    private EquinoxLauncher launcher;
    @Component
    private MavenSession session;
    @Parameter(defaultValue="standalone")
    private DirectorMojo.DirectorRuntimeType directorRuntime;
    @Component
    private StandaloneDirectorRuntimeFactory standaloneDirectorFactory;
    @Parameter(defaultValue="${p2.timeout}")
    private int forkedProcessTimeoutInSeconds;
    private File runtimeLocation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.runtimeLocation = new BuildOutputDirectory(this.project.getBuild().getDirectory()).getChild("director");
        this.setDirectorRuntime();
        FeatureInstaller installer = this.constructFeatureInstaller();
        installer.install();
    }

    private FeatureInstaller constructFeatureInstaller() {
        FeatureInstallResourceBundle resourceBundle = new FeatureInstallResourceBundle();
        resourceBundle.setDestination(this.destination);
        resourceBundle.setProfile(this.runtime == null ? "WSO2CarbonProfile" : this.runtime);
        resourceBundle.setRepository(this.repositoryURL);
        resourceBundle.setFeatures(this.features);
        resourceBundle.setDeleteOldProfileFiles(this.deleteOldRuntimeFiles);
        resourceBundle.setProject(this.project);
        resourceBundle.setLauncher(this.launcher);
        resourceBundle.setForkedProcessTimeoutInSeconds(this.forkedProcessTimeoutInSeconds);
        resourceBundle.setLog(this.getLog());
        resourceBundle.setRuntimeLocation(this.runtimeLocation);
        return new FeatureInstaller(resourceBundle);
    }

    private void setDirectorRuntime() throws MojoFailureException, MojoExecutionException {
        switch (this.directorRuntime) {
            case standalone: {
                this.standaloneDirectorFactory.createStandaloneDirector(this.runtimeLocation, this.session.getLocalRepository(), this.forkedProcessTimeoutInSeconds);
                return;
            }
        }
        throw new MojoFailureException("Unsupported value for attribute 'directorRuntime': \"" + this.directorRuntime + "\"");
    }
}

