/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.feature.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.wso2.maven.p2.feature.install.FeatureInstallResourceBundle;
import org.wso2.maven.p2.utils.FileManagementUtil;
import org.wso2.maven.p2.utils.StandaloneManager;

public class FeatureInstaller {
    private final FeatureInstallResourceBundle resourceBundle;
    private final String destination;
    private Log log;

    public FeatureInstaller(FeatureInstallResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.log = resourceBundle.getLog();
        this.destination = resourceBundle.getDestination();
    }

    public void install() throws MojoExecutionException, MojoFailureException {
        try {
            this.writeEclipseIni();
            this.installFeatures();
            this.updateProfileConfigIni();
            this.deleteOldProfiles();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void updateProfileConfigIni() {
        File profileConfigIni = FileManagementUtil.getProfileConfigIniFile(this.destination, this.resourceBundle.getProfile());
        FileManagementUtil.changeConfigIniProperty(profileConfigIni, "eclipse.p2.data.area", "@config.dir/../lib/p2/", this.resourceBundle.getLog());
    }

    private void installFeatures() throws MojoFailureException {
        this.log.info((CharSequence)"Running Equinox P2 Director Application");
        StandaloneManager launcher = new StandaloneManager(this.resourceBundle.getLauncher());
        launcher.setRuntimeLocation(this.resourceBundle.getRuntimeLocation());
        launcher.addArgumentsToInstallFeatures(this.resourceBundle.getRepository().toExternalForm(), this.destination, this.resourceBundle.getProfile());
        launcher.performAction(this.extractIUsToInstall(), this.resourceBundle.getForkedProcessTimeoutInSeconds());
    }

    private String extractIUsToInstall() {
        StringBuilder installIUs = new StringBuilder();
        this.resourceBundle.getFeatures().forEach(feature -> installIUs.append(feature.getId().trim()).append("/").append(feature.getVersion().trim()).append(","));
        return installIUs.toString();
    }

    private void deleteOldProfiles() throws IOException {
        String[] profileFileList;
        String profileFolderName;
        File profileFolder;
        if (!this.resourceBundle.isDeleteOldProfileFiles()) {
            return;
        }
        String destination = this.resourceBundle.getDestination();
        if (!destination.endsWith("/")) {
            destination = destination + "/";
            this.resourceBundle.setDestination(destination);
        }
        if ((profileFolder = new File(profileFolderName = this.resourceBundle.getDestination() + "p2/org.eclipse.equinox.p2.engine/profileRegistry/" + this.resourceBundle.getProfile() + ".profile")).isDirectory() && (profileFileList = profileFolder.list((dir, name) -> name.endsWith(".profile"))) != null) {
            for (int i = 0; i < profileFileList.length - 1; ++i) {
                File profileFile = new File(profileFolderName, profileFileList[i]);
                if (!profileFile.exists() || profileFile.delete()) continue;
                throw new IOException("Failed to delete old profile file: " + profileFile.getAbsolutePath());
            }
        }
    }

    private void writeEclipseIni() throws IOException {
        String profileLocation = this.resourceBundle.getDestination() + File.separator + this.resourceBundle.getProfile();
        File eclipseIni = Paths.get(profileLocation + File.separator + "eclipse.ini", new String[0]).toFile();
        if (eclipseIni.exists()) {
            this.updateFile(eclipseIni, profileLocation);
        }
    }

    private void updateFile(File file, String profileLocation) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Failed to delete " + file.getAbsolutePath());
        }
        this.log.info((CharSequence)("Updating " + file.getName()));
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
             PrintWriter pw = new PrintWriter(writer);){
            pw.write("-install\n");
            pw.write(profileLocation);
            pw.flush();
        }
        catch (IOException e) {
            this.log.debug((CharSequence)("Error while writing to file " + file.getName()), (Throwable)e);
        }
    }
}

