/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.feature.uninstall;

import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.wso2.maven.p2.feature.uninstall.Feature;
import org.wso2.maven.p2.utils.P2ApplicationLaunchManager;

public class FeatureUnInstaller {
    private String destination;
    private String profile;
    private List<Feature> features;
    private MavenProject project;
    private P2ApplicationLauncher launcher;
    private int forkedProcessTimeoutInSeconds;
    private static final String PUBLISHER_APPLICATION = "org.eclipse.equinox.p2.director";

    public void uninstallFeatures() throws MojoFailureException {
        String iUs = this.getIUsToUninstall();
        this.uninstallFeatures(iUs);
    }

    private String getIUsToUninstall() {
        if (this.features == null) {
            return null;
        }
        StringBuilder uninstallUIs = new StringBuilder();
        this.features.forEach(feature -> uninstallUIs.append(feature.getId().trim()).append("/").append(feature.getVersion().trim()).append(","));
        return uninstallUIs.toString();
    }

    private void uninstallFeatures(String uninstallUIs) throws MojoFailureException {
        if (this.project != null) {
            P2ApplicationLaunchManager launcher = new P2ApplicationLaunchManager(this.launcher);
            launcher.setWorkingDirectory(this.project.getBasedir());
            launcher.setApplicationName(PUBLISHER_APPLICATION);
            launcher.addArgumentsToUnInstallFeatures(uninstallUIs, this.destination, this.profile);
            launcher.performAction(this.forkedProcessTimeoutInSeconds);
        }
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setLauncher(P2ApplicationLauncher launcher) {
        this.launcher = launcher;
    }

    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }
}

